#include <stdio.h>
#include <na.h>

typedef struct SDESC US;

#define ss_free(X)      free((X)->ADDR)
#define ss_clear(X)     memset((X)->ADDR,0,(X)->SDLEN);
#define ss_rdrop(D,S,N) {(D)->ADDR=(S)->ADDR;(D)->SDLEN=(S)->SDLEN-(N);}
#define ss_take(D,S,N)  {(D)->ADDR=(S)->ADDR;(D)->SDLEN=N;}
#define ss_obj(D, S, TMP) \
      { \
      ss_dropz((TMP), (S)); \
      if(ss_alloc((D), (TMP)->SDLEN)) return ERROR; \
      memcpy((D)->ADDR, (TMP)->ADDR, (D)->SDLEN); \
      }

#define ss_slice_obj(D,S)  {(D)->ADDR=TEXT_PTR((S));(D)->SDLEN=MSIZE((S));}
#define ss_eat1(D)         {((D)->ADDR)++;((D)->SDLEN)--;}
#define ss_is_scalar(S,V)  (*(S)->ADDR)==V && (S)->SDLEN==1)

/*
        Arithmetic routines on decimal strings.
*/

int     qv = 1;         /* verbose switch */
int     fc = 'A';
int     nvar = 0;
int     cnt = 1;
int     seed = 0;
int     pp[2] = {30, 20};
US      na[10];

main(argc, argv)
int     argc;
char  **argv;
{
extern  int atoi();
char *s;
US r, w, x, y, z;
int     i, k;

for(argv++, argc--; 0 < argc--; argv++) {
    s = *argv;
    if (s[0] == '-') switch(s[1]) {
        case 'c':   /* cnt */
                cnt = atoi(*++argv);
                argc --;
        break;
        case 'f':   /* function */
                fc = s[2];
        break;
        case 'p':       /* precision */
                pp[0] = atoi(*++argv);
                pp[1] = atoi(*++argv);
                argc -=2;
        break;
        case 's':   /* seed */
                seed = atoi(*++argv);
                argc --;
        break;
        case 'q':       /* -quiet */
                qv = 0;
        break;
        case 'v':       /* -verbose */
        default:
                qv = 1;
        break;
        }
    else ss_copy_str(&na[nvar++], *argv);
    }

    printf("nvar= %d fc=%c cnt=%d seed=%d pp=%d %d v=%d\n",
        nvar, fc, cnt, seed, pp[0], pp[1], qv);
if (seed) srand(seed);
for (i = 0; i < nvar; i++) ss_print("$$", &na[i]);

/*
    ss_alloc(&z, x.SDLEN + y.SDLEN);
    ss_mult(&z, &x, &y);
    ss_print("z", &z);
    ss_free(&z);
    return OK;
*/


for(i=0; i< cnt; i++) {
    ss_rlong(&x, pp[0]);
    ss_rlong(&y, pp[1]);
    ss_print("x", &x);
    ss_print("y", &y);
    ss_divrem(&z, &w, &r, &x, &y);
    ss_print("r", &w);
    ss_free(&z);
    ss_free(&w);
    ss_free(&r);
    ss_free(&x);
    ss_free(&y);
    }
return OK;
}

int ss_copy_str(US *dst, char *src)     /* instance of string */
{
int n = strlen (src);
if (ss_alloc(dst, n)) return ERROR;
if (n>0) memcpy(dst->ADDR, src, n);
return OK;
}

int ss_alloc(US *z, int n)
{
extern BYTE* malloc();
if (n == 0) {
    z->ADDR = NULL;
    z->SDLEN = 0;
    return OK;
    }
if (NULL == (z->ADDR  = malloc(n))) return ERROR;
z->SDLEN = n;
memset(z->ADDR, 0, z->SDLEN);
return OK;
}

int ss_mult(US *z, US *x, US *y)
{
BYTE   *t, *xi, *yi;
int     j, cc, k, nd, n, sx;
int     minz, maxz;
n = x->SDLEN + y->SDLEN;
if (z->ADDR == NULL || z->SDLEN < n) return ERROR;
ss_strip_bits (x);
ss_strip_bits (y);
ss_clear(z);
t  = z->ADDR + n-1;

if (x->SDLEN > y->SDLEN) { minz = y->SDLEN; maxz = x->SDLEN;}
else                     { minz = x->SDLEN; maxz = y->SDLEN;}

/* optimise inner loop */

for (k = 1, cc = 0; k <= n-1; k++) {
    if (k < minz) nd = k;
    else if (k > maxz) nd = n-k;
    else nd = minz;
    xi = x->ADDR + x->SDLEN-1;
    if (k > y->SDLEN) xi -= (k - y->SDLEN);
    yi = y->ADDR;
    if (k < y->SDLEN) yi += (y->SDLEN - k);
    for (sx = cc, j = 0; j < nd; j++) {
        sx += (*xi--) * (*yi++);
        }
    cc = sx/10;
    *t-- = sx-10*cc;
    }
*t = cc;
return cc;
}



int ss_print(char *name, US *x)
{
if (qv == 0) return OK;
if   (x->SDLEN==0) printf("%s=()\n", name);
else {
    ss_to_ascii(x);
    printf("%s=%.*s\n", name, x->SDLEN, x->ADDR);
    ss_strip_bits(x);
    }
return OK;
}


int ss_strip_bits(US *x)  /* strip bits from ASCII digits */
{
int     i;
BYTE   *t = x->ADDR;
for (i=0; i< x->SDLEN; i++) t[i] &= 0X0F;
return OK;
}

int ss_to_ascii(US *x)  /* un-strip bits from ASCII digits */
{
int     i, k;
BYTE   *t = x->ADDR;
for (i=0; i< x->SDLEN; i++) t[i] = '0' + (t[i] & 0X0F);
return OK;
}

/*      z<-z+x*10^offset */

int     ss_add_to(US *z, US *x, int offset)
{
int     a, cc, j;
BYTE   *s, *t;
if (x->SDLEN+offset > z->SDLEN) return ERROR;
t= z->ADDR + z->SDLEN - 1 - offset;
for (s = x->ADDR+x->SDLEN-1, j = cc = 0; j < z->SDLEN-offset ; j++) {
    a = cc + *t;
    if (j< x->SDLEN) a += *s--;
    cc = (a >= 10);
    if (cc) a -= 10;
    *t-- = a;
    }
return cc;
}

/*      z <- z- x/10^n        */

int     ss_sub_from(US *z, US *x, int offset)
{
int     a, bb, j;
BYTE   *s, *t;
if (x->SDLEN-offset > z->SDLEN) return ERROR;
t = z->ADDR + z->SDLEN -1;
for (s = x->ADDR+x->SDLEN-1-offset, j = bb = 0; j < z->SDLEN; j++) {
    a = *t - bb;
    if (j < x->SDLEN-offset) a -= *s--;
    bb = (a < 0);
    if (bb) a += 10;
    *t-- = a;
    }
return bb;
}

/*
Reference:
  MSIEVE: A Library for Factoring Large Integers
  Jason Papadopoulos (jasonp@boo.net) 11/27/05

Z<-RECIP X;N;Y;T
|Multiprecision reciprocal
N<-rX;Y<-(N,1)/"10"
WHILE 1
T<-N RSHIFT X*Y;Z<-("2"*Y)-N RSHIFT T*Y
BREAKIF Y #equiv Z
Y<-Z;WEND
WHILE "1"=1tZ*X; Z<-Z-"1";WEND

*/

int ss_recip(US *z, US *x)
{
int     n = x->SDLEN;
BYTE    one = 0X01;
int     cnt, k;
US      r1, r2, prod, xp, xq;
US      c1 = {&one, 1};
if (ss_alloc(&r1, n+1)||
    ss_alloc(&r2, n+1)||
    ss_alloc(&prod, 2*n+2) ||
    ss_alloc(&xp, 2*n+1)) return ERROR;

ss_strip_bits(x);
*(r1.ADDR) = 1;

for (;;) {
    memcpy(r2.ADDR, r1.ADDR, r1.SDLEN);
    ss_add_to(&r2, &r1, 0);
    ss_mult(&xp, x, &r1);
    ss_rdrop(&xq, &xp, n);
    ss_mult(&prod, &xq, &r1);
    ss_dropz(&xq, &prod);
    ss_strip_bits(&xq);
    ss_sub_from(&r2, &xq, n);
    if (0 == memcmp(r1.ADDR, r2.ADDR, r1.SDLEN)) break;
    memcpy(r1.ADDR, r2.ADDR, r1.SDLEN);
    }

for(;;) {
    ss_dropz(&xq, &xp);
    if (1 != *xq.ADDR) break;
    ss_sub_from(&r2, &c1, 0);
    ss_sub_from(&xp, x, 0);
    }

free(r1.ADDR);
free(xp.ADDR);
free(prod.ADDR);
*z = r2;
return OK;
}

/* drop leading zeros */

int     ss_dropz(US *z, US *x)
{
int     i;
US      zz;
for (zz.ADDR = x->ADDR, i = 0; i < x->SDLEN; i++) {
    if (*zz.ADDR & 0X0F) break;
    else zz.ADDR++;
    }
zz.SDLEN = x->SDLEN -i;

if (zz.SDLEN == 0) {
    zz.ADDR = x->ADDR+x->SDLEN-1;
    zz.SDLEN = 1;
    }
*z = zz;
return OK;
}

/*  divide/remainder  x=q*y+r with r < y
Z<-A DIV B;N;R;T
|Compute multi-precision A%B
Z<-"0"; REM<-A
IF "-"=1tA-B; ->0
R<-RECIP B;N<-_1+rR
WHILE 1
T<-(N+1) RSHIFT R * (N-1) RSHIFT A;REM<-A-B*T;Z<-Z+T
BREAKIF (rREM) <= N
A<-REM;WEND
WHILE ~REM<B;REM<-REM-B;Z<-Z+"1";WEND
*/

int     ss_divrem(US *q, US *r, US *recip, US *x, US *y)
{
BYTE    one = 0X01;
int     cnt, k, n;
US      r1, z1, prod, xt, xd, xe;
US      c1 = {&one, 1};

if (y->SDLEN == 1 && 0 == *y->ADDR) return ERROR;
if (y->SDLEN == 1) return ss_idiv(q, r, x, *y->ADDR);
k = ss_comp(x,y);
if (k < 0) {    /* q<-0; r<-y */
    k = ss_copy_str(q, "0") || ss_alloc(r,y->SDLEN);
    if (k == OK) memcpy(r->ADDR, y->ADDR, r->SDLEN);
    return k;
    }
ss_strip_bits(x);
ss_strip_bits(y);
if (ss_recip(recip, y)) return ERROR;
n = (recip->SDLEN)-1;
if (ss_alloc(&xt, recip->SDLEN + x->SDLEN+1)) return ERROR;
if (ss_alloc(&prod, recip->SDLEN + x->SDLEN+1)) return ERROR;
if (ss_alloc(&r1, x->SDLEN)) return ERROR;
if (ss_alloc(&z1, x->SDLEN)) return ERROR;

memcpy(r1.ADDR, x->ADDR, x->SDLEN);

for(;;) {
    ss_rdrop(&xd, &r1, n-1);
    ss_mult(&xt, recip, &xd);
    ss_take(&xd, &xt, xd.SDLEN+recip->SDLEN);
    ss_rdrop(&xd, &xd, n+1);
    ss_dropz(&xd, &xd);
    ss_mult(&prod, y, &xd);
    ss_take(&xe, &prod, y->SDLEN+xd.SDLEN);
    ss_dropz(&xe, &xe);
    ss_sub_from(&r1, &xe, 0);
    ss_add_to(&z1, &xd, 0);
    ss_dropz(&xd, &r1);
    if (xd.SDLEN <= n) break;
    }

for (;;) {
    ss_dropz(&xd, &r1);
    if (ss_comp(&xd, y) < 0) break;
    ss_sub_from(&r1, y, 0);
    ss_add_to(&z1, &c1, 1);
    }

ss_free(&xt);
ss_free(&prod);
ss_obj(q, &z1, &xd);
ss_free(&z1);
ss_obj(r, &r1, &xd);
ss_free(&r1);

return OK;
}

/*      q <- z / (int) a */

int     ss_idiv(US *q, US *r, US *x, int a)
{
US      xc;
BYTE   *s, *t;
int     ax, cc, n, qd;

a = a & 0X0F;
qd = (a > (0X0F & *x->ADDR));   /* drop digit */
if (ss_alloc(q, x->SDLEN - qd) || ss_alloc(r, 1)) return ERROR;

n = x->SDLEN;
s = x->ADDR;
cc = 0;
if (qd) {
    cc = *s;
    s++;
    n--;
    }

for (t = q->ADDR; 0 < n--; t++, s++) {
    ax = 10 * cc + (*s & 0X0F);
    *t = '0' + ax / a;
    cc  = ax % a;
    }
*r->ADDR = '0' + cc;          /* remainder */
return OK;
}

/* compare (unsigned) decimal strings */

int     ss_comp(US *x, US *y)
{
US      u, v;
ss_dropz(&u, x);
ss_dropz(&v, y);
if (u.SDLEN > v.SDLEN) return 1;
else if (u.SDLEN < v.SDLEN) return -1;
return memcmp(u.ADDR, v.ADDR, u.SDLEN);
}

int ss_rlong(US *x, int n)
{
extern  int rand();
char   *d_10="0123456789";
int     i, k;
if (ss_alloc(x, n)) return ERROR;
for (i=0; i<n; i++) {
    k = (i == 0);
    (x->ADDR)[i] = d_10[k+rand() % (10-k)];
    }
return OK;
}














