/* elliptic curve with parameters a, c.
ecc -zone y0 x0 y1 x1 -size ny nx -ofile file ...
minimum memory varsion. Allocate only one line                                    
*/                                                                                
                                                                                  
#include <stdio.h>                                                                
#include <math.h>                                                                 
                                                                                  
#define ERROR   -1                                                                
                                                                                  
double  zw[4]   = {-2,-2,2,2};                                                    
int     size[2] = {24,80};                                                        
double  eps     =  1.0e-10;     /* -eps epsilon */                                
double  a       = 1.0;          /* solve Y^2=X^3+aX+c */                          
double  c       = 1.0;                                                            
int     bailout = 35;           /* maximum iteration */                           
char   *ofile   = NULL;                                                           
char   *lut     = ".123456789ABCDEF";                                             
int     nlut;                                                                     
int     fcmax   = 6;                                                              

main(argc, argv)                                                                  
int argc;                                                                         
char **argv;                                                                      
{                                                                                 
extern  double  atof();                                                           
extern  char   *malloc();                                                         
FILE   *ofp = NULL;                                                               
char   *s;                                                                        
char   *rup, *t;                                                                  
int     i, j, k;                                                                  
double  x, y, dx, dy;                                                             
                                                                                  
for(argv++, argc--; 0 < argc--; argv++) {                                         
    s = *argv;                                                                    
    if (s[0] == '-') switch(s[1]) {                                               
        case 'z':   /* zone */                                                    
                zw[0] = atof(*++argv);                                            
                zw[1] = atof(*++argv);                                            
                zw[2] = atof(*++argv);                                            
                zw[3] = atof(*++argv);
                argc -= 4;                                                        
        break;                                                                    
        case 's':   /* size */                                                    
                size[0] = atoi(*++argv);                                          
                size[1] = atoi(*++argv);                                          
                argc -=2;                                                         
        break;                                                                    
        case 'l':       /* lut */                                                 
                lut = *++argv;                                                    
                argc--;                                                           
        break;                                                                    
        case 'o':       /* ofile */                                               
                ofile = *++argv;                                                  
                argc--;                                                           
        break;                                                                    
        case 'b':       /* -bailout */                                            
                bailout = atoi(*++argv);                                          
                argc--;                                                           
        break;                                                                    
        case 'e':       /* -eps */
                eps = atof(*++argv);                                              
                argc--;                                                           
        break;                                                                    
        case 'a':       /* -a */                                                  
                a = atof(*++argv);                                                
                argc--;                                                           
        break;                                                                    
        case 'c':       /* -c */                                                  
                c = atof(*++argv);                                                
                argc--;                                                           
        break;                                                                    
        default: break;                                                           
        }                                                                         
    }                                                                             
nlut = strlen(lut);                                                               
                                                                                  
if (ofile) {                                                                      
    ofp = fopen(ofile, "w");                                                      
    if (ofp == NULL) return ERROR;                                                
    }
else    ofp = stdout;                                                             
                                                                                  
fprintf(ofp,                                                                      
    "ecc -size %d %d -zone %f %f %f %f -a %f -c %f -eps %f -bailout %d -lut %s\n",
     size[0], size[1], zw[0], zw[1], zw[2], zw[3], a, c, eps, bailout, lut);      
                                                                                  
if (NULL == (rup = malloc(1+size[1]))) return ERROR;                              
dy=(zw[2]-zw[0])/(size[0]-1);                                                     
dx=(zw[3]-zw[1])/(size[1]-1);                                                     
for (i=0, y=zw[0]; i < size[0]; i++, y +=dy) {                                    
    for (t=rup, j=0, x=zw[1]; j < size[1]; j++, x += dx) {                        
        k = nr_ecc(y,x);                                                          
       *t++ = (k == 0) ? ' ': lut[k % nlut];                                      
        }                                                                         
    for (t = rup, j=0; j < size[1]; j++) fputc(*t++, ofp);                        
    fputc('\n', ofp);                                                             
    }                                                                             
if (ofile) fclose (ofp);                                                          
return 0;                                                                         
}
                                                                                  
/* dynamic system z<-F(z) with global parameters eps, bailout                     
*   F(z) = 2*z^3-b+Y^Y/(3*z^2+a)                                                  
*   iterate z <- z-f(z)/f'(z) until |f(z)/f'(z)|<eps                              
*   here we set z = x+iy                                                          
*   start the iteration with cy, cx                                               
*/                                                                                
                                                                                  
int     nr_ecc(cy, cx)                                                            
double  cy, cx;                                                                   
{                                                                                 
double  x = cx, y = cy;                                                           
double  reysq = cx*cx - cy*cy;                                                    
double  imysq = 2*cx*cy;                                                          
double  x1, x2, y1, y2, nx, ny, dx, dy, delta;
int     j;
for(j = 0; j < bailout; j++) {
    if (1e10 < x*x+y*y) return 0;      /* infinity */
    x2 = x*x; y2 = y*y;
    dx = 3*(x2-y2) + a;
    dy = 6*x*y;
    delta =dx*dx+dy*dy;
    if (delta < eps) return 0;
    nx = c + 2*x*(x2-3*y2) - reysq;
    ny = 2*y*(3*x2-y2) - imysq;
    x1 = (nx*dx+ny*dy)/delta;                                                     
    y1 = (ny*dx-nx*dy)/delta;                                                     
    dx = x-x1;                                                                    
    dy = y-y1;                                                                    
    delta = dx*dx + dy*dy;                                                        
    if (delta < eps) return j;                                                    
    x = x1;                                                                       
    y = y1;                                                                       
    }                                                                             
return 0;                                                                         
}                                                                                 
                                                                                  
