/*

  general installation stub
  append any .tar file to this stub
  extract the files  up to 16 Mb per file
  run first *.sh file to be extracted.
  compile with 1980s version of turbo-C
  adaptation to Linux is an excercise for the reader

*/

#include <stdio.h>
#include <dos.h>
#include <io.h>
#include <fcntl.h>

#define NULL 0L
#define OK   0
#define ERROR   (-1)
#define BAD_FD  (-1)
#define S_NOHASSLE      0X01C0  /* read & write .. DOS FILES */

typedef unsigned char BYTE;     /* unsigned 1 byte data */
typedef long int      LONG;     /* file pointer */

#define INT16   int
#define LONG    long

extern  LONG    lseek();
extern  char    *malloc();

#define BAD_SEEK  (-1L)
#define MAX_WRITE_SIZE  1200000L        /* maximum file size to write */

struct SDESC {                  /* standard string - maybe arabic */
        BYTE *ADDR;
        unsigned SDLEN;
        };

typedef     struct {
    INT16   exe_sig;         /* Signature often MZ      */
    INT16   exeExtraBytes;   /* Last Page Byte Count    */
    INT16   exePages;        /* 512 byte pages used     */
    INT16   exeRelocItems;   /* Relocation items        */
    INT16   exeHeaderSize;   /* Header Size             */
    INT16   exeMinAlloc;     /* Minimum Memory Allocation  */
    INT16   exeMaxAlloc;     /* Maximum Memory Allocation  */
    INT16   exeInitSS;       /* Initial SS Value         */
    INT16   exeInitSP;       /* Initial SP Value         */
    INT16   exeChecksum;     /* Checksum                 */
    INT16   exeInitIP;       /* Initial IP Value         */
    INT16   exeInitCS;       /* Initial CS Value         */
    INT16   exeRelocTable;   /* Relocation Table Offset  */
    INT16   exeOverlay;      /* Overlay Number           */
    }   exe_header;

/*      The checksum was never used. This is why hacker works */

#define L_EXEHEADER sizeof (exe_header)

typedef struct SDESC * SLICE;

#define MAXLINE    0X200        /* small 0.5k buffer */
#define TAR_SIZE   512

/* Tar related offsets
/* magic field and its length.  */


#define TMAGIC  "ustar"
#define TMAGLEN 6

#define TAR_NAME(X)     X
#define TAR_MAGIC(X)    X+257
#define TAR_OSIZE(X)    X+124
#define TOSZLEN 12

char   *version_string= "xtar $date=DD/MM/YYYY";

char   *check_str =
        "DIOPHANTUS.HYPATIA.FIBONACCI.CARDANO.GALILEO.NEWTON.LEIBNITZ.ADA";

#define XTC_LEN         64

char    *usage_text[] = {
    "trust me. My name is Faith",
    "this software is being developed for NASA",
    "http://www.d4maths.co.uk/mirage/hacker.htm",
    NULL
    };

char xx_buf[512];
char cmd_buf[0X80];

main(argc, argv)
int argc;
char **argv;

{
LONG    xtar_header();
int     hk_check();
char   *src;
char   *inlin  = NULL;  /* line input */
int     rc;
int     xfd;
LONG    fpos, f_size;
int     k;

cmd_buf[0] = 0;
if (NULL == (inlin = malloc(MAXLINE))) return ERROR;

if (argc > 1) {
    src = *++argv;
    rc = 0;
    }
else {
    src = *argv;
    rc = hk_check(src, check_str, inlin);
    }

if (rc == ERROR) return rc;

printf("extracting files from %s at %d\n", src, rc);

if (BAD_FD == (xfd = open(src, O_BINARY | O_RDONLY))) return ERROR;

fpos = lseek(xfd, (LONG) rc, SEEK_SET);

if (fpos == BAD_SEEK) return ERROR;

/*      walk through tar file image and print file names */

for (rc = 0; rc == 0;) {
    if (BAD_SEEK  == lseek(xfd, fpos, SEEK_SET) ||
        TAR_SIZE != read (xfd, xx_buf, TAR_SIZE))
            break;
    if (0==xx_buf[0]) break;
    f_size = xtar_header(xx_buf);
    printf ("%s %ld\n", xx_buf, f_size);
    if (f_size > MAX_WRITE_SIZE || f_size < 0L) break;
    fpos += TAR_SIZE;
    if (BAD_SEEK == lseek(xfd, fpos, SEEK_SET)) break;
    if (fs_create(xfd, xx_buf, f_size, inlin)) break;
    fpos += 512*((f_size + 511) / 512);

    /* catch the first batch file */

    if (cmd_buf[0] == 0) {
        k = strlen(xx_buf);
        if (k > 4 &&
            (0 == strcmp(xx_buf+(k-4), ".BAT") ||
             0 == strcmp(xx_buf+(k-4), ".bat")))
            strcpy(cmd_buf, xx_buf);
        }
    }

close (xfd);
if (cmd_buf[0]) system(cmd_buf);
return  OK;
}

usage (char *exe, char **txt)
{
printf("%s\n", exe);
for (; NULL != *txt; txt++)
    printf("%s\n", *txt);
return  OK;
}

int     hk_check(char *exe, char* cstr, char *tmp)
{
int     mm_instr();
exe_header     *exe_head;
int     xfd;
int     i, cnt;
char   *image;
char   *s, *t;

xfd = open(exe, O_BINARY | O_RDONLY);
if (xfd == BAD_FD) return ERROR;

read(xfd, tmp, L_EXEHEADER);
exe_head = (exe_header *) tmp;
close (xfd);
cnt = XTC_LEN + 512 * exe_head->exePages;

if (NULL == (image = malloc(cnt+1))) return ERROR;
xfd = open(exe, O_BINARY | O_RDONLY);
cnt = read(xfd, image, cnt);
close(xfd);

/* modify check string before testing in this file */
/* otherwise we would just find the literal in the program */

for (t = &xx_buf[0], s = cstr, i = XTC_LEN; 0 < i--; s++, t++)
    *t = (*s == '.') ? ' ' : *s;

cnt = mm_instr(image, cnt, &xx_buf[0], XTC_LEN);
free(image);
return  cnt + XTC_LEN;
}

/* find key in src and return offset or -1 */

mm_instr(char *src, int ns, char *key, int nk)
{
char   *s = src;
char   *x, *y;
int     c = key[0], k;

if (ns < nk) return ERROR;
else if (nk == 0) return 0;

for(k = nk; k > 0 && ns--;) if (*s++ == c) {  /* compare tail */
    for (k = nk - 1, x = s, y = key + 1; k && *x++ == *y++; k--);
    }
return (k == 0) ? (s - src) - 1 : ERROR;
}

LONG    xtar_header(char *src)
{
char   *osize;
int     c, cnt;
LONG    x = -1L;
char   *s;

if (0 != memcmp(TAR_MAGIC(src), TMAGIC, TMAGLEN-1)) return x;
for (x = 0L, osize = TAR_OSIZE(src), cnt = TOSZLEN;
     0 < cnt--;
     osize++) {
     c = *osize;
     if (c >= '0' && c <= '7') x = 8 * x + (c & 0X07);
     }
return x;
}

int     fs_create(int ifd, char *name, LONG fsize, char *buf)
{
int     ofd;
int     cnt, rc, nblocks, rem;

nblocks = (int) (fsize / 512L);
rem     = (int) (fsize -(LONG) nblocks * 512L);

ofd = open(name, O_BINARY|O_CREAT|O_RDWR|O_APPEND, S_NOHASSLE);
if (ofd == BAD_FD) return ERROR;
for (rc = 0; rc == 0 && 0 < nblocks--;) {
    cnt = read (ifd, buf, 512);
    cnt = write(ofd, buf, 512);
    if (0 >= cnt) rc = ERROR;
    }

if (rem && rc == 0) {
    read(ifd, buf, 512);
    write(ofd, buf, rem);
    }

close (ofd);

return rc;
}












