/* Fold key-words. See FOLD.DOC */

#include <na.h>
#include <fdata.h>

#define LX_MOD  512
BYTE    lx_xi[LX_MOD];

static int lx_wt[]={55,19,27,13,3,25,39,45,27};

struct ISM_NZ { char *name; int kf; int zcode; } lx_systab[] = {
{"abs",          94, F_ABS       },
{"and",         429, F_AND       },
{"av",          473, F_AV        },
{"atan",        132, F_ATAN      },
{"base",        195, F_BASE      },
{"call",        152, F_CALL      },
{"cd",          241, F_CD        },
{"cieling",     253, F_CIELING   },
{"circle",      510, F_CIRCLE    },
{"close",        36, F_CLOSE     },
{"cmd",           8, F_CMD       },
{"copy",        183, F_COPY      },
{"cursor",      256, F_CURSOR    },
{"dbclose",     186, F_DBCLOSE   },
{"dbget",        60, F_DBGET     },
{"dbnames",      18, F_DBNAMES   },
{"dbput",       511, F_DBPUT     },
{"dbsize",       67, F_DBSIZE    },
{"dbtie",       418, F_DBTIE     },
{"deb",         369, F_DEB       },
{"decode",      216, F_DECODE    },
{"del",         127, F_DEL       },
{"disk",         23, F_DISK      },
{"dltb",        502, F_DLTB      },
{"do",          505, F_DO        },
{"domino",      366, F_DOMINO    },
{"drop",        151, F_DROP      },
{"encode",      442, F_ENCODE    },
{"envp",        319, F_ENVP      },
{"equiv",       324, F_EQUIV     },
{"ex",          219, F_EX        },
{"exp",         139, F_EXP       },
{"fi",          501, F_FI        },
{"files",       435, F_FILES     },
{"find",        419, F_FIND      },
{"floor",       188, F_FLOOR     },
{"fmt",          93, F_FMT       },
{"fnames",      258, F_FNAMES    },
{"fsize",       263, F_FSIZE     },
{"fstat",       280, F_FSTAT     },
{"ge",          480, F_GE        },
{"goto",        381, F_GOTO      },
{"ifdef",       288, F_IFDEF     },
{"ifndef",      180, F_IFNDEF    },
{"inkey",       174, F_INKEY     },
{"inlin",       220, F_INLIN     },
{"inner",       234, F_INNER     },
{"inp",         169, F_INP       },
{"int",         277, F_INT       },
{"iota",        309, F_IOTA      },
{"is",          344, F_IS        },
{"kjarc",        41, F_KJARC     },
{"kjbloc",      101, F_KJBLOC    },
{"kjfill",      386, F_KJFILL    },
{"kjget",        85, F_KJGET     },
{"kjput",        24, F_KJPUT     },
{"kjvec",       439, F_KJVEC     },
{"kjplot",      392, F_KJPLOT    },
{"le",          243, F_LE        },
{"ln",          414, F_LN        },
{"load",          0, F_LOAD      },
{"lprint",       61, F_LPRINT    },
{"mattoss",     235, F_MATTOSS   },
{"mkdir",       179, F_MKDIR     },
{"member",      116, F_MEMBER    },
{"mod",          84, F_MOD       },
{"nc",          315, F_NC        },
{"ne",          353, F_NE        },
{"nfind",       297, F_NFIND     },
{"nxfind",      111, F_NXFIND    },
{"nl",          486, F_NL        },
{"open",        422, F_OPEN      },
{"or",          143, F_OR        },
{"outp",        436, F_OUTP      },
{"outer",       347, F_OUTER     },
{"peek",        229, F_PEEK      },
{"phi",         251, F_PHI       },
{"port",        375, F_PORT      },
{"print",       171, F_PRINT     },
{"qmenu",        26, F_QMENU     },
{"quit",        301, F_QUIT      },
{"read",        140, F_READ      },
{"represent",    22, F_REPRESENT },
{"rho",          11, F_RHO       },
{"rmdir",       492, F_RMDIR     },
{"rxfind",      331, F_RXFIND    },
{"rxsubs",      153, F_RXSUBS    },
{"save",        187, F_SAVE      },
{"screen",      482, F_SCREEN    },
{"sed",         224, F_SED       },
{"sleep",       497, F_SLEEP     },
{"socket",       21, F_SOCKET    },
{"sort",         28, F_SORT      },
{"split",       314, F_SPLIT     },
{"sqrt",         66, F_SQRT      },
{"sstomat",     425, F_SSTOMAT   },
{"take",        457, F_TAKE      },
{"theta",       114, F_THETA     },
{"transpose",    99, F_TRANSPOSE },
{"ts",          437, F_TS        },
{"use",         115, F_USE       },
{"val",          17, F_VAL       },
{"varptr",      385, F_VARPTR    },
{"vram",        212, F_VRAM      },
{"wget",        257, F_WGET      },
{"window",      438, F_WINDOW    },
{"wput",        348, F_WPUT      },
{"write",        77, F_WRITE     },
{"x",           296, F_X         },
{"zgets",       479, F_ZGETS     },
{"zload",        40, F_ZLOAD     },
{"zputs",        58, F_ZPUTS     },
{"zsave",        71, F_ZSAVE     },
{ NULL,           0, 0 }};

lx_sysinv()    /* map key-words to lx_xi */
{
struct  ISM_NZ* nz = lx_systab;
BYTE   *s;  /* symbol */
int     k;
for (k = 0;;k++, nz++) {
    if(NULL == nz->name) break;
    lx_xi[nz->kf] = k+1;
    }
return OK;
}

lx_fold(dst, sym)        /* fold symbol */
MATRIX dst;     /* function object */
SLICE  sym;     /* symbol */
{
BYTE   *s = sym->ADDR;  /* symbol */
int     n = sym->SDLEN;
int    *ix = &lx_wt[0];
unsigned int hc = 0;
int     fc, op;
   /* mod 32, so fold upper, lower case */
for (hc = 0, n--, s++; 0 < n--; ix++, s++)
    hc += (*ix) * (0X1F & *s);
hc = hc % LX_MOD; /* modulus */
if (0 == (fc = lx_xi[hc])) return ERROR;
op = lx_systab[fc-1].zcode;
mkobj(dst, 'F', op, 0);
if (op > 127) {       /* special */
    MELSIZ(dst->ADDR) = 'S';
    MINDX(dst->ADDR)  = op;
    }
return OK;
}

