/*      lexical analyser */

#include <na.h>
#define LEX_TABLES
#include <lex.h>
#include <dt.h>
#include <fdata.h>

#ifdef TC
#define MAX_INT_DIGITS   5
#else
#define MAX_INT_DIGITS  10
#endif

int     lx_intv;

lx_init2()      /* tables for composite function symbols */
{
int     fc, j;
char   *s;
memset(vid_a, 0, 256);
for (s = lx_f2c, j = 0; *s; s++) vid_a[*s] = ++j;
for (j = 0; j < 121; j++) vid_b[j] = 0;
j = strlen(lx_f2map) / 3;
for (s = lx_f2map; 0 < j--; s+=3) {
        fc = 11*vid_a[s[0]]+vid_a[s[1]];
        vid_b[fc] = s[2];
        }
return  OK;
}

lx_split(dst, xx)       /* split to tokens */
TAGD  dst;              /* parts */
SLICE xx;               /* text line */
/*      exit states:    number of tokens
*                       pointer, final state.
*/
{
BYTE   *s;
int     k, mode, next, qa;
int     n, cnt=0;
int     ntok;
s = xx->ADDR;
n = xx->SDLEN;
for(mode = ntok = 0; mode < LEX_EXIT; n--, s++) {
        k = (n > 0) ? lx_ctype[*s] & 0X0F : lx_stopc;
        next = lx_t1[mode * LEX_NTYPE + k];
        qa   = lx_t2[mode * LEX_NTYPE + k];
        qa = qa & 3;
        switch (qa) {
        case 3:
        case 2: /* finish */
                dst->tag = lx_tsym[mode];
                dst->slice.SDLEN = cnt;
                dst++;
                ntok++;
                cnt = 0;
                if (qa == 2) break;
        case 1: /* start */
                dst->slice.ADDR = s;
                cnt = 1;
                break;
        case 0: if (mode != 0) cnt++;
                break;
                }
        mode = next;
        }

/* terminating state */
dst->tag = lx_tsym[mode];
for(; n < 0; n++, s--);
dst->slice.SDLEN = n;
dst->slice.ADDR  = s;
return(ntok+1);
}

lx_asplit(tk, src)      /* get ALL tokens in slice */
TAGD    tk;     /* stack */
SLICE   src;    /* line  */
/*      no validation here */
{
struct SDESC tt;
TAGD    tmp;
int     n;
tt.ADDR  = src->ADDR;
tt.SDLEN = src->SDLEN;
for (n = 2, tmp = tk; n > 1;) {
        n = lx_split(tmp, &tt);
        tmp += n;
        tt = (tmp-1)->slice;
        if ('X' == (tmp-1)->tag) break;
        }
n = tmp-tk;   /* cursor */
return(n);
}

/*
*       Convert a slice of text to tokens
*       Update the pointer in the text matrix
*/

MATRIX  sk_decode (sp, str)
MATRIX  sp;     /* stack pointer */
SLICE   str;    /* for error */
{
struct  SDESC tt;
TAGD    tp, tmp;
BYTE   *s = (sp-1)->ADDR;
int     n  = MSIZE(s);
int     nc = MCOLS(s);
int     j  = MINDX(s);
int     rc = 0;

if (n == 0)  {
    str->ADDR  = NULL;
    str->SDLEN = 0;
    rc = ERR_LEX;
    }

while (rc == 0) {
    rc = EV_DO;
    str->ADDR  = TEXT_PTR(sp-1) + j;
    str->SDLEN = nc - (j % nc);
    if(mk_tabs(sp, 2*str->SDLEN, sizeof(tdesc))) {
        rc = ERR_MEM;
        break;
        }
    tp = TAG_PTR(sp);
    n = lx_split(tp, str);      /* lexical analyser */
    tmp = tp+n-1;
    if ('E' != tmp->tag) {
        rc = ERR_LEX;
        break;
        }
    MINDX(s) = (tmp->slice.ADDR) - TEXT_PTR(sp-1);
    MELSIZ(s) = (MINDX(s) >= MSIZE(s))  ? 'Y':'X';
    if (n == 1 || 0 == (n = lx_ncat(sp+1, tp))) {
        mkobj(sp++, 'T', 0, 0);
        break;
        }
    tt.ADDR  = sp->ADDR;    /* rotate sp to sp+n */
    tt.SDLEN = sp->SDLEN;
    for (; 0 < n--; sp++) *sp = *(sp+1);
    sp->ADDR = tt.ADDR;
    sp->SDLEN = tt.SDLEN;
    }
mkobj(sp, 'F', rc,  0);
return sp;
}

lx_ncat(dst, tok)       /* concatenate numeric objects */
MATRIX dst;             /* for objects */
TAGD tok;               /* tagged slices */
{
DOUBLE  lx_stod();
MATRIX  sp = dst;
TAGD    npoint, npx;
int     rc = 0;
int     qf=0, n, ncnt, fc;
int    *ix;
DOUBLE *xd;

/*  labels    don't store 'name:' or "text": combination */

while ((tok->tag == 'A' || tok->tag == 'T' || tok->tag == 'D') &&
        ':' == *((tok+1)->slice.ADDR))
    tok += 2;

for (npoint = tok, n = ncnt = 0; rc == 0; tok++) {
    fc = tok->tag;
    if (ncnt && fc !='N' && fc != 'D') {
        npx = npoint;
        switch (qf) {
        case 'N':       /* integer constant */
            if(rc = mkobj(sp, 'N', ncnt, ncnt)) break;
            ix = INT_PTR(sp);
            lx_intv = 0;
            for (n = ncnt; lx_intv == 0 && n--; ix++, npx++)
                *ix = lx_stoi(&npx->slice);
            if (lx_intv == 0) break;
        case 'D':       /* something else .. so float */
            if(rc = mkobj(sp, 'D', ncnt, ncnt)) break;
            xd = DBL_PTR(sp);
            for (n = ncnt, npx = npoint; n--; xd++, npx++)
                *xd = lx_stod(&npx->slice);
        default: break;
        }
    ncnt = 0;
    sp++;
    }
    switch (fc) {
        case 'A':       /* name */
                rc = mk_sk(sp++, TYPI, &tok->slice);
                break;
        case 'D':       /* number */
        case 'N':
                if (ncnt == 0) {
                    npoint = tok;
                    qf = fc;
                    }
                else if (fc == 'D') qf = fc;
                ncnt++;
                break;
        case 'F':       /* functions */
                sp += lx_stkop(sp, &tok->slice);
                break;
        case 'S':       /* special   */
                rc = lx_fold(sp, &tok->slice);
                        /* modify with next operator */
                if (rc == 0 && MINDX(sp->ADDR) == F_OUTER) {
                    tok++;
                    MCOLS(sp->ADDR) = *(tok->slice.ADDR);
                    }
                sp++;
                break;
        case 'T':       /* text         */
                rc = lx_stotxt(sp++, &tok->slice);
                break;
        default: break;
        }
    if (fc == 'E') break;
    }
return (sp-dst);
}

lx_stkop(dst , ss)     /* split operators */
MATRIX dst;     /* pointer */
SLICE  ss;      /* descriptor -- operators */
{
MATRIX  p = dst;
BYTE   *s = ss->ADDR;
int     n = ss->SDLEN;
int     c, cprev, iprev, inow, fc, op;

for (cprev = iprev = 0; 0 < n--; s++) {
    op = 0;
    inow = vid_a[c = *s];
    if (c == ':' && cprev) {
         mkobj(p, 'F', cprev, 0);
         MINDX(p->ADDR) = AXIS_MODIFIER;
         p++;
         inow = c = 0;
         }
    else if (fc = vid_b[11 * iprev + inow]) {
        op = fc;
        inow = c = 0;
        }
    else if (cprev) op = cprev;
    iprev = inow;
    cprev = c;
    if (op) mkobj(p++, 'F', op, 0);
    }
if (cprev) mkobj(p++, 'F', cprev, 0);
return (p - dst);
}

lx_stotxt(dst, src)     /* store text */
MATRIX dst;
SLICE src;
{
/*      undouble quotes         */
BYTE   *t, *s = src->ADDR;
int     n = src->SDLEN;
int     rc, cnt, mode;
for (cnt = 0, n -= 2 , t = s + 1; n > 0; n--, t++)
        if (*t == lx_quote) cnt++;
cnt  = src->SDLEN - (2 + (cnt / 2));
if (rc = mkobj(dst, 'T', cnt, cnt))
        return(rc);
t = TEXT_PTR(dst);
for (s++, n = src->SDLEN - 2, mode = 0; n > 0; n--, s++)  {
        if (lx_quote == *s) mode = ! mode;
        if (! mode) *t++ = *s;
        }
return(rc);
}

fx_val(dst, src)        /* text -> num */
MATRIX dst;             /* numeric */
MATRIX src;             /* ASCII */
{
DOUBLE  lx_stod();
struct  SDESC tt;
BYTE   *s;
DOUBLE *xd;
int    *di;
int     n  = MSIZE(src->ADDR);
int     qs;
int     c, ntok;

if(MTYPE(src->ADDR) != TYPT) return ERROR;

for (s = TEXT_PTR(src), ntok = 0, c = '@'; 0 < n--; s++) {
    if (c == '@' && lx_ctype[*s] != '@') ntok++;
    c = lx_ctype[*s];
    }

if (mkobj(dst, 'N', ntok, ntok)) return ERROR;
di = INT_PTR(dst);
n  = MSIZE(src->ADDR);
s  = TEXT_PTR(src);

lx_intv = 0;
for (qs = 0; 0 < n-- && lx_intv == 0; s++)
    switch(2 * qs + (lx_ctype[*s] != '@')) {
    case 1: tt.ADDR = s;
            tt.SDLEN = 1;
            qs = 1;
        break;
    case 3: tt.SDLEN++;
        break;
    case 2: qs = 0;       /* end of token */
        *di++ = lx_stoi(&tt);
    default: break;
    }
if (qs && lx_intv == 0) *di = lx_stoi(&tt);
if (lx_intv == 0) return OK;

/*      non integer result */

if (mkobj(dst, 'D', ntok, ntok)) return ERROR;
xd = DBL_PTR(dst);
n  = MSIZE(src->ADDR);
s  = TEXT_PTR(src);
for (qs = 0; 0 < n--; s++)
    switch(2 * qs + (lx_ctype[*s] != '@')) {
    case 1: tt.ADDR = s;
        tt.SDLEN = 1;
        qs = 1;
        break;
    case 3: tt.SDLEN++;
        break;
    case 2: qs = 0;       /* end of token */
        *xd++ = lx_stod(&tt);
    default: break;
    }
if (qs) *xd = lx_stod(&tt);
return OK;
}

DOUBLE  lx_stod(xx)     /* slice to double */
SLICE   xx;
{
DOUBLE  val = 0.0, xe = 1.0;
BYTE   *s = xx->ADDR;
int     n = xx->SDLEN;
int     sgn = 1;
int     exp = 0, k, se;
int     c, qs;
for (qs = se = 0, c = *s++; 0 < n--; c = *s++) {
    if (lx_ctype[c] == 'E') k = 1;
    else if (c == '-' || c == '_' || c == '+') k = 0;
    else if (c == '.') k = 2;
    else if (c == 'e' || c == 'E') k = 3;
    else return 0.0;
    switch (4*qs + k) {
    case 0: if (c != '+') sgn = -1;
            val = 0.0;
            qs = 1;
        break;
    case 1: val = (DOUBLE) (c & 0X0F);
            qs = 1;
        break;
    case 5: val = 10.0 * val + (DOUBLE) (c & 0X0F);
        break;
    case 6: xe = 1.0;
            qs = 2;
        break;
    case 9: xe = xe / 10.0;
            val = val + xe * (DOUBLE) (c & 0X0F);
        break;
    case 7:
    case 11:    /* exponent */
            exp = 0;
            se = 1;
            qs = 3;
        break;
    case 12:     /* sign of exponent */
            if (c != '+') se = -1;
        break;
    case 13:
            exp = 10 * exp + (c & 0X0F);
        break;
    default: return 0.0;        /* should not happen */
        break;
        }
    }
if (se == 0 || exp == 0) return (sgn > 0) ? val : -val;
if (se > 0)  while(exp--) val = val * 10.0;
else         while(exp--) val = val * 0.1;
return (sgn > 0) ? val : -val;
}

lx_stoi(xx)     /* convert to integer */
SLICE xx;
{
BYTE   *s = xx->ADDR;
int     n = xx->SDLEN;
double  xsum;
int     sgn = 1, sum = 0;
int     c   = *s;
lx_intv = 0;
if (n == 0) return 0;
else if (n == 1 && lx_ctype[c] == 'E')
    return c & 0X0F;    /* one digit numeric constant */

if (c == '-' || c == '_') {
    sgn = -1;       /* negative */
    n--;
    c = *++s;
    }
else if (c == '+') {
    n--;
    c = *++s;
    }
else if (c == '.' || c == 'e' || c == 'E') {
    lx_intv = 1;
    return 0;
    }

while (c == '0' && n--) c = *++s;       /* leading zeros */

if (n > MAX_INT_DIGITS) {
    lx_intv = 1;
    return sgn * MAX_INT;
    }
else if (n == MAX_INT_DIGITS) {
    for (xsum = 0.0; n--; s++)
        if ('E' == lx_ctype[c = *s]) xsum = 10 * xsum + (c & 0X0F);
        else lx_intv = 1;
    if (xsum > (double) MAX_INT) {
        lx_intv = 1;
        return sgn * MAX_INT;
        }
    else return sgn * (int) xsum;
    }
        /* reasonable number of digits */

while (n--)
    if ('E' == lx_ctype[c = *s++]) sum = 10 * sum + (0X0F & c);
    else lx_intv = 1;
return sgn * sum;
}




