#include <htext.h>
#include <na.h>
#include <fdata.h>
#include <dt.h>
#include <sy95.h>
#include <scrnio.h>

/* __version__ */
#if defined (TC)
char   *d4_version="d4t.exe(dos)     12/2002, http://d4maths.lowtech.org";
#elif defined (DJGPP)
char   *d4_version="d4x.exe(windows) 12/2002, http://d4maths.lowtech.org";
#elif defined (linux)
char   *d4_version="d4x(linux)       11/2009, http://d4maths.lowtech.org";
#else
char   *d4_version="d4x(unknown)     --/----, http://d4maths.lowtech.org";
#endif

char   *d4_licence=
        "Please read the GNU GENERAL PUBLIC LICENSE Version 2, June 1991";
char   *d4_errfmt="ERROR [%3d]: %.*s";
BYTE    d4_errbuf[0X51];                /* hopefully enough */
struct  SDESC   err_str = {NULL,0};     /* error string  */

/* new keywords */

struct HARD_FNS {char *name; int zcode; } hf_tab[] = {
{"BREAKIF",     F_BREAKIF},
{"IF",          F_IF},
{"REPEATIF",    F_REPEATIF},
{"SRAND",       F_SRAND},
{"TTY_SET",     F_TTY_SET},
{"WHILE",       F_WHILE},
{"WEND",        F_WEND},
{NULL, 0}};

struct SOFT_VARS {char *name; int zcode; } sv_tab[] = {
{"$$",       F_SPLIT},
{"$FN",      F_GOTO},
{"$FSTAT",   F_FSTAT},
{"$FTIME",   F_FTIME},
{"$NL",      F_NL},
{"$MEM",     F_PEEK},
{"$INP",     F_PORT},
{"$OUTP",    F_PORT},
{"$S",       F_NXFIND},
{"$SOCKET",  F_SOCKET},
{"$SCR",     F_ZPUTS},
{"$T",       F_NFIND},
{"$V",       F_WINDOW},
{"$VA",      F_DBTIE},
{NULL, 0}};

BYTE   *linbuf = NULL;
int     qt = 0;
int     q_cbreak = 1;   /* allow test for console break in */

main(argc, argv, envp)
int argc;
char **argv;
char **envp;
{
char   *mk_sname();
char   *mkasciz();
MATRIX  sys_alink();
MATRIX  sys_nlink();
MATRIX  sys_text();
extern  int     mm_cnt_alloc;
extern  int     mm_cnt_free;
char    name[6];
MATRIX  p, sp, sz;
char   *aname;
char   *ufile = "init.afn";
BYTE   *s, *t;
int     nstak = SP_MAX;
int     nsym  = SYM_MAX;
int     nww   = WW_MAX;
int     nfile = FF_MAX;
int     do_ufile = 1;
int     q_setenv = 1;
int     cnt, rc, qq;

if (tty_init()  ||
    lx_init2()  ||
    lx_sysinv() ||
    syn_ctset() ||
    sk_setup()  ||
    jt_inv()    ||
    mkobj(pm_sym, 'A', 2 * nsym, nsym))
        exit(ERROR);

/* set up command line parameters $0 $1 .. or name=val */

for(cnt = 0; 0< argc--; argv++) {
    s = (BYTE*) *argv;
    for (t = s; *t && *t !='=';) t++;
    if (*t == '=') {
        *t++ = 0;
        p = sys_nlink(pm_sym, s, t, strlen(t));
        if (t-s == 2) switch (*s) {
            case 'E':   /* don't set env */
            case 'e':   q_setenv = 0;
                break;
            case 'I':   /* internet invoked. Suppress BRAKE test */
            case 'i':   q_cbreak = 0;
                break;
            case 'N':   /* symbols */
            case 'n': nsym = atoi(t);
                break;
            case 'S':   /* stack */
            case 's': nstak = atoi(t);
                break;
            case 'W':   /* windows */
            case 'w': nww   = atoi(t);
                break;
            case 'F':   /* files */
            case 'f': nfile = atoi(t);
                break;
            case 'K':   /* get first command from keyboard */
            case 'k':   do_ufile = 0;
            default: break;
            }
        }
    else {
        aname = mk_sname(&name[0], cnt);
        if (cnt == 1) ufile = s;
        sys_nlink(pm_sym, aname, s, strlen(s));
        cnt++;
        }
    }

rc =    na_getenv("$ENVP", envp, q_setenv)
     || na_reset(nsym, nstak, nfile, nww);
if (rc) exit(rc);
sp = sz = NA_PTR(pm_stack);       /* a stack */

if (do_ufile) mkobj(++sp, 'F', EV_FILE, 0);

tty_set(1);

/*      Take next state from stack */

for (qq = 0; qq != EV_EXIT;) {
    if (rc)             qq = EV_ELX;
    else if (q_cbreak && BRAKE)
                        qq = EV_ALX;
    else if (sp == sz)  qq = EV_KBIN;
    else if (sp->ADDR == NULL || TYPF != MTYPE(sp->ADDR))
                        qq = EV_ELX;
    else                qq = MELSIZ(sp->ADDR);  /* return code */
    switch(qq) {
    case F_LOAD:        /* load */
        ufile = mkasciz(sp+1);
        rc = na_reset(0, nstak, nfile, nww);
    case EV_FILE:       /* startup file */
        sys_nlink(pm_sym, "_UFILE", ufile, strlen(ufile));
        sp = sz = NA_PTR(pm_stack);
        rc = na_fload(ufile, pm_sym, pm_stack);
        if (qq == F_LOAD) free(ufile);
        if (rc || NULL == sp->ADDR)
            rc = mkobj(sp,   'F', EV_KBIN, 0);
        else
            rc = mkobj(++sp, 'F', EV_DECOD, 0);
        break;
    case EV_ELX:
        if (err_str.SDLEN > 64) err_str.SDLEN = 64;
        if (err_str.ADDR != NULL) {
        cnt = sprintf(d4_errbuf, d4_errfmt, rc, err_str.SDLEN, err_str.ADDR);
        sys_nlink(pm_sym, "$ERROR", d4_errbuf, cnt);
        printf("%s\r\n", d4_errbuf);

#ifdef  DJGPP
          if (mm_vptr != NULL) ScreenRetrieve(mm_vptr);
#endif
        }
    case EV_ALX:        /*  break in key .. test for EV.ALX */
    case EV_KBIN:       /* key-board input */
        pm_stack = sys_alink(pm_sym, "$stack", nstak, 1);
        if (pm_stack == NULL) {
            qq = EV_EXIT;
            break;
            }
        sp = NA_PTR(pm_stack);
        rc = 0;
        p = sys_text(pm_sym, (qq == EV_ALX) ? "EV.ALX" : "EV.KB");
        if (p != NULL) sasa(sp, p);
        else {
            tty_set(0);
            while (0 == inlin(sp));
            tty_set(1);
            }
        MELSIZ(sp->ADDR) = 'Y';
        MINDX(sp->ADDR)  = 0;
        mkobj(++sp, 'F', EV_DECOD, 0);
        break;
    case EV_DECOD:  /* decode */
        sp = sk_decode(sp, &err_str);
        break;
    case  EV_DO:    /* do it */
        sp = unstak(sp);
        break;
    default:
        rc = qq;
        mkobj(sp, 'F', EV_ELX, 0);
        break;
        }
    }

sys_del(pm_sym);        /* should delete all allocated blocks */
tty_set(0);             /* this has the effect 'stty sane' */
if (mm_cnt_alloc != mm_cnt_free)
       printf ("MEMORY ALLOCATION ERROR %d:%d\r\n ",
           mm_cnt_alloc, mm_cnt_free);
return  rc;
}

MATRIX  unstak(sp)      /* analyse  stack */
MATRIX  sp;
{
MATRIX  sys_nget();
MATRIX  sk_down();
MATRIX  p = NULL;
MATRIX  sz = NA_PTR(pm_stack);
MATRIX  sr;
BYTE   *s;
int     qpp = 1;            /* print result */
int     ag, k, qa, qr, rc, tc;

sk_r3 = 0;      /* initialise shift */

for (tc = rc = 0; rc == 0 && tc != 'X' && --sp >= sz;) {
    s = sp->ADDR;
    tc = sk_look(s);
    if (tc == 'I') {
        if (NULL == (p  = sys_nget(pm_sym, sp))) tc = 'V';
        else switch(tc = sk_look(p->ADDR)) {
        case 'U':       /* function */
            mkobj(sp, 'F', 'U', 0);
            MINDX(sp->ADDR)  = MINDX(pm_sym->ADDR);
            break;
        case 'A':       /* nested array */
            MELSIZ(sp->ADDR) = 'A';
            MINDX(sp->ADDR)  = MINDX(pm_sym->ADDR);
            tc = 'D';
            break;
        case 'V':       /* no op */
            break;
        case 'F':       tc = 'F';
        default:
            rc = sasa(sp, p);   /* data */
            break;
            }
        }
    if (rc) break;
    sk_r3 = SK_RDX * (sk_r3 % SK_RDXSQ) + sk_tr[tc];
    ag = sk_xmap[sk_r3]-1;
    if (ag == ERROR)    continue;
    if (ag != 4)        qpp = 1;
    switch (ag) {
    case 0:                /* niladic F00 */
        if ('U' == MELSIZ(sp->ADDR)) rc = EV_FETCH;
        else if (0 == (rc = gofx(sp, 0))) sk_r3 = sk_tr['D'];
        else if (rc == '+' || rc == '-') {      /* postfix ++ -- */
            mkobj(sp, 'N', 0, 0);
            MINDX(sp->ADDR) = rc;
            sp--;
            if (MTYPE(sp->ADDR)==TYPF && MELSIZ(sp->ADDR) == rc) {
                MELSIZ(sp->ADDR) = 'a';
                sk_r3 = SYN_HD0;
                rc = 0;
                }
            else rc = MELSIZ(sp->ADDR);
            }
        break;
    case 1:                /* monadic XFD (FD [FD HFD FFD */
        sp++;
        s = sp->ADDR;
        tc = MELSIZ(s);
        if (tc == 'U') rc = EV_FETCH;
        else if (tc == 'x' || (tc == 'S' && MINDX(s) == 'x')) {
            s = (sp+1)->ADDR;                   /* dynamic text */
            if (MTYPE(s) != TYPT || MSIZE(s) == 0)
                rc = mkobj(sp, 'T', 0, 0);      /* no error */
            else if (MSIZE(s) == MCOLS(s)) {    /* ok */
                MINDX(s) = 0;           /* set counter */
                MELSIZ(s) ='X';
                rc = EV_DECOD;
                sp += 2;                /* text + 1 */
                }
            else rc = 'x';
            }
        else    rc = gofx(sp, 1);
        sk_r3 = sk_tr[tc = 'D'];
        break;
    case 2:                /* dyadic DFD -> D00 */
        sa_swap(sp, sp+1);
        s = sp->ADDR;
        if ('U' == MELSIZ(s)) rc = EV_FETCH;
        else if ('A' == MELSIZ((sp+1)->ADDR))
                rc = use_get(sp, sp+1, sp+2);
        else    rc = gofx(sp, 2);
        sk_r3 = sk_tr['D'];
        break;
    case 3:                 /* V <- EXP VHD DHD */
        if (tc == 'V' && NULL != (p =  sys_nput(pm_sym, sp)))
            p += MCOLS(pm_sym->ADDR);
        if (p == NULL ||
            (p->ADDR != NULL && MTYPE(p->ADDR) == TYPA)) {
            rc = 'a';   /* block nested array */
            break;
            }
        s = (sp+2)->ADDR;
        k = (MTYPE(s)==TYPN && MSIZE(s) == 0) ? MINDX(s) : 0;
        rc = (k) ? sasa(sp, p)   || fx_incdec(k, p)
                 : sasa(p, sp+2) || sasm(sp, sp+2);
        sk_r3 = sk_tr['D'];
        qpp = 0;
        break;
    case 4:     /* XD0  STOP */
        if (qpp) sk_echo(sp+1);
        if (tc == 'Y' && sp == sz) break;
        if (tc == 'Y') {
           sp = sk_ret(sp);    /* return */
           if (sp == NULL) rc = ERR_SYN;
           else            qpp = 1;
           }
        else {
            sp++;
            rc = EV_DECOD;
            }
        break;
    case 5:                /* down ) .. )00 )FD */
        sr = sk_down(sp, sz);
        if (sr == NULL) rc = ERR_SYN;
        else if (sk_r3 == SYN_500) {    /* )00 */
            sk_rotl(sr, sp, 1);
            sk_r3 = 0;
            sp--;
            }
        else if (sk_r3 == SYN_5FD) {    /* )FD */
            MINDX(sr->ADDR) = sk_r3;
            sk_rotr(sr, sp+2, 2);
            sk_r3 = 0;
            sp +=2;
            }
        break;
    case 6:                     /* .. (D0   */
        sasm(sp, sp+1);
        sk_rotr(sp-2, sp, 1);
        sk_r3 = SYN_FD0;        /* must be FD0 */
        sp--;
        break;
    case 7:                     /* down ..  ]00  ]FD  ]HD */
        sr = sk_down(sp, sz);
        if (sr == NULL) {
            rc = ERR_SYN;
            break;
            }
        k  = '[';       /* index operator */
        qr = ':' == MELSIZ((sp-1)->ADDR);
        if (qr) k = 'R';
        else if (MINDX(sr->ADDR) == ':') k = 'Q';

        if (sk_r3 == SYN_700) { /* ]00 */
            MELSIZ(sr->ADDR) = 'S';
            MINDX(sr->ADDR) = k;
            }
        else {                  /* ]FD ]HD */
            MINDX(sr->ADDR) = k;
            sp +=2;
            sk_rotr(sr, sp, 2);
            }
        if (qr) sp--;
        sk_r3 = 0;
        break;
    case 8:                /*  [D0 so should be AFD[N  */
        rc = '[';
        qr = MINDX(sp->ADDR);
        sp-=3;
        if (sp < sz) break;
        p = NULL;
        qa = 'a' == sk_look((sp+1)->ADDR);      /* is it <- */
        tc = sk_look(sp->ADDR);
        if (tc =='I' && NULL == (p = sys_nget(pm_sym, sp))) {
            rc = ERR_VAL;
            break;
            }
        if (p != NULL && MTYPE(p->ADDR) == TYPA)
        switch (qa) {
        case 0:     /* GA[IDX] + VAL */
            MELSIZ(sp->ADDR) = 'A';
            MINDX(sp->ADDR)  = MINDX(pm_sym->ADDR);
            sa_swap(sp, sp+3);
            rc = use_get(sp, sp+3, sp+4);   /* sp <- (@sp+3)[sp+4] */
            sp++;
            sk_r3 = SYN_FD0;
            break;
        case 1:     /* GA[IDX] <- VAL */
            rc = use_set(p, sp+4, sp+2);   /* (@p)[sp+4]<-(sp+2) */
            sasm(sp, sp+2);
            sasr(sp+1) || sasr(sp+3) || sasr(sp+4);
            sk_r3 = sk_tr['D'];
            qpp = 0;
            break;
            }
        else switch (qa) {
        case 0:                                 /* A[EXP]+VAL */
            if (p != NULL) sasa(sp, p);
            sa_swap(sp, sp+3);
            rc = vs_jdx(qr, sp, sp+3, sp+4);    /* sp<-(sp+3)[sp+4] */
            sp++;
            sk_r3 = SYN_FD0;
            break;
        case 1:                                 /* A[EXP]<-VAL */
            if (p == NULL) break;
            rc = vs_idx(qr, p, sp+4, sp+2);     /* p[sp+4]<-(sp+2) */
            if (rc == '+') rc = sasa(sp, p);
            else                sasm(sp, sp+2);
            sasr(sp+1) || sasr(sp+3) || sasr(sp+4);
            sk_r3 = sk_tr['D'];
            qpp = 0;
            break;
            }
        break;
    case 9:
        rc = ERR_SYN;
        default:        /* anything else */
        break;
        }       /* switch */
    }       /* while rc */
if (rc == EV_FETCH) sp = sk_ufn(sp, ag);
else {
     if (sp == NULL || sp < sz) sp = sz;
     mkobj(sp, 'F', rc, 0);
     }
return sp;
}

sk_look(s)      /* type of object */
BYTE   *s;
{
BYTE    k;
if (s == NULL) return 'V';
k = MELSIZ(s);
switch (MTYPE(s)) {
    case TYPT:          /* various subtypes */
        return (k) ? k : 'D';
    case TYPF:          /* test for seperator */
        switch(k) {
             case 'V':
             case '[':
             case ']':
             case '(':
             case ')':
             case 'a':  /* assign */
                 return k;
                 break;
             default:  return 'F';
             }
    case TYPA: return (k == 'T') ? 'A' : 'U';
    case TYPI: return (k == 'A') ? 'D' : 'I';
        default:
            break;
        }
return 'D';
}

         /* scan down stack for matching parenthesis */

MATRIX  sk_down(sp, smin)
MATRIX  sp;             /* stack pointer */
MATRIX  smin;           /* frame limit */
{
BYTE   *s;
int     cs = MELSIZ(sp->ADDR);
int     co = (cs == ')') ? '(' : '[';
int     k, fc;

for (sp--, k = 1; sp >= smin && k; sp--) {
    s = sp->ADDR;
    if (s == NULL) break;
    fc  =  MELSIZ(s);
    if (fc == cs)      k++;
    else if (fc == co) k--;
    else if (fc == 'X' || fc == 'Y') break;
    }
return  (k == 0) ? sp+1: NULL;
}

sk_echo(src)    /* format and print     */
MATRIX  src;    /* data */
{
MATRIX  sys_text();
MATRIX  sink = sys_text(pm_sym, "$SINK");
MATRIX  dst = src;
BYTE   *s =src->ADDR;
int  rc = 0;

if (s == NULL) return OK;

if (TYPD == MTYPE(s) || TYPN == MTYPE(s))
    fx_format(dst = src+1, src);

rc = (sink) ? w_print(src + 2, sink, dst) : d_naprint(dst);
if (dst != src) sasr(dst);
if (sink)       sasr(src+2);

#ifdef  DJGPP
ScreenRetrieve(mm_vptr);
#endif

return rc;
}

sk_rotl(sp, sq, k)      /* rotate stack frame */
MATRIX  sp;             /* start */
MATRIX  sq;             /* end */
int     k;              /* shift count */
{
MATRIX  xp;
struct SDESC tt;
while (0 < k--) {
    for (xp = sp, tt = *xp; xp < sq; xp++) *xp = *(xp+1);
    *sq = tt;
    }
return OK;
}

sk_rotr(sp, sq, k)      /* rotate stack frame */
MATRIX  sp;             /* start */
MATRIX  sq;             /* end */
int     k;              /* shift count */
{
MATRIX  xp;
struct SDESC tt;
while (0 < k--) {
    for (xp = sq, tt = *xp; xp > sp; xp--) *xp = *(xp-1);
    *sp = tt;
    }
return OK;
}

syn_ctset()      /* initialise table */
{
BYTE   *s = sk_alpha;
BYTE   *t = sk_cval;
memset(sk_tr, 0, 256);
for (; *s; s++, t++) sk_tr[*s] = (0X0F & *t);
return  OK;
}

sk_setup()    /* set up sk_xmap */
{
struct  T_VAL *xx = &tv_tab[0];
BYTE   *s;
int     k;

for (; NULL != xx->tt; xx++) {
    s = xx->tt;
    k = (SK_RDX * sk_tr[s[2]] + sk_tr[s[1]]) * SK_RDX + sk_tr[s[0]];
    sk_xmap[k] = 1 + xx->val;
    }
return OK;
}

na_reset(nsize, nstak, nfile, nww)
int     nsize;   /* symbol table size */
int     nstak, nfile, nww;
{
MATRIX  sys_alink();
MATRIX  sys_nlink();
struct  HARD_FNS       *hf;
struct  SOFT_VARS      *sv;
MATRIX  p;
BYTE   *s = pm_sym->ADDR;
int     n    = MSIZE(s);
int     nsym = MCOLS(s);

if (nsize == 0) {
    for (p = NA_PTR(pm_sym); 0 < n--; p++)
        if(sys_del(p)) return ERROR;
    }
else if (nsym != nsize && na_resize(pm_sym, nsize)) {
    return ERROR;
    }

pm_stack = sys_alink(pm_sym, "$stack", nstak, 1);
pm_files = sys_alink(pm_sym, "$nfiles", nfile, 1);
pm_ww    = sys_alink(pm_sym, "$nww", nww * 4, 4);
#ifdef  TC      /*      do nothing */
#elif   DJGPP   /* 32-bit DOS/WINDOWS */
pm_scr  = sys_alink(pm_sym, "$vs", 1, 1);
mkobj(p = NA_PTR(pm_scr), 'T', 2*ed_scr[2]*ed_scr[3], 2*ed_scr[3]);
mm_vptr = TEXT_PTR(p);
#else
pm_scr  = sys_alink(pm_sym, "$vs", 1, 1);
mkobj(p = NA_PTR(pm_scr), 'T', ed_scr[2]*ed_scr[3], ed_scr[3]);
mm_vptr = TEXT_PTR(p);
#endif

/*      hardcoded version string */
if (NULL== sys_nlink(pm_sym, "$VERSION", d4_version, strlen(d4_version))||
    NULL== sys_nlink(pm_sym, "$LICENCE", d4_licence, strlen(d4_licence)))
    return ERROR;

/*  hard functions */

for (hf = &hf_tab[0]; hf->name; hf++) {
     p = sys_nlink(pm_sym, hf->name, NULL, 0);
     if (p == NULL) return ERROR;
     mkobj(p, 'F', hf->zcode, 0);
     }

/*      line input buffer, used in alin.c and mm_sfile.c */

if (NULL==(p = sys_nlink(pm_sym, "$inline", NULL, MAXLINE+1))) return ERROR;
linbuf = TEXT_PTR(p);

if (NULL == (p = sys_nlink(pm_sym, "$sockets", NULL, 0))) return ERROR;

#ifdef linux
if (set_sockets(pm_sock = p, SOCK_MAX)) return ERROR;
#endif

/* soft variables */
for (sv = &sv_tab[0]; sv->name; sv++) {
     if (NULL==sys_alink(pm_sym, sv->name, 0, sv->zcode)) return ERROR;
     }
return OK;
}

na_getenv(name, azptr, set)     /* $ENV[]<-environment strings */
char   *name;
char  **azptr;          /* pointer to array of ASCIZ strings */
int     set;
{
extern  char    *strchr();
MATRIX  sys_alink(), sys_nlink();
extern  MATRIX   pm_sym;
MATRIX  p, q;
char  **ep;
char   *s, *t;
int     ns, size;
for (ns = 0, ep = azptr; *ep; ep++) ns++; /* length */
size = 4*ns+1;
p = sys_alink(pm_sym, name, 2*size, size);
MELSIZ(p->ADDR) = 'T'; /* generalised array */
for (ep = azptr; *ep; ep++) {
    s = *ep;
    for (t = s; *t && *t !='=';) t++;
    if (*t == '=') {
        *t++ = 0;
        q = sys_nlink(p, s, t, strlen(t));
        if (set) setenv(s, t, 1);
        }
    else {
        q = sys_nlink(p, s, NULL, 0);
        if (set) setenv(s, NULL, set);
        }
    }
return OK;
}

int fx_tty(dst, hi)     /* set mode for stdin 0 = line, 1 = screen */
MATRIX  dst, hi;
{
int     rc = ERROR;
int     mode = ERROR;
if (hi != NULL && TYPN == MTYPE(hi->ADDR) && MSIZE(hi->ADDR)==1)
    mode = *(INT_PTR(hi));
rc = tty_set(mode);
return mkik(dst, rc);
}



