/*      D4VGA.H   */
/*      hardware dependent features for display handler */
/*      Storage definitions are made in the file for    */
/*      which EGA_BLOCKDATA is defined                  */

#ifdef  DJGPP
#include <sys/nearptr.h>
#endif

#define D4VGA

/* Controller */
#define EGA_ADD 0X3CE   /* EGA port -- address */
#define EGA_VAL 0X3CF   /* EGA port -- value   */

/* sequencer */
#define EGA_SEQ 0X3C4   /* EGA port -- address */
#define EGA_SQV 0X3C5   /* EGA port -- value   */

#define MAXROWS 480
#define MAXCOLS 640

#define COLBYTES (MAXCOLS/8)

#define GRAFOUT(IDX,VAL)  {outp(EGA_ADD, IDX); outp(EGA_VAL, VAL);}
#define GRAFSEQ(IDX,VAL)  {outp(EGA_SEQ, IDX); outp(EGA_SQV, VAL);}

#define PSET    0       /* Memory mapped write functions: write */
#define AND     1       /* and with pixel */
#define OR      2       /* or with pixel */
#define XOR     3       /* exclusive or pixel */

#define LMASK(x)  (0XFF >> ((x) & 7))
#define RMASK(x)  (~(0XFF >> ((x) & 7)))>>1
#define GCUR_Y  vga_cz[0]
#define GCUR_X  vga_cz[1]
#define SWAP(A,B,TMP) {TMP=A;A=B;B=TMP;}

#ifdef VGA_DATA         /* initialisers */

BYTE   *gr_ram  = (BYTE*) 0XA0000000L;    /* Video ram */
BYTE   *gr_bios = (BYTE*) 0XC0000000L;    /* Video bios base */
BYTE    m1_bit[] = { 128, 64, 32, 16, 8, 4, 2, 1};
int    *vga_cz; /* pixel cursor used in line joining routines */

#else                   /* declarations only */

extern  BYTE   *gr_ram;
extern  BYTE   *gr_bios;
extern  BYTE    m1_bit[];
extern  int    *vga_cz;

#endif



