/*      DT.H   dispatch tables and nested array system  */
/*      sept 2005. Upped limits   */

#define SP_MAX  640   /* 512 */
#define SYM_MAX 1024  /* 512 */
#define WW_MAX  50
#define FF_MAX  32
#define SOCK_MAX        16


#ifdef DT_BLKDATA
/*      Global variables */

struct SDESC s_root = {NULL, 0};
MATRIX pm_sym   = &s_root;
MATRIX pm_stack = NULL;
MATRIX pm_ww    = NULL;
MATRIX pm_files = NULL;
MATRIX pm_scr   = NULL;
MATRIX pm_sock  = NULL;

#else

extern MATRIX pm_sym;           /* names */
extern MATRIX pm_stack;         /* temporaries */
extern MATRIX pm_ww;            /* windows */
extern MATRIX pm_files;         /* files */
extern MATRIX pm_scr;           /* screen */
extern MATRIX pm_sock;          /* sockets */

#endif

MATRIX sys_nput();
MATRIX sys_nget();
MATRIX na_idx();

MATRIX sk_decode();
MATRIX sk_push();
MATRIX unstak();
MATRIX sk_idx();
MATRIX sk_ufn();
MATRIX sk_ret();
MATRIX sk_up();

#define DQUOTE  0X22    /* double quote (") */

#define ERR_LEX 20      /* lexical error */
#define ERR_VAL 21      /* lexical error */
#define ERR_DOM 30      /* domain error */
#define ERR_SYN 40      /* syntax */
#define ERR_MEM 50      /* no more memory */
#define ERR_SIGSEGV 26  /* system error */
