/*   MS-DOS HEADER FILE. <HTEXT.H>   Sheffield 1998
     Mainly used for key-board definitions
*/

#define HTEXT   1       /* this file */

#if defined(TC) || defined (DJGPP)

#define DOSKEY  0X00FF & bdos(0X07, NULL, NULL) /* dos inkey */
#define BRAKE   BREAK == (0X00FF & bdos(0X06,0XFF)) /* STOP ! */

#else

#define DOSKEY ansi_key()
#define BRAKE  break_in()

#endif

#define EOF (-1)        /* Physical EOF returned by low level I/O */
#define CPMEOF 0x1A     /* CP/M End-of-text-file marker (sometimes!)  */

#define TRUE 1          /* logical true constant */
#define FALSE 0         /* logical false constant */

/*      Output codes */

#define BEEP    0X07    /* ^G - bell          */
#define CRGHT   0X1C           /*  LEFT CURSOR */
#define CLEFT   0X1D           /*  BACKSPACE */
#define CUP     0X1E           /*  UP */
#define CDOWN   0X1F           /*  LINE FEED */
#define LF      0X0A    /* LINE FEED          */
#define FF      0X0C    /* form feed          */
#define CLS     0X0C    /* ^L --              */

/* CONSOLE CONTROL CODES */

#define BREAK   0X03    /* ^C BREAK KEY       */

#define CTRLA   0X01    /* ^A                 */
#define CTRLB   0X02    /* ^B                 */
#define CTRLC   0X03    /* ^C copy block      */
#define CTRLD   0X04    /* ^D delete block    */
#define CTRLE   0X05    /* ^E   del eol       */
#define CTRLF   0X06    /* ^F   find          */
#define CTRLG   0X07    /* ^G - get           */
#define BS      0X08    /* BACK SPACE         */
#define HTAB    0X09    /* TAB                */
#define CTRLJ   0X0A    /* ^J                 */
#define CTRLK   0X0B    /* ^K                 */
#define CTRLL   0X0C    /* ^L  line           */
#define CR      0X0D    /* return key         */
#define CTRLN   0X0E    /* ^N  next           */
#define CTRLO   0X0F    /* ^O  cut            */
#define CTRLP   0X10    /* ^P  push line      */
#define CTRLQ   0X11    /* ^Q  quit           */
#define CTRLR   0X12    /* ^R  restore        */
#define CTRLS   0X13    /* ^S  save           */
#define CTRLT   0X14    /* ^T  tag            */
#define CTRLU   0X15    /* ^U  up             */
#define CTRLV   0X16    /* ^V insert mode     */
#define CTRLW   0X17    /* ^W width           */
#define CTRLX   0X18    /* ^X move block      */
#define CTRLY   0X19    /* ^Y                 */
#define CTRLZ   0X1A    /* ^Z end key         */
#define KRGHT   0X1C    /* cursor forward     */
#define KLEFT   0X1D    /* cursor back        */
#define KUP     0X1E    /* up                 */
#define KDOWN   0X1F    /* down               */
#define ESC     0X1B    /* ESCAPE             */

#define CLEOL   CTRLE   /* ^E del e.o.l.      */
#define DEL     0X7F    /* DELETE             */
#define KINS    CTRLV   /* INSERT KEY         */
#define KHOME   CTRLK   /* cursor home        */
#define KEND    CTRLZ   /* End key ^Z         */
#define KPGDN   CTRLJ   /* ^J page down       */
#define KPGUP   CTRLU   /* ^U page up         */

/*      editor functions                      */

#define PFK1    CTRLA   /* ^A alt language    */
#define PFK2    CTRLB   /* ^B                 */
#define PFK3    CTRLF   /* ^F find            */
#define PFK4    CTRLP   /* ^P push line       */
#define PFK5    CTRLR   /* ^R restore         */
#define PFK6    CTRLT   /* ^T tag             */
#define PFK7    CTRLX   /* ^X move block      */
#define PFK8    CTRLQ   /* ^Q quit + confirm  */
#define PFK9    CTRLY   /* ^Y                 */
#define PF10    CTRLS   /* ^S save            */

#define  ON     1
#define  OFF    0

#define I_XLATE 0X01            /* translate */
#define I_FLIP  0X02            /* reverse   */
#define I_PUSH  0X04            /* push mode */
#define I_FOLD  0X08            /* allow composite characters */
#define I_ARAB  0X10            /* allow character modification */
#define I_NUM   0X20            /* reverse */
#define I_THAI  0X40            /* thai */
#define I_VSEL  0X80            /* reverse video active line */

/*      set or inquire bilingual input modes */

#define B_FLIP(X)       (X & I_FLIP)    /* use masking */
#define B_XLATE(X)      (X & I_XLATE)
#define B_PUSH(X)       (X & I_PUSH)
#define B_THAI(X)       (X & I_THAI)
#define B_VSEL(X)       (X & I_VSEL)
#define BIT_ON(D,M)     (B |= M)
#define BIT_OFF(D,M)    (B &= ~M)
#define BIT_XOR(X,TMP,M)  {TMP = ~(X & (M));X &= ~(M); X |= (TMP & (M));}

/*      cursor on | off         */

#define CURSOR(X)       cursor(X)

/*      Function codes involved in editing  */

#define WW_DEL    0        /* delete                         */
#define WW_INIT   1        /* setup window n.                */
#define WW_IMODE  2        /* input mode                     */
#define WW_SIZE   3        /* Reset size                     */
#define WW_SHOW   4        /* Display contents, respect mode */
#define WW_SETCUR 5        /* set cursor -- in window        */


/* Macros for Xterm mouse used by xterm, rxvt X-consoles.
   These macros are meant to work on low endian and big endian machines

    _ESC,"[?Psh"      DEC Private Mode Set (DECSET)
    (Ps = 9 )    Send Mouse X & Y on button press.
    (Ps = 1000 ) Send Mouse X & Y on button press and release.
    (Ps = 1001 ) Use Hilite Mouse Tracking.
    On button press, xterm sends _ESC,"[M" Cb Cx Cy.
    Cb is button -1. All bytes are offset by 32.
    Cb takes the values 0 (left) 1 (middle) 2 (right)

    Mouse tracking is enabled by definition of $MOUSE. The result of mouse
press is returned to the program by the inkey function: K<-k. Since this
function returns an integer, the value K is made up of the four bytes
'M', Cb, Cx, Cy, in a specific order.

    Since keystrokes are returned as (int), these can be tested for
being packed information, via an expression:

    AA: DO (0 #ne M_MASK #and K<-k)/"0 r #cursor ((4r256)nK)[0 1]"
    ->(K #ne _ESC)/AA

*/

#define XMOUSE_MASK     0X00004D20      /* 0 0 'M' ' ' */

/* linux */

#define XMOUSE_CONS(SRC)   ((*(SRC+1))\
                           | ('M')<< 8\
                           | (*((SRC)+2))<<16\
                           | (*((SRC)+3))<<24)\
/* DOS */

#define XMOUSE_PACK(B,X,Y) ((B+32)|('M')<< 8|(33+X/8)<<16|(33+Y/8)<<24)

#define XMOUSE_CB(X)    ((X) & 0XFF)
#define XMOUSE_CX(X)    (((X)>>16) & 0XFF)
#define XMOUSE_CY(X)    (((X)>>24) & 0XFF)
#define XMOUSE_KEY(X)   (XMOUSE_MASK==((X) & XMOUSE_MASK))

/*      these macros are for documentation only */

#define XMOUSE_ON       vdisp("[?9h")
#define XMOUSE_OFF      vdisp("[?9l")


