/*      lexical analyser types */

typedef struct {
        int tag;
        struct SDESC slice;
        } tdesc;

typedef tdesc*   TAGD;

#define TAG_PTR(X)      (TAGD)((X)->ADDR+HDSIZE)

#define LEX_ISDIGIT(X)  (lx_ctype[(X)]=='E')

#ifdef LEX_TABLES

char *lx_ctype="\
LLLLLLLL@@LLLMLLLLLLLLLLLLLLLLLL@JFHBJLJJJJGJGDJEEEEEEEEEEJLJJJJ\
JBBBBCBBBBBBBBBBBBBBBBBBBBBJJJJAJIIIIIIIIIIIIIIIIIIIIIIIIIIJKJJJ\
JJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJ@JJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJ\
JJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJ";

int  lx_t1[]={
        0,  8,  1,  1, 17,  3, 10, 12, 14, 12, 12, 16, 18, 18,
        0,  2,  2,  2,  2,  2, 10, 12, 17, 12, 12, 16, 18, 18,
        0,  2,  2,  2,  2,  2, 10, 12, 17, 12, 12, 16, 18, 18,
        0, 17, 17,  5,  4,  3, 10, 12, 17, 12, 12, 16, 18, 18,
        0, 17, 17,  5, 17,  4, 10, 12, 17, 12, 12, 16, 18, 18,
        0, 17, 17, 17, 17,  7, 17,  6, 17, 17, 17, 17, 17, 17,
        0, 17, 17, 17, 17,  7, 17, 17, 17, 17, 17, 17, 17, 17,
        0, 17, 17, 17, 17,  7, 10, 12, 17, 12, 12, 16, 18, 18,
        0,  9,  2,  2, 17,  3, 10, 12, 17, 12, 12, 16, 18, 18,
        0,  9,  2,  2, 17, 17, 10, 12, 17, 12, 12, 16, 18, 18,
       10, 10, 10, 10, 10, 10, 11, 10, 10, 10, 10, 10, 10, 17,
        0,  8,  1,  1, 17,  3, 10, 12, 14, 12, 12, 16, 18, 18,
        0,  8,  1,  1, 13,  3, 10, 12, 14, 12, 12, 16, 18, 18,
       17, 17, 17, 17, 17, 17, 17, 12, 17, 12, 12, 17, 17, 17,
       17, 17, 15, 15, 17, 17, 17, 17, 17, 15, 17, 17, 17, 17,
        0, 17, 15, 15, 17,  3, 10, 12, 17, 15, 12, 16, 18, 18,
       16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 18,
      };

#define LEX_NTYPE  14

char *lx_t2="\
01110111111100\
20000033033322\
20000033033322\
20000033033322\
20000033033322\
20000000000000\
20000000000000\
20000033033322\
20000033033322\
20000033033322\
00000000000000\
23330303333322\
23330330300322\
00000000000000\
00000000000000\
20000333003322\
00000000000002";

char *lx_tsym = "BAANDDDDUUTTFFSSCXE";

        /* accelerate parsing of arithmetic functions */

static char     *lx_f2map ="<-a->g+/A-/B*/Cf/Dc/E+\\F-\\G*\\Hf\\Ic\\J<=1>=2";
static char     *lx_f2c ="*+-/<=>\\cf";

BYTE    vid_a[256];
BYTE    vid_b[121];

#endif

#define lx_quote        0X22    /* double quote */
#define lx_stopc        0X0D    /* stop character */
#define LEX_EXIT   17
#define LEX_ERROR  18

#define LX_TUD1    5
#define LX_UMAX    6
#define LX_UEXIT  11
#define LX_UERROR 12

#define NAL_LX  8       /* startup expression */
#define NAL_VA  9       /* data               */
#define NAL_DF 10       /* function old way   */
