/*      NA.H New version 1991 */
/*      Structures and types  */

#ifdef  TC                      /* Turboc 16-bit */
#ifndef NULL
#define NULL    0L
#endif
#define MAX_INT 0X7FFF
#define NOT_INT 0X8000
#else
#ifndef NULL
#define NULL    0
#endif
#define MAX_INT 0X7FFFFFFF      /* GCC 32-bit */
#define NOT_INT 0X80000000
#endif

#define MIN_INT (-MAX_INT)
#define OK   0
#define ERROR   (-1)
#define CR      0X0D
#define LF      0X0A

typedef unsigned char BYTE;     /* unsigned 1 byte data */
typedef double DOUBLE;          /* for importing tabular data */

struct SDESC {                  /* standard string - maybe arabic */
        BYTE * ADDR;
        unsigned SDLEN;
};

#ifndef REGISTER
#define REGISTER register
#endif

/*      Structures used by A86.C to develop matrix & array processing */

typedef struct SDESC * MATRIX;
typedef struct SDESC * SLICE;

struct HILOB    {               /* hardware structure */
        BYTE LO;
        BYTE HI;
                };

union ULH {
        struct HILOB    HL;
        unsigned int    WORDVAL;
        };

struct WXY {
        unsigned XVAL;
        unsigned YVAL;
        };

union U_COMPLEX {
        struct WXY W2;
        long U_ZVAL;
        };

struct DVEC {
        union ULH APTYPE;       /* type */
        unsigned TSIZE;         /* size of data */
        unsigned TMPIDX;        /* active row, or cell */
        unsigned COLSIZ;};      /* slice length */

#define HDSIZE sizeof(struct DVEC)      /* HEADER TYPE */
#define MTYPE(X)        (((struct DVEC*) X)->APTYPE.HL.LO)
#define MELSIZ(X)       (((struct DVEC*) X)->APTYPE.HL.HI)
#define MSIZE(X)        (((struct DVEC*) X)->TSIZE)
#define MINDX(X)        (((struct DVEC*) X)->TMPIDX)
#define MCOLS(X)        (((struct DVEC*) X)->COLSIZ)

#define TEXT_PTR(X)     (BYTE*)((X)->ADDR+HDSIZE)
#define INT_PTR(X)      (int*)((X)->ADDR+HDSIZE)
#define DBL_PTR(X)      (double*)((X)->ADDR+HDSIZE)
#define NA_PTR(X)       (MATRIX)((X)->ADDR+HDSIZE)
#define LINK_PTR(X)     (SLBASE)((X)->ADDR+HDSIZE)

struct S_LIST {
        union ULH APTYPE;
        struct S_LIST  *s_next;
        struct S_LIST  *s_prev;
        unsigned int    s_len;
        };

typedef struct S_LIST* SLIST;

struct SL_BASE {
        struct S_LIST   sl_base;
        struct S_LIST  *s_cur;
        int             s_lc;
        };

typedef struct SL_BASE* SLBASE;

#define S_SIZE          sizeof(struct S_LIST)
#define S_TYPE(X)       (((SLIST)(X))->APTYPE.HL.LO)
#define S_NEXT(X)       (((SLIST)(X))->s_next)
#define S_PREV(X)       (((SLIST)(X))->s_prev)
#define S_LEN(X)        (((SLIST)(X))->s_len)
#define S_TEXT(X)       (((BYTE*)(X)) + S_SIZE)
#define S_NOW(X)        (((SLBASE)(X))->s_cur)
#define S_LC(X)         (((SLBASE)(X))->s_lc)

/*      sl_bloc function codes    */

#define SL_DEL  'D'
#define SL_MOV  'M'
#define SL_CPY  'C'

/*      modify  TYPF object in TMPIDX field  */

#define AXIS_MODIFIER ':'


/*      edit window structure   */

struct ww_control {     /* define window structure      */
        struct  DVEC    w_head; /* header like integer vector */
        unsigned int    w_mode; /* input control modes   */
        unsigned int    w_attr; /* text attributes */
        int       w_stat;       /* block status */
        int       w_cx;         /* cursor */
        int       w_cy;         /* cursor */
        int       w_shift;      /* horizontal scroll offset */
        int       w_size[4];    /* y, x, dy, dx      */
        int       w_line[4];    /* i, x, 1 , width   */
        int       w_paste[4];   /* tag operations */
        };

#define WW_NINT  18             /* Could use sizeof() */

typedef struct ww_control WINDOW;

#define WW_TAG(X)     MTYPE(X)                          /* validation code */
#define WW_STAT(X)    MELSIZ(X)                         /* status      */
#define WW_MODE(X)    ((WINDOW *)X)->w_mode             /* input mode      */
#define WW_ATTR(X)    ((WINDOW *)X)->w_attr             /* text attributes */
#define WW_CX(X)      ((WINDOW *)X)->w_cx               /* x position */
#define WW_CY(X)      ((WINDOW *)X)->w_cy               /* y position */
#define WW_HCUT(X)    ((WINDOW *)X)->w_shift            /* shift offset */
#define WW_FB(X)      ((WINDOW *)X)->w_stat             /* block status */
#define WW_TXT(X)  (int *)(((WINDOW *)X)->w_size)       /* text area */
#define WW_LIN(X)  (int *)(((WINDOW *)X)->w_line)       /* line      */
#define WW_BLK(X)  (int *)(((WINDOW *)X)->w_paste)      /* text area */
#define WW_DLINK(X)   ((MATRIX)(X+1))                   /* transcript */
#define WW_DLINE(X)   ((MATRIX)(X+2))                   /* single line */
#define WW_SFIND(X)   ((MATRIX)(X+3))                   /* find text */

#define WW_QFLIP(X)        (0 != (WW_MODE(X) & I_FLIP))

#define TYP_MDESC   0XC0        /* contains allocateable pointers */

#define TYPF    0X00            /* op-code */
#define TYPT    0X01            /* text */
#define TYPN    sizeof(int)     /* int .. 0X02 or 0X04 */
#define TYPD    0X08            /* double */
#define TYPUC   0X09            /* integer complex */
#define TYPAX   0X10            /* Slices: in something else */
#define TYPU    0X11            /* Special function */
#define TYPI    0X15            /* symbol */
#define TYPLK   0X16            /* link --  state + offset */
#define TYPWW   0X1A            /* window structure */
#define TYPB    0X80            /* normalised (trimmed) bit-map */
#define TYPW    0X90            /* Special bit-map (window) */
#define TYPWC   0XA0            /* Compressed bit-map (window) */
#define TYPA    0XC1            /* Homogenous Slices: descriptors */
#define TYPR    0XC0            /* Raw slices */
#define TYPL    0XCC            /* linked list of slices */
#define TYPLB   0XCD            /* base or root */
#define TYPLS   0XCE            /* slice of list */
#define TYPHS   0XE9            /* spread sheet */

/* slice handling macros */

#define MID_STR(D,S,N)  {(D)->ADDR = (S)->ADDR+N; (D)->SDLEN = (S)->SDLEN-N;}
#define LFT_STR(D,S,N)  {(D)->ADDR = (S)->ADDR; (D)->SDLEN = N;}
#define RGT_STR(D,S,N)  {(D)->ADDR=(S)->ADDR+((D)->SDLEN-1)-N;(D)->SDLEN=N;}
#define NUL_STR(D)  {(D)->ADDR = NULL; (D)->SDLEN = 0;}

/* macro to check for object as leaf of tree */
#define IS_LEAF_TYPE(X)      ((X)==TYPT||(X)==TYPN||(X)==TYPD)

#ifdef  TC
#define MAXLINE        0X1000   /* max line */
#else
#define MAXLINE        0X4000   /* 32 bit systems */
#endif








