/*      SCRNIO.H
*       ega / vga text page info
*
*       use memory mapped screen for text
*       The pointer may be changed by a function
*
*       want to use maximum capacity of a DOS screen
*       maximum screen size varies with systems
*/

#ifdef  TC      /* 16-bit */

#define SCR_MAX_YVAL    120     /* 4-bit hi characters  */
#define SCR_MAX_XVAL    132     /* exists in theory     */

#elif   DJGPP   /* DJGPP 32-bit */

#define SCR_MAX_YVAL    120     /* 4-bit hi characters  */
#define SCR_MAX_XVAL    80      /* limited  */

#else   /* GNU */

#define SCR_MAX_YVAL    600     /* use xterm nil2 font  */
#define SCR_MAX_XVAL    800     /* one character=pixel  */

#endif

#define SCR_NORM        0X07    /* normal screen attribute */

#ifdef SCRMAP_DATA

int     d4_si = SCR_NORM;       /* virtual colour attribute */

#ifdef  TC      /* real memory mapping */

BYTE   *mm_vptr = (BYTE*) 0XB8000000L;  /* depends on monitor */
int     ed_scr[]        = {0, 0, 25, 80};

#elif   DJGPP

BYTE   *mm_vptr = (BYTE*) 0;    /* must initialise */
int     ed_scr[]        = {0, 0, 25, 80};       /* Dos console */

#else   /* GNU */

BYTE   *mm_vptr = (BYTE*) 0;    /* must initialise */
int     ed_scr[]        = {0, 0, 24, 80};       /* Linux console */

#endif /* TC */

#else

extern  BYTE*   mm_vptr;
extern  int     ed_scr[];
extern  int     d4_si;

#endif

#define WW_MAXROWS      ed_scr[2]
#define WW_MAXCOLS      ed_scr[3]

#define S_NR    WW_MAXROWS
#define S_NC    WW_MAXCOLS
#define S_WLEN  (S_NR*S_NC)
#define V_2COLS        (2 * WW_MAXCOLS)

#ifdef  TC

#define WW_MMAP(Y,X)    mm_vptr + (Y)*V_2COLS + 2*(X)
#define CU_MAP(Y,X)     (Y)*V_2COLS + 2*(X)

#elif   DJGPP

#define WW_MMAP(Y,X)    mm_vptr + (Y)*V_2COLS + 2*(X)
#define CU_MAP(Y,X)     (Y)*V_2COLS + 2*(X)

#else   /* GNU */

#define WW_MMAP(Y,X)    mm_vptr + (Y)*ed_scr[3] + (X)
#define CU_MAP(Y,X)     (Y)*ed_scr[3] + (X)

#endif




