/*      DOJT.C  Jump table */

#include <na.h>
#include <dt.h>
#include <fdata.h>
#include <jtab.h>

int fx_nop();
int fx_poke();
int fx_sh();
int d4_stat();
int sockstat();

#ifdef  TC

#define VAL_SH  9
#define FX_SH   system

#elif   DJGPP

#define VAL_SH  9
#define FX_SH   system

#else

#define VAL_SH   0
#define FX_SH    fx_sh

#define fx_disk  fx_nop
#define kjget fx_nop
#define kjput fx_nop
#define kjvec fx_nop
#define kjarc fx_nop
#define kjbloc fx_nop
#define kjfill fx_nop
#define kjplot fx_nop

#endif /* XTC */

BYTE    jt_xi[256];

struct JT3 {int zcode; int xfc; int (*jtgo[3])();} jt3[] = {
{',',          0, fx_nop,    fx_nop,    fex_cat   },     /* concatenate */
{F_AV,         0, fx_nop,    fx_av,     fx_cvt    },     /* av        */
{F_ATAN,       0, fx_nop,    fx_math,   fx_nop    },     /* atan2     */
{F_CALL,       0, fx_nop,    fx_nop,    fx_call   },     /* call      */
{F_CD,        16, fx_cwd,    chdir,     fx_nop    },     /* cd        */
{F_CIRCLE,     0, fx_nop,    fx_nop,    fx_circle },     /* circle    */
{F_CLOSE,      2, fx_dbexit, fx_dbexit, fx_nop    },     /* close     */
{F_CMD,   VAL_SH, fx_nop,    FX_SH,     fx_nop    },     /* cmd       */
{F_COPY,      10, fx_nop,    sys_copy,  fx_nop    },     /* copy      */
{F_CURSOR,     2, fx_cur,    fx_cur,    fx_nop    },     /* cursor    */
{F_DBCLOSE,    2, fx_dbexit, fx_dbexit, fx_nop    },     /* dbclose   */
{F_DBGET,      0, fx_nop,    fx_dbget,  fx_nop    },     /* dbget     */
{F_DBNAMES,    2, fx_dbtab,  fx_dbtab,  fx_nop    },     /* dbnames   */
{F_DBPUT,      0, fx_nop,    fx_nop,    fx_dbput  },     /* dbput     */
{F_DBSIZE,     2, fx_nop,    fx_dbsize, fx_nop    },     /* dbsize    */
{F_DBTIE,      0, fx_nop,    fx_nop,    fx_dbtie  },     /* dbtie     */
{F_DEB,        0, fx_nop,    fx_deb,    fx_nop    },     /* deb       */
{F_DEL,        9, fx_nop,    unlink,    fx_nop    },     /* del file  */
{F_DISK,       3, fx_nop,    fx_disk,   fx_disk   },     /* bios disk */
{F_DLTB,       0, fx_nop,    fx_dltb,   fx_nop    },     /* dltb      */
{F_DOMINO,     0, fx_det,    fx_domino, fx_nop    },     /* domain    */
{F_DROP,       7, fx_nop,    fx_nop,    fex_struc },     /* drop  (d) */
{F_EX,         6, fx_nop,    fx_symop,  fx_nop    },     /* ex        */
{F_EXP,        0, fx_nop,    fx_math,   fx_nop    },     /* exp       */
{F_FI,         0, fx_nop,    fx_val,    fx_nop,   },     /* fi (val)  */
{F_FILES,     11, fx_nop,    fx_dtxt,   fx_dtxt,  },     /* files     */
{F_FIND,       0, fx_nop,    fx_nop,    fx_find   },     /* find  (j) */
{F_FMT,        0, fx_nop,    fx_format, fx_fmt    },     /* fmt   (z) */
{F_FNAMES,     2, fx_dbtab,  fx_dbtab,  fx_nop    },     /* fnames    */
{F_FSIZE,      2, fx_nop,    fx_dbsize, fx_nop    },     /* fsize     */
{F_FSTAT,      9, fx_nop,    d4_stat,   fx_nop    },     /* fstat     */
{F_GOTO,       0, fx_nop,    xgoto,     fx_nop    },     /* goto  (g) */
{F_IFDEF,      3, fx_nop,    ifdef,     fx_nop    },     /* ifdef     */
{F_IFNDEF,     3, fx_nop,    fx_nop,    ifdef     },     /* ifndef    */
{F_INKEY,      2, fx_nop,    fx_inkey,  fx_nop    },     /* inkey (k) */
{F_INLIN,      0, fx_inlin,  fx_inwin,  fx_nop    },     /* inlin (q) */
{F_INNER,      0, fx_nop,    fx_nop,    fx_mult   },     /* inner product */
{F_INT,        0, fx_nop,    fx_nop,    fx_86     },     /* interrupt */
{F_IOTA,       0, fx_nop,    fx_nop,    fx_iota   },     /* iota  (i) */
{F_KJARC,      0, fx_nop,    mk_arc,    kjarc     },     /* kjarc     */
{F_KJBLOC,     3, fx_nop,    kjbloc,    kjbloc    },     /* kjbloc    */
{F_KJFILL,     0, fx_nop,    mk_yxx,    kjfill    },     /* kjfill    */
{F_KJGET,      0, fx_nop,    kjget,     fx_nop    },     /* kjget     */
{F_KJPLOT,     3, fx_nop,    kjplot,    kjplot    },     /* kjplot    */
{F_KJPUT,      0, fx_nop,    fx_nop,    kjput     },     /* kjput     */
{F_KJVEC,      0, fx_nop,    mk_yxline, kjvec     },     /* kjvec     */
{F_LN,         0, fx_nop,    fx_math,   fx_nop    },     /* ln        */
{F_LOAD,       0, fx_nop,    fx_nop,    fx_nop    },     /* load      */
{F_LPRINT,     0, fx_nop,    fx_lprint, fx_nop    },     /* lprint    */
{F_MATTOSS,    3, fx_nop,    mattoss,   mattoss   },     /* mattoss   */
{F_MEMBER,     3, fx_nop,    fx_nop,    fx_member },     /* member    */
{F_MKDIR,      9, fx_nop,    mkdir,     fx_nop    },     /* mkdir     */
{F_NC,         6, fx_nop,    fx_symop,  fx_nop    },     /* nc        */
{F_NFIND,      7, fx_nop,    fx_nfind,  fx_nfind  },     /* nfind     */
{F_NXFIND,     7, fx_nop,    fx_nfind,  fx_nfind  },     /* nxfind    */
{F_NL,         3, fx_nlist,  fx_nlist,  fx_nop    },     /* nl        */
{F_OPEN,       0, fx_nop,    fx_nop,    fx_dbtie  },     /* open      */
{F_OUTER,      3, fx_nop,    fx_nop,    fx_outer  },     /* outer     */
{F_PEEK,       3, fx_nop,    fx_peek,   fx_peek   },     /* peek      */
{F_PRINT,      3, fx_nop,    w_print,   w_print   },     /* print     */
{F_QMENU,      5, fx_nop,    fx_nop,    ww_menu   },     /* qmenu     */
{F_READ,       0, fx_nop,    fx_dbget,  fx_nop    },     /* read      */
{F_RMDIR,      9, fx_nop,    rmdir,     fx_nop    },     /* rmdir     */
{F_RXFIND,     0, fx_nop,    fx_nop,    rx_find   },     /* find  rx  */
{F_RXSUBS,     0, fx_nop,    fx_nop,    rx_subs   },     /* string op */
{F_SCREEN,     2, fx_screen, fx_screen, fx_nop    },     /* screen    */
{F_SED,        3, sed,       sed,       sed       },     /* sed       */
{F_SLEEP,      0, fx_nop,    fx_sleep,  fx_nop    },     /* usleep    */
{F_SOCKET,     0, sockstat,  fx_nop,    fx_socket },     /* socket    */
{F_SORT,       0, fx_nop,    fx_rank,   fx_nop    },     /* sort      */
{F_SPLIT,      3, fx_nop,    fx_split,  fx_split  },     /* split     */
{F_SQRT,       0, fx_nop,    fx_math,   fx_nop    },     /* sqrt      */
{F_SSTOMAT,    3, fx_nop,    sstomat,   sstomat   },     /* sstomat   */
{F_TAKE,       7, fx_nop,    fx_nop,    fex_struc },     /* take (t)  */
{'y',          0, fx_nop,    fx_transp, fx_nop    },     /* transpose (y) */
{F_TS,         0, fx_ts,     fx_nop,    fx_nop    },     /* time stamp */
{F_USE,        3, use,       use,       use       },     /* use       */
{F_VAL,        0, fx_nop,    fx_val,    fx_nop    },     /* evaluate  */
{F_VARPTR,     6, fx_nop,    fx_symop,  fx_nop    },     /* varptr    */
{F_VRAM,       2, fx_vram,   fx_vram,   fx_nop    },     /* vram      */
{F_WGET,       2, fx_nop,    ww_mget,   fx_nop    },     /* wget      */
{F_WINDOW,     3, fx_win,    fx_win,    fx_win    },     /* window    */
{F_WPUT,       4, fx_nop,    fx_nop,    ww_mput   },     /* wput      */
{F_WRITE,      0, fx_nop,    fx_nop,    fx_dbput  },     /* write     */
{F_ZGETS,      3, fx_nop,    fx_zgets,  fx_zgets  },     /* input     */
{F_ZLOAD,     10, fx_nop,    dh_zload,  fx_nop    },     /* zload     */
{F_ZSAVE,     12, fx_nop,    fx_nop,    dh_zsave  },     /* zsave     */
{ 0, 0,   NULL, NULL, NULL}};

jt_inv()        /* index(fc) into jump table */
{
struct  JT3    *jt =&jt3[0];
int     fc;
int     k;
for (k = 0; k < 256; k++) jt_xi[k] = 0XFF;
for (k = 0;; k++, jt++) {
    if(0 == (fc = jt->zcode)) break;
    jt_xi[fc] = k;
    }
return OK;
}

do_jt(fc, dst, lo, hi)
int fc;         /* function code */
MATRIX dst;
MATRIX lo;
MATRIX hi;
{
char   *mkasciz();
char   *fn = NULL;
int     ag = (lo != NULL) + (hi != NULL);
int     rc = 0;
int     kp, decode;
int   (*call)();

kp = jt_xi[fc];         /* table entry */
if (kp == 0XFF) return fc;
decode = jt3[kp].xfc;
if (decode == 0) decode = 1 + ag;
else if (decode == 16) {
    decode = (ag == 0) ? 1 : 9;
    }
        /* ASCIZ file name */
if (hi && (decode & 0X08)) fn = mkasciz(hi);

call = jt3[kp].jtgo[ag];

switch (decode) {
        case 1: rc = (*call)(dst);
                break;
        case 2: rc = (*call)(dst, hi);          /* read or get */
                break;
        case 3: rc = (*call)(dst, lo, hi);
                break;
        case 4: rc = (*call)(lo, hi);           /* write or put */
                break;
        case 5: rc = (*call)(lo, hi);           /* selection */
                break;
        case 6: rc = (*call)(fc, dst, hi);      /* symop functions */
                break;
        case 7: rc = (*call)(fc, dst, lo, hi);
                break;
        case 9: rc = (*call)(fn);
                break;
        case 10:rc = (*call)(dst, fn);
                break;
        case 11:rc = (*call)(dst, lo, fn);
                break;
        case 12:rc = (*call)(lo , fn);
                break;
        default: rc = ERROR;
                }

if (fn != NULL) free(fn);
if (decode == 4 || decode == 12)
        rc |= mkobj(dst, 'T', 0, 0);
else if (decode == 5 || decode == 9)
        rc = mkik(dst, rc);
return (rc) ? fc : 0;           /* current operation */
}

fx_nop(dst, lo, hi)
MATRIX dst;
MATRIX lo;
MATRIX hi;
{
return ERROR;
}
