/* EVAL.C */

#include <na.h>
#include <dt.h>
#include <fdata.h>

char *fex_s2op = "+-*%<>=#|^&fc!12";
char *fex_s1op = "ABCDEFGHIJ";
char *fex_smon = "+-*!~?cf";

extern int qt;
extern int mm_cnt_alloc;
extern int mm_cnt_free;

gofx(sp, argc)          /* DECODE and DO function */
MATRIX sp;
int    argc;
{
extern BYTE* strchr();
MATRIX  lo;
MATRIX  hi;
struct  SDESC ss, tt;
int     rc = MELSIZ(sp->ADDR);
int     axmod = MINDX(sp->ADDR);
BYTE   *s, *t;
int     k, n, nr, nc;
int     t1, t2;
int     *ix, *iy;

if (rc == 'S') rc = axmod;

switch (argc) {
    default:
    case 0:             /* niladic */
    switch (rc) {
        case '?':       /* trace & memory size */
            qt ^= 1;
            if (rc = mkobj(sp, 'N', 2, 2)) break;
            ix = INT_PTR(sp);
            ix[0] = mm_cnt_alloc; ix[1] = mm_cnt_free;
            break;
        case 'k':       /* key */
            rc = mkik(sp, vgetch());
            break;
        case F_QUIT:    /* exit program */
            break;
        default: rc = do_jt(rc, sp, NULL, NULL);
        }
    break;
    case 1:     /* monadic function */
        hi = sp+1;
        if (NULL != strchr(fex_smon, rc))
            rc = sca_mon(rc, sp, hi);
        else if (NULL != strchr(fex_s1op, rc))
            rc = sca_sum(rc, sp, hi);
        else switch(rc) {
        case 'm':       /* flip data */
            rc = sasm(sp, hi) || matflip(sp);
            break;
        case F_THETA:   /* flip data about horizontal axis */
            rc = sasa(sp, hi)      ||
                 fx_transp(hi, sp) ||
                 matflip(hi)       ||
                 fx_transp(sp, hi) ||
                 sasr(hi);
            break;
        case 'r':       /* shape */
            n  = rho(hi, &nr, &nc);
            if (axmod == AXIS_MODIFIER || nr >= 2) {
                if (OK == (rc = mkobj(sp, 'N' , 2, 2))) {
                    ix    = INT_PTR(sp);
                    ix[0] = nr;
                    ix[1] = nc;
                    }
                }
            else rc = mkik(sp, n);      /* vector or scalar */
            break;
        case ',':       /* ravel */
            rc = sasm(sp, hi);
            MCOLS(sp->ADDR) = MSIZE(sp->ADDR);
            break;
        case 'i':               /* iota */
            if (MSIZE(hi->ADDR) == 0 ||
                MTYPE(hi->ADDR) != TYPN) break;
            ix = INT_PTR(hi);
            if (MSIZE(hi->ADDR) == 1) {         /* sequence 0,1, (*ix)-1 */
                nc = ix[0];
                if (nc < 0 || mkobj(sp, 'N', nc, nc)) break;
                ix  = INT_PTR(sp);
                for (k = 0; 0 < nc--; *ix++ = k++);
                rc = 0;
                }
            else               /* cartesian product */
                rc = mkixy(sp, ix[0], ix[1]);
            break;
        default: rc = do_jt(rc, sp, NULL, hi);
            break;
        }
        if (rc == 0) sasr(hi);
    break;
    case 2:         /* DYADIC */
        lo = sp+1;
        hi = sp+2;
        if (NULL != strchr(fex_s2op, rc)) {
            rc = (axmod) ? cpx_dya(sp, lo, hi)
                          :sca_dya(rc, sp, lo, hi);
            }
        else switch (rc) {
        case 'r':       /* shape .. make a table */
            n = MSIZE(lo->ADDR);
            if (MTYPE(lo->ADDR) != TYPN || n < 1 || n > 2) break;
            ix = INT_PTR(lo);
            nr = (n == 1) ? 1 : *ix++;
            nc = *ix;
            if (nr < 0 || nc < 0 ||
                mkobj(sp, MTYPE(hi->ADDR), nr * nc, nc)) break;
            MID_STR(&tt, sp, HDSIZE);
            MID_STR(&ss, hi, HDSIZE);
            rc = dsccyc(&tt, &ss);
            break;
        case '[':       /* index */
        case 'Q':       /* columns */
        case 'R':       /* rows */
            rc = vs_jdx(rc, sp, lo, hi);
            break;
        case '/':       /* reduce   */
            rc = fx_slash(sp, lo, hi);
            break;
        case '\\':       /* pad */
            rc = fx_pad(sp, lo, hi);
            break;
        case 'm':       /* shift  no error */
            rc = mshift(sp, lo, hi);
            break;
        case F_THETA:   /* flip data about horizontal axis */
            rc = sasm(sp, hi)       ||
                 fx_transp(hi, sp)  ||
                 mshift(sp, lo, hi) ||
                 fx_transp(hi, sp)  ||
                 sasm(sp, hi);
            break;
        case F_EQUIV:   /* test lo == hi */
            rc = (lo->SDLEN == hi->SDLEN &&
                  0 == memcmp(lo->ADDR, hi->ADDR, lo->SDLEN));
            rc = mkik(sp, rc);
            break;
        case'?':        /* deal m from n objects */
            rc = fx_deal(sp, lo, hi);
            break;
        case 'b':       /* base */
        case 'n':       /* represent */
            rc = fx_ec(sp, lo, hi);
            break;
        default:
            rc = do_jt(rc, sp, lo, hi);
            break;
        }
    if (rc == 0) rc = sasr(lo) || sasr(hi);
    break;
    }
return rc;
}

vs_jdx(fc, dst, src, idx)       /* dst <- src[idx] */
int     fc;                     /* select rows */
MATRIX  dst;
MATRIX  src;
MATRIX  idx;
{
BYTE   *s  = idx->ADDR;
int     n2 = MSIZE(s);
BYTE   *t  = src->ADDR;
int     n1 = MSIZE(t);
int    *ix, *iy, *iz;
int     dx, imax, k, n, nr, nc;

if (n2 == 0) return mkobj(dst, MTYPE(t), 0, 0);
if (MTYPE(s) != TYPN) return ERR_DOM;

if (fc == 'Q' && n1 > MCOLS(t)) {       /* columns of matrix */
    k = fx_transp(dst, src) ||
        sasm(src, dst) ||
        vs_jdx('[', dst, src, idx) ||
        fx_transp(src, dst) ||
        sasm(dst, src);
    return k;
    }

if (n1 > MCOLS(t)) fc = 'R';      /* select rows anyway */
if (fc == 'R') {
    nc = MCOLS(t);
    if (n1 == 0 || nc == 0) return sasa(dst, src);
    imax = n1 / nc;
    n = nc * n2;
    dx = MTYPE(t) * nc;
    }
else {                          /* take shape from idx */
    nc = MCOLS(s);
    imax = n1;
    n = n2;
    dx = MTYPE(t);
    }

if (mkobj(dst, MTYPE(t), n, nc)) return ERR_MEM;
if (n == 0) return OK;
t = TEXT_PTR(dst);
s = TEXT_PTR(src);
ix = INT_PTR(idx);

if (dx == TYPT) {
   for (; 0 < n2--; ix++, t++) {
        k = *ix;
        if (k >= 0 && k < imax) *t = s[k];
        }
    }
else if (dx == TYPN) {
    iz = INT_PTR(dst);
    iy = INT_PTR(src);
    for (; 0 < n2--; ix++, iz++) {
        k = *ix;
        if (k >= 0 && k < imax) *iz = iy[k];
        }
    }
else {
    for (ix = INT_PTR(idx); 0 < n2--; ix++, t += dx) {
        k = *ix;
        if (k >= 0 && k < imax) memcpy(t, s + k*dx, dx);
        }
    }
return sasr(src) || sasr(idx);
}

vs_idx(fc, dst, idx, src)       /* dst[idx]<-src */
int     fc;
MATRIX  dst;
MATRIX  idx;
MATRIX  src;
{
BYTE   *s  = src->ADDR;
BYTE   *t  = dst->ADDR;
int     nt = MSIZE(t);                  /* dst.size */
int     nc = MCOLS(t);                  /* dst.ncols */
int     ns = MSIZE(s);                  /* src.size */
int     cs = MCOLS(s);                  /* src.ncols */
int    *ix = INT_PTR(idx);
int     nx = MSIZE(idx->ADDR);          /* idx.size */
int     t1 = MTYPE(dst->ADDR);          /* dst.type */
int     dx = t1;                        /* number of bytes of element */
int     rc = 0;
BYTE   *sz, *tz;
int    *iz;
int     i, j, ip, k, nr;

if (nx == 0) return OK; /* no op */

if (TYPN != MTYPE(idx->ADDR) || t1 != MTYPE(s)) return ERROR;

if (nt == 0) return OK; /* dst.size zero */
nr = nt / nc;           /* number of rows of dst */

if (ns == 0) {          /* dst[idx]<-object of size 0 .. maybe special */
    rc = MINDX(s);
    if (rc == 0 || t1 != TYPN) return OK;

        /* postfix ++ or -- operations */

    for (iz = INT_PTR(dst); 0 < nx--; ix++) {
        i = *ix;
        if (i < 0 || i >= nt) continue;
        if (rc == '+')  iz[i]++;
        else            iz[i]--;
        }
    return '+';
    }

s = src->ADDR+HDSIZE;
t = dst->ADDR+HDSIZE;

if (fc == 'Q' || nr == 1) {     /* set columns   A[:J]<-DATA */
    k = (ns > 1);
    for (nx = MCOLS(idx->ADDR); 0 < nx--; ix++, s += k*dx) {
        ip = *ix;
        if (ip >= 0 && ip < nc) {       /* column in range */
            sz = s;
            tz = t + ip * dx;
            for (i = nr; 0 < i--; tz += nc * dx, sz += k * cs * dx)
                memcpy(tz, sz, dx);
            }
        }
    return OK;
    }

if (cs != nc) return ERROR;     /* set rows  A[J:]<-DATA */
i = ns/cs;                      /* DATA.nr */
if (i > 1 && i != nx) return ERROR;
k = (i > 1);
for(; 0 < nx--; ix++, s += k * dx * nc) {
    ip = *ix;
    if (ip < 0 || ip >= nr) continue;
    memcpy(t + ip * dx * nc, s, dx * nc);
    }
return OK;
}

fx_deal(dst, lo, hi)
MATRIX  dst;
MATRIX  lo;
MATRIX  hi;
{
BYTE   *s;
int     k;
int    *si = INT_PTR(hi);
int    *di = INT_PTR(lo);
int     n  = si[0];
int     m  = di[0];
if (m > n || m < 0 || n < 0 ||
    mkobj(hi, 'T', n, n) ||
    mkobj(dst, 'N', m, m)) return ERROR;
s  = TEXT_PTR(hi);
di = INT_PTR(dst);
for (; 0 < m--; di++) {
        for(k = rand() % n; s[k] != ' '; k = rand() % n);
        s[k] = '-';     /* don't use again */
        *di = k;
        }
return OK;
}

fx_ec(dst, lo, hi)      /* APL encode/decode */
MATRIX  dst;            /* dst <- lo (#base | #represent) hi */
MATRIX  lo;             /* like size of array */
MATRIX  hi;             /* list of index n-tuples | values */
{
BYTE   *s  = lo->ADDR;
int     nx = MSIZE(s);
BYTE   *t  = hi->ADDR;
int     n  = MSIZE(t);
int     nc = MCOLS(t);
int     j, nr;
unsigned int   *iz, *ix, *iy;
unsigned int    sum, val;

if (n == 0) return mkobj(dst, 'N', 0, 0);
if (MTYPE(s) != TYPN || MTYPE(t) != TYPN || nx == 0) return ERROR;

switch (MELSIZ(dst->ADDR)) {
    case 'b' :  /* base */
        if (nc != nx) return ERROR;
        nr = n/nc;
        if (mkobj(dst, 'N', nr, nr)) return ERROR;
        iy = (unsigned int*) INT_PTR(hi);
        iz = (unsigned int*) INT_PTR(dst);
        for(; 0 < nr--; iz++) {
            ix = (unsigned int*) INT_PTR(lo);
            for (sum = 0, j = nc; 0 < j--; ix++, iy++)
                if (*ix) sum = (*ix) * sum + *iy;
            *iz = sum;
            }
        return OK;
    case 'n' :  /* represent */
        if (mkobj(dst, 'N', n * nx, nx)) return ERROR;
        matflip(lo);
        iy = (unsigned int*) INT_PTR(hi);
        iz = (unsigned int*) INT_PTR(dst);
        for(; 0 < n--; iy++) {
            ix = (unsigned int*) INT_PTR(lo);
            for (val = *iy, j = nx; 0< j--; ix++, iz++)
                if (*ix) {
                    *iz = val % *ix;
                    val = val / *ix;
                    }
            }
        return matflip(dst);
    default: break;
    }
return ERROR;
}

fx_incdec(fc, xx)       /* postfix op. ++ or -- */
int     fc;             /* '+' or '-' */
MATRIX  xx;             /* operand */
{
BYTE   *s = xx->ADDR;
int     n, *ix;
double *xp;

n  = MSIZE(s);
if (MTYPE(s) == TYPN) {
    ix = INT_PTR(xx);
    if (fc == '+') for (; 0 < n--; ix++) (*ix)++;
    else           for (; 0 < n--; ix++) (*ix)--;
    }
else if (MTYPE(s) == TYPD) {
    xp = DBL_PTR(xx);
    if (fc == '+') for (; 0 < n--; xp++) (*xp)++;
    else           for (; 0 < n--; xp++) (*xp)--;
    }
else return ERROR;
return OK;
}

xgoto(sp, src)  /* goto */
MATRIX sp;      /* stack pointer of function */
MATRIX src;     /* line numbers */
/*      assumes ->X occurs in XFD triple */
{
extern  BYTE  *memchr();
extern  struct SDESC sx_match();
MATRIX  code = sp-1;    /* assumption here */
BYTE   *s, *t, *z;
int     num, n, nr, nc;
struct  SDESC   zz, ss, tt;

if (0 == MSIZE(src->ADDR)) return(mkobj(sp, 'T', 0, 0));
s = code->ADDR;
if (MTYPE(s) != TYPT || MELSIZ(s) == 0) return ERROR;
n  = MSIZE(s);
nc = MCOLS(s);
if (n == 0 || nc == 0 || n == nc) return ERROR;
nr = n/nc;

if (TYPN == MTYPE(src->ADDR)) {
    num = * INT_PTR(src);
    if (num <=0 || num >= nr) {     /* cause return */
        MINDX(s)  =  ERROR;
        MELSIZ(s) = 'Y';
        }
    else {
        MINDX(s) = num * nc;
        MELSIZ(s) = 'X';
        }
    }
else {  /*      match nearest string in function */
    ss.ADDR = TEXT_PTR(src);
    ss.SDLEN= MSIZE(src->ADDR);
    if (mkobj(sp, 'T', nc, nc)) return ERROR;
    tt.ADDR = TEXT_PTR(sp);
    for (nr--, t = TEXT_PTR(code)+nc; 0 < nr--; t+=nc) {
        if (*t == '"' && (z = memchr(t+1, '"', nc)) && ':' == *(z+1)) {
            tt.SDLEN = (z-t)-1;
            if (tt.SDLEN) memcpy(tt.ADDR, t+1, tt.SDLEN);
            sed_cstr(1, &tt);       /* interpret escape characters */
            zz = sx_match(&ss, &tt);
            if (zz.SDLEN) {
                MINDX(s) = t - TEXT_PTR(code);
                MELSIZ(s) = 'X';
                break;
                }
            }
       }
    }
return mkobj(sp, 'T', 0, 0);
}

int     fx_while(sp, lo, hi)   /* implement WHILE .. WEND */
MATRIX  sp;
MATRIX  lo;
MATRIX  hi;
{
MATRIX  code = sp-1;
int     pc   = fx_scan_token(code, NULL, 0, 0);
int     rc;
if (pc == ERROR) return pc;
if (hi == NULL) {       /* wend so search for preceding while */
    pc = fx_scan_token(code, "WHILE", pc, 0);
    if (pc == ERROR) return pc;
    MINDX(code->ADDR) = pc * MCOLS(code->ADDR);
    MELSIZ(code->ADDR) = 'X';
    return mkobj(sp, 'T', 0, 0);
    }

/*      while, so search for wend */

rc = fx_logicize(hi);   /* get boolean value */
if (rc == 0) {  /* exit the loop */
    pc = fx_scan_token(code,"WEND",pc,MSIZE(code->ADDR)/MCOLS(code->ADDR));
    if (pc == ERROR) return pc;
    MINDX(code->ADDR) = (pc+1) * MCOLS(code->ADDR);
    if (MINDX(code->ADDR)>= MSIZE(code->ADDR)) {        /* force return */
        MELSIZ(code->ADDR)='Y';
        MINDX(code->ADDR) = ERROR;
        }
    }
return mkobj(sp, 'T', 0, 0);
}

fx_logicize(sp)         /* return boolean value from object context */
MATRIX  sp;
{
int     rc;
if (sp == NULL || sp->ADDR == NULL || MSIZE(sp->ADDR) == 0) rc = 0;
else if (TYPN == MTYPE(sp->ADDR)) rc = (0 != *INT_PTR(sp));
else if (TYPT == MTYPE(sp->ADDR))
    rc = ! allblank(TEXT_PTR(sp), MSIZE(sp));
return  rc;
}

int     fx_iter(sp, cx) /* implement BREAKIF .. REPEATIF */
MATRIX  sp;     /* function code */
MATRIX  cx;     /* condition value */
{
MATRIX  code = sp-1;
int     fc   = MELSIZ(sp->ADDR);        /* volatile .. may change */
int     rc   = fx_logicize(cx);
int     pc;

if (fc == F_IF) rc = ! rc;
if (rc == 0) return mkobj(sp, 'T', 0, 0);       /* do nothing */

pc   = fx_scan_token(code, NULL, 0, 0);
if (pc == ERROR) return pc;

switch (fc) {
    case F_REPEATIF:    /* search for preceding while */
        pc = fx_scan_token(code, "WHILE", pc, 0);
        if (pc == ERROR) return pc;
        MINDX(code->ADDR) = pc * MCOLS(code->ADDR);
        break;
    case F_BREAKIF:     /* search for wend */
        pc =
        fx_scan_token(code,"WEND", pc, MSIZE(code->ADDR)/MCOLS(code->ADDR));
        MINDX(code->ADDR) = (pc == ERROR)
            ? MSIZE(code->ADDR)         /* force return */
            : (pc+1)*MCOLS(code->ADDR); /* exit loop */
        break;
    case F_IF:          /* skip to next line */
        MINDX(code->ADDR) = (pc+1) * MCOLS(code->ADDR);
        break;
    default:            /* unknown function */
        return ERROR;
    break;
    }

if (MINDX(code->ADDR) >= MSIZE(code->ADDR)) {
    MINDX(code->ADDR) = ERROR;
    MELSIZ(code->ADDR) = 'Y';  /* force return */
    }

return mkobj(sp, 'T', 0, 0);
}

fx_scan_token (txt, name, a, b) /* find token 'name' in text */
MATRIX  txt;
char   *name;
int     a, b;   /* start, end */
{
struct  SDESC x;
int     rc = ERROR;
int     n, nc, nr, ns;
int     i, k, dx;
BYTE   *s = txt->ADDR;

if (s == NULL || MTYPE(s) != TYPT || MELSIZ(s) == 0) return ERROR;
n  = MSIZE(s);
nc = MCOLS(s);
if (n == 0 || nc == 0 || n == nc) return ERROR;
nr = n/nc;

if (name == NULL || 0 == (ns = strlen(name)))
    return (MINDX(s)-1)/ MCOLS(s); /* current line */

dx = (a<b) ? 1 : -1;
for (i=a; rc == ERROR; i+=dx) {
    if (i < 0 || i>= nr) break;
    x.ADDR  = TEXT_PTR(txt) + i*nc;
    x.SDLEN = nc;
    ss_rtrim(&x);
    k = x.SDLEN;
    if (k>=ns &&
       (0 == memcmp(x.ADDR,name,ns)||0 == memcmp(x.ADDR+k-ns,name,ns))) {
        rc = i;
        break;
        }
    }
return  rc;
}

int     fx_srand(dst, hi)       /* initialise random number stream */
MATRIX  dst, hi;
{
extern  int     srand();
BYTE   *s = hi->ADDR;
int     seed = 0;
if (TYPN != MTYPE(s) || 0 == MSIZE(s)) return ERROR;
seed = *(INT_PTR(hi));
srand(seed);
return mkik(dst, seed);
}
