/*
     Jan-May 2003. New functions which should really be in fxker.c
     soft variables $FTIME, $FSTAT, $INP, $OUTP
     usage: FTS<- $FTIME[file_name_table]

     FTS is a nfiles*6 integer matrix where the integers are
     year, month(1-12),day(1-31),hour, second, minute.

           FSTAT<- $FSTAT[file_name_table]

     FSTAT is a vector of nfiles integers. Each integer is bit
significant according to UNIX specifications.

     int getftime(int handle, struct ftime *ptr);
Get the timestamp for the given file handle.  The return structure is as
follows:
     struct ftime {
       unsigned ft_tsec:5; 0-29, double to get real seconds
       unsigned ft_min:6;  0-59
       unsigned ft_hour:5;    0-23
       unsigned ft_day:5;    1-31
       unsigned ft_month:4;    1-12
       unsigned ft_year:7;    since 1980
     }
Return Value: Zero on success, nonzero on failure.

*/

#if defined(TC)
#include <io.h>
#define OUTP(P,VAL) outp((unsigned)P,(unsigned char)VAL)
#define INP(P) inp(P)
#elif defined (DJGPP)
#include <pc.h>
#define OUTP(P,VAL) outp((unsigned short)P,(unsigned char)VAL)
#define INP(P) inp((unsigned short)P)
#elif defined (linux)
#include <sys/io.h>
#define OUTP(P,VAL) outb((unsigned char)VAL, (unsigned short) P)
#define INP(P) inb((unsigned short)P)
#endif

#ifndef linux
#include <dos.h>
#endif

#include <fcntl.h>
#include <na.h>

#ifdef linux

d4_ftime(dst, lst)
MATRIX  dst, lst;
{
return ERROR;
}

#else

d4_ftime(dst, lst)
MATRIX  dst, lst;
{
extern  void *malloc();
struct  ftime   ft;
char   *fn, *s;
int     n = MSIZE(lst->ADDR);
int     nc = MCOLS(lst->ADDR);
int    *ix, fd, nr;
BYTE   *t;
if (n == 0 || nc == 0) return mkobj(dst, 'T', 0, 0);
nr = n/nc;
if (mkobj(dst, TYPN, 6*nr, 6)) return ERROR;

if (NULL == (fn = malloc(nc+1))) return ERROR;
for (t = TEXT_PTR(lst), ix = INT_PTR(dst); 0<nr--; ix+=6, t+=nc) {
     memcpy(fn, t, nc);
     fn[nc] = ' ';
     for (s = fn; *s != ' '; s++);
     *s = 0;
     fd = open(fn, O_RDONLY);
     if (fd != -1 && 0 == getftime(fd, &ft)) {
        ix[0] = 1980 + ft.ft_year, ix[1] = ft.ft_month, ix[2] = ft.ft_day;
        ix[3] = ft.ft_hour, ix[4] = ft.ft_min, ix[5] = 2* ft.ft_tsec;
        close(fd);
        }
    }
free(fn);
return OK;
}

#endif

d4_fstat(dst, lst)      /* status of file list */
MATRIX  dst, lst;
{
extern  void *malloc();
char   *fn, *s;
int     n = MSIZE(lst->ADDR);
int     nc = MCOLS(lst->ADDR);
int    *ix, fd, nr;
BYTE   *t;
if (n == 0 || nc == 0) return mkobj(dst, 'T', 0, 0);
nr = n/nc;
if (mkobj(dst, TYPN, nr, nr)) return ERROR;

if (NULL == (fn = malloc(nc+1))) return ERROR;
for (t = TEXT_PTR(lst), ix = INT_PTR(dst); 0<nr--; ix++, t+=nc) {
    memcpy(fn, t, nc);
    fn[nc] = ' ';
    for (s = fn; *s != ' '; s++);
    *s = 0;
    *ix = d4_stat(fn);
    }
free(fn);
return OK;
}

fx_portb(dst, src, idx)         /* hardware IO ports */
MATRIX  dst, src, idx;
{
int     port, n;
BYTE   *s;
if (idx == NULL || NULL == idx->ADDR || TYPN != MTYPE(idx->ADDR))
     return ERROR;
else port = *INT_PTR(idx);

if (src == NULL) {              /* input */
     if (mkobj(dst, TYPT, 1, 1)) return ERROR;
     *(TEXT_PTR(dst)) = INP(port);
     return OK;
     }

if (NULL == src->ADDR || TYPT != MTYPE(src->ADDR)) return OK;
/*      quiet error, or no-op.  */

for(s = TEXT_PTR(src), n = MSIZE(src->ADDR); 0 < n--; s++ ) {
    OUTP(port, *s);
    }
return OK;
}


