/*      FXKER.C -- Memory | port | channel routines */
#include <na.h>
#include <fdata.h>
#include <stdio.h>
#include <time.h>
#include <sys/types.h>
#include <sys/time.h>
#include <dirent.h>
#include <sys/stat.h>

#define MAX_FILE_LEN    0X200
#define S_D4REG 0X01    /* Like DOS file */
#define S_D4DIR 0X10    /* Directory .. DOS */
#define S_D4ALL 0X3F    /* All files */

/*      directory search
*       return a matrix containing a list of files.
*       LA::=  union {int DOS_mode; char[] unix_types}
*       RA:: = path {/regexp}
*       Usage:
*       TAB<- {LA} #files path {/regexp}
*/

fx_dtxt(dst, lo, fp)    /*  {attributes} #files "*.*" */
MATRIX  dst;            /* list */
MATRIX  lo;             /* attributes. int for DOS, string for UNIX .*/
char   *fp;             /* ASCIZ file name */
{
extern  DIR    *opendir();
extern  SLIST   sl_push();
DIR    *xd;
struct  dirent *xp;
SLIST   t;
struct  SDESC tt;
char   *name;
char   *ncomp = NULL;
char   *s, *slash, *scan;
int     ks = S_D4REG;   /* select */
int     n, rc, qfind;

if (lo != NULL) ks = *(INT_PTR(lo));

/* check for pattern search */
if (fp == NULL || 0 == (n = strlen(fp))) return mkobj(dst, 'T', 0, 0);
for (scan = slash = NULL, s = fp; 0 < n--; s++) {
    if (scan == NULL && (*s == '?' || *s == '*')) scan = s;
    if (*s == '/') slash = s;
    }

if (scan) {
    if (slash) {
        if (scan < slash) fp = NULL;
        else {
            ncomp = slash+1;
            *slash = 0;
            if (slash == fp) fp = "/";
            }
        }
    else {
        ncomp = fp;
        fp = ".";
        }
    }
else ncomp = NULL;

rc = (fp) ? d4_stat(fp) : 0;    /* file existance */

if  (scan == NULL)
    return (S_ISREG(rc) || (S_ISDIR(rc) && (ks & S_D4DIR)))
        ? mk_zstr(dst, fp)
        : mkobj(dst, 'T', 0, 0);

if (! S_ISDIR(rc)) return mkobj(dst, 'T', 0, 0);

/* search for pattern */

if (mkobj(dst, 'T', MAX_FILE_LEN, MAX_FILE_LEN) ||
    mkobj(dst+1, 'L', 1, 1))    /* linked list */
    return ERROR;

name = TEXT_PTR(dst);
t  = (SLIST)LINK_PTR(dst+1);
if (NULL == (xd = opendir(fp)))
    return sys_del(dst+1) || mkobj(dst, 'T', 0, 0);

for (xp = readdir(xd); xp != NULL; xp = readdir(xd)) {
    qfind = 0;
    sprintf(name, "%s/%s", fp, xp->d_name);
    rc = d4_stat(name);
    if (ks == S_D4ALL) qfind |= 1;
    if (ks & S_D4REG)  qfind |= S_ISREG(rc);
    if (ks & S_D4DIR)  qfind |= S_ISDIR(rc);
    if(qfind) {
        tt.ADDR = xp->d_name;
        tt.SDLEN = strlen(xp->d_name);
        if (OK == ff_match(ncomp, xp->d_name))
            t = sl_push(t, &tt);
        }
    }
rc = closedir(xd);
rc = sl_cat('M', dst, S_NEXT(LINK_PTR(dst+1)), NULL) ||
     sys_del(dst+1);
return rc;
}

mk_zstr(p, s)   /* Object from string */
MATRIX  p;
BYTE   *s;
{
int     n = strlen(s);
if (mkobj(p, 'T', n, n)) return ERROR;
memcpy(TEXT_PTR(p), s, n);
return OK;
}

int     d4_stat(name)   /* give file status as ordinary int */
char   *name;
{
struct  stat    file_mode;
int     rc = lstat(name, &file_mode);
return (rc) ? 0: (int) file_mode.st_mode;
}

int     ff_match(char *x, char *a)
{
int     k;
while (k = *x++) switch (k) {
    case '?': /* match any single character */
        if (*a++ == 0) return ERROR;
        break;
    case '*': /* match any string */
        if (0 == (k= *x++)) return OK;
        while (k != *a) {       /* find k */
            if (*a == 0) return ERROR;
            a++;
            }
        a++;
        break;
    default:    /* want an exact match */
       if (k !=*a++) return ERROR;
       }
return OK;
}

fx_peek(dst, lo, hi)        /* peek, poke */
MATRIX  dst;
MATRIX  lo;
MATRIX  hi;
{
int     n = MSIZE(hi->ADDR);
BYTE  **s, *t;
int     m, dx = 1;

if (lo == NULL) {
    if (mkobj(dst, 'T', n, n)) return ERROR;
    for (t=TEXT_PTR(dst),s=(BYTE**)(INT_PTR(hi)); 0<n--;*t++ = *(*s++));
    return OK;
    }

m = MSIZE(lo->ADDR);    /* poke */

if (m == 1) dx = 0;
else if (m != n) return ERROR;
for (t = TEXT_PTR(lo), s = (BYTE**)(INT_PTR(hi)); 0 < n--; *(*s++) = *t)
        t += dx;
return OK;
}

fx_lprint(dst, src)     /* send text (bytes) to printer */
MATRIX dst;             /* number of characters printed */
MATRIX src;             /* any character vector */
{
extern  char   *mkasciz();
extern  MATRIX  sys_text();
extern  MATRIX  pm_sym;
MATRIX  lp_dev = sys_text(pm_sym, "$LP_DEV");   /* selected device */
BYTE   *s  = src->ADDR;
int     n  = MSIZE(s);
int     rc;
char   *sink;

if (lp_dev == NULL || MTYPE(s) != TYPT) return ERROR;
if (NULL == (sink = mkasciz(lp_dev, 0))) return ERROR;
rc = dh_zsave(src, sink);
free(sink);
return mkik(dst, (rc) ? ERROR : n);
}

fx_86(dst, lo, hi)
MATRIX dst, lo, hi;
/*      AX,BX,CX,DX <- (AX,BX,CX,DX) #int N    */
{
return mkik(dst, ERROR);
}

        /* ENQUIRE DATE AND TIME */

fx_ts(dst)      /* years, months, days, hours, minutes, seconds */
MATRIX  dst;
{
extern  time_t time();
extern  struct tm *localtime();
time_t  tnow;
int    *ix;
struct  tm*     tvec;

if (mkobj(dst, 'N', 6, 6)) return ERROR;
else    ix = INT_PTR(dst);

tnow = time(NULL);
tvec = localtime(&tnow);
ix[0] = 1900 + tvec->tm_year;
ix[1] = 1 + tvec->tm_mon;       /* compatability with DOS version */
ix[2] = tvec->tm_mday;
ix[3] = tvec->tm_hour;
ix[4] = tvec->tm_min;
ix[5] = tvec->tm_sec;
return OK;
}

fx_sh(dst, src)      /* do a command after 'stty sane' */
MATRIX  dst;
MATRIX  src;
{
BYTE   *s = src->ADDR;
int     n = 0;
int     rc = 0;
BYTE   *t;

if (s) {
    n = MSIZE(s);
    s += HDSIZE;
    }
if (*s == '<') {
    rc = 1;
    for (n--, s++; 0 < n && *s == ' '; s++, n--);
    }
if (mkobj(dst, 'T', n+1, n+1)) return ERROR;
t = TEXT_PTR(dst);
if (n) memcpy(t, s, n);
t[n] = 0;     /* ASCIZ string */
if (rc) { /* open pipe */
    if (mkobj(src, 'L', 1, 1)) return ERROR;
    sl_xget(LINK_PTR(src), t);
    return sl_cat('V', dst, LINK_PTR(src), NULL) ||
           sys_del(src);
    }
tty_set(0);
rc = system(t);
tty_set(1);
return mkik(dst, rc);
}

mk_nltab(dst, src)      /* make list of names as matrix */
MATRIX  dst;    /* matrix of names */
MATRIX  src;    /* a name list */
{
BYTE   *s  = src->ADDR;
int     n  = MSIZE(s);
int     nc = MCOLS(s);
struct  SDESC   ss;

if (TYPT != MTYPE(s)) return ERROR;
if (n != nc) return OK;        /* do nothing */
else if (fx_deb(dst, src)) return ERROR;
    ss.ADDR  = TEXT_PTR(dst);
    ss.SDLEN = MSIZE(dst->ADDR);
return ss_mat(src, &ss, ' ') || sasr(dst);
}

fx_symop(fc, dst, src)  /* symbol operations */
int     fc;     /* function:  nc = class, ex = delete, varptr = pointer */
MATRIX  dst;    /* return vector */
MATRIX  src;    /* a name list */
{
extern  MATRIX  pm_sym;
extern  MATRIX  sys_vget();
BYTE   *s, *t;
int     n, nc, nr, k, rc;
int    *di;
MATRIX  p;
struct  SDESC   tt;

if (mk_nltab(dst, src)) return ERROR;   /* convert src to matrix */

s  = src->ADDR;
n  = MSIZE(s);
nc = MCOLS(s);
if (nc == 0) return ERROR;
nr = n / nc;

if (rc = mkobj(dst, 'N', nr, nr)) return ERROR;

for (di = INT_PTR(dst), s = TEXT_PTR(src); rc == 0 && 0 < nr --; s += nc) {
    tt.ADDR = s;
    tt.SDLEN = nc;
    ss_rtrim(&tt);
    p  =  sys_vget(pm_sym, &tt);
    switch(fc) {
        case F_NC:      /* name class */
            *di++ = (p == NULL || p->ADDR == NULL) ? 0 : MTYPE(p->ADDR);
        break;
        case F_EX:      /* delete */
            if (p == NULL || p->ADDR == NULL) k = 0;
            else {
                rc |= sys_del(p);       /* function is complicated */
                k = 1;
                }
            *di++ = k;
        break;
        case F_VARPTR:  /* data pointer */
            *di++ = (p == NULL) ? 0 : (int) p->ADDR;
        break;
        default: return ERROR;
        }
    }
return OK;
}

fx_cvt(dst, op, src)    /* general data conversion */
MATRIX  dst;
MATRIX  op;
MATRIX  src;
{
BYTE   *s  = src->ADDR;
int     dx = MTYPE(s);
BYTE   *t  = op->ADDR;
int     fc;

if (t == NULL || 0 == MSIZE(t)) return ERROR;

if (MTYPE(t) == TYPN)           fc = *(INT_PTR(op));
else if (MTYPE(t) == TYPT)      fc = (int) *(TEXT_PTR(op));
else    return ERROR;

switch (fc) {
    case 'T':
    case TYPT:  /* text */
        if (dx == TYPT)         return sasa(dst, src);
        else if (dx == TYPN)    return fx_av(dst, src);
        break;
    case 'N':
    case TYPN:  /* integer */
        if (dx == TYPN)         return sasa(dst, src);
        else if (dx == TYPT)    return fx_av(dst, src);
        else if (dx == TYPD)    return fx_cvi(dst, src);
        break;
    case 'D':
    case TYPD:  /* float */
        if (dx == TYPD)         return sasa(dst, src);
        else if (dx == TYPN)    return fx_cvd(dst, src);
        break;
    default: break;
    }
return ERROR;
}

fx_av(dst, src)         /* char <=> ASCII conversion */
MATRIX  dst;
MATRIX  src;
{
BYTE   *s = src->ADDR;
int     dx = MTYPE(s);
int     n  = MSIZE(s);
int     nc = MCOLS(s);
int    *si;

if (n == 0)       return sasa(dst, src);
else if (nc == 0) return ERROR;
if (dx == TYPN) {       /* numeric to character */
    if (mkobj(dst, 'T', n, nc)) return ERROR;
    for(s = TEXT_PTR(dst), si = INT_PTR(src); 0 < n--;  s++, si++)
        *s = (BYTE)(*si);
    }
else if (dx == TYPT) {  /*      ASCII values of text */
    if (mkobj(dst, 'N', n, nc)) return ERROR;
    for(si = INT_PTR(dst), s = TEXT_PTR(src); 0 < n--; s++, si++)
        *si = (int) *s;
    }
else return ERROR;
return OK;
}

fx_cvd(dst, src)        /* convert to double */
MATRIX  dst;
MATRIX  src;            /* must be numeric */
{
BYTE   *s  = src->ADDR;
int     n  =  MSIZE(s);
int     nc =  MCOLS(s);
int    *ix;
DOUBLE *x;

if (MTYPE(s) == TYPD) return sasa(dst, src);
else if (MTYPE(s) == TYPN) {
    if (mkobj(dst, 'D', n, nc)) return ERROR;
    for (x = DBL_PTR(dst), ix = INT_PTR(src); 0 < n--;)
        *x++ = (DOUBLE) (*ix++);
    return OK;
    }
else return ERROR;
}

fx_cvi(dst, src)        /* double to integer */
MATRIX  dst;
MATRIX  src;            /* must be numeric */
{
BYTE   *s  = src->ADDR;
int     n  =  MSIZE(s);
int     nc =  MCOLS(s);
int    *di;
DOUBLE *x, xr;
if (MTYPE(s) == TYPN) return sasa(dst, src);
else if (MTYPE(s) == TYPD) {
    if (mkobj(dst, 'N', n, nc)) return ERROR;
    for (x = DBL_PTR(src), di = INT_PTR(dst); 0 < n--; di++, x++) {
        xr = *x;
        if (xr > (DOUBLE) MAX_INT)      xr = (DOUBLE) MAX_INT;
        else if (xr < (DOUBLE) MIN_INT) xr = (DOUBLE) MIN_INT;
        *di = (int) xr;
        }
    return OK;
    }
else return ERROR;
}

fx_call(dst, lo, hi)
MATRIX  dst;    /* result */
MATRIX  lo;     /* paramaters to be used as AX,BX,CX,DX,SI,DI etc */
MATRIX  hi;     /* code */
{
return sasa(dst, hi);
}

fx_cwd(dst)
MATRIX dst;
{
extern  char *getcwd();
struct  SDESC tt;
BYTE   *s;

mkobj(dst+1, 'T', MAX_FILE_LEN+1, MAX_FILE_LEN+1);
tt.ADDR = TEXT_PTR(dst+1);
tt.SDLEN = 0;
if (NULL != getcwd(tt.ADDR, MAX_FILE_LEN)) {
        for (s = tt.ADDR; *s; s++);
        tt.SDLEN = s - tt.ADDR;
        if (tt.SDLEN > MAX_FILE_LEN) tt.SDLEN = MAX_FILE_LEN;
        }
return mk_sk(dst, TYPT, &tt) || sasr(dst+1);
}

/* sleep, usleep */

int     fx_sleep(dst, delay) /* #sleep seconds, microseconds */
MATRIX  delay;
MATRIX  dst;
{
extern  int     sleep();
#ifndef TC
extern  int     usleep();
#endif
int     n = MSIZE(delay->ADDR);
int    *ix = INT_PTR(delay);
int     rc = 0;
if (n==0 || TYPN != MTYPE(delay->ADDR)) return mkik(dst, ERROR);
if (ix[0]) sleep ((unsigned) (rc = ix[0]));
#ifndef TC
if (n>1 && ix[1]) usleep((unsigned) (rc=ix[1]));
#endif
return mkik(dst, rc);
}
