/*      MATOP.C - integer only */
/* Oct 22 2009. change (n,0) z X to supress spurious - sign */
/* Nov 2009     change default precision in xx_fmt          */

#include <na.h>

#define FW_MAX  0X40
BYTE    xx_dst[2*FW_MAX+1];

fex_cat(dst, lo, hi)            /* general con-catenate */
MATRIX dst;
MATRIX lo;
MATRIX hi;
{
int     rc = OK;
int     t1  = MTYPE(lo->ADDR);
int     n1  = MSIZE(lo->ADDR);
int     nc1 = MCOLS(lo->ADDR);
int     t2  = MTYPE(hi->ADDR);
int     n2  = MSIZE(hi->ADDR);
int     nc2 = MCOLS(hi->ADDR);
int     i, i1, i2, nr1, nr2, dx, nr, nc;
BYTE   *r, *s, *t;

if (dst != NULL &&
    dst->ADDR &&
    MINDX(dst->ADDR) == AXIS_MODIFIER)
        return fx_over(dst, lo, hi);

if      (n1 == 0) return sasa(dst, hi);
else if (n2 == 0) return sasa(dst, lo);
else if (nc1 == 0 || nc2 == 0) return ERROR;

switch (t1) {           /* make types compatible */
        case TYPT: if (t2 != TYPT) return ERROR;
                dx = t1;
        break;
        case TYPN:      /* numeric */
                if (t2 == TYPD) rc = fx_cvd(dst, lo) || sasm(lo, dst);
           else if (t2 != TYPN) return ERROR;
                dx = t2;
        break;
        case TYPD:      /* numeric */
                if (t2 == TYPN) rc = fx_cvd(dst, hi) || sasm(hi, dst);
           else if (t2 != TYPD) return ERROR;
                dx = t1;
        break;
        default:        /* non data */
                rc = ERROR;
        break;
        }
if (rc) return rc;
i1 = (n1 > 1);
i2 = (n2 > 1);
nr1 = n1 / nc1;
nr2 = n2 / nc2;
if (nr1 > 1 && nr1 == nc2 && nr1 == n2) {
    nr2 = n2;   /* adjust hi to column */
    nc2 = 1;
    }
else if (nr2 > 1 && nr2 == nc1 && nr2 == n1) {
    nr1 = n1;   /* adjust lo to column */
    nc1 = 1;
    }
if (i1 && i2  && nr1 != nr2) return ERROR;
nr = (nr1 > nr2) ? nr1 : nr2;   /* maximum rows */
nc = nc1 + nc2;
if (rc = mkobj(dst, dx, nr * nc, nc))
        return (rc);
r =  TEXT_PTR(dst);
s =  TEXT_PTR(lo);
t =  TEXT_PTR(hi);
for(nc1 *= dx, nc2 *= dx; 0 < nr; nr--) {
        memcpy(r, s, nc1);
        if (i1) s += nc1;
        r += nc1;
        memcpy(r, t, nc2);
        if (i2) t += nc2;
        r += nc2;
        }
return OK;
}

fx_over(dst, lo, hi)    /* conatenate: A over B */
MATRIX  dst;
MATRIX  lo;
MATRIX  hi;
{
return    fx_transp(dst, hi) || sasm(hi, dst)
       || fx_transp(dst, lo) || sasm(lo, dst)
       || fex_cat(dst, lo, hi)
       || fx_transp(hi, dst) || sasm(dst, hi);
}

xvshift(zz, xx, cnt)    /* shift data vector */
SLICE zz;               /* destination */
SLICE xx;               /* data */
int cnt;                /* shift count */
{
BYTE *s;
BYTE *t = zz->ADDR;
int   n = zz->SDLEN;
cnt = cnt % n;
if (cnt < 0) cnt += n;
if (cnt == 0 || n < 2 ) {
        memcpy(t, xx->ADDR, n);
        return (OK);
        }
for (s = xx->ADDR + cnt, cnt = n - cnt; n > 0; n--, cnt--) {
        if (cnt == 0) s = xx->ADDR;
        *t++ = *s++;
        }
return OK;
}

mshift(dst, cvec, src)  /* shift a matrix */
MATRIX dst;             /* result */
MATRIX cvec;            /* shift count vector */
MATRIX src;             /* object to permute */
/* in case of error, do nothing, & give OK result. */
{
int rc;
int dx, nr, nc, n, ns, dj;
int *jx;
struct SDESC ss, tt;    /* slice */
ns = rho(cvec, &nr, &nc);
n  = rho(src,  &nr, &nc);
if (ns == 0 || n == 0) return OK;
dx = MTYPE(src->ADDR);
if (dx != TYPT && dx !=TYPN && dx != TYPD) return ERROR;
if (rc = sasa(dst, src))
        return rc;
nc = nc * dx;           /* slice size in bytes */
dj = (ns == nr);        /* constant or vector  */
tt.ADDR  = TEXT_PTR(dst);
tt.SDLEN = nc;
ss.ADDR  = TEXT_PTR(src);
ss.SDLEN = nc;
for (jx = INT_PTR(cvec); 0 < nr--; jx += dj, tt.ADDR += nc, ss.ADDR += nc)
                xvshift(&tt, &ss, dx * (*jx));
return OK;
}

/* PAD */

fx_pad (dst, lo, hi)    /* pad columns */
MATRIX dst;             /* result */
MATRIX lo;              /* bool vector */
MATRIX hi;              /* vector or matrix */
{
BYTE   *s  = hi->ADDR;
int     n  = MSIZE(s);
int     nc = MCOLS(s);
int     dx = MTYPE(s);
int     nd = MSIZE(lo->ADDR);
BYTE   *t;
int    *ix, fw, i, j, nr;
int    *is, *it;
DOUBLE *xs, *xt;

if (n == 0 || 0 == MSIZE(s)) return (mkobj(dst, dx , 0, 0));
if (MTYPE(lo->ADDR) != TYPN) return ERROR;

nr = n/nc;

for (ix = INT_PTR(lo), i = nd, fw=0; 0 < i--; ix++)
    fw += 0 != ix[0];
if (nc != fw ||
    mkobj(dst, dx, nr * nd, nd)) return ERROR;

switch(dx) {
    case TYPT:  /* bytes */
        s  = TEXT_PTR(hi);
        t  = TEXT_PTR(dst);
        for (i=nr; 0 < i--; )
            for(ix = INT_PTR(lo), j = nd; 0 < j--; ix++, t++)
                if (*ix) *t = *s++;
        break;
    case TYPN:  /* integers */
        is = INT_PTR(hi);
        it = INT_PTR(dst);
        for (i=nr; 0 < i--; )
            for(ix = INT_PTR(lo), j = nd; 0 < j--; ix++, it++)
                if (*ix) *it = *is++;
        break;
    case TYPD:  /* double */
        xs = DBL_PTR(hi);
        xt = DBL_PTR(dst);
        for (i=nr; 0 < i--; )
            for(ix = INT_PTR(lo), j = nd; 0 < j--; ix++, xt++)
                if (*ix) *xt = *xs++;
        break;
    default: return ERROR;
    }
return OK;
}

/* COMPRESS */

fx_slash(dst, lo, hi)   /* compress -- duplicate */
MATRIX dst;             /* works along horizontal axis */
MATRIX lo;              /* numeric vector */
MATRIX hi;              /* vector or matrix */
{
BYTE   *s  = hi->ADDR;
int     dx = MTYPE(s);
int    *ix = INT_PTR(lo);
int     n  = MSIZE(lo->ADDR);
int     i1 = n > 1;
int     qaxis = 0;
int     i, j, qh, kc;
int     nr, nc;
int     rc = 0;
struct  SDESC tt, ss;

if (n == 0 || 0 == MSIZE(s))
    return (mkobj(dst, dx , 0, 0));
if (n == 1) switch (ix[0]) {
    case 0: return (mkobj(dst, dx , 0, 0));
    case 1: return (sasa(dst, hi));
    default: if (ix[0]<0) return ERROR;
             else break;
    }

if (dst != NULL && MINDX(dst->ADDR) == AXIS_MODIFIER) {
    qaxis = 1;
    if (fx_transp (dst, hi) || sasm(hi, dst)) return ERROR;
    s = hi->ADDR;
    }

rho(hi, &nr, &nc);
qh = (MSIZE(s) > 1);
if (i1 && qh && n != nc) return ERROR;
if (i1 == 0) kc = ix[0] * (n = nc);     /* use length of r.h.s. */
else for (kc = j = 0; j < n; j++, ix += i1) {
    kc += *ix;
    rc |= (*ix < 0);
    }
if (rc || mkobj(dst, dx, nr*kc, kc)) return ERROR;
tt.ADDR  = dst->ADDR + HDSIZE;
ss.ADDR  = s + HDSIZE;
ss.SDLEN = dx;

for (i = 0; i < nr; i++) {
    ix = INT_PTR(lo);
    for (j = n; 0 < j--;) {
        tt.SDLEN = dx * (*ix);
        dsccyc(&tt, &ss);
        tt.ADDR += tt.SDLEN;
        if (qh) ss.ADDR += dx;
        if (i1) ix++;
        }
    }

if (qaxis) return fx_transp(hi, dst) || sasm(dst, hi);
return OK;
}

/*  MATFLIP   */

matflip(z)              /* reverse a matrix in situ     */
MATRIX z;               /* text or integer matrix       */
{
BYTE   *s  = z->ADDR;
int     dx = MTYPE(s);
int     n  = MSIZE(s);
int     nc = MCOLS(s);
int     k, nr;
int    *ix, *jx;
struct  SDESC tt;

if (n == 0 || nc == 0) return OK;
tt.ADDR  = TEXT_PTR(z);
tt.SDLEN = nc * dx;
        /* reverse each row */
for (nr = n / nc; 0 < nr--; tt.ADDR += tt.SDLEN) {
    if      (dx == TYPT)  vflip (&tt);
    else if (dx == TYPN)  {
        ix = (int *) tt.ADDR;
        jx = ix + nc - 1;
        while (jx > ix) {
            k = *jx;
            *jx-- = *ix;
            *ix++ = k;
            }
        }
    else if (dx == TYPD)  dxflip(&tt, dx);
    }
return OK;
}

dxflip(xx, fw)          /* reverse a string in situ */
SLICE   xx;             /* data */
int     fw;             /* field width */
{
BYTE   *s   = xx->ADDR;
int     cnt = xx->SDLEN;
BYTE   *t = s + cnt - fw;
int     j, k;

cnt = cnt / fw;
if (cnt == 0) return OK;
for (j = fw; t > s; ) { /* do it by transpositions */
    k = *t;
    *t++ = *s;
    *s++ = k;
    if (0 == --j) t -= 2 * (j = fw);
    }
return OK;
}

fx_transp(dst, hi)  /* transpose */
MATRIX dst;
MATRIX hi;
{
BYTE *s = hi->ADDR;
BYTE *t;
int dx  = MTYPE(s);
int n, nr, nc;
int i, j, k;
n = rho(hi, &nr, &nc);
if (n == 0) return sasa(dst, hi);
if (mkobj(dst, dx, nr*nc, nr)) return ERROR;
t = dst->ADDR+HDSIZE;
s  += HDSIZE;
if (nr == 1 || nc == 1) {
        memcpy(t, s, n*dx);
        return (OK);
        }
for(i = 0; i < nr; i++)
        for (j = 0; j < nc; j++)  {
        k = nr*j + i;
        memcpy(t + dx*k, s, dx);
        s += dx;
        }
return OK;
}

fex_struc(op, dst, lo, hi)      /* take and drop */
int op;                         /* 't' or 'd' */
MATRIX dst;                     /* result */
MATRIX lo;                      /* left argument */
MATRIX hi;                      /* right argument */
/*              Take and drop */
{
int     rc;
int     n = MSIZE(lo->ADDR);
int    *ix = INT_PTR(lo);
int     k1, k2, nsize, nr, nc;
switch (op) {
    case 't':       /* take */
        rc = (n == 1) ? fx_take(dst, hi, 1, ix[0])
                      : fx_take(dst, hi, ix[0], ix[1]);
        break;
    case 'd' :      /* drop -- calculate size */
        nsize = rho (hi, &nr, &nc);
        if (n == 1) {
                if (ix[0] < 0) {
                    k1 = ix[0] + nc;
                    if (k1 < 0) k1 = 0;
                    }
                else {
                    k1 = ix[0] - nc;
                    if (k1 > 0) k1 = 0;
                    }
                rc = fx_take(dst, hi, 1, k1);
                }
        else {
                if (ix[0] < 0) {
                    k1 = ix[0] + nr;
                    if (k1 < 0) k1 = 0;
                    }
                else {
                    k1 = ix[0] - nr;
                    if (k1 > 0) k1 = 0;
                    }
                if (ix[1] < 0) {
                    k2 = ix[1] + nc;
                    if (k2 < 0) k2 = 0;
                    }
                else {
                    k2 = ix[1] - nc;
                    if (k2 > 0) k2 = 0;
                    }
                rc = fx_take(dst, hi, k1, k2);
                }
        break;
        }
return rc;
}

fx_take(dst, src, nr, nc)
MATRIX dst;                     /* result */
MATRIX src;                     /* right argument */
int nr, nc;                     /* new size */
/*
        usage:  SIMILAR TO APL 'TAKE' OPERATION.

        Make |nr| x |nc| matrix from src.
        fill to top, bottom, left, right depending
        on signs of nr, nc.

*/
{
BYTE *t, *s = src->ADDR;
int dx = MTYPE(s);
int k;
int nrs, ncs;
int qh, qv;
if (dx != TYPT && dx != TYPN && dx != TYPD) return ERROR;
if (qv = (nr < 0)) nr = -nr;
if (qh = (nc < 0)) nc = -nc;
rho(src, &nrs, &ncs);
if (mkobj(dst, dx, nr*nc, nc)) return ERROR;
s   = src->ADDR + HDSIZE;
t   = dst->ADDR + HDSIZE;

        /* copy to the bottom */
if (qv && nr > nrs) t += nc * dx * (nr-nrs);
else    s += qv * dx * ncs * (nrs-nr);
        /* copy to right */
if (qh && nc > ncs)
        t += dx * (nc - ncs);
else    s += qh * dx * (ncs - nc);
        /* length of copy */
        k = (nc > ncs) ? ncs : nc;
if (nrs > nr) nrs = nr;         /* truncate */
for (; 0 < nrs--; t += nc * dx, s += ncs * dx)
        memcpy(t, s, k * dx);
return OK;
}

fx_format(dst, src)     /* numeric format */
MATRIX dst;             /* text           */
MATRIX src;             /* numeric | text */
{
BYTE   *s = src->ADDR;
int     n  = MSIZE(s);
int     nc = MCOLS(s);
int     fw;
if (n == 0) return(mkobj(dst, 'T', 0, 0));
else if (MTYPE(s) == TYPT) return  sasa(dst, src);
else if (MTYPE(s) == TYPD) return  xx_fmt(dst, NULL, src);
if (nc == 0) return ERROR;
else if (n == nc) return iv_fmt(dst, src, '_'); /* vector */
fw = 1 + fx_maxd(src);
return mkobj(dst, 'T', n * fw, nc * fw) ||
       iv_a(TEXT_PTR(dst), INT_PTR(src), fw, n);
}

fx_fmt(dst, fmt, src)   /* numeric format   */
MATRIX dst;             /* text             */
MATRIX fmt;             /* field specifier  */
MATRIX src;             /* numeric | text   */
{
BYTE   *s = src->ADDR;
int     n  = MSIZE(s);
int     nc = MCOLS(s);
int     nr, fw;
int    *ix;
struct  SDESC tt;
if (n == 0) return(mkobj(dst, 'T', 0, 0));
else if (MTYPE(s) == TYPT) return  sasa(dst, src);
else if (MTYPE(s) == TYPD) return  xx_fmt(dst, fmt, src);
if (nc == 0) return ERROR;
switch(MTYPE(fmt->ADDR)) {
    case TYPT:  /* apply format string to each row */
        fw = MSIZE(fmt->ADDR);
        nr = n / nc;
        if (mkobj(dst, 'T', nr * fw, fw)) return ERROR;
        tt.ADDR = TEXT_PTR(dst);
        tt.SDLEN = fw;
        for (ix =  INT_PTR(src); 0 < nr--; tt.ADDR += fw, ix+=nc) {
            memcpy(tt.ADDR, TEXT_PTR(fmt), fw);
            ss_using(&tt, ix);
            }
        return OK;
    case TYPN:  /* field length */
        ix = INT_PTR(fmt);
        fw = ix[0];
        return (mkobj(dst, 'T', n * fw, nc * fw) ||
        iv_a(TEXT_PTR(dst), INT_PTR(src), fw, n));
    }
return ERROR;
}

fx_maxd(src)    /* field length of integer vector */
MATRIX src;
{
int i;
int n  = MSIZE(src->ADDR);
int *ix= INT_PTR(src);
int xhi = MIN_INT;
int xlo = MAX_INT;
char s[20];
if (n == 0) return n;
for  (i = 0; i<n; i++, ix++) {
        if (xlo > *ix)  xlo = *ix;
        if (xhi < *ix)  xhi = *ix;
        }
xlo = ac_len(xlo);
xhi = ac_len(xhi);
return (xhi > xlo) ? xhi : xlo;
}

iv_fmt(dst, src, cminus)        /* format an integer vector */
MATRIX dst;             /* destination .. character string */
MATRIX src;             /* object of integer type */
BYTE cminus;            /* minus sign */
{
BYTE *s;
int n   = MSIZE(src->ADDR);
int *si = INT_PTR(src);
int     j, fw;
unsigned int nsize;
struct SDESC tt;

if (n == 0) return mkobj(dst, 'T', 0, 0);
/*      estimate size */
for (j = nsize = 0; j < n; j++, si++) nsize += 1 + ac_len(*si);
nsize--;        /* drop last blank */
if (mkobj(dst, 'T', nsize, nsize)) return ERROR;
tt.ADDR = TEXT_PTR(dst);
si = INT_PTR(src);
for(j = 0; j < n; j++, si++) {
        tt.SDLEN = fw  = ac_len(*si);
        ito_slice(&tt, *si);
        if (*si < 0) *tt.ADDR = cminus;
        tt.ADDR += fw+1;
        }
return OK;
}

ac_len(val)     /* ascii length */
int     val;
{
int     k = 0;
if (val == 0) return 1; /* digit '0' */
else if (val < 0) {
        k++;
        val = - val;
        }
for( ; val > 0; val = val/10) k++;
return k;
}

xx_fmt(dst, fmt, src)   /* special routine */
MATRIX  dst;
MATRIX  fmt;            /* format string, or NULL */
MATRIX  src;            /* should not be changed */
{
extern  int snprintf();
DOUBLE *x;
struct  SDESC tt;
MATRIX  tmp = &tt;
char   ufmt[FW_MAX+1];
BYTE   *t = src->ADDR;
int     n = MSIZE(t);
int     nc = MCOLS(t);
int     fw = 8;         /* for %8.3g */
int     pp = 3;
int     qf = 'G';       /* general */
int     c, j, k, m, qp, *ix;

NUL_STR(tmp);

if (nc == 0) return ERROR;

if (fmt != NULL) {
    k = MSIZE(fmt->ADDR);
    if (k == 0) qf = '*';       /* compress */
    else  switch (MTYPE(fmt->ADDR)) {
    case TYPN:  /* get integers width, precision */
        qf = 'F';
        ix = INT_PTR(fmt);
        fw = pp = ix[0];
        if (k > 1) pp = ix[1];
        break;
    case TYPT:  /* use a c-style string */
        if (n != nc) break;
        qf = 'U';
        if(k > FW_MAX) k = FW_MAX;
        memcpy(&ufmt[0], TEXT_PTR(fmt), k);
        ufmt[k] = 0;
        fw = FW_MAX;
        break;
    case TYPD:  /* could be ww.d for fixed format */
        k = (int) 10.0 * *DBL_PTR(fmt);
        fw = k / 10;
        pp = k % 10;
        break;
        }
    }
if (fw > FW_MAX) fw = FW_MAX;
m = n * (fw + 1);
if (mkobj(tmp, 'T', m, m)) return ERROR;
t = TEXT_PTR(tmp);
x = DBL_PTR(src);

/* user format of real vector */

if (qf == 'U') {
     for(nc = 0; 0 < n--; x++) {
         k = snprintf(xx_dst, fw, ufmt, *x);
         memcpy(t, xx_dst, k);
         nc += (k+1);
         t+=k;
        *t++ = ' ';     /* separate by blanks */
         }
    nc--;       /* drop last blank */
    if (mkobj(dst, 'T', nc, nc)) return ERROR;
    memcpy(TEXT_PTR(dst), TEXT_PTR(tmp), nc);
    return sasr(tmp);
    }

for (t = TEXT_PTR(tmp), x = DBL_PTR(src), j = n; 0 < j--; x++, t+=fw) {
    switch (qf) {
    default:
    case 'G':   /* general */
        sprintf(xx_dst, "%*.*g", fw, pp, *x);
        break;
    case 'F':   /* fixed */
        sprintf(xx_dst, "%*.*f", fw, pp, *x);
        if (pp == 0 && fw>1 && xx_dst[fw-1] == '0' && xx_dst[fw-2] == '-')
            xx_dst[fw-2] = ' ';
        break;
        }
    memcpy(t, xx_dst, fw);
    }

/*      trim dst */
if (mkobj(dst, 'T', n * fw, nc * fw)) return ERROR;
memcpy(TEXT_PTR(dst), TEXT_PTR(tmp), n * fw);
return sasr(tmp);
}


