/* stream file functions - changed putch() to vputch() oct 1995 */

#include <stdio.h>
#include <fcntl.h>
#include <na.h>

struct SDESC line_input(fd)     /* next line */
FILE *fd;                       /* opened descriptor */
{
BYTE   *memchr();
extern BYTE *linbuf;            /* data */
char   *s, *t;
struct  SDESC   tt;
int     k;
NUL_STR(&tt);
        s = fgets(linbuf, MAXLINE, fd);
        if (s == NULL) return(tt);
        else  tt.ADDR = (BYTE*) s;
        t = memchr(s, '\n', MAXLINE);
        k = (t == NULL) ? MAXLINE-1 : t - s;
        if (strlen(s) < k) k = strlen(s);
        tt.SDLEN = k;
        for (t = tt.ADDR + tt.SDLEN - 1; t >= s && *t == '\r'; t--)
                tt.SDLEN--;
        return(tt);
}

d_dlin1(ss)      /* write to console */
struct SDESC *ss;
{
BYTE *s = ss->ADDR;
int n =   ss->SDLEN;
while(0 < n--) vputch(*s++);
vputch(CR);
vputch(LF);
return OK;
}

sl_fget(dst, file)      /* get file text */
SLIST   dst;            /* part of linked list */
BYTE   *file;           /* file name */
{
FILE *fd;
SLIST tnow = dst;
struct SDESC tt;
SLIST sl_push();
if (NULL == dst || NULL == file) return ERROR;
if (NULL == (fd = fopen(file, "r"))) return ERROR;
while(tnow)  {
    tt = line_input(fd);
    if (NULL == tt.ADDR) break;
    tnow = sl_push(tnow, &tt);
    }
fclose(fd);
return (tnow) ? OK : ERROR;
}

sl_xget(dst, cmd)       /* get cmd text */
SLIST   dst;            /* part of linked list */
BYTE   *cmd;            /* cmd name */
{
struct SDESC line_input();
FILE *fd;
SLIST tnow = dst;
struct SDESC tt;
SLIST sl_push();
if (NULL == dst || NULL == cmd) return ERROR;
if (NULL == (fd = popen(cmd, "r"))) return ERROR;
while(tnow)  {
    tt = line_input(fd);
    if (NULL == tt.ADDR) break;
    tnow = sl_push(tnow, &tt);
    }
pclose(fd);
return (tnow) ? OK : ERROR;
}

sl_fput(src, file, ux)  /* write file text */
SLIST   src;            /* part of linked list */
BYTE   *file;           /* file name */
int     ux;             /* unix linefeed */
{
FILE   *fd;
SLIST   x = src;
BYTE   *s;
int     k;

if (NULL == src || NULL == file) return ERROR;
if (NULL == (fd = fopen(file, "w"))) return ERROR;
for(; x != NULL; x = S_NEXT(x))
    if (TYPLS == S_TYPE(x)) {
        for(s = S_TEXT(x), k = S_LEN(x); 0 < k--; s++) fputc(*s, fd);
        if (ux == 0) fputc('\r', fd);
        fputc('\n', fd);  /* line feed */
        }
fclose(fd);
return  OK;
}

sl_xput(src, cmd, ux)   /* pipe text to command */
SLIST   src;            /* part of linked list */
BYTE   *cmd;            /* command name */
int     ux;             /* unix linefeed */
{
FILE   *fd;
SLIST   x = src;
BYTE   *s;
int     k;

if (NULL == src || NULL == cmd) return ERROR;
if (NULL == (fd = popen(cmd, "w"))) return ERROR;
for(; x != NULL; x = S_NEXT(x))
    if (TYPLS == S_TYPE(x)) {
        for(s = S_TEXT(x), k = S_LEN(x); 0 < k--; s++) fputc(*s, fd);
        if (ux == 0) fputc('\r', fd);
        fputc('\n', fd);  /* line feed */
        }
pclose(fd);
return  OK;
}

inlin(xx)       /* line input -- create line */
MATRIX xx;      /* result */
{
struct SDESC tt;
tt = line_input(stdin);
mk_sk(xx, TYPT, &tt);
return (tt.ADDR == NULL) ? ERROR : tt.SDLEN;
}

#ifndef OBJ_TRACE

d_naprint(src)  /* print nested array */
MATRIX src;     /* object */
{
struct SDESC xx;
BYTE   *s = src->ADDR;
int     n = MSIZE(s);
int     nc = MCOLS(s);
int     nr;
if (s == NULL || MTYPE(s) != TYPT) return ERROR;
else if (n == 0) return OK;

for(nr = n/nc, xx.ADDR = TEXT_PTR(src), xx.SDLEN = nc; nr--; xx.ADDR += nc)
    d_dlin1(&xx);
return OK;
}

#else

sl_print(src)   /* print link lists */
SLIST src;      /* head */
{
struct SDESC tt;
SLIST x;
int  rc = OK;
BYTE k;
if (src == NULL) return(ERROR);
k = S_TYPE(src);
if (k != TYPLB && k!= TYPLS)
        return(ERROR);
for(x = src; rc == OK && x != NULL; x = S_NEXT(x)) {
        k = S_TYPE(x);
        switch(k) {
        case TYPLS:     /* slice */
                tt.ADDR = S_TEXT(x);
                tt.SDLEN = S_LEN(x);
                d_dlin1(&tt);
                break;
        case TYPLB:     break;
        default:        /* error */
                rc = ERROR;
                break;
                }
        }
return(rc);
}

d_naprint(src)  /* print nested array */
MATRIX src;     /* object */
/*              print CR LF at end of each line */
{
struct SDESC xx;
MATRIX  t;
SLIST   tmp;
BYTE   *s;
BYTE    kt;
int     rc = 0;
int     n, nr, nc;
int    *ix;
if (NULL == src || NULL == (s = src->ADDR)) return(rc);
kt = MTYPE(s);
n  = rho(src, &nr, &nc);
switch(kt) {
        case TYPF:      /* op-code */
                cprintf("F: %2.2X %c %4.4d\r\n", kt, MELSIZ(s), MINDX(s));
                rc = OK;
                break;
        case TYPT:      /* text -- vector (nr=1) or matrix (nr >1 ) */
        if (n == 0) break;
        for(xx.ADDR = TEXT_PTR(src), xx.SDLEN = nc; nr--; xx.ADDR += nc)
                rc |= d_dlin1(&xx);
                break;
        case TYPI:      /* symbol */
                xx.ADDR = TEXT_PTR(src);
                xx.SDLEN = MSIZE(s);
                rc = d_dlin1(&xx);
                break;
        case TYPN:      /* int */
                for (ix = INT_PTR(src); n > 0; n--, ix++)
                        cprintf("%d ", *ix);
                cprintf("\r\n");
                rc = OK;
                break;
        case TYPA:                 /* descriptor */
                for (t = NA_PTR(src); rc == 0 && 0 < n--; t++)
                        rc |= d_naprint(t);
                break;
        case TYPR:              /* raw slices */
                for (t = NA_PTR(src); rc == 0 && 0 < n--; t++)
                        rc |= d_dlin1(t);
                break;
        case TYPL:              /* linked list of slices */
                for(tmp = LINK_PTR(src); rc == 0 && 0 < n--; tmp++)
                        rc |= sl_print(tmp);
                break;
        case TYPLB:             /* base or root */
        case TYPLS:             /* slice of list */
                        rc = sl_print(src);
                break;
        default:        rc = ERROR;     /* should not be here */
                break;
        }
return(rc);
}

#endif

#ifdef D4_DSYM

d_symbols(tab)  /* print a symbol table */
MATRIX tab;
{
MATRIX  p, q;
BYTE   *t;
int     j, k, n, nr, nc;
if (tab == NULL || NULL == tab->ADDR)
        return OK;
p = NA_PTR(tab);
n = rho(tab, &nr, &nc);
if (nr != 2) return (d_naprint(tab));
for(j = 0; j < nc; p++, j++) {
        if (p->ADDR == NULL) continue;
        t = (p+nc)->ADDR;
        k = (t == NULL) ? 0XFF : MTYPE((p+nc)->ADDR);
        cprintf("# %2.2X  <%.*s>\r\n", k, p->SDLEN-HDSIZE, p->ADDR+HDSIZE);
        switch(k) {
                case TYPT:
                case TYPN:
                case TYPD:
                        d_naprint(p+nc);
                        break;
                case TYPA:
                        if (MELSIZ(t) != 'U') {
                                d_naprint(p+nc);
                                break;
                                }
                        q = NA_PTR(p+nc);
                        d_naprint(q);
                        lex_trace(q+1);
                        break;
                default:
                        cprintf("Bad type\r\n");
                        break;
                }
        }       /* next j, p */
return OK;
}

#endif
