/*      MM_SLICE.C Memory management */

#include <na.h>

extern int qt;
int mm_cnt_alloc = 0;
int mm_cnt_free  = 0;

mkstr(HL, size, val)    /* fill descriptor */
SLICE HL;               /* pointer to result */
unsigned int size;      /* number of bytes.*/
char val;               /* set to value */
{
extern BYTE *malloc();
if (HL == NULL) return mm_dserror("mkstr");
if (HL->SDLEN == 0) HL->ADDR = NULL;
if (NULL != HL->ADDR) sasr(HL);
if (size == 0) return OK;

        /* statistics */
HL->ADDR = malloc(size);
if (NULL == HL->ADDR) return mm_dserror("mkstr size");
mm_cnt_alloc++;
HL->SDLEN = size;
if (size) memset(HL->ADDR, val, size);
return OK;
}

sasa(HL,DE)     /* string store :warning:: HL should be ssvar,not ssa */
SLICE HL;       /* destination */
SLICE DE;       /* source */
{
extern BYTE *malloc();
if (HL == NULL || DE == NULL) return mm_dserror("sasa");
if (HL == DE) return OK;        /* do nothing */
if (HL->SDLEN == 0) HL->ADDR = NULL;
if (NULL != HL->ADDR) sasr(HL);
if (0 == DE->SDLEN) {
        HL->ADDR  = DE->ADDR;
        HL->SDLEN = 0;
        }
else {
        if(NULL == (HL->ADDR = malloc(DE->SDLEN)))
        return mm_dserror("sasa copy");
        memcpy(HL->ADDR, DE->ADDR, HL->SDLEN = DE->SDLEN);
        mm_cnt_alloc++;
        }
return OK;
}

sasr(HL)        /* HL$="" Restore space */
SLICE HL;
{
if (HL == NULL) return mm_dserror("sasr");
if (0 == HL->SDLEN) HL->ADDR = NULL;
if (NULL != HL->ADDR) {
        free(HL->ADDR);
        HL->ADDR = NULL;
        HL->SDLEN=0;
        mm_cnt_free++;
        }
return OK;
}

sasm(xx, yy)            /* xx <- yy; yy<- NULL,0 */
MATRIX xx;
MATRIX yy;
{
if (xx == NULL || yy == NULL) return (ERROR);
if (xx == yy) return (OK);
if (sasr(xx)) return (ERROR);
xx->ADDR  = yy->ADDR;
xx->SDLEN = yy->SDLEN;
yy->ADDR  = NULL;
yy->SDLEN = 0;
return (OK);
}

sa_swap(xx, yy) /* swap descriptors */
SLICE xx, yy;
{
struct SDESC tmp;
if (xx == NULL || yy == NULL)
        return(ERROR);
tmp = *xx;
*xx = *yy;
*yy = tmp;
return (OK);
}

mkobj(dst, type, size, cols)    /* Make object */
MATRIX  dst;                    /* Destination */
BYTE    type;                   /* Type T|N|S|D|P|F */
unsigned int    size, cols;     /* Dimension */
{
int     j = sizeof(BYTE);
int     val = 0;
int     k;
BYTE    c = 0;
BYTE   *t;
SLBASE  tp;
switch (type) {
    default:
        return ERROR;
        break;
    case TYPI:
    case 'I': k = TYPI;  /* name */
        val = ' ';
        break;
    case TYPT:
    case 'T' : k = TYPT; /* text */
        val = ' ';
        break;
    case TYPN:
    case 'N' : k = TYPN; /* numeric - integer */
        j = sizeof(int);
        break;
    case TYPD:
    case 'D' : k = TYPD; /* double */
        j = sizeof(double);
        break;
    case TYPA:
    case 'A' : k = TYPA;    /* table */
        j = sizeof(struct SDESC);
        break;
    case TYPF:
    case 'F' : k = TYPF;    /* function, or marker */
        c = size;
        j = size = 0;
        break;
    case TYPL:
    case 'L' : k = TYPL;    /* array of linked lists */
        j = sizeof(struct SL_BASE);
        break;
    case TYPWW:
    case 'W'  : k = TYPWW;      /* window */
        j = sizeof(WINDOW);
        c = 0;
        cols = size = 1;
        break;
        }

/* Zero | space fill string */

val = (k == TYPT) ? ' ' : 0;
if (sys_del(dst) || mkstr(dst, HDSIZE + j * size, val))
    return ERROR;
t = dst->ADDR;
MTYPE(t)  = k;
MELSIZ(t) = c;
MSIZE(t)  = size;
MINDX(t)  = 0;
MCOLS(t)  = cols;
if (k == TYPL)
    for(tp = LINK_PTR(dst); 0 < size--; tp++) {
        S_TYPE(tp) = TYPLB;
        S_LC(tp)   = -1;
        }
return OK;
}

mk_tabs(dst, num, size)
MATRIX  dst;            /* Destination */
int     num;            /* number of elements */
int size;               /* structure size */
{
return(mkobj(dst, 'T', num * size, size));
}

SLIST   sl_push(dst, src) /* insert slice _after_ dst */
SLIST   dst;    /* location in chain */
SLICE   src;    /* slice */
{
extern BYTE *malloc();
SLIST   x, next;
BYTE    k;
if (dst == NULL) return NULL;
k = S_TYPE(dst);
if (k != TYPLB && k != TYPLS) return NULL;
x = (SLIST) malloc(S_SIZE + src->SDLEN);
if (x == NULL) return NULL;
mm_cnt_alloc++;
next = S_NEXT(dst);
S_TYPE(x) = TYPLS;
S_NEXT(x) = next;
S_PREV(x) = dst;
S_LEN(x)  = src->SDLEN;
if (src->SDLEN) memcpy(S_TEXT(x), src->ADDR, src->SDLEN);
S_NEXT(dst) = x;
if (next != NULL) S_PREV(next) = x;     /* relink end of chain */
return x;
}

SLIST sl_replace(dst, src) /* replace item in linked list */
SLIST dst;      /* item chain */
SLICE src;      /* slice */
{
extern BYTE *malloc();
SLIST   x, last, next;
if (dst == NULL || S_TYPE(dst) != TYPLS) return NULL;
last = S_PREV(dst);
next = S_NEXT(dst);
x = (SLIST) malloc(S_SIZE + src->SDLEN);
if (x == NULL) return NULL;
free (dst);     /* balance alloc and free count */
S_TYPE(x) = TYPLS;      /* re-link everything */
S_LEN(x)  = src->SDLEN;
S_PREV(x) = last;       /* should not be NULL */
S_NEXT(x) = next;
S_NEXT(last) = x;
if (next != NULL) S_PREV(next) = x;
if (src->SDLEN) memcpy(S_TEXT(x), src->ADDR, src->SDLEN);
return x;
}

SLIST   sl_xs(x)        /* delete a line */
SLIST   x;
{
SLIST   next, prev;

if (S_TYPE(x) == TYPLB) return x;
prev = S_PREV(x);
next = S_NEXT(x);
S_NEXT(prev) = next;
if (next != NULL) S_PREV(next) = prev;
free((char*) x);
mm_cnt_free++;
return prev;
}

sys_del(src)    /* tree delete routine */
MATRIX  src;    /* nested array */
{
MATRIX  t;
SLBASE  tp;
BYTE   *s;
int     rc = 0;
int     n, k;
if (src == NULL) return OK;
else if (NULL == (s = src->ADDR)) {
    src->SDLEN = 0;
    return OK;
    }
n   = MSIZE(s);
k   = MTYPE(s);
if (TYP_MDESC == (k & TYP_MDESC)) switch(k) {
    case TYPA:  /* nested array */
        for(t = NA_PTR(src); rc == 0 && 0 < n--; t++) rc |= sys_del(t);
        break;
    case TYPL:  /* linked list of slices */
        for(tp = LINK_PTR(src); rc == 0 && 0 < n--; tp++)
            rc |= sl_del(tp);
        break;
    default:  rc = ERROR;   /* should not be here */
        break;
    }
return (rc || sasr(src));
}

sl_del(src)     /* delete tail of linked list */
SLIST   src;    /* current item, possibly base */
{
SLIST   x;

if (src == NULL) return ERROR;
x  = src;
src = S_NEXT(x);
if      (S_TYPE(x) == TYPLB) S_LC(x) = -1;
else if (S_TYPE(x) != TYPLS) return ERROR;

S_NEXT(x) = NULL;

while (src != NULL) {
    x = src;
    src = S_NEXT(x);
    if (S_TYPE(x) == TYPLS) {
        free((char*) x);
        mm_cnt_free++;
        }
    else return ERROR;
    }
return OK;
}

mm_dserror(msg)     /* Trace message */
char *msg;          /* name */
{
    if (qt) printf ("NULL object: %s\r\n", msg);
return ERROR;
}

mm_stat()
{
printf("strings = %5d free count = %5d\r\n", mm_cnt_alloc, mm_cnt_free);
return OK;
}
