/*      MMSYM.C          Symbol table and stack */

#include <na.h>

#define DT_BLKDATA
#include <dt.h>

MATRIX na_idx(src, idx)
MATRIX src;
int idx;
/*
        return pointer in nested array, after validation.
        idx >= 0      set index
        idx == ERROR  => get index

*/
{
BYTE *s  = src->ADDR;
int n    = MSIZE(s);
int k    = MTYPE(s);
MATRIX p = NA_PTR(src);
if (s == NULL || k != TYPA) return NULL;
if (idx == ERROR)
        return (p + MINDX(s));
else if (idx < 0 || idx >= n) return NULL;
MINDX(s) = idx;
return (p+idx);
}

na_resize(tab, nsym)    /* re-size a hash table */
MATRIX  tab;
int     nsym;
{
MATRIX  p, pv, q;
struct  SDESC ss;
int     nc = MCOLS(tab->ADDR);
int     j;

if (nc == nsym) return OK;      /* do nothing */
ss.ADDR  = NULL;
ss.SDLEN = 0;

mkobj(&ss, 'A', 2*nsym, nsym);

for (p = NA_PTR(tab), pv = p+nc, j = nc; 0 < j--; p++, pv++)
    if (p->ADDR != NULL) {
        if (NULL == (q = sys_nput(&ss, p))) return ERROR;
        q += nsym;
        q->ADDR = pv->ADDR;
        pv->ADDR = NULL;
        q->SDLEN = pv->SDLEN;
        pv->SDLEN = 0;
        }

sys_del(tab);
tab->ADDR  = ss.ADDR;
tab->SDLEN = ss.SDLEN;
return OK;
}

ht_scan(tab, xx)        /* Search symbol table */
MATRIX  tab;            /* names -- text items */
SLICE   xx;             /* symbol */
{
BYTE   *s  = tab->ADDR;
BYTE   *t  = xx->ADDR;
int     nc = MCOLS(s);
int     n  = xx->SDLEN;
MATRIX  p;
int     rc, cnt;
if (s == NULL || MTYPE(s) != TYPA) return ERROR;

for (rc = 0; 0 < n--; t++) rc += (17*rc + *t);
rc = (rc & MAX_INT) % nc;
n  = xx->SDLEN;

for (cnt = 0; cnt < nc; cnt++, rc++) {
    if (rc == nc) rc = 0;       /* wrap round */
    p = NA_PTR(tab) + rc;
    if (NULL == (t = p->ADDR) ||
        (MSIZE(t) == n &&
         0 == memcmp(TEXT_PTR(p), xx->ADDR, n)))
        break;
    }
if (cnt == nc) return ERROR;

MINDX(tab->ADDR) = rc;
return rc;
}

MATRIX sys_hput(dst, name)      /* put symbol in table */
MATRIX dst;     /* symbol table */
SLICE name;     /* name as slice */
{
BYTE   *s = dst->ADDR;
MATRIX  p;
int     rc;

rc = ht_scan(dst, name);
if (rc == ERROR) return NULL;
p = NA_PTR(dst) + rc;
if (p->ADDR == NULL)  mk_sk(p, TYPI, name);
return p;
}

MATRIX sys_nput(dst, src)
MATRIX dst;     /* the table */
MATRIX src;     /* the name */
{
MATRIX p;
struct SDESC nn;
int rc;

MID_STR(&nn, src, HDSIZE);              /* the text */
rc = ht_scan(dst, &nn);
if (rc == ERROR) return NULL;
p = NA_PTR(dst) + rc;
if (p->ADDR == NULL) sasa(p, src);      /* copy */
return p;                               /* table location */
}

MATRIX  sys_vget(tab, name)     /* symbol in table */
MATRIX  tab;    /* table */
SLICE   name;   /* the name */
{
MATRIX  p;
int     rc = ht_scan(tab, name);

if (rc == ERROR) return NULL;
p = NA_PTR(tab) + rc;
if (p->ADDR == NULL) return NULL;
return p + MCOLS(tab->ADDR);    /* variable */
}

MATRIX  sys_nget(tab, src)      /* p <- value [$src] */
MATRIX  tab;    /* table */
MATRIX  src;    /* name as a matrix */
{
struct  SDESC nn;
MATRIX  p;
int     rc;

MID_STR(&nn, src, HDSIZE);      /* the text */
rc = ht_scan(tab, &nn);
if (rc == ERROR) return NULL;
p = NA_PTR(tab) + rc;
if (p->ADDR == NULL) return NULL;
return p + MCOLS(tab->ADDR);    /* variable */
}

/*
        add string to table
*/

MATRIX  sys_text(tab, s)
MATRIX  tab;    /* the table */
BYTE   *s;      /* name ASCIZ string */
{
MATRIX  p = NA_PTR(tab);
BYTE   *t = tab->ADDR;
int rc;
struct SDESC tt;

tt.ADDR = s;
tt.SDLEN = strlen(s);
rc = ht_scan(tab, &tt);
if (rc == ERROR) return NULL;
p = NA_PTR(tab) + rc;
if (p->ADDR == NULL) return NULL;
p += MCOLS(tab->ADDR);
return (NULL != p->ADDR) ? p : NULL;
}

/*      NLIST.C      Symbol table */

fx_nlist(dst, lo, hi)   /* name list */
MATRIX dst;     /* table */
MATRIX lo;      /* not used */
MATRIX hi;      /* types to match */
{
extern  SLIST sl_push();
SLIST   t;
BYTE   *s;
MATRIX  p;
struct  SDESC name;
int     nsym = MCOLS(pm_sym->ADDR);
int     fc, j, rc;

if (hi == NULL) {       /* all names */
    rc = use_nlist(dst+1, pm_sym) ||
         sstomat(dst, NULL, dst+1) ||
         sasr(dst+1);
    return rc;
    }

/*      filter names according to desired type */

if (mkobj(dst, 'L', 1, 1)) return ERROR;
t = (SLIST)LINK_PTR(dst);

for (p = NA_PTR(pm_sym), j = nsym; 0 < j--; p++) {
    if (NULL == p->ADDR) continue;
    s = (p + nsym)->ADDR;               /* check type */
    if (s == NULL) fc = 'V';
    else switch (MTYPE(s)) {
    case TYPA:   /* general array or function */
        fc = (MELSIZ(s) == TYPU) ? 'F' : 'A';
        break;
    case TYPT:  /* text */
        fc = 'T';
        break;
    case TYPN:  /* integer */
        fc = 'N';
        break;
    case TYPD:  /* double */
        fc = 'D';
        break;
    default:    /* should not happen */
        fc = '?';
        break;
        }
    if (memchr(TEXT_PTR(hi), fc, MSIZE(hi->ADDR))) {
        name.ADDR =  TEXT_PTR(p);       /* push symbol */
        name.SDLEN = MSIZE(p->ADDR);
        t = sl_push(t, &name);
        }
    }
rc = sl_cat('M', dst+1, S_NEXT(LINK_PTR(dst)), NULL) ||
     sys_del(dst) ||
     sasm(dst, dst+1);
return rc;
}

sys_copy(dst, fn)
MATRIX  dst;    /* copy set of functions and variables */
char   *fn;     /* asciz file name */
{
extern  char   *malloc();
extern  int     d4_stat();
extern  MATRIX  sys_text();
extern  MATRIX  pm_sym;
extern  int     qt;
MATRIX  libpath = sys_text(pm_sym, "D4LIB_PATH");       /* library */
int     rc, np, ns;
char   *fp = NULL, *p;
if (0 == d4_stat(fn) && libpath != NULL) {         /* try and get from library directory */
     np = MSIZE(libpath->ADDR);
     ns = strlen(fn);
     fp = malloc(1+ np + ns);
     memcpy(fp, TEXT_PTR(libpath), np);
     memcpy(fp + np, fn, ns);
     fp[np+ns] = 0;
     fn = fp;
     }
rc = mkobj(dst, 'A', 20, 20) ||         /* temporary stack */
     na_fload(fn, pm_sym, dst);
if (fp) free (fp);
return mkik(dst, rc);
}

MATRIX  sys_nlink(tab, name, src, n)
MATRIX  tab;
BYTE   *name;   /* string such as "_UFILE"  */
BYTE   *src;    /* text */
int     n;      /* character count */
{
MATRIX sys_hput();
MATRIX  p;
struct  SDESC tt;

tt.ADDR  = name;
tt.SDLEN = strlen(name);
p = sys_hput(tab, &tt);
if (p == NULL) return NULL;
p += MCOLS(tab->ADDR);
mkobj(p, 'T', n, n);
if (src && n > 0) memcpy(TEXT_PTR(p), src, n);
return p;
}

MATRIX  sys_alink(tab, name, n, nc)
MATRIX  tab;
BYTE   *name;   /* string such as "$STACK"  */
int     n, nc; /* table size */
{
MATRIX sys_hput();
MATRIX  p;
struct  SDESC tt;
int     fc = (n) ? 0: nc;

tt.ADDR  = name;
tt.SDLEN = strlen(name);
p = sys_hput(tab, &tt);
if (p == NULL) return NULL;
p += MCOLS(tab->ADDR);
if (mkobj(p, 'A', n * nc, nc)) return NULL;
if (fc)     {
    MELSIZ(p->ADDR) = 'T';
    MINDX(p->ADDR) = fc;
    }
return p;
}

ifdef(MATRIX dst, MATRIX def, MATRIX src)
{
MATRIX  sys_nget();
MATRIX  p = sys_nget(pm_sym, src);
if (p && p->ADDR)
       return (TYPA == MTYPE(p->ADDR)) ? mkik(dst, *((int*)(p->ADDR)))
                                       : sasa(dst, p);
else   return (def) ? sasa(dst, def)   : mkobj(dst, 'T', 0, 0);
}


