/*      nested array routines */

#include <na.h>

/*  RHO       */

rho(z, nr, nc)  /* dimensions of matrix */
MATRIX z;
int *nr, *nc;   /* rows, columns */
{
int k, n;
BYTE *ip;
*nr = *nc = 0;
if (z == NULL || NULL == (ip = z->ADDR))
        return (0);
k = *nc =MCOLS(ip);
if (k==0) return (0);
*nr = (n = MSIZE(ip))/ k;
return (n);
}

/*      MKIK.C */

mkik(dst, val)          /* Make integer value */
MATRIX dst;             /* object */
int val;                /* value */
/*      Usage:
        A<- 5
        mkik(A,5);
*/
{
int rc, *iy;
if (OK == (rc = mkobj(dst, 'N', 1, 1))) {
        iy = INT_PTR(dst);      /* start of data */
        *iy = val;              /* set value */
        }
return (rc);
}

/*      MKSK.C  */

mk_sk(dst, type, val)   /* make string */
MATRIX dst;             /* object */
int type;               /* TYPT or TYPI */
SLICE val;              /* a slice */
{
int n, rc;
if (val == NULL || NULL == val->ADDR ) n = 0;
else n = val->SDLEN;
rc = mkobj(dst, type, n, n);
if (rc == OK || n > 0) memcpy(TEXT_PTR(dst), val->ADDR, n);
return(rc);
}

/*      MKIXY.C */

mkixy(dst, nr, nc)      /* Make (i:j) pairs */
MATRIX dst;             /* object */
int nr, nc;             /* shape */
/*      Usage:
        I<-i N,M gives 2 x N x M matrix for cartesian product
*/
{
int *iy;
int i, j, k1, k2;
mkobj(dst, 'N', nr*nc*2, 2);    /* integer matrix */
iy = INT_PTR(dst);              /* start of data */
    for(i = 0, k1 = 0; i<nr; i++, k1++)
        for(j = 0, k2 = 0; j<nc; j++, k2++) {
                        *iy++ = k1;
                        *iy++ = k2;
                        }
return OK;
}

/* searching operations */
 
fx_find(dst, key, src)  /* string search */
MATRIX dst;     /* result -- 0 1 matrix */
MATRIX key;     /* characters to find */
MATRIX src;     /* data to scan  */
{
BYTE   *s, *t, *z;
int    *di, i, j, k, fw, n, nr, nc;
int     dx;     /* element size */
if     (src  == NULL ||
        NULL == (s = src->ADDR) ||
        0    == (n = MSIZE(s)))
        return mkobj(dst, 'N', 0, 0);
if(0 == (nc = MCOLS(s))) return ERROR;
nr = n / nc;
dx = MTYPE(s);  /* should be 1 or 2 */
if (mkobj(dst, 'N', n, nc)) return ERROR;       /* result */
di = INT_PTR(dst);
if (key == NULL || NULL == (t = key->ADDR)) return ERROR;
fw = MSIZE(t);
if (MTYPE(s) != MTYPE(t) || fw > nc) return OK; /* all zero */
else if (fw == 0)
        for (j = 0; j < n; j++, di++) *di = 1;
else {
        t  = TEXT_PTR(key);  k = *t;
        s  = TEXT_PTR(src);     /* use byte compare for strings */
        for (i = 0; i < nr; i++, di += nc, s += nc * dx)
        for(z = s, j = 0; j < nc-fw+1; j++, z += dx)
                if (k == *z && 0 == memcmp(z, t, dx * fw))
                    di[j] = 1;
        }
return OK;
}

/* indices which sort. I<- #sort X gives permutation.    *
 * I and #sort I will then be inverse permutations.      *
 * This would give a fast algorithm in special cases     */

fx_rank(dst, src)       /* grade up. Slowest algorithm */
MATRIX  dst;
MATRIX  src;
{
BYTE   *s = src->ADDR;
int     n  = MSIZE(s);
int     rc, nc, nr;
switch(MTYPE(s)) {
    case TYPN:      /* integer */
        rc = mkobj(dst, 'N', n, n) ||
        ix_rank(INT_PTR(dst), INT_PTR(src), n);
        break;
    case TYPD:      /* double  */
        rc = mkobj(dst, 'N', n, n) ||
        zx_rank(INT_PTR(dst), DBL_PTR(src), n);
        break;
    case TYPT:
        if (0 == (nc = MCOLS(s))) return OK;
        nr = n / nc;
        rc = mkobj(dst, 'N', nr, nr) ||
        txt_rank(INT_PTR(dst), TEXT_PTR(src), nr, nc);
        break;
        default: rc = ERROR;
                }
return rc;
}

txt_rank(di, s, n, fw)
int    *di;     /* destination */
BYTE   *s;      /* words to rank */
int     n;      /* number of items */
int     fw;     /* field width */
{
int     a, b, i, j, k;
BYTE   *x;
for (x = s, i = 0; i < n; i++, x += fw) {
    if (i == 0) j = i;          /* start */
    else {                      /* insert in list si[di[0]], si[di[1]].. */
        a = 0; b = i-1;
        if      (0 > memcmp(x, s + fw * di[a], fw)) j = a;
        else if (0 > memcmp(s + fw * di[b], x, fw)) j = b+1;
        else {
            for (j = (a+b)/2; j > a; j=(a+b)/2)
                if (0 < memcmp(x, s + fw * di[j], fw)) a = j;
                else                                   b = j;
            if (0 < memcmp(x, s + fw * di[j], fw)) j++;
            }
        }
    for (k = i; k > j; k--) di[k] = di[k-1];
    di[j] = i;
    }
return OK;
}

ix_rank(di, si, n)
int    *di;     /* destination */
int    *si;     /* integers to rank */
int     n;      /* length */
{
int     a, b, i, j, k, x;
for (i = 0; i < n; i++) {
    if (i == 0) j = i;          /* start */
    else {                      /* insert in list si[di[0]], si[di[1]].. */
        x = si[i]; a = 0; b = i-1;
        if      (x < si[di[a]]) j = a;
        else if (si[di[b]] < x) j = b+1;
        else {
            for (j = (a+b)/2; j > a; j=(a+b)/2)
                if (x > si[di[j]]) a = j;
                else               b = j;
            if (x > si[di[j]]) j++;
            }
        }
    for (k = i; k > j; k--) di[k] = di[k-1];
    di[j] = i;
    }
return OK;
}

zx_rank(di, si, n)
int    *di;     /* destination */
DOUBLE *si;     /* values to rank */
int     n;      /* length */
{
int     a, b, i, j, k;
DOUBLE  x;
for (i = 0; i < n; i++, x++) {
    if (i == 0) j = i;          /* start */
    else {                      /* insert in list si[di[0]], si[di[1]].. */
        x = si[i]; a = 0; b = i-1;
        if      (x < si[di[a]]) j = a;
        else if (si[di[b]] < x) j = b+1;
        else {
            for (j = (a+b)/2; j > a; j=(a+b)/2)
                if (x > si[di[j]]) a = j;
                else               b = j;
            if (x > si[di[j]]) j++;
            }
        }
    for (k = i; k > j; k--) di[k] = di[k-1];
    di[j] = i;
    }
return OK;
}

/*      Search and set membership */

fx_iota(dst, src, cc)  /* search */
MATRIX  dst;     /* result -- 0 origin indices */
MATRIX  src;     /* data to scan  */
MATRIX  cc;      /* characters / numbers to find */
{
extern BYTE* memchr();
BYTE   *s  = src->ADDR;
int     nx = MSIZE(s);
BYTE   *t  = cc->ADDR;
int     ny = MSIZE(t);
BYTE   *v;
int    *di, *yi;
DOUBLE *ys;

if (MTYPE(s) != MTYPE(t)) return ERROR;
if (mkobj(dst, 'N', ny, MCOLS(t))) return ERROR;
if (nx == 0) return OK;

di = INT_PTR(dst);
if (MTYPE(s) == TYPT)   /* index set - characters only */
    for (s = TEXT_PTR(src), t = TEXT_PTR(cc); 0 < ny--; t++, di++) {
        v = memchr(s, *t, nx);
        if (v != NULL)  *di = v - s;    /* found */
        else            *di = nx;       /* not found */
        }
else if (MTYPE(s) == TYPN)
    for (yi = INT_PTR(cc); 0 < ny--; di++, yi++)
        *di = int_scan(INT_PTR(src), *yi, nx);
else if (MTYPE(s) == TYPD)
    for (ys = DBL_PTR(cc); 0 < ny--; di++, ys++)
        *di = dbl_scan(DBL_PTR(src), *ys, nx);
else    return ERROR;
return OK;
}

int_scan(src, val, cnt)
int    *src;    /* place */
int     val;    /* scan for this */
int     cnt;    /* search length */
{
int    *si = src;
int     j;
for (j = 0; j < cnt; j++, si++)
        if (val == *si) break;
return j;
}

dbl_scan(src, val, cnt)
DOUBLE *src;    /* place */
DOUBLE  val;    /* scan for this */
int     cnt;    /* search length */
{
DOUBLE *zi = src;
int     j;
for (j = 0; j < cnt; j++, zi++)
        if (val == *zi) break;
return j;
}

fx_member(dst, lo, hi)  /* elements of lo in hi */
MATRIX dst;             /* result - 0 1 vector */
MATRIX lo;              /* find these */
MATRIX hi;              /* in this */
{
int rc;
int    *ix, n, nc;
if (rc = fx_iota(dst, hi, lo))
        return rc;
nc = MSIZE(hi->ADDR);   /* logicise in situ */
for (ix = INT_PTR(dst), n = MSIZE(dst->ADDR); 0 < n--; ix++)
        *ix = (nc != *ix);
return rc;
}

#define FN_MAX  128

fx_split(dst, fs, src)  /* split a line */
MATRIX  dst;    /* number of fields */
MATRIX  fs;     /* field seperator */
MATRIX  src;    /* ASCII text */
{
extern  MATRIX  pm_sym;
extern  char *lx_ctype;
MATRIX  sys_nlink();
BYTE   *mk_sname();
struct  SDESC   tt;
MATRIX  p;
BYTE    name[6];
BYTE   *s, *t, *fn;
int     n  = MSIZE(src->ADDR);
int     cnt, qs;
int     sep = ' ';
int     ntok;

if(MTYPE(src->ADDR) != TYPT) return ERROR;

if (fs != NULL &&
    MTYPE(fs->ADDR) == TYPT &&
    MSIZE(fs->ADDR) == 1)
        sep = *(TEXT_PTR(fs));

s = TEXT_PTR(src);
ntok = qs = 0;

if (sep == ' ') {       /* white space */
    for (; 0 < n-- && ntok < FN_MAX; s++)
        switch(2 * qs + (lx_ctype[*s] != '@')) {
        case 1: t = s;
            cnt = 1;
            qs = 1;
            break;
        case 3: cnt++;
            break;
        case 2: qs = 0;       /* end of token */
            fn = mk_sname(&name[0], ntok);
            p = sys_nlink(pm_sym, fn, t, cnt);
            ntok++;
        default: break;
        }
    if (qs) {
        fn = mk_sname(&name[0], ntok);
        p = sys_nlink(pm_sym, fn, t, cnt);
        ntok++;
        }
    }
else {  /* use field seperator */
    for (t = s, cnt = 0; 0 < n-- && ntok < FN_MAX; s++)
        if (*s == sep) {
            fn = mk_sname(&name[0], ntok);
            p = sys_nlink(pm_sym, fn, t, cnt);
            ntok++;
            cnt = 0;
            }
        else {  /* not a seperator */
            if (cnt == 0) t = s;
            cnt++;
            }
    fn = mk_sname(&name[0], ntok);
    p = sys_nlink(pm_sym, fn, t, cnt);
    ntok++;
    }
return mkik(dst, ntok);
}

BYTE   *mk_sname(dst, val)      /* make names $0, $1, ... etc */
BYTE   *dst;
int     val;
{
BYTE   *s = dst + 6;
*s-- = 0;
if (val == 0) *s-- = '0';       /* convert val to decimal */
else for (; val > 0; s--) {
    *s = (val%10) + '0';
    val = val/10;
    }
*s = '$';
return  s;
}

na_catstr(dst, idx)     /* dst <- $$[idx] .. $(i[0]), $(i[1]) .. */
MATRIX  dst;
MATRIX  idx;
{
extern  MATRIX  pm_sym;
BYTE   *mk_sname();
MATRIX  sys_text();
MATRIX  ofs = sys_text(pm_sym, "$OFS");
MATRIX  p;
BYTE    name[16];
BYTE   *s, *t;
int     ntok = MSIZE(idx->ADDR);
int    *ix = INT_PTR(idx);
int     i, n, cnt;
int     sep = (ofs) ? *(TEXT_PTR(ofs)) : ' ';
int     qsep = 1;

if (ofs && MSIZE(ofs->ADDR) == 0) qsep = 0;

for (cnt = 0, i = ntok; 0 < i--; ix++) {
     s = mk_sname(&name[0], *ix);
     p = sys_text(pm_sym, s);
     if (p) cnt += MSIZE(p->ADDR);
     }

n = cnt + qsep * (ntok-1);
if(mkobj(dst, 'T', n, n)) return ERROR;
t = TEXT_PTR(dst);
ix = INT_PTR(idx);

for (i = cnt = 0; i < ntok; i++, ix++) {
     s = mk_sname(&name[0], *ix);
     p = sys_text(pm_sym, s);
     if (i && qsep) *t++ = sep;
     if (p && MSIZE(p->ADDR)) {
         memcpy(t, TEXT_PTR(p), MSIZE(p->ADDR));
         t += MSIZE(p->ADDR);
         }
     }
return OK;
}


