/*      Block  file IO functions
*       Depend on MS_DOS -- not so portable.
*       Use memory slice routines
*/

#include <na.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

#if  defined(TC) || defined (DJGPP)

#define S_NOHASSLE    0X01C0    /* read & write */

#else                           /* Linux */

#define O_BINARY           0    /* no_op when used with | 'or'. */
#define S_NOHASSLE      0666    /* read & write */

#endif

typedef int     FD;

#define BAD_FD          ((FD)-1)

dh_zload(dst, file)     /* read file into object */
MATRIX  dst;            /* file image --raw data */
BYTE   *file;           /* file name */
{
extern long lseek();
int     rc;     /* return code */
long    nsize;  /* file size */
unsigned int  n;
FD      fd;     /* result of open */
int     cc;

if (ERROR == (fd = open(file, O_RDONLY | O_BINARY))) return ERROR;
nsize = lseek(fd, 0L, SEEK_END);
n     = nsize;
if (OK == (rc = mkobj(dst, 'T', n, n))) {
        lseek(fd, 0L, SEEK_SET);
        cc = read(fd, TEXT_PTR(dst), n);
        }
rc |= close(fd);
return rc;
}

dh_zsave(src, file)      /* reverse of dh_zload */
MATRIX  src;    /* object */
BYTE   *file;   /* file name */
{
extern long lseek();
int     rc = 0;
int     n;      /* size */
int     k;
BYTE   *s;
FD      fd;     /* file handle */

if(NULL == src || NULL == (s = src->ADDR)) return ERROR;
if (TYPT != MTYPE(s)) return ERROR;
n = MSIZE(s);
if (BAD_FD ==
        (fd = open(file, O_CREAT | O_TRUNC | O_RDWR | O_BINARY, S_NOHASSLE)))
        return ERROR;

lseek(fd, 0L, SEEK_SET);
k = write(fd, TEXT_PTR(src), n);
return close(fd);
}
