/*      NA_LOAD.C  */
#include <stdio.h>
#include <na.h>
#include <lex.h>
#include <dt.h>

#define NAL_A                  1
#define NAL_F                  2
#define NAL_T                  3
#define NAL_AA                 8
#define NAL_AT                10
#define NAL_AAA               57
#define NAL_AFA               64
#define NAL_TFA              162
#define NAL_TFT              164
#define NAL_AFAA             449
#define NAL_AFAAA           3144

/* these functions recognize the script
*  Unix shell and c++ comments are skipped
*  try and get it to recognize embedded scripts
*/


BYTE   *lx_cufn = "N....NR...ZN...ZNR..LNR..ZLNR.";
int     scan_auto;

#define FX_TPL(X)       (X == NAL_A)     ? 0 \
                       :(X == NAL_AA)    ? 1 \
                       :(X == NAL_AFA)   ? 2 \
                       :(X == NAL_AFAA)  ? 3 \
                       :(X == NAL_AAA)   ? 4 \
                       :                   5

na_fload(ufile, tab, stack)     /* load objects */
char   *ufile;          /* file name */
MATRIX  tab;            /* symbol table */
MATRIX  stack;          /* stack */
{
MATRIX sp;

if (tab->ADDR == NULL   || TYPA != MTYPE(tab->ADDR))   return ERROR;
if (stack->ADDR == NULL || TYPA != MTYPE(stack->ADDR)) return ERROR;

sp = NA_PTR(stack);             /* use this for work space */

if (mkobj(sp, 'L', 1, 1) ||
    sl_fget(LINK_PTR(sp), ufile) ||
    na_catobj(tab, LINK_PTR(sp), sp+1))
    return ERROR;
return sys_del(sp) || sasm(sp, sp+1);
}

na_catobj (tab, start, sp)
MATRIX  tab;    /* symbol table  */
SLIST   start;  /* block begin   */
MATRIX  sp;     /* stack pointer */
{
struct  SDESC tt, eof;
SLIST   x, xstart, xnow;
TAGD    tk;
int     mode, qb, rc;
int     obj_type = 0;
int     n;

eof.SDLEN = 0;
scan_auto = 1;
for (mode = rc = 0, x = start; rc == 0 && x != NULL; x = S_NEXT(x)) {
    tt.ADDR = S_TEXT(x);
    tt.SDLEN = S_LEN(x);
    qb  =  (eof.SDLEN) ? eof.SDLEN == tt.SDLEN &&
                         0 == memcmp(eof.ADDR, tt.ADDR, eof.SDLEN)
                       : allblank(tt.ADDR, tt.SDLEN);
    switch(2 * mode + ! qb) {
        case 0: break;
        case 1: /* start */
            xstart = xnow = x;
            if (mk_tabs(sp+1, 2 * tt.SDLEN, sizeof(tdesc))) return ERROR;
            tk = TAG_PTR(sp+1);
            n  = lx_split(tk, &tt);
            obj_type = na_start_obj(tk, n-1);
            if (obj_type == NAL_TFA) eof = (tk+2)->slice;
            mode = 1;
            break;
        case 2: /* end */
            rc |= na_cput(obj_type, tab, sp, xstart, xnow);
            eof.SDLEN = 0;
            mode = 0;
            break;
        case 3: xnow = x;
            break;
        }
    }

if (mode) rc |= na_cput(obj_type, tab, sp, xstart, NULL);

return rc;
}

na_cput(obj, dst, sp, start, last)
int     obj;    /* type of object */
MATRIX  dst;    /* symbol table  */
MATRIX  sp;     /* stack pointer */
SLIST   start;  /* block begin   */
SLIST   last;   /* block end     */
{
extern  MATRIX sys_hput();       /* look up in symbol table */
struct  SDESC sym;
MATRIX  p;
BYTE   *fc;
TAGD    tk = TAG_PTR(sp+1);
int     nsym = MCOLS(dst->ADDR);
int     rc = 0;
int     fdx;

if (start == last) {    /* search for start up expression */
    if (scan_auto && '#' != *S_TEXT(start)) { /* sanity check */
        scan_auto = 0;
        return sl_cat('M', sp, start, last);
        }
    else return OK;
    }

switch (obj) {
    default: return OK;
    case NAL_T:         /* "name" -> matrix */
    case NAL_TFA:       /* here document .. "name" >> End_Symbol */
        sym.ADDR  = tk->slice.ADDR  + 1;
        sym.SDLEN = tk->slice.SDLEN - 2;
        rc = NULL == (p = sys_hput(dst, &sym)) ||
             sl_cat('M', p + nsym, S_NEXT(start), last);
        break;
    case NAL_F:         /* #do .. startup expression */
        if (tk->tag == 'S' && (tk+1)->tag =='E') {
            scan_auto = 0;
            rc = sl_cat('M', sp, S_NEXT(start), last);
            }
        break;
    case NAL_A:
    case NAL_AA:
    case NAL_AAA:
    case NAL_AFA:
    case NAL_AFAA:
    case NAL_AFAAA:
        rc = (obj == NAL_A || obj == NAL_AA) ? 0
            :(obj == NAL_AAA)                ? 1
            :(obj == NAL_AFAAA)              ? 3
            :                                  2;
        fdx = FX_TPL(obj);
        fc  = lx_cufn + 5 * fdx;
        sym = (tk+rc)->slice;
        p = sys_hput(dst, &sym);
        if (p == NULL) return ERROR;
        p += nsym;
        rc = mkobj(p, 'A', 2, 2) ||
             sl_cat('M', NA_PTR(p), start, last) ||
             na_ffix(fc, p, sp+1);
        break;
        }
return rc;
}

na_ffix(fc, dst, sp)
BYTE   *fc;     /* parse template */
MATRIX  dst;    /* nested array   */
MATRIX  sp;     /* tags */
{
MATRIX  text = NA_PTR(dst);     /* function text */
TAGD    tk, tmp;
struct  SDESC tt;
BYTE   *s;
int     rc, j, n, nt, nr, nc;

n = rho(text, &nr, &nc);

if(mk_tabs(sp, 2 * nc + nr, sizeof(tdesc)))
        return ERROR;

tt.ADDR  = TEXT_PTR(text);
tt.SDLEN = nc;

tk       = TAG_PTR(sp);
n        = lx_asplit(tk, &tt);
tmp      = tk + n;
s        = nc + TEXT_PTR(text);
n        = nc * (nr-1);

/* scan for labels: XX: */
for (j = 0; j < n; j++, s++) if (':' == *s) {
        tt.ADDR =  TEXT_PTR(text) + nc * (1 + j / nc);
        tt.SDLEN = j % nc;
        nt = lx_split(tmp, &tt);
        if (nt == 2 && 'A' == tmp->tag && 'E' == (tmp+1)->tag) {
                tmp->tag = 'K';
                tmp++;
                }
        }

nc = tmp - tk;                  /* number of names */

                                /* count names     */
for (tmp = tk, j = nc, n = 0; j > 0; j--, tmp++)
        if (tmp->tag == 'A' || tmp->tag == 'K') n++;

if (rc = mk_tabs(++text, n, sizeof(tdesc)))
        return rc;

for (j = nc, tmp = TAG_PTR(text); j > 0; j--, tk++)
        if (tk->tag == 'A' || tk->tag == 'K')
                *tmp++  = *tk;  /* copy structure */

for (tk = TAG_PTR(text), j = 0; j < 5 && '.' != *fc; j++, tk++, fc++)
                tk->tag = *fc;

MINDX(text->ADDR) = n;          /* used */
MELSIZ(dst->ADDR) = TYPU;       /* mark */
return rc;
}

na_start_obj(tok, ntok)
TAGD    tok;            /* parts */
int     ntok;
{
int     rc, ct;
if (ntok > 5) return ERROR;
for (rc = 0; 0 < ntok-- ; tok++) {
        switch(tok->tag) {
        case 'A': ct = 1;       /*  name        */
                break;
        case 'F':               /*  function symbols */
        case 'S': ct = 2;       /*  special     */
                break;
        case 'T': ct = 3;       /*  text        */
                break;
        case 'N': ct = 4;       /* numeric */
                break;
        default:
                return ERROR;
                break;
                }
        rc = 7 * rc + ct;
        }
return rc;
}
