/*      file system .. include stream file facilities

        X<-NAME #dbtie N, {mode}        N=0 for stdin | stdout
        NAME <- #dbtie N

        #dbclose list
        #dbclose

        R<- #dbnames            Table of names
        R<- #dbnames N          Table of unit numbers
        R<- #dbget P X DX N     F[P][(iN)+DX+X*N]
        R<- #dbget P            next line

        DATA #dbput P, X, DX, N

        NR<- #dbsize N, record_size
             NR = (number of records, remainder)

        These functions are aliased by the array $VA[]
        Z<-$VA[P, X, DX, N]     read from file n
        $VA[P, X, DX, N]<-DATA  write to file n


*/

#include <stdio.h>
#include <fcntl.h>
#include <na.h>

#define LONG    long int

#ifdef linux
#define O_BINARY        0X0000
#endif

#ifdef  TC

#define S_NOHASSLE      0X01C0  /* read & write .. DOS FILES */

#else

/* #include <unistd.h>  really ? */

#define S_NOHASSLE      000666  /* read & write */

#endif

#define N_READ 1    /* read only */
#define N_USE  3    /* read and write */
#define N_STR  5    /* stream file, or pipe */
#define BAD_SEEK  (-1L)
#define BAD_FD    (-1)

typedef union {
    int   bfd;  /* block file fd */
    FILE *sfd;  /* stream file pointer */
    } FD;

typedef struct {
        int use;
        FD fd;
        } NFD;

#define NFD_FD(X)    ((NFD*)((X)+HDSIZE))->fd.bfd
#define NFD_SFD(X)   ((NFD*)((X)+HDSIZE))->fd.sfd
#define NFD_USE(X)   ((NFD*)((X)+HDSIZE))->use
#define NFN_PTR(X)   ((X)+HDSIZE+sizeof(NFD))

fx_dbtie(dst, lo, hi)   /* file functions */
MATRIX  dst;            /* result */
MATRIX  lo;             /* file name */
MATRIX  hi;             /* number, mode */
/* usage
        open    R <- name #dbtie n  {mode}
        close   R <- ""   #dbtie n
*/
{
extern  MATRIX  pm_files;
MATRIX  na_idx();
int    *ix  = INT_PTR(hi);      /* file_num, mode */
MATRIX  p   = na_idx(pm_files, ix[0]);
BYTE   *fn;             /* file name */
int     nc  = MSIZE(lo->ADDR);
int     mode, rc, c;
int     fd;

if (nc == 0) return fx_dbexit(dst, hi);
if (ix[0] == 0 ||               /* reserved STDIN | STDOUT */
    p == NULL ||                /* bad number */
    hi->ADDR == NULL ||
    MSIZE(hi->ADDR) == 0 ||     /* no number */
    MTYPE(lo->ADDR) != TYPT) return ERROR;

mode = (MSIZE(hi->ADDR) > 1) ? ix[1] : N_READ;

if (p->ADDR != NULL ||          /* create new entry */
    mk_tabs(p, 1, nc + 1 + sizeof(NFD)))
        return ERROR;

/* set up file data */

NFD_USE(p->ADDR) = mode;
fn = NFN_PTR(p->ADDR);
memcpy(fn, TEXT_PTR(lo), nc);
fn[nc]=0;       /* ASCIZ */
switch (mode) {
    case N_STR:
        c = *fn;
        if (c == '>' || c == '<') {
            for (fn++; *fn == ' ' && fn;) fn++;
            NFD_SFD(p->ADDR) = popen(fn, (c == '<') ? "r" : "w");
            }
        else
            NFD_SFD(p->ADDR) = fopen(fn,  "r");
        rc = NULL == NFD_SFD(p->ADDR);
        break;
    case N_READ:
    case N_USE:
        fd = open(fn, O_BINARY | O_RDONLY);
        if (mode == N_USE)  {
            close (fd); /* checked existance */
            fd = (fd == BAD_FD)
                ? open(fn, O_BINARY|O_CREAT|O_RDWR, S_NOHASSLE)
                : open(fn, O_BINARY | O_RDWR, S_NOHASSLE);
            }
        rc = BAD_FD == (NFD_FD(p->ADDR) = fd);
        }
return mkik(dst, rc);
}

fx_dbexit(dst, lst)     /* close files */
MATRIX  dst;            /* a number */
MATRIX  lst;            /* numbers to be closed */
{
extern  MATRIX  pm_files;
int     nfiles = MSIZE(pm_files->ADDR);
int    *ix;
int     j, nf, rc;

if (lst == NULL || MSIZE(lst->ADDR) == 0)
    for (rc = j = 0; j < nfiles; j++) rc |= db_close(j);
else {                          /* close certain files */
    if (NULL == lst->ADDR || TYPN != MTYPE(lst->ADDR)) return ERROR;
    ix = INT_PTR(lst);
    nf = MSIZE(lst->ADDR);
    for (rc = 0; 0 < nf--; ix++) rc |= db_close(ix[0]);
    }
return  mkik(dst, rc);
}

db_close(fnum)  /* close a file */
int     fnum;
{
extern  MATRIX  pm_files;
extern  MATRIX  na_idx();
MATRIX  p = na_idx(pm_files, fnum);
int     c, rc;

if (p == NULL) return ERROR;
else if (fnum == 0) return OK;
if (p->ADDR != NULL) switch(NFD_USE(p->ADDR)) {
    case N_READ:
    case N_USE:
        close(NFD_FD(p->ADDR));         /* raw file */
        break;
    case N_STR:
        c = * NFN_PTR(p->ADDR);
        rc = (c == '>' || c == '<')
            ? pclose(NFD_SFD(p->ADDR))        /* pipe */
            : fclose(NFD_SFD(p->ADDR));       /* stream file */
        break;
    default:
        break;
        }
return sasr(p);
}

fx_dbget(dst, hi)
MATRIX dst;     /* result */
MATRIX hi;      /* file tie number, start, size, rp */
{
return db_xfer(dst, NULL, hi);
}

fx_dbput(dst, lo, hi)
MATRIX dst;     /* result */
MATRIX lo;      /* data */
MATRIX hi;      /* file tie number, start, size, rp */
{
return db_xfer(dst, lo, hi);
}

db_xfer(dst, lo, hi)
MATRIX dst;     /* result */
MATRIX lo;      /* data */
MATRIX hi;      /* file tie number, start, size, rp */
{
extern  MATRIX  pm_files;
MATRIX  na_idx();
extern  LONG lseek();
struct SDESC line_input();
int    *ix = INT_PTR(hi);
int     n  = MSIZE(hi->ADDR);
MATRIX  p = na_idx(pm_files, ix[0]);
int     start = 0;
int     size  = 0;
int     rp    = 0;
struct  SDESC tt;
int     cnt_op, rc;
LONG    fpos, spos;
int     fd;
char   *fn;

if (p == NULL) return ERROR;
if (ix[0] == 0) {               /* 0 for  stdin, stdout */
    if (lo == NULL) {   /* dst    <- stdin @ */
        if (n==1)       /* read a line */
             return read_line(dst,  stdin);
        else if (n==3){ /* try to read ix[2] bytes and adjust size */
             size = ix[2];
             fd = fileno(stdin);
             if (mkobj(dst, TYPT, size, size)) return ERROR;
             cnt_op = read(fd, TEXT_PTR(dst), size);
             if (cnt_op < 0 || cnt_op > size)  return ERROR;
             if (cnt_op == size) return OK;
             if (OK == sa_swap(dst, dst+1) &&
                 OK == mkobj(dst, 'T', cnt_op, cnt_op)) {
                      memcpy(TEXT_PTR(dst), TEXT_PTR(dst+1), cnt_op);
                      return OK;
                      }
             return ERROR;
             }
        }
    else                /* stdout <- data */
        return (out_line(lo, stdout) || mkobj(dst, 'T', 0, 0));
    }
else if(p->ADDR == NULL) return ERROR;

fn = NFN_PTR(p->ADDR);
switch(NFD_USE(p->ADDR)) {
    case N_READ:
    case N_USE:
        if (n < 3) return ERROR;
        fd    = NFD_FD(p->ADDR);
        start = ix[1];
        size  = ix[2];
        rp    = (n > 3) ? ix[3] : -1;
        fpos  = (LONG) start + (LONG) rp * (LONG) size;
        if (lo == NULL) {       /* read */
            if (rp < 0 ||
                BAD_SEEK == lseek(fd, fpos, SEEK_SET) ||
                mkobj(dst, 'T', size, size)) return ERROR;
            cnt_op = read(fd, TEXT_PTR(dst), size);
            if (cnt_op < 0 || cnt_op > size) return ERROR;
            else if (cnt_op == size) rc = OK;
            else if (OK == (rc = sa_swap(dst, dst+1) ||
                    mkobj(dst, 'T', cnt_op, cnt_op)))
                memcpy(TEXT_PTR(dst), TEXT_PTR(dst+1), cnt_op);
            }
        else {  /* write */
            if (lo->ADDR == NULL ||
                MTYPE(lo->ADDR) != TYPT ||
                size != MSIZE(lo->ADDR)) return ERROR;
            spos = (rp == -1) ? lseek(fd, 0L, SEEK_END)    /* append */
                              : lseek(fd, fpos, SEEK_SET); /* write @ rp */
            if (spos == BAD_SEEK) return ERROR;
            rc = (size != write(fd, TEXT_PTR(lo), size)) ||
                  mkobj(dst, 'T', 0, 0);
            }
        break;
    case N_STR:         /* read next line */
        rc = (*fn == '>' || lo != NULL)
             ?  out_line (lo,  NFD_SFD(p->ADDR))
             :  read_line(dst, NFD_SFD(p->ADDR));
        break;
    default:
        rc = ERROR;
        break;
        }
return  rc;
}

fx_dbtab(dst, src)
MATRIX  dst;    /* table */
MATRIX  src;
{
extern  MATRIX  pm_files;
extern  MATRIX  na_idx();
MATRIX  p  = na_idx(pm_files, 0);
int     nf = MSIZE(pm_files->ADDR);
int     j, k, nr, nc, rc;
BYTE   *s, *t;
if (p == NULL)  return ERROR;   /* no file table */
for (nr = nc = 0, j = nf; 0 < j--; p++)
    if (NULL != p->ADDR) {
        k = strlen(NFN_PTR(p->ADDR));
        if (k > nc) nc = k;     /* find size of table */
        nr++;
        }
nc += 4;
if (mkobj(dst, 'T', nr * nc, nc)) return ERROR;
for (p = na_idx(pm_files, 0), t = TEXT_PTR(dst), j = 0; j < nf; j++, p++)
    if (NULL != p->ADDR) {
        iv_a(t, &j, 2, 1);              /* format j as 2 digits */
        k = strlen(NFN_PTR(p->ADDR));
        memcpy(t + 4, NFN_PTR(p->ADDR), k);     /* copy name */
        t += nc;
        }
return  OK;
}

fx_dbsize(dst, src)
MATRIX  dst;    /* number of records, remainder */
MATRIX  src;
{
extern  LONG filelength();
extern  MATRIX  pm_files;
MATRIX  na_idx();
BYTE   *s;
int    *ix;
int     size;
int     nrecs;
MATRIX  p;
LONG    xlen, quot;
FD      fd;

if (NULL == (s = src->ADDR) || TYPN != MTYPE(s) || MSIZE(s) < 2)
    return ERROR;
ix    = INT_PTR(src);
size  = ix[1];
if (size <= 0) return ERROR;
if (NULL == (p = na_idx(pm_files, ix[0])) || NULL == p->ADDR)
    return ERROR;
if (mkobj(dst, 'N', 2, 2)) return ERROR;
ix    = INT_PTR(dst);
xlen  = filelength (NFD_FD(p->ADDR));
quot  =  xlen / (LONG) size;
ix[0] = (int) quot;
ix[1] = (int) xlen - quot * (LONG) size;
return OK;
}

read_line(dst, fp)      /* stream file input */
MATRIX dst;             /* result */
FILE  *fp;
{
extern struct SDESC line_input();
struct SDESC tt;
tt = line_input(fp);
return (tt.ADDR == NULL) ? mkik(dst, ERROR) : mk_sk(dst, TYPT, &tt);
}

out_line(data, fp)      /* write block to stream file */
MATRIX  data;
FILE   *fp;
{
BYTE   *s = TEXT_PTR(data);
int     n = MSIZE(data->ADDR);
if (MTYPE(data->ADDR) != TYPT) return ERROR;
for(; 0 < n--; s++) fputc(*s, fp);
fflush(fp);
return OK;
}

#if defined (TC) || defined (DJGPP)

/*      Turbo-C includes the filelength function */

#else

LONG    filelength(fd)
FD      fd;
{
extern  LONG lseek();
return lseek(fd.bfd, 0, SEEK_END);
}

#endif


