/* FXS2OP.C - mixed version */

#include <signal.h>
#include <fdata.h>
#include <na.h>
#include <dt.h>

extern  DOUBLE fmod();
extern  DOUBLE floor();
extern  DOUBLE ceil();
extern  DOUBLE exp();
extern  DOUBLE log();
extern  DOUBLE sqrt();
extern  DOUBLE sin();
extern  DOUBLE cos();
extern  DOUBLE tan();
extern  DOUBLE asin();
extern  DOUBLE acos();
extern  DOUBLE atan();
extern  DOUBLE sqrt();
extern  DOUBLE atan2();
extern  void * memcpy();
extern  void * memset();

#define ZILDE(X)        mkobj((X), TYPN, 0, 0)
#define FMOD(X,Y)       fmod((X),(Y))
#define FFLOOR(X)       floor((X))
#define FCEILING(X)     ceil((X))

/* Jan 2006. optimisation attempts for string arithmetic.
   Use macros and inline code more ..
   March 2006
   make divmod work better for signed values.
   (-A) % B is always B - A #mod B,
   add more functions for large integers.
   June 2006 allow '_' as minus sign
   November 2009 +: -: *: %: for complex numbers

*/

typedef struct SDESC US;

#define ss_clear(X)     memset((X)->ADDR,0,(X)->SDLEN);
#define ss_rdrop(D,S,N) {(D)->ADDR=(S)->ADDR;(D)->SDLEN=(S)->SDLEN-(N);}
#define ss_take(D,S,N)  {(D)->ADDR=(S)->ADDR;(D)->SDLEN=N;}

#define ss_slice_obj(D,S)  {(D)->ADDR=TEXT_PTR((S));(D)->SDLEN=MSIZE((S)->ADDR);}
#define ss_eat1(D)         {((D)->ADDR)++;((D)->SDLEN)--;}
#define ss_is_scalar(S,VAL)     ((S)->SDLEN==1 && *(S)->ADDR==VAL)

#define us_strip_bits(S, T, N) \
    { for (T=(S)->ADDR, N=(S)->SDLEN; 0<N--;) *T++ &= 0X0F; }

#define us_ascii_bits(S, T, N) \
    { for (T=(S)->ADDR, N=(S)->SDLEN; 0<N--;) *T++ |= 0X30; }

#define ds_plus(D,L,H)  ds_add('+',D,L,H)
#define ds_minus(D,L,H) ds_add('-',D,L,H)

int     sca_id[]  = {0,     0,   1,  MAX_INT, MIN_INT};
DOUBLE  sca_xid[] = {0.0, 0.0, 1.0, 1.0e200, -1.0e200};
DOUBLE  (*trig_fns[])()={atan, acos, asin, floor, sin, cos, tan};

sca_dya(op, dst, lo, hi)        /* scalar dyadic */
int     op;     /* +,-,*,%, etc  */
MATRIX dst;
MATRIX lo;
MATRIX hi;
{
BYTE   *s  = lo->ADDR;
int     dx = MTYPE(s);
int     nx = MSIZE(s);
BYTE   *t  = hi->ADDR;
int     dy = MTYPE(t);
int     ny = MSIZE(t);
int     dz, qx, qy, n, nc, rc, esize;
MATRIX  p;
int    *ix, *jx, *kx;
DOUBLE *zd, *xs, *ys;
DOUBLE  xr;

       /* null absorbs    X + NULL -> NULL */
if (nx == 0 || ny == 0) return ZILDE(dst);

n  = (nx > ny) ? nx : ny;
nc = (nx > ny) ? MCOLS(s) : MCOLS(t);
qx = nx > 1;
qy = ny > 1;
esize = qx & qy & (nx != ny);   /* size error */

switch (dx | dy) {
    default: return ERROR;
    case TYPT:  /* character compare */
        if (op == '=' || op == '!') {
           if (esize) return op;        /* shape error */
           if (mkobj(dst, 'N', n, nc)) return ERROR;
           kx = INT_PTR(dst);
           for(s += HDSIZE, t += HDSIZE; 0 < n--; kx++) {
               *kx = ((*s) == (*t));
               if (op == '!') *kx = ! *kx;
               if (qx) s++;
               if (qy) t++;
               }
           return OK;
           }
        else switch (op) {
        case '>': rc = as_comp(lo, hi);
                  return mkik(dst, rc == 1);
        case '<': rc = as_comp(lo, hi);
                  return mkik(dst, rc == -1);
        case '+': return ds_plus(dst, lo, hi);
        case '-': return ds_minus(dst, lo, hi);
        case '*': return ds_mult(dst, lo, hi);
        case '%':
        case '#': return ds_divmod(op, dst, lo, hi);
        default:  return ERROR;
            break;
            }
        break;
    case (TYPN | TYPT): /* mixed compare or #mod */
        if (op == '#' && dx == TYPT)
             return ds_vmod(dst, lo, hi);
        else if (op == '=' || op == '!')
             return mkobj(dst, 'N', n, nc);
        else return ERROR;
    case TYPN:          /* integer */
    case TYPD:  break;  /* double  */
    case TYPN|TYPD:     /* mixed */
        p = (dx == TYPN) ? lo : hi;
        if (fx_cvd(dst, p) || sa_swap(p, dst)) return ERROR;
        dx = dy = TYPD;
        }

if (esize) return op;
dz = (op == '=' || op == '!' || op == '<' ||
      op == '>' || op == '1' || op == '2') ? TYPN : TYPD;
if (((dx | dy) & TYPD) && dz == TYPN)
        rc = mkobj(dst, dz, n, nc);
else    rc = (nx > ny) ? sasa(dst, lo) : sasa(dst, hi);
if (rc) return ERROR;
if (dx == TYPN)         /* N+N->N */
    for(ix = INT_PTR(lo), jx = INT_PTR(hi), kx = INT_PTR(dst);
        0 < n-- && rc == 0; kx++) {
        switch (op) {
        default:
        case '+' : *kx = (*ix)+(*jx);   /* plus */
            break;
        case '-' : *kx = (*ix)-(*jx);   /* minus */
            break;
        case '*' : *kx = (*ix)*(*jx);   /* times */
            break;
        case '%' :  if (rc = (0 == *jx)) break;
                *kx = (*ix)/(*jx);      /* divide */
            break;
        case '#' :  if (rc = (0 == *jx)) break;
                *kx = (*ix)%(*jx);      /* #mod */
                 if (*kx < 0) *kx += *jx;
            break;
        case 'f' : *kx = *ix;            /* floor .. min */
               if ((*ix) > (*jx)) *kx = *jx;
            break;
        case 'c' : *kx = *ix;            /* cieling .. max */
               if ((*ix) < (*jx)) *kx = *jx;
            break;
        case '&' : *kx = (*ix) & (*jx); /* #and */
            break;
        case '|' : *kx = (*ix) | (*jx); /* #or */
            break;
        case '<' : *kx = ((*ix) < (*jx));
            break;
        case '>' : *kx = ((*ix) > (*jx));
            break;
        case '=' : *kx = ((*ix) == (*jx));
            break;
        case '!' : *kx = ((*ix) != (*jx));          /* #ne */
            break;
        case '1' : *kx = ((*ix) <= (*jx));          /* <=  */
            break;
        case '2' : *kx = ((*ix) >= (*jx));          /* >=  */
            break;
            }
    if (qx) ix++;
    if (qy) jx++;
    }
else if (dz == TYPN)    /* D+D->N */
    for(xs = DBL_PTR(lo), ys = DBL_PTR(hi), kx = INT_PTR(dst); 0<n--; kx++) {
        switch (op) {
        default:
        case '&' : /* *kx = (*xs) & (*ys);    #and */
            break;
        case '|' : /* *kx = (*xs) | (*ys);    #or */
            break;
        case '<' : *kx = ((*xs) < (*ys));
            break;
        case '>' : *kx = ((*xs) > (*ys));
            break;
        case '=' : *kx = ((*xs) == (*ys));
            break;
        case '!' : *kx = ((*xs) != (*ys));          /* #ne */
            break;
        case '1' : *kx = ((*xs) <= (*ys));          /* <=  */
            break;
        case '2' : *kx = ((*xs) >= (*ys));          /* >=  */
            break;
            }
    if (qx) xs++;
    if (qy) ys++;
    }
else            /* D+D->D */
    for(xs = DBL_PTR(lo), ys = DBL_PTR(hi), zd = DBL_PTR(dst); 0<n--; zd++) {
        switch (op) {
        default:
        case '+' : *zd = (*xs)+(*ys);   /* plus */
            break;
        case '-' : *zd = (*xs)-(*ys);   /* minus */
            break;
        case '*' : *zd = (*xs)*(*ys);   /* times */
            break;
        case '%' :  if (rc = (0.0 == *ys)) break;
                *zd = (*xs)/(*ys);      /* divide */
            break;
        case '#' :  if (rc = (0.0 == *ys)) break;
                if (*xs < 0.0) *zd = *ys - FMOD(-*xs, *ys);
                else *zd = FMOD (*xs, *ys);     /* #mod */
            break;
        case 'f' : *zd = *xs;           /* floor .. min */
               if ((*xs) > (*ys)) *zd = *ys;
            break;
        case 'c' : *zd = *xs;           /* ceiling .. max */
               if ((*xs) < (*ys)) *zd = *ys;
            break;
            }
    if (qx) xs++;
    if (qy) ys++;
    }
return rc;
}

sca_mon(fc, dst, src)   /* monadic operation */
int     fc;             /* utility operations on integers */
MATRIX  dst;            /* same size */
MATRIX  src;            /* src = integer vector */
{
BYTE   *s  = src->ADDR;
int     n  = MSIZE(s);
int     nc = MCOLS(s);
int     dx = MTYPE(s);
int    *di, dz, k, rc;
DOUBLE *x, xr;
if (n == 0) return sasa(dst, src);      /* no change */
if (dx == TYPT) {                       /* large integer */
    switch (fc) {
    case '-': return ds_uminus(dst, src);
        break;
    case '+':   /* Absolute value */
        return ('-' == *TEXT_PTR(src))
            ? fx_take(dst, src, 1, -(n-1))
            : sasa(dst, src);
        break;
    case '*':   /* INT32 signum */
        k = *TEXT_PTR(src);
        if (k == '-') rc = -1;
        else if (n == 1 && '0' == *s) rc = 0;
        else rc = 1;
        return mkik(dst, rc);
        break;
    default: return ERR_DOM;
        }
    }
if  (dx == TYPN) dz = dx;
else dz =  (fc == '!' || fc == '~' || fc == '*') ? TYPN : TYPD;
rc = (dx == TYPN || dz == TYPD)
      ? sasa (dst, src)
      : mkobj(dst, dz, n, nc);
if (rc) return rc;
if (dx == TYPN)         /* N->N */
    for (di = INT_PTR(dst); 0 < n--; di++)
        switch(fc) {
        case '-': *di = -*di;   /* negate */
                break;
        case '+':       /* absolute value */
                if (*di < 0) *di = -*di;
                break;
        case '*':       /* signum */
                if (*di > 0) *di = 1;
                else if (*di == 0) *di = 0;
                else *di = -1;
                break;
        case '~':       /* not 1->0 and 0->1 */
                *di = 1 & ~ *di;
                break;
        case '!':       /* logicise */
                *di = (*di != 0);
                break;
        case '?':   /* random throw */
                k = *di;
                *di = (k > 0) ? rand() % k : 0;
        default:        /* copy */
                break;
        }
else if (dz == TYPN)    /* D -> N */
    for (di = INT_PTR(dst), x = DBL_PTR(src); 0 < n--; di++, x++)
        switch(fc) {
        case '*':       /* signum */
                if (*x > 0.0) *di = 1;
                else if (*x == 0.0) *di = 0;
                else *di = -1;
                break;
        case '~':       /* not 1->0 and 0->1 */
                *di = (*x == 0.0) ? 1 : 0;
                break;
        case '!':       /* logicise */
                *di = (*x != 0.0);
                break;
        }
else                    /* D -> D */
    for (x = DBL_PTR(dst); 0 < n-- && rc == 0; x++)
        switch(fc) {
        case '-': *x = -*x;   /* negate */
                break;
        case '+':       /* absolute value */
                if (*x < 0) *x = -*x;
                break;
        case 'f':       /* floor */
                *x = FFLOOR(*x);
                break;
        case 'c':       /* cieling */
                *x = FCEILING(*x);
                break;
        default:        /* copy */
                break;
        }
return rc;
}

sca_sum(fc, dst, src)   /* summation */
int     fc;             /* [A-E][F-I] */
MATRIX  dst;            /* DST <- f / HI  or DST <- f \ HI  */
MATRIX  src;            /* src = vector -> fc/src  matrix: sum rows */
{
BYTE   *s = src->ADDR;
int     n  = MSIZE(s);
int     nc = MCOLS(s);
int     dx = MTYPE(s);
int     j, kc, nr, qs, rc, sn;
int    *ix, *jx;
DOUBLE *xs,  *zd;

fc = fc - 'A';  /* multi thread coding */
kc = fc % 5;    /* function */
qs = fc > 4;    /* operator */

if (n == 0)     /* small min and max values .. ok for province */
        return (qs) ? ZILDE (dst) : mkik(dst, sca_id[kc]);
else if ((dx != TYPN && dx != TYPD) || nc == 0) return ERROR;

nr  = n / nc;   /* rows */
if (nr == 1) {
    nr = nc;
    nc = 1;     /* vector */
    }
if(rc = (qs) ? sasa(dst, src) : mkobj(dst, dx, nc, nc)) return rc;
if (dx == TYPN) {
    ix = INT_PTR(dst);  /* result */
        if (qs) {       /* scan   */
        for (ix += nc, nr--, sn =-1; 0 < nr--; sn = -sn)
            for (j = 0; j < nc; j++, ix++)
            switch (kc) {
            default:
            case 0   : *ix += ix[-nc];
                    break;
            case 1   : *ix = ix[-nc]+sn * *ix;  /* alternating sum */
                    break;
            case 2   : *ix *= ix[-nc];
                    break;
            case 3   : if (ix[-nc] < *ix) *ix = ix[-nc];
                    break;
            case 4   : if (ix[-nc] > *ix) *ix = ix[-nc];
                    break;
            }
        }
        else {          /* start from zero, and accumulate */
        jx = INT_PTR(src);       /* source */
        for (j = 0; j < nc; j++) ix[j] = sca_id[kc];
        for (sn =1; 0 < nr--; sn = -sn)
            for (j = 0; j < nc; j++, jx++)
                switch (kc) {
                default:
                case 0   : ix[j] += *jx;
                        break;
                case 1   : ix[j] += sn * *jx;   /* alternating sum */
                        break;
                case 2   : ix[j] *= *jx;
                        break;
                case 3   : if (ix[j] > *jx) ix[j] = *jx;
                        break;
                case 4   : if (ix[j] < *jx) ix[j] = *jx;
                        break;
                }
        }
    }
else {  /* D->D */
    zd = DBL_PTR(dst);  /* result */
    if (qs) {           /* scan   */
        for (zd += nc, nr--, sn =-1; 0 < nr--; sn = -sn)
            for (j = 0; j < nc; j++, zd++)
            switch (kc) {
            default:
            case 0   : *zd += zd[-nc];
                    break;
            case 1   : *zd = zd[-nc]+sn * *zd;  /* alternating sum */
                    break;
            case 2   : *zd *= zd[-nc];
                    break;
            case 3   : if (zd[-nc] < *zd) *zd = zd[-nc];
                    break;
            case 4   : if (zd[-nc] > *zd) *zd = zd[-nc];
                    break;
            }
        }
        else {          /* start from zero, and accumulate */
        xs = DBL_PTR(src);       /* source */
        for (j = 0; j < nc; j++) zd[j] = sca_xid[kc];
        for (sn =1; 0 < nr--; sn = -sn)
            for (j = 0; j < nc; j++, xs++)
                switch (kc) {
                default:
                case 0   : zd[j] += *xs;
                        break;
                case 1   : zd[j] += sn * *xs;   /* alternating sum */
                        break;
                case 2   : zd[j] *= *xs;
                        break;
                case 3   : if (zd[j] > *xs) zd[j] = *xs;
                        break;
                case 4   : if (zd[j] < *xs) zd[j] = *xs;
                        break;
                }
        }
    }
return OK;
}

fx_math(dst, src)       /* math utility functions */
MATRIX  dst;            /* always double */
MATRIX  src;
{
DOUBLE (*zf)();
int     fc = MELSIZ(dst->ADDR);
BYTE   *s  = src->ADDR;
int     n  = MSIZE(s);
int     nc = MCOLS(s);
int     dx = MTYPE(s);
int     rc = 0;
DOUBLE *x, *xr;

if (fc == 'S') fc = MINDX(dst->ADDR);
if (n == 0) return sasa(dst, src);      /* no change */
if (dx == TYPN) {
    if (fx_cvd(dst, src) || sa_swap(src, dst)) return fc;
    }
if (fc == F_ATAN && 0 == (nc & 1)) {    /* for complex numbers */
    rc = mkobj(dst, TYPD, n=n/2, nc/2);
    signal(SIGFPE, SIG_IGN);
    for (xr = DBL_PTR(dst), x = DBL_PTR(src); rc == 0 && 0 < n--; xr++, x+=2)
        *xr = atan2(*x, *(x+1));
    return rc;
    }

rc = mkobj(dst, TYPD, n, nc);
if      (fc == F_EXP ) zf = exp;
else if (fc == F_LN)   zf = log;
else if (fc == F_SQRT) zf = sqrt;
else return ERROR;
signal(SIGFPE, SIG_IGN);
for (xr = DBL_PTR(dst), x = DBL_PTR(src); rc == 0 && 0 < n--; xr++, x++)
    *xr = (*zf)(*x);
return rc;
}

fx_circle(dst, f, src) /* math utility functions (trig) */
MATRIX  dst;            /* always double */
MATRIX  f;
MATRIX  src;
{
int     nf = MSIZE(f->ADDR);
BYTE   *s  = src->ADDR;
int     n  = MSIZE(s);
int     nc = MCOLS(s);
int     rc = 0, k, nmax;
int    *fc = INT_PTR(f);
int     df = 1;
int     dx = 1;
DOUBLE *x, *xr;

if (n == 0 || nf == 0) return ZILDE(dst);  /* empty object */
nmax = (nf > n) ? nf : n;
if (nf != n) {
    if ((nf * n) != nmax) return ERROR;
    if (nf < n) df = 0;
    else {
        dx = 0;
        nc = MCOLS(f->ADDR);
        }
    }

signal(SIGFPE, SIG_IGN);        /* ignore domain error for time being */

if (MTYPE(s) == TYPN) {
    if (fx_cvd(dst, src) || sa_swap(src, dst)) return ERROR;
    }
rc = mkobj(dst, TYPD, nmax, nc);
xr = DBL_PTR(dst);
x =  DBL_PTR(src);
for ( ; rc == 0 && 0 < nmax--; xr++) {
    k = *fc;
    if (k < -3 || k > 3) rc = k;
    else  *xr = (trig_fns[k+3])(*x);
    if (df) fc++;
    if (dx) x++;
    }
return rc;
}

/* general function for add, subtract. Destroys arguements */
/*
  To perform the '+' and '-' operations on large integers A, B there
are three logical conditions on the operands A,B. These are
A<0, B<0, and  |A|>|B|. Here |A| is the absolute value of A.

  If H = Max(|A|,|B|) and L = Min {|A|,|B|) then it is possible
to tabulate the results in terms of H+L, H-L and an appropriate sign.

    A+B         Result   A-B
    A<0 B<0 |A|>|B|      A<0 B<0 |A|>|B|
    0   0   0   H+L,+    0   0   0   H-L,-
    0   0   1   H+L,+    0   0   1   H-L,+
    0   1   0   H-L,-    0   1   0   H+L,+
    0   1   1   H-L,+    0   1   1   H+L,+
    1   0   0   H-L,+    1   0   0   H+L,-
    1   0   1   H-L,-    1   0   1   H+L,+ -> H+L,- (06/11/2009)
    1   1   0   H+L,-    1   1   0   H-L,+
    1   1   1   H+L,-    1   1   1   H-L,-

    These numbers may be encoded (base 2) to give lists:
    f_dt = ++----++ --++++--
    s_dt = ++-++--- -+++-++-
                                                                  */

ds_add(int op, MATRIX dst, MATRIX lo, MATRIX hi)
{
char   *f_dt = "++----++--++++--";
char   *s_dt = "++-++----+++--+-";
US      x, y, z, *zmax, *zmin;
BYTE   *s, *t;
int     fc, bb, cc, n, qadd, qs;

ss_slice_obj(&x, lo);
ss_slice_obj(&y, hi);
if (x.SDLEN == 0 || y.SDLEN == 0)
    return mkobj(dst, TYPT, 0, 0);

if (op == '-') fc = 8;
else if (op == '+') fc = 0;
else return ERROR;

if (*x.ADDR == '-' || *x.ADDR == '_') {    /* sign of LO */
    fc += 4;
    ss_eat1 (&x);
    }

if (*y.ADDR == '-' || *y.ADDR == '_') {    /* sign of HI */
    fc += 2;
    ss_eat1 (&y);
    }

if (1 == ss_comp(&x, &y)) {     /* test |LO|>|HI| */
    fc += 1;
    zmax = &x;
    zmin = &y;
    }
else {                  /* |LO| <= |HI| */
    zmax = &y;
    zmin = &x;
    }

qadd = ('+' == f_dt[fc]);       /* read dispatch tables */
qs   = ('-' == s_dt[fc]);


if (qadd) {   /* add slice */
    cc = ss_add_to (zmax, zmin, 0);
    n = zmax->SDLEN + (cc>0) + qs;
    mkobj(dst, TYPT, n, n);
    t = TEXT_PTR(dst);
    if (qs) *t++ = '-';
    if (cc) *t++ = cc | 0X30;
    memcpy(t, zmax->ADDR, zmax->SDLEN);
    }
else {          /* subtract slice */
    bb = ss_sub_from (zmax, zmin, 0);
    if (bb) return ERR_DOM;     /* this should not happen */
    ss_dropz(&z, zmax);
    if (z.SDLEN == 1 && '0' == *z.ADDR)
        return mk_ck(dst, 0);
    n = z.SDLEN + qs;
    mkobj(dst, TYPT, n, n);
    t = TEXT_PTR(dst);
    if (qs) *t++ = '-';
    memcpy(t, z.ADDR, z.SDLEN);
    }
return OK;
}

/*      z<-z+x*10^offset */

int     ss_add_to(US *z, US *x, int offset)
{
int     a, cc, j;
BYTE   *s, *t;
if (x->SDLEN+offset > z->SDLEN) return ERROR;
t= z->ADDR + z->SDLEN - 1 - offset;
for (s = x->ADDR+x->SDLEN-1, j = cc = 0; j < z->SDLEN-offset ; j++) {
    a = cc + *t & 0X0F;
    if (j< x->SDLEN) a += 0X0F & *s--;
    cc = (a >= 10);
    if (cc) a -= 10;
    *t-- = a | 0X30;
    }
return cc;
}

/*      z <- z- x/10^n        */

int     ss_sub_from(US *z, US *x, int offset)
{
int     a, bb, j;
BYTE   *s, *t;
if (x->SDLEN-offset > z->SDLEN) return ERROR;
t = z->ADDR + z->SDLEN -1;
for (s = x->ADDR+x->SDLEN-1-offset, j = bb = 0; j < z->SDLEN; j++) {
    a = (*t & 0X0F) - bb;
    if (j < x->SDLEN-offset) a -= 0X0F & *s--;
    bb = (a < 0);
    if (bb) a += 10;
    *t-- = a | 0X30;
    }
return bb;
}

int     ss_dropz(US *z, US *x)  /* drop zeros. OK to use z=x */
{
int     i;
US      zz;
for (zz.ADDR = x->ADDR, i = 0; i < x->SDLEN; i++) {
    if (*zz.ADDR & 0X0F) break;
    else zz.ADDR++;
    }
zz.SDLEN = x->SDLEN -i;

if (zz.SDLEN == 0) {
    zz.ADDR = x->ADDR+x->SDLEN-1;
    zz.SDLEN = 1;
    }
*z = zz;
return OK;
}

mk_ck(MATRIX dst, int c)        /* one digit scalar */
{
BYTE   *t;
int     qs =(c<0);
if (mkobj(dst, TYPT, 1+qs, 1+qs)) return ERROR;
t=TEXT_PTR(dst);
if (qs) { *t++ = '-'; c = -c; }
*t = 0X30 | c;
return OK;
}

ss_strip_bits(BYTE *si, int n)  /* strip bits from ASCII digits */
{
for (; 0 < n--; si++) *si &= 0X0F;
return OK;
}

ds_trim(MATRIX dst, MATRIX src) /* delete leading zeros */
{
BYTE   *si = TEXT_PTR(src);
int     nx = MSIZE(src->ADDR);
BYTE   *di;
int     cnt, i, n;

for (cnt = 0, i= nx; 0 < i--; si++) {
    if (*si & 0X0F) break;
    else cnt++;
    }

n = nx - cnt;
if (n == 0) return mk_ck(dst, 0);

if (mkobj(dst, TYPT, n, n)) return ERROR;
for (di =TEXT_PTR(dst), si = TEXT_PTR(src) + cnt; 0 < n--; di++, si++)
    *di = *si | 0X30;

return OK;
}

ds_uminus(MATRIX dst, MATRIX src)    /* unary minus */
{
US      x;
BYTE   *s, *t;
int     n, qs;
ss_slice_obj(&x, src);
if (x.SDLEN == 0) return mkobj(dst, TYPT, 0, 0);
qs = ('-' == *x.ADDR || '_' == *x.ADDR);
if (qs) {
    ss_eat1(&x);
    return mk_sk(dst, TYPT, &x);
    }
mkobj(dst, TYPT, 1+x.SDLEN, 1+x.SDLEN);
t = TEXT_PTR(dst);
*t++ = '-';
for (n = x.SDLEN, s = x.ADDR; 0<n--; s++, t++) *t = *s | 0X30;
return OK;
}

int ss_comp(US *x, US *y)  /* if x>y 1 else if x==y 0 else x<y -1 */
{
int     rc = 0;
if (x->SDLEN > y->SDLEN) rc = 1;       /* compute sign lo-hi */
else if (x->SDLEN < y->SDLEN) rc = -1;
else {
    rc = memcmp(x->ADDR, y->ADDR, x->SDLEN);
    if (rc > 0) rc = 1;
    else if (rc < 0) rc = -1;
    }
return rc;
}


int as_comp(MATRIX lo, MATRIX hi)       /* test lo > hi */
{
extern  int     memcmp();
int     nx = MSIZE(lo->ADDR);
int     ny = MSIZE(hi->ADDR);
BYTE   *si = TEXT_PTR(lo);
BYTE   *zi = TEXT_PTR(hi);
int     k;

if (nx > ny)      k =  1;       /* compute sign lo-hi */
else if (nx < ny) k = -1;
else {
    k = memcmp(si, zi, nx);
    if (k > 0) k = 1;
    else if (k < 0) k = -1;
    }
return k;
}

ds_mult(MATRIX dst, MATRIX lo, MATRIX hi)       /* multiply */
{
extern  BYTE*   malloc();
US      x, y, z, tmp;
BYTE   *t, *xi, *yi;
int     j, cc, k, nd, n, sx;
int     n_sign = 1, minz, maxz;

ss_slice_obj(&x, lo);
ss_slice_obj(&y, hi);
if (*x.ADDR == '-' || *x.ADDR== '_') {       /* sign of lo */
    n_sign = -n_sign;
    ss_eat1(&x);
    }

if (*y.ADDR == '-' || *y.ADDR== '_') {       /* sign of hi */
    n_sign = -n_sign;
    ss_eat1(&y);
    }

if (x.SDLEN*y.SDLEN == 0) return mkobj(dst, TYPT, 0, 0);
if (ss_is_scalar(&x, '0') || ss_is_scalar(&y, '0')) return mk_ck(dst, 0);

us_strip_bits(&x, t, n);
us_strip_bits(&y, t, n);

z.SDLEN = n = x.SDLEN+y.SDLEN;
z.ADDR = (BYTE*) malloc(n);
if (z.ADDR == NULL) return ERR_MEM;
ss_clear(&z);
t  = z.ADDR + n-1;

if (x.SDLEN > y.SDLEN)  { minz = y.SDLEN; maxz = x.SDLEN;}
else                    { minz = x.SDLEN; maxz = y.SDLEN;}

/* optimise inner loop */

for (k = 1, cc = 0; k <= n-1; k++) {
    if (k < minz) nd = k;
    else if (k > maxz) nd = n-k;
    else nd = minz;
    xi = x.ADDR + x.SDLEN-1;
    if (k > y.SDLEN) xi -= (k - y.SDLEN);
    yi = y.ADDR;
    if (k < y.SDLEN) yi += (y.SDLEN - k);
    for (sx = cc, j = 0; j < nd; j++) {
        sx += (*xi--) * (*yi++);
        }
    cc = sx/10;
    *t-- = '0' + sx-10*cc;
    }
*t = '0' + cc;

x = z;          /* create object for result */
if (cc == 0) ss_eat1(&x);
n = x.SDLEN + (n_sign < 0);
if (mkobj(dst, TYPT, n, n)) return ERR_MEM;
t = TEXT_PTR(dst);
if (n_sign < 0) *t++ = '-';
memcpy(t, x.ADDR, x.SDLEN);
free(z.ADDR);           /* must do so here */
return OK;
}

/* modified March 2006 to handle negative values of LO */

ds_divmod(int op, MATRIX dst, MATRIX lo, MATRIX hi)     /* Z<-LO op HI */
{
extern  MATRIX  pm_sym;
MATRIX  sys_nlink();
MATRIX  ds_t9();
MATRIX  x9 = NULL;      /* multiplication table */
MATRIX  xr = NULL;      /* remainder */
MATRIX  xq = NULL;      /* quotient */
int     nx = MSIZE(lo->ADDR);
int     ny = MSIZE(hi->ADDR);
BYTE   *di, *si, *t9, *zq;
int     dx, i, ip, k, kz, n, nc9, nt, nq;
int     sl, sh;

if (nx == 0 || ny == 0)
    return mkobj (dst, TYPT, 0, 0);

if (op == '%') {
    xq = dst;
    xr = sys_nlink(pm_sym, "$REMAINDER", NULL, 0);
    }
else if (op == '#') {
    xq = sys_nlink(pm_sym, "$QUOTIENT", NULL, 0);
    xr = dst;
    }
else return ERROR;

sl = ('-' == *TEXT_PTR(lo) || '_' == *TEXT_PTR(lo));
sh = ('-' == *TEXT_PTR(hi) || '_' == *TEXT_PTR(hi));
if (sl) {               /* truncate sign */
    nx--;
    fx_take(dst, lo, 1, -nx);
    sa_swap(lo, dst);
    }
if (sh) {               /* truncate sign */
    if (op == '#') return ERROR;
    ny--;
    fx_take(dst, hi, 1, -ny);
    sa_swap(hi, dst);
    }

k = as_comp(lo, hi);

if (k == 0) {
    return mk_ck(xr, 0) || mk_ck(xq, (sh == sl) ? 1: -1);
    }
else if (k < 0) {
    mk_ck(xq, 0);
    if (sl) ds_minus(xr, hi, lo);
    else sasa (xr, lo);
    return OK;
    }

if (ny == 1) {          /* trivial case. divide by 0 or 1 */
    si = TEXT_PTR(hi);
    if (*si == '0') return ERROR;
    else if (*si == '1') {
        return mk_ck(xr, 0) ||
        (sl == sh) ? sasa(xq, lo) : ds_uminus(xq, lo);
        }
    else return ds_idiv(xq, lo, *si, &k, (sh != sl)) || mk_ck(xr, k);
    }

/* really difficult stuff */

ss_strip_bits(TEXT_PTR(lo), nx);
ss_strip_bits(TEXT_PTR(hi), ny);

x9  = ds_t9("$QR_T9", hi);
t9  = TEXT_PTR(x9);
nc9 = MCOLS(x9->ADDR);
nq  = nx-ny+1;

if (mkobj(xq, TYPT, nq, nq)) return ERROR;
zq = TEXT_PTR(xq);
for (i = 0; i < nq; i++) zq[i] = '0';

for (di = TEXT_PTR(lo);;) {
    si = TEXT_PTR(hi);
    dx = MINDX(lo->ADDR);
    kz = (nx - dx) - ny;
    if (kz < 0) break;          /* test hi < lo */
    else if (kz == 0 && 0 > memcmp(di + dx, si, ny)) break;
    kz -= (0 < memcmp(si, di + dx, ny));        /* decimal place */

    for (ip = 9, i = 0; i < 9; i++) {   /* get the correct digit */
        si = t9 + i*nc9;
        nt = nc9;
        if (*si == 0) {
            si++;
            nt--;
            }
        if ((nx-dx == kz+nt && 0 < memcmp(si, di + dx, nt)) ||
             nx-dx <  kz+nt) {
            ip = i;
            break;
            }
        }

    si = t9 + (ip-1)*nc9;
    nt = nc9;
    if (*si == 0) {
        si++;
        nt--;
        }
    zq[nq-(kz+1)] = '0'+ip;
    ds_decz(lo, si, nt, kz);
    }

k = MINDX(lo->ADDR);
n = nx - k;
if (n == 0)  mk_ck(xr, 0);
else {
     if (mkobj(xr, TYPT, n, n)) return ERROR;
     for (si = TEXT_PTR(xr), di += k; 0 < n--; si++, di++) *si =(0X30|*di);
     }
sa_swap(lo, xq);
ds_trim(xq, lo);

if (sl != sh) { /* compute xr = hi-xr */
     sa_swap(lo, xr);
     for (si=TEXT_PTR(hi), i = ny; 0 < i--; si++) *si |= 0X30;
     ds_minus(xr, hi, lo);
     ds_uminus(lo, xq);
     sa_swap(xq, lo);
     }
return OK;
}

/* dst<- dst-(10**nz)*(s, ns) */

ds_decz(MATRIX dst, BYTE *src, int n, int nz)  /* compute in situ */
{
int     nx = MSIZE(dst->ADDR);
int     dx = MINDX(dst->ADDR);
BYTE   *si, *di;
int     bb, j, x;

nx = nx - dx;                                   /* precision of dst */
di = TEXT_PTR(dst) + dx + (nx - 1) - nz;        /* skip nz zeros */
si = src + n - 1;

for (nx -= nz, bb = 0; 0 < nx--; di--) {
    x = (*di) - bb;
    if (0 < n--) x -= (*si--);
    if (x < 0) {
        bb = 1;
        x += 10;
        }
    else bb = 0;
    *di = x;
    }

/*      count leading zeros */

for (j = 0, di = TEXT_PTR(dst), nx = MSIZE(dst->ADDR); 0 < nx--; di++) {
    if (*di) break;
    else j++;
    }

MINDX(dst->ADDR) = j;
return OK;
}

MATRIX  ds_t9 (BYTE *name, MATRIX src)  /* multiplication table */
{
extern  MATRIX  pm_sym;
MATRIX  sys_nlink();
MATRIX  p;
int     nx = MSIZE(src->ADDR);
BYTE   *si, *di, *zi;
int     cc, j, k, n, x;

p = sys_nlink(pm_sym, name, NULL, 0);
n = nx+1;
if (p == NULL || mkobj(p, 'T', 9*n, n))  return NULL;
si = TEXT_PTR(src);
di = TEXT_PTR(p);
memcpy(di+1, si, nx);
ss_strip_bits(di, n);
for (k = 2, di += n; k < 10; k++, di += n) {    /* src * 'k' */
    zi = di + n  - 1;
    si = TEXT_PTR(src) + nx - 1;
    for (cc = j = 0; j < nx; j++, si--, zi--) {
        x = cc + k * (*si & 0X0F);
        *zi =  x % 10;
        cc = x / 10;
        }
    *zi = cc;
    }
return p;
}

/* dst <- src % val */
ds_idiv(MATRIX dst, MATRIX src, int k, int *r, int qs)
{
BYTE   *si = TEXT_PTR(src);
int     nx = MSIZE(src->ADDR);
int     x  = si[0] & 0X0F;
BYTE   *di;
int     cc, n;

k = k & 0X0F;
n = nx - (k > x);
if (mkobj(dst, TYPT, n+qs, n+qs)) return ERROR;

di = TEXT_PTR(dst);
if (qs) *di++ = '-';

if (k > x) {
    cc = x;
    si++;
    nx--;
    }
else    cc = 0;

for (; 0 < nx--; di++, si++) {
    x = 10*cc + (*si & 0X0F);
    *di = '0' + x / k;
    cc  = x % k;
    }
*r = (qs) ? k-cc : cc;   /* remainder */
return OK;
}

/* Z<- BIGINT #mod INT32_VECTOR */

int     ds_vmod(MATRIX dst, MATRIX lo, MATRIX hi)
{
BYTE   *s  = TEXT_PTR(lo);
int     nc = MSIZE(lo->ADDR);
int    *iy = INT_PTR(hi);
int     n  = MSIZE(hi->ADDR);
BYTE   *t;
int     j, sgn = 0, z, *iz;
if (sasa(dst, hi)) return ERROR;
if ('-' == *s || '_' == *s) {s++; nc--; sgn = 1;}
for (iz = INT_PTR(dst); 0 < n--; iy++, iz++) {
    for (t = s, j = nc, z = 0; 0 < j--; t++) {
        z = (10 * z + (*t & 0X0F)) % *iy;
        }
    *iz = (z && sgn) ? *iy - z : z;
    }
return OK;
}

cpx_dya(dst, lo, hi)        /* complex arithmetic */
MATRIX dst;
MATRIX lo;
MATRIX hi;
{
int     op = MELSIZ(dst->ADDR);
BYTE   *s  = lo->ADDR;
int     dx = MTYPE(s);
int     nx = MSIZE(s);
BYTE   *t  = hi->ADDR;
int     dy = MTYPE(t);
int     ny = MSIZE(t);
int     den, dz, qx, qy, n, rc=0;
MATRIX  p;
int    *ix, *jx, *kx;
DOUBLE *zd, *xs, *ys;
DOUBLE  zden;

       /* null absorbs    X + NULL -> NULL */
if (nx == 0 || ny == 0) return ZILDE(dst);
if (MCOLS(s) !=2 || MCOLS(t) !=2)
    return sca_dya(op, dst, lo, hi);

n  = (nx > ny) ? nx : ny;
qx = nx > 2;
qy = ny > 2;
if (qx & qy & (nx != ny))  return op;   /* size error */

if (dx != dy || op == '%') {    /* float */
    if (dx == TYPN) rc = (fx_cvd(dst, lo) || sa_swap(lo, dst));
    if (dy == TYPN) rc = (fx_cvd(dst, hi) || sa_swap(hi, dst));
    if (rc) return ERR_MEM;
    dx = dy = TYPD;
    }

rc = (nx > ny) ? sasa(dst, lo) : sasa(dst, hi);
if (rc) return op;

if (dx == TYPN)         /* N+N->N */
    for (ix = INT_PTR(lo), jx = INT_PTR(hi), kx = INT_PTR(dst);
        0 < n && rc == 0; kx += 2, n -= 2) {
        switch (op) {
        default:
        case '+' : kx[0] = ix[0] + jx[0];       /* plus */
                   kx[1] = ix[1] + jx[1];
            break;
        case '-' : kx[0] = ix[0] - jx[0];       /* minus */
                   kx[1] = ix[1] - jx[1];
            break;
        case '*' : kx[0] = ix[0]*jx[0] - ix[1]*jx[1];   /* multiply */
                   kx[1] = ix[0]*jx[1] + ix[1]*jx[0];
            break;
            }
    if (qx) ix += 2;
    if (qy) jx += 2;
    }
else            /* D+D->D */
    for(xs = DBL_PTR(lo), ys = DBL_PTR(hi), zd = DBL_PTR(dst);
        0 < n; zd += 2, n -=2) {
        switch (op) {
        default:
        case '+' : zd[0] = xs[0] + ys[0];       /* plus */
                   zd[1] = xs[1] + ys[1];
            break;
        case '-' : zd[0] = xs[0] - ys[0];       /* minus */
                   zd[1] = xs[1] - ys[1];
            break;
        case '*' : zd[0] = xs[0]*ys[0] - xs[1]*ys[1];   /* multiply */
                   zd[1] = xs[0]*ys[1] + xs[1]*ys[0];
            break;
        case '%' : zden  = ys[0]*ys[0] + ys[1]*ys[1];   /* divide */
                   if (zden == 0.0) rc = op;
                   else {
                   zd[0] = (xs[0]*ys[0] + xs[1]*ys[1]) / zden;
                   zd[1] = (( -xs[0]*ys[1]) + xs[1]*ys[0]) / zden;
                   }
            break;
            }
    if (qx) xs+=2;
    if (qy) ys+=2;
    }
return rc;
}






