/* sed.c  editing functions  */

#include <htext.h>
#include <na.h>
#include <lex.h>
#include <d4str.h>

w_print (dst, idx, data)
MATRIX  dst;
MATRIX  idx;    /* window pointer */
MATRIX  data;
{
extern  MATRIX  na_idx();       /* nested array selector */
extern  SLIST   sl_movcur();
SLIST   sl_app();
extern  MATRIX  pm_ww;          /* window list */
MATRIX  wp;
SLBASE  base;
SLIST   t, x;
int     k;
int    *ww;

wp = na_idx(pm_ww, (idx == NULL ) ? ERROR : 4 * DS_IVAL(idx));
if (wp == NULL) return ERROR;
if (wp->ADDR == NULL && ww_init(wp, NULL)) return ERROR;

ww = WW_TXT(wp->ADDR);
base = LINK_PTR(wp+1);
t = sl_movcur(2, base, 0);      /* end of transcript */
if (t == NULL) t = (SLIST) base;
sl_app(t, data);                /* append to transcript */

for (k = S_LC(base), x = S_NEXT(t); x != NULL; x = S_NEXT(x)) {
     t = x;
     k++;
     }
S_LC(base) = k;
S_NOW(base) = t;
x = sl_movcur(1, base, -(ww[2]-1));
return  mkobj(dst, 'T', 0, 0);
}

sed(dst, lo, str)
MATRIX  dst;
MATRIX  lo;     /* window pointer */
MATRIX  str;    /* command list */
{
extern  MATRIX  na_idx();       /* nested array selector */
extern  MATRIX  pm_ww;          /* window list */
extern  MATRIX  pm_sym;         /* symbol table */
MATRIX  wp;
struct  SDESC   ss;
BYTE   *s;
int     n, rc;

wp = na_idx(pm_ww, (lo == NULL ) ? ERROR : 4 * DS_IVAL(lo));
if (wp == NULL) return ERROR;
if (wp->ADDR == NULL && ww_init(wp, NULL)) return ERROR;

if (str == NULL) {              /* R <- #sed .. edit */
    rc = ww_edit(wp, dst);
    return (mkik(dst, rc));
    }

n = MSIZE(str->ADDR);

if (n == 0) {   /* R<- #sed "" .. show */
    rc = ww_show(wp, dst);
    return mkik(dst, rc);
    }

ss.ADDR  = s = TEXT_PTR(str);
ss.SDLEN = n;

if (*s == 'X') {        /* do command list */
    ss.ADDR = ++s;
    ss.SDLEN = 0;
    n--;
    for (rc = 0; rc == 0 && 0 < n--; s++) {
        if (*s == ';') {
            rc = sed_cmd(dst, wp, &ss);
            ss.ADDR = s+1;
            ss.SDLEN = 0;
            }
        else ss.SDLEN++;
        }
    if (ss.SDLEN) rc = sed_cmd(dst, wp, &ss);
    }
else rc = sed_cmd(dst, wp, &ss);
return rc;
}

sed_cmd(dst, wp, str)
MATRIX  dst;    /* return object */
MATRIX  wp;     /* window pointer */
SLICE   str;    /* sub-command */
{
extern  char *lx_ctype;
SLIST   sl_app(), sl_movcur(), sl_join(), sl_push(), sl_replace(), sl_xs();
struct  SDESC sl_slice(), sx_match(), sx_subs();
MATRIX  sys_vget(), sys_hput();
extern  MATRIX  pm_sym;         /* symbol table */
MATRIX  ystr = WW_SFIND(wp);
SLBASE  base = LINK_PTR(wp+1);  /* transcript buffer */
SLBASE  scrap = base+1;         /* delete store */
SLIST   xnow = S_NOW(base);
BYTE   *ws = wp->ADDR;
int    *tag = WW_BLK(ws);       /* tagged block */
int     fc = *(str->ADDR);
MATRIX  obj;
SLIST   x;
struct  SDESC src, ss, rr, zz;
BYTE   *s, *t;
int     rc = fc;
int     qdel, k, n, tmode, sub_fc;

if (str->SDLEN == 0) return mkik(dst, 0);
else if (fc == 'N')
    return sed_xxstr(dst, wp, 1);       /* find, replace again */
else if (fc == '/' || fc == '[' || fc == ']' || fc == '|') fc = '/';
else {
    str->ADDR++;
    str->SDLEN--;
    if (fc == ':') return sed_xbuf(dst, wp, str);
    }

mk_sk(ystr, TYPT, str); /* copy to find buffer */
str->ADDR = TEXT_PTR(ystr);

if (fc == '/') return sed_xxstr(dst, wp, 0);

else if (fc == '$') {   /* fetch object */
    if (xnow == NULL) xnow = (SLIST) base;
    ss_trim(str);
    obj = sys_vget(pm_sym, str);
    rc = (obj == NULL || obj->ADDR == NULL ||
          NULL == sl_app(xnow, obj));
    return mkik(dst, rc);
    }

else if (fc == '@') {                   /* return text of line */
    ss_trim(str);
    if (str->SDLEN > 0) xnow = sl_movcur(0, base, lx_stoi(str));
    if (xnow == NULL) return mkik(dst, ERROR);
    src = sl_slice(xnow);
    if (str->SDLEN == 0) {  /* advance line */
        S_NOW(base) = S_NEXT(xnow);
        S_LC(base)++;
        }
    return mk_sk(dst, 'T', &src);
    }

else if (fc == '.' || fc == '+' || fc == '-') {
    rc = sed_movcur(fc, base, str);
    WW_CY(ws) = 0;
    return mkik(dst, rc);
    }

sub_fc = sed_slash(str->ADDR, str->SDLEN, &ss, &rr);

if (fc == 's' || fc == 'S')
    if (3 != (sub_fc & 3)) return ERROR;

if (fc == 'v' || fc == 'g')
    sub_fc |= SED_GLOBAL;

if (fc == 'v' || fc == 'g' || fc == 's')
    sed_cstr(1, &ss);       /* prepare string 1 */

if (fc == 's') sed_cstr(2, &rr);

if (sub_fc & SED_GLOBAL) {
    for (rc = 0, x = S_NEXT(base); x != NULL; x  = S_NEXT(x)) {
        src = sl_slice(x);
        n = (sub_fc & SED_ALL) ? src.SDLEN :1;
        switch(fc) {
            case 's':   /* global replace */
                while(n--) {
                    zz = sx_match(&src, &ss);
                    if (zz.SDLEN == 0) break;
                    zz = sx_subs(dst, &src, &zz, &rr);
                    x = sl_replace(x, &zz);
                    src = sl_slice(x);
                    rc++;
                    }
                break;
            case 'S':
                for (k = 0; n--;) {
                    k = sx_instr(&src, &ss, k);
                    if (k == ERROR) break;
                    zz.ADDR  = src.ADDR + k;
                    zz.SDLEN = ss.SDLEN;
                    zz = sx_subs(dst, &src, &zz, &rr);
                    k += rr.SDLEN;
                    x = sl_replace(x, &zz);
                    src = sl_slice(x);
                    rc++;
                    }
                break;
            case 'v':       /* filter lines not containing ss */
            case 'g':       /* filter lines containing ss */
                zz  = sx_match(&src, &ss);
                qdel = (fc == 'g')^(zz.SDLEN > 0);
                if (qdel) x = sl_xs(x);
                else rc++;
            default:
                break;
            }
        }
    S_NOW(base) = NULL;
    return mkik(dst, 0);
    }

/*  local functions */


xnow = S_NOW(base);
if (xnow == NULL) xnow = sl_movcur(0, base, 0);

switch (fc) {
    case 'D':   /* delete tagged block */
    case 'M':   /* move   tagged block */
    case 'C':   /* copy   tagged block */
        rc = sl_bloc(fc, wp+1, S_NOW(base), tag);
        break;
    case 'T':   /* tag current line */
        tmode = tag[0];
        if (tmode < 2) tag[1+tmode] = S_LC(base);
        else    tag[1] = tag[2] = -1;
        tag[0] = tmode = (tmode + 1) % 3;
        if (tmode == 2 && tag[1] > tag[2])
            {tmode = tag[2]; tag[2] = tag[1]; tag[1] = tmode;}
        return OK;
        break;
    case 'o':   /* cut tagged block */
        ss_trim(str);
        if (tag[0] != 2 || NULL == (obj = sys_hput(pm_sym, str))) break;
        obj += MCOLS(pm_sym->ADDR);
        if (NULL == obj->ADDR || TYPT == MTYPE(obj->ADDR))
            return sl_obj('V', obj, base, tag+1);
        break;
    case 'd':   /* delete a line */
        if (ss.ADDR == NULL) {
            S_NOW(base) = S_NEXT(xnow);
            sl_swap(scrap, xnow);
            }
        else while (xnow != NULL) {     /* delete to string 'ss' */
            src = sl_slice(xnow);
            if (ERROR != sx_instr(&src, &ss, 0)) break;
            S_NOW(base) = S_NEXT(xnow);
            sl_swap(scrap, xnow);
            xnow = S_NOW(base);
            }
        break;
    case 'p':   /* pop a line */
        if (S_NEXT(scrap) != NULL) {
            sl_swap(xnow, S_NEXT(scrap));
            S_NOW(base) = sl_movcur(0, base, S_LC(base));
            }
        break;
    case 'y':   /* yank a line */
        src = sl_slice(xnow);
        sl_push(scrap, &src);
        break;
    case 'j':   /* join with next line */
        S_NOW(base) = sl_join(xnow);
        break;
    case 'r':       /* replace line with text */
        S_NOW(base) = sl_replace(xnow, &ss);
        break;
    case 'i':
        S_NOW(base) = sl_push(xnow, &ss);
        S_LC(base)++;
        break;
    case 's': /* replace */
        src = sl_slice(xnow);
        for (zz.SDLEN = 1; zz.SDLEN > 0;) {
            zz  = sx_match(&src, &ss);
            if (zz.SDLEN > 0) {
                zz = sx_subs(dst, &src, &zz, &rr);
                xnow = sl_replace(xnow, &zz);
                if (0== (sub_fc|SED_ALL)) break;
                else src = sl_slice(x);
                }
            }
        S_NOW(base) = xnow;
        break;
    case 'S':   /* replace */
        src = sl_slice(xnow);
        for (k = 0; k != ERROR;) {
           k = sx_instr(&src, &ss, 0);
           if (k != ERROR) {
                zz.ADDR  = src.ADDR + k;
                zz.SDLEN = ss.SDLEN;
                zz = sx_subs(dst, &src, &zz, &rr);
                xnow = sl_replace(xnow, &zz);
                if (0== (sub_fc|SED_ALL)) break;
                else src = sl_slice(x);
                }
            }
        S_NOW(base) = xnow;
    default: break;
    }
return mkik(dst, rc);
}

/*      LINUX ... allow read and write via pipes */

sed_xbuf(dst, wp, str)  /* file and transcript functions */
MATRIX  dst;
MATRIX  wp;     /* window */
SLICE   str;    /* file or function codes */
{
extern  MATRIX  sys_hput();
extern  MATRIX  pm_sym;
SLBASE  base =  LINK_PTR(wp+1); /* transcript buffer */
SLIST   xnow;
MATRIX  name, p;
BYTE   *s, *t;
char   *fn;
int     fc = *(str->ADDR);
int     n, rc, qpipe;

if (fc == 'r' || fc == 'u' || fc == 'w' || fc == 'i') { /* make filename */
    str->ADDR++;
    if (mk_sk(dst, 'T', str)) return ERROR;
    str->ADDR = TEXT_PTR(dst);
    *(str->ADDR + str->SDLEN-1) = ' ';
    ss_trim(str);
    if (str->SDLEN <= 0) return ERROR;
    *(str->ADDR + str->SDLEN) = 0;
    fn = (char*) str->ADDR;
    qpipe = (fc == 'i' || fc == 'r') ? *fn == '<' : *fn == '|';
    if (qpipe)
        for (fn++; *fn && *fn == ' '; fn++);
    }

switch (fc) {
    case 'e':       /* edit */
        rc = ww_edit(wp, dst);
        return mkik(dst, rc);
    case 's':       /* show */
        rc = ww_show(wp, dst);
        return mkik(dst, rc);
    case 'p':   /* paragraph */
        ss_trim(str);
        n = lx_stoi(str);
        rc = sl_para(dst, base, base+1);
        if (rc == 0 && n > 0 && n < MAXLINE)
            rc = sl_fold(base, base+1, n);
        break;
    case 'c':   /* cut */
        fc = *++str->ADDR; /* want V or M */
        if (fc == 'm') fc = 'M';        /* M for matrix */
        return sl_cat(fc, dst, S_NEXT(base), NULL);
        break;
    case 'o':   /* cut as named object */
        str->ADDR++;
        str->SDLEN--;
        ss_trim(str);
        if (0 == str->SDLEN || NULL == (name = sys_hput(pm_sym, str)))
            return ERROR;
        fc = 'V';
        p = name + MCOLS(pm_sym->ADDR);
        if (p->ADDR && (MSIZE(p->ADDR) > MCOLS(p->ADDR))) fc = 'M';
        rc = sl_cat(fc, p, S_NEXT(base), NULL);
        return(mkik(dst, rc));
    case 'f':   /* create a function */
        if (mkobj(dst, 'A', 20, 20)) return ERROR;
        rc = na_catobj(pm_sym, S_NEXT(base), NA_PTR(dst));
        break;
    case 'i':   /* include a file */
        xnow = S_NOW(base);
        if (xnow == NULL) xnow = (SLIST) base;
        rc = (qpipe) ? sl_xget(xnow, fn) : sl_fget(xnow, fn);
        return mkik(dst, rc);
    case 'd':   /* delete buffer */
        if (str->SDLEN > 1 && ('t' == *(++str->ADDR))) {
            rc = sl_deltbl(base);
            break;
            }
    case 'q':
    case 'r':
        if(rc = sl_del(base)) return ERROR;
        if (fc == 'q' || fc == 'd') break;
        rc = (qpipe) ? sl_xget(base, fn) : sl_fget(base, fn);
        break;
    case 'u':
    case 'w':
        rc = (qpipe)
            ? sl_xput(base, fn, fc == 'u')
            : sl_fput(base, fn, fc == 'u');
        break;
    case 'b': /* break lines */
        rc = sl_xlate_nl(dst, base);
        break;
    default: rc = ERROR;
        break;
    }
S_LC(base)  = 0;
S_NOW(base) = S_NEXT(base);
return (rc) ? rc : mkik(dst, rc);
}

sed_xxstr(dst, wp, qnext)       /* do search and replace */
MATRIX  dst;            /* contains new string after replace */
MATRIX  wp;             /* window pointer */
int     qnext;          /* advance ? */
{
SLIST   sl_replace();
SLIST   sl_movcur();
struct  SDESC sl_slice();
struct  SDESC sx_subs();
BYTE   *ws = wp->ADDR;
MATRIX  xx = WW_DLINK(wp);
MATRIX  sp = WW_SFIND(wp);
SLBASE  base  = LINK_PTR(xx);   /* transcript */
BYTE   *s = sp->ADDR;
int     n = MSIZE(s);
struct  SDESC rr, ss, tt, zz;
SLIST   x, xnow;
BYTE   *t;
int     fc, dx, rc, cz;

if (s == NULL || n < 2) return OK;

s = TEXT_PTR(sp);
fc = sed_slash(s, n, &ss, &rr);
if (ss.SDLEN == 0) return 0;

dx = WW_HCUT(ws) + WW_CX(ws) + qnext;
x  = S_NOW(base);

for (n = 0, rc = -1; x != NULL; n++, x = S_NEXT(x)) {
    tt = sl_slice(x);
    rc = sx_instr(&tt, &ss , (n == 0) ? dx:  0);
    if (rc != -1) break;
    }

if (rc == -1) return 0;

/* find |xyz    or find |xyz ... |      */

WW_CX(ws) = rc;         /* column      */
sl_movcur(1, base, n);
WW_CY(ws) = 0;
if (fc < 3)  return 1;  /* done */

/* replace  |abc|xyz|   */

zz.ADDR  = tt.ADDR + rc;
zz.SDLEN = ss.SDLEN;
zz = sx_subs(dst, &tt, &zz, &rr);
S_NOW(base) = sl_replace(x, &zz);
return 1;
}

sed_movcur(fc, base, str)       /* move cursor */
int     fc;
SLBASE  base;
SLICE   str;
{
struct  SDESC sl_slice();
struct  SDESC sx_match();
SLIST   sl_movcur();
extern  char *lx_ctype;
struct  SDESC src, ss, tt, zz;
SLIST   xnow = S_NOW(base);
int     rc = S_LC(base);
int     cnt = 0;
int     num = 0;
int     k;

if (str->SDLEN == 0) return S_LC(base);
else k = *str->ADDR;

if (fc == '+') cnt = 1;
else if (fc == '-') cnt = -1;

if (k == 'z' || k == 'Z') xnow = sl_movcur(2, base, 0);
else if (LEX_ISDIGIT(k)) {
    num = lx_stoi(str);
    xnow = (cnt == 0) ? sl_movcur(0, base, num)
                      : sl_movcur(1, base, cnt * num);
    }
else {
    sed_slash(str->ADDR, str->SDLEN, &ss, &tt);
    sed_cstr(1, &ss);
    for (; xnow != NULL; rc++, xnow = S_NEXT(xnow)) {
        src = sl_slice(xnow);
        zz = sx_match(&src, &ss);
        if (zz.SDLEN > 0) {
             S_NOW(base) = xnow;
             S_LC(base) = rc;
             break;
             }
        }
    }
rc = (xnow == NULL) ? ERROR : S_LC(base);
return rc;
}
