/*      SL_SUPP.C Linked lists */

#include <na.h>
#define  CR     0X0D

SLIST   sl_movcur(fc, base, cnt)
int     fc;     /* function. 0:absolute  1:relative  2:end */
SLBASE  base;   /* transcript buffer */
int     cnt;    /* displacement */
{
SLIST   x, t;
int     k;

switch(fc) {
    default:
    case 0:     /* absolute */
        if (cnt < 0) cnt = 0;
        for (k = 0, x = S_NEXT(base); x != NULL; k++, x = S_NEXT(x))
            if (k == cnt) break;
        if (x == NULL) k = 0;
        break;
    case 1:     /* relative movement */
        k = S_LC(base);
        x = S_NOW(base);
        if (cnt > 0)
            for (; 0 < cnt-- && x != NULL; k++) x = S_NEXT(x);
        else if (cnt < 0) {
            for(cnt = - cnt; x != NULL && 0 < cnt--; k--) {
                x = S_PREV(x);
                if (S_TYPE(x) != TYPLS) x = NULL;
                }
            }
        break;
    case 2:     /* end */
        x = NULL;
        for (k = 0, t = S_NEXT(base); t != NULL; k++, t = S_NEXT(t))
            x = t;
        if (k > 0) k--;
        break;
        }
S_NOW(base) = x;
if (x == NULL) k = 0;
S_LC(base) = k;
if (k == 0) S_NOW(base) = S_NEXT(base);
return x;
}

SLIST   sl_join(cur)    /* join two lines */
SLIST   cur;            /* cur, NEXT(cur) */
{
SLIST sl_push(), sl_xs();
SLIST   x, next;
struct  SDESC  ss;
BYTE   *t = NULL;
if (cur == NULL || NULL == (next = S_NEXT(cur)))
    return cur;   /* do nothing */
if (0 == S_LEN(cur)) return sl_xs(cur);
if (0 == S_LEN(next)) {
    sl_xs(next);
    return cur;
    }
ss.ADDR = S_TEXT(cur);
ss.SDLEN = S_LEN(cur) + S_LEN(next);
x = sl_push(cur, &ss);
memcpy(S_TEXT(x)+S_LEN(cur), S_TEXT(next), S_LEN(next));
sl_xs(cur);
sl_xs(next);
return x;
}

SLIST   sl_break(cur, k)   /* break into two lines at k */
int     k;
SLIST   cur;    /* cur, NEXT(cur) */
{
SLIST   sl_push(), sl_xs();
struct SDESC sl_slice();
SLIST   x;
struct  SDESC  ss, tt;
ss = sl_slice(cur);
if (k > ss.SDLEN) k = ss.SDLEN; /* this is valid */
tt.ADDR = ss.ADDR;
tt.SDLEN = k;
x = sl_push(cur, &tt);   /* left */
tt.ADDR  += k;
tt.SDLEN = ss.SDLEN - k;
x = sl_push(x, &tt);    /* right */
sl_xs(cur);             /* delete split line */
return x;
}

sl_obj(fc, dst, base, ix)       /* extract block */
int     fc;     /* function */
MATRIX  dst;
SLIST   base;   /* base pointer */
int    *ix;     /* block specifier */
{
SLIST   sl_movcur();
SLIST   xnow = S_NOW(base);
SLIST   x, y;
int     cx = S_LC(base);
x = sl_movcur(0, base, ix[0]);
y = sl_movcur(0, base, ix[1]);
S_LC(base) = cx;
S_NOW(base) = xnow;
return sl_cat(fc, dst, x, y);
}

sl_cat(fc, dst, start, last)   /* concatenate slices */
int  fc;        /* function code */
MATRIX dst;     /* text object */
SLIST start;    /* start of linked list */
SLIST last;     /* last item to use. can be NULL */
/*
        return value: OK or ERROR
*/
{
SLIST x;
int  n;         /* size of block */
int  nr, nc;    /* rows, columns */
BYTE *t;
if (dst == NULL) return ERROR;
switch(fc) {
    case 'V':   /* vector -- delimit with NL characters */
    default:
        for (nr = 1, nc = 0, x = start;; x = S_NEXT(x)) {
            if (x != NULL) nc += S_LEN(x);
            if (x == last || x == NULL) break;
            nc++;
            }
        break;
    case 'M':       /* matrix, or box */
        nr = nc = 0;
        for (x = start; x != NULL; x = S_NEXT(x)) {
            n = S_LEN(x);
            if (n > nc) nc = n;
            nr++;
            if (x == last) break;
            }
        break;
        }

if (mkobj(dst, 'T', nr * nc, nc)) return ERROR;
t = TEXT_PTR(dst);
switch(fc) {
    case 'V':   /* vector */
    default:
        for   (x = start; x != NULL; x = S_NEXT(x)) {
            if (0 < S_LEN(x)) memcpy(t, S_TEXT(x), S_LEN(x));
            t += S_LEN(x);
            if (x == last) break;
            *t++ = CR;         /* newline */
            }
        break;
    case 'M':   /* matrix, box */
        for (x = start; x != NULL; x = S_NEXT(x), t += nc) {
            if (0 < S_LEN(x)) memcpy(t, S_TEXT(x), S_LEN(x));
            if (x == last) break;
            }
        break;
        }
return OK;
}

SLIST   sl_app(dst, src)        /* insert object */
SLIST   dst;            /* pointer to collect data */
MATRIX  src;            /* object -- text data, nested array */
{
extern  SLIST  sl_push();
BYTE   *s = src->ADDR;
struct  SDESC tt;
MATRIX  p;
int     fc, n, nc, nr;

if (s == NULL) return NULL;
fc = MTYPE(s);
n =  MSIZE(s);
nc = MCOLS(s);

switch (fc) {
    case TYPA:
        if (MELSIZ(s) == TYPU) nc = 1;
        for (p = NA_PTR(src); dst != NULL && 0 < nc--; p++)
            if (p->ADDR != NULL) dst = sl_app(dst, p);
        break;
    case TYPI:
    case TYPT:
        tt.ADDR  = TEXT_PTR(src);
        if (n == 0 || nc == 0) {
            tt.SDLEN = 0;
            return sl_push(dst, &tt);
            }
        else if (n == nc) {     /* vector */
            for (s = tt.ADDR, tt.SDLEN = 0; 0 < n--; s++)
                if (CR == *s) {
                    dst = sl_push(dst, &tt);
                    tt.ADDR = s+1;
                    tt.SDLEN = 0;
                    }
                else    tt.SDLEN++;
            if (tt.SDLEN > 0) dst = sl_push(dst, &tt);
            }
        else    /* matrix */
            for(tt.SDLEN = nc, nr = n / nc; 0 < nr--; tt.ADDR += nc)
                dst = sl_push(dst, &tt);
        break;
    default: dst = NULL;
        break;
    }
return dst;
}

SLIST   sl_place(base, idx)
SLIST   base;           /* TYPLB object */
int     idx;            /* offset */
{
extern  SLIST  sl_push();
SLIST   x, z;
struct  SDESC tt;
if (TYPLB != S_TYPE(base)) return NULL;
if (idx < 0) return NULL;
NUL_STR(&tt);
for (x = base, idx++; 0 < idx--;) {
        z = S_NEXT(x);
        if (z == NULL) x = sl_push(x, &tt);
        else x = z;
        }
return x;               /* list[idx] exists */
}

/* sl_slice .. similar to line input */

struct SDESC sl_slice(src)
SLIST   src;
{
struct SDESC tt;
NUL_STR(&tt);
if (src != NULL && TYPLS == S_TYPE(src)) {
        tt.ADDR  = S_TEXT(src);
        tt.SDLEN = S_LEN(src);
        }
return tt;
}

/* sl_swap      use in delete and insert */

sl_swap(dst, src)
SLIST   dst;    /* insert here -- normally base. */
SLIST   src;    /* delete from here */
{
SLIST   next, prev;
if (dst == NULL || src == NULL) return ERROR;
if  ((TYPLS != S_TYPE(dst) && TYPLB != S_TYPE(dst))
    ||TYPLS != S_TYPE(src)) {
     return ERROR;
     }
prev = S_PREV(src);     /* delete src */
next = S_NEXT(src);
S_NEXT(prev) = next;
if (next != NULL) S_PREV(next) = prev;

next = S_NEXT(dst);     /* insert after dst */
S_NEXT(dst) = src;
S_PREV(src) = dst;
S_NEXT(src) = next;
if (next != NULL) S_PREV(next) = src;
return OK;
}

sl_bloc(fc, xx, cur, ix)        /* block operations */
int     fc;     /* function */
MATRIX  xx;     /* linked list  */
SLIST   cur;    /* current pointer */
int    *ix;     /* block specifier */
{
struct  SDESC  sl_slice();
SLIST   sl_movcur();
SLIST   sl_push();
SLBASE  base = LINK_PTR(xx);    /* no validation */
SLBASE  scrap = base+1;
SLIST   x, next, prev;
struct  SDESC  ss;
int     n = ix[2]-ix[1]+1;
int     i;
int     cz = S_LC(base);
if (ix[0] != 2 || n < 1) return 0;      /* no op */
x = sl_movcur(0, base, ix[1]);
if (x == NULL) return 1;
switch(fc) {
    case SL_DEL:        /* delete to scrap */
        if(0 < (cz = ix[1])) cz--;
    case SL_MOV:        /* move */
        for (i = n; 0 < i--;) {
            next = S_NEXT(x);
            sl_swap(scrap, x);
            x = next;
            }
        if (fc == SL_DEL) break;
        for(i = n; 0 < i--;) sl_swap(cur, S_NEXT(scrap));
        break;
    case SL_CPY:    /* copy */
        for (i = n; 0 < i--; x = S_NEXT(x), cur = S_NEXT(cur)) {
           ss = sl_slice(x);
           sl_push(cur, &ss);
           }
        break;
        }
if (fc != SL_CPY) {
    ix[0] = 0;      /* reset */
    ix[1] = ix[2] = -1;
    }
S_LC(base) = cz;
return 1;
}

sl_para(sp, src, tmp)   /* paragraph => long line */
MATRIX  sp;
SLIST   src;    /* text to format */
SLIST   tmp;    /* scrap */
{
struct  SDESC sl_slice();
SLIST   sl_push();
SLIST   x, y;
struct  SDESC ss, tt;
int     nc = MAXLINE;
int     k;

if (sl_del(tmp) || mkobj(sp, 'T', nc, nc)) return ERROR;
tt.ADDR  = TEXT_PTR(sp);
tt.SDLEN = 0;
for(k = 0, y = tmp, x = S_NEXT(src); x != NULL; k++, x  = S_NEXT(x)) {
    ss = sl_slice(x);
    ss_rtrim(&ss);
    if (tt.SDLEN == 0 ||
        ss.SDLEN == 0 ||
        ' ' == *ss.ADDR ||
        '<' == *ss.ADDR ||              /* html tag */
        nc < 1+ss.SDLEN+tt.SDLEN ) {    /* new paragraph */
        if (k > 0) y = sl_push(y, &tt);
        if (0 < ss.SDLEN) memcpy(tt.ADDR, ss.ADDR, ss.SDLEN);
        tt.SDLEN = ss.SDLEN;
        }
    else {
        if (0 < tt.SDLEN) tt.ADDR[tt.SDLEN++] = ' ';
        if (0 < ss.SDLEN) memcpy(tt.ADDR+tt.SDLEN, ss.ADDR, ss.SDLEN);
        tt.SDLEN += ss.SDLEN;
        }
    }
if (k > 0) y = sl_push(y, &tt);
sl_del(src);
y = S_NEXT(tmp);
S_NEXT(src) = y;
S_PREV(y)   = src;
S_NEXT(tmp) = NULL;
return OK;
}

sl_fold(src, tmp, nc)   /* fold long lines */
SLIST   src;    /* text to format */
SLIST   tmp;    /* scrap */
int     nc;     /* width */
{
struct  SDESC sl_slice();
SLIST   sl_spush();
SLIST   x, y;
struct  SDESC tt;

if (sl_del(tmp)) return ERROR;
for(y = tmp, x = S_NEXT(src); x != NULL; x  = S_NEXT(x)) {
    tt = sl_slice(x);
    y = sl_spush(y, &tt, nc);
    }
sl_del(src);
y = S_NEXT(tmp);
S_NEXT(src) = y;
S_PREV(y)   = src;
S_NEXT(tmp) = NULL;
return OK;
}

SLIST   sl_spush(dst, src, nc)
SLIST   dst;    /* place */
SLICE   src;    /* paragraph */
int     nc;     /* page width */
{
BYTE   *s  = src->ADDR;
int     n  = src->SDLEN;
SLIST   sl_push();
struct  SDESC ss;
int     cnt, k;
BYTE   *t;

if (n == 0) dst = sl_push(dst, src);
else for (cnt = 0; n > 0; cnt++) {
    if (n > nc) for (k=nc, t = s+k; k > 0 && *t != ' '; t--) k--;
    else k = n;
    if (k == 0) k = nc;    /* cut long words */
    ss.ADDR = s;
    ss.SDLEN = k;
    if (cnt > 0) ss_trim(&ss);
    dst = sl_push(dst, &ss);
    s += k;
    n -= k;
    }
return dst;
}

sl_xlate_nl(sp, src)    /* translate newlines */
MATRIX  sp;
SLIST   src;    /* text to format */
{
struct  SDESC sl_slice();
SLIST   sl_app(), sl_xs();
SLIST   x;
struct  SDESC ss;

for(x = S_NEXT(src); x != NULL;) {
    ss = sl_slice(x);
    mk_sk(sp, TYPT, &ss);
    x = sl_xs(x);
    x = sl_app(x, sp);
    x = S_NEXT(x);
    }
return OK;
}

sl_deltbl(base)  /*delete trailing blank lines */
SLBASE  base;
{
SLIST   sl_xs();
SLIST   t = S_NEXT(base);
SLIST   x = NULL;

for (; t != NULL; t = S_NEXT(t)) x = t; /* goto end */
while (x != NULL) {
    if (S_TYPE(x) != TYPLS || ! allblank(S_TEXT(x), S_LEN(x))) break;
    x = sl_xs(x);                       /* delete blank lines */
    }
return OK;
}
