/*      socket routines

        X<-(HOST, PORT) #socket N, {mode} open socket

        X<- "" #socket N  or X<- #socket N      close

        D<-$SOCKET[N]           read from socket
        $SOCKET[N]<-DATA        write to socket
*/

#include <na.h>
#include <dt.h>
#include <netinet/in.h>

/* UDP ports for communication. default values */

#define SERVER_PORT     55555
#define CLIENT_PORT     55556
#define S_WRITE         3
#define S_READ          1

typedef struct {        /* save socket info */
        int     mode;
        BYTE    host[4];
        int     port;
        int     fd;
        } SFD;

#define  SFD_IDX(X,I)    ((SFD*)(((X)->ADDR)+HDSIZE))+(I)

set_sockets(dst, num)   /* initialise socket table */
MATRIX  dst;
int     num;
{
int     n = num * sizeof(SFD);
int     rc;
rc = mkobj(dst, 'T', n, sizeof(SFD));
if (rc == 0) memset(TEXT_PTR(dst), 0, n);
return rc;
}

/*      fx_socket
        open    R <- host, {port}  #socket n  {mode}
        close   R <- ""   #socket n
*/

fx_socket(dst, lo, hi)  /* socket functions */
MATRIX  dst;            /* result */
MATRIX  lo;             /* host */
MATRIX  hi;             /* number, mode */
{
extern  MATRIX  pm_sock;
int    *ix  = INT_PTR(hi);      /* sock_num, mode */
SFD    *my_sfd;
int     mode, port, rc;
int     nc  = MSIZE(lo->ADDR);
int     fd;
int    *iy = INT_PTR(lo);       /* four bytes */
char    addr[4];
struct sockaddr_in saddr;

if (ix[0] < 0  || ix[0] >= SOCK_MAX) return ERROR;
my_sfd = SFD_IDX(pm_sock,ix[0]);
if (nc == 0) { /* close socket */
    rc = 0;
    if (my_sfd->mode) {
        my_sfd->mode = 0;
        rc = close (my_sfd->fd);
        }
    return mkobj(dst, rc);
    }
else if (my_sfd->mode != 0) return ERROR;       /* busy */
my_sfd->host[0] = iy[0];        /* convert to bytes */
my_sfd->host[1] = iy[1];
my_sfd->host[2] = iy[2];
my_sfd->host[3] = iy[3];

mode = (MSIZE(hi->ADDR) > 1) ? ix[1] : S_READ;
my_sfd->port = (mode == S_WRITE) ? SERVER_PORT : CLIENT_PORT;

    if (0 > (fd = socket(PF_INET, SOCK_DGRAM, 0))) return ERROR;
    saddr.sin_family = AF_INET;
    saddr.sin_port = htons(my_sfd->port);
    saddr.sin_addr.s_addr = *((unsigned long *) my_sfd->host);
    if (0 > (rc = bind(fd, &saddr, sizeof(saddr)))) {
        close(fd);
        return ERROR;
        }
my_sfd->mode = mode;
my_sfd->fd   = fd;
return mkik(dst, rc);
}

read_socket(dst, hi)
MATRIX dst;     /* result */
MATRIX hi;      /* socket number */
{
extern  MATRIX  pm_sock;
int    *ix   = INT_PTR(hi);
int     size = ix[1];
int     nc, rc;
SFD    *my_sfd;
struct sockaddr_in saddr;
socklen_t saddrlen = sizeof(saddr);

if (ix[0] < 0  || ix[0] >= SOCK_MAX) return ERROR;
my_sfd = SFD_IDX(pm_sock, ix[0]);

memset(&saddr, 0, saddrlen);

rc = mkobj(hi, 'T', size, size);

nc = recvfrom(my_sfd->fd, TEXT_PTR(hi), size, 0,
              (struct sockaddr *)&saddr, &saddrlen);

if (nc < 0) return ERROR;
rc = mkobj(dst, 'T', nc, nc);
if (rc == 0 && nc > 0) memcpy(TEXT_PTR(dst), TEXT_PTR(hi), nc);
return rc;
}

/*      $SOCKET[num, addr1, addr2, addr3, addr4]<-DATA */

write_socket(dst, data, hi)
MATRIX dst;     /* result */
MATRIX data;    /* data */
MATRIX hi;      /* socket number + destination */
{
extern  MATRIX  pm_sock;
int    *ix  = INT_PTR(hi);      /* sock_num, mode */
int     cnt, rc;
BYTE    addr[4];    /* four bytes */
SFD    *my_sfd;
struct sockaddr_in saddr;

if (ix[0] < 0  || ix[0] >= SOCK_MAX) return ERROR;
my_sfd = SFD_IDX(pm_sock, ix[0]);
    addr[0] = ix[1];    /* destination address */
    addr[1] = ix[2];
    addr[2] = ix[3];
    addr[3] = ix[4];

    memset(&saddr, 0, sizeof(saddr));
    saddr.sin_family = AF_INET;
    saddr.sin_port = htons(CLIENT_PORT);
    saddr.sin_addr.s_addr = *((unsigned long *) addr);

    cnt = sendto(my_sfd->fd, TEXT_PTR(data), MSIZE(data->ADDR), 0,
            (struct sockaddr *) &saddr, sizeof(saddr));

return mkik(dst, cnt);
}

sockstat(dst)   /* return socket table */
{
extern  MATRIX  pm_sock;
return sasa(dst, pm_sock);
}

