
#include <na.h>
#define CR      0X0D
#define LF      0X0A

#define DS_CVAL(X)      (*(TEXT_PTR(X)))

/*  ALLBLANK  */

allblank(s,n)   /* test for string == BLANK */
BYTE *s;
int n;
{
while (n--) if (' ' != *s++) return 0;
return 1;
}

lset(dst, src)          /* LSET S$ = D$ */
SLICE dst, src;
{
int n;
if (dst == NULL || dst->ADDR == NULL || src == NULL)
        return (ERROR);
n = src->SDLEN;
memset(dst->ADDR, ' ', dst->SDLEN);
if (NULL == src->ADDR || n == 0) return(OK);
if (n > dst->SDLEN) n = dst->SDLEN;       /* truncate */
memcpy(dst->ADDR, src->ADDR, n);
return(OK);
}

ss_trim(ss)             /* trim blanks */
SLICE ss;               /* descriptor */
{
BYTE *t = ss->ADDR;
BYTE *tmax;
if(t == NULL || 0 == ss->SDLEN)
        return(ERROR);
/*      Leading blanks */
for(tmax = t + ss->SDLEN -1; ' ' == *t && t <= tmax ; t++) {
        ss->SDLEN--;
        ss->ADDR++;
        }
/*      Trailing blanks */
for(t = tmax; ' ' == *t && t > ss->ADDR; t--)
        ss->SDLEN--;
return(OK);
}

/*      TRAILING BLANKS */

ss_rtrim(ss)            /* trim trailing blanks */
SLICE ss;               /* descriptor */
{
BYTE *t = ss->ADDR;
int   n = ss->SDLEN;
if(t == NULL || 0 == n) return(ERROR);
for(t += (n-1); ' ' == *t && t >= ss->ADDR; t--) ss->SDLEN--;
return(OK);
}

/*  VFILL     */

vfill(xx, val)          /* fill out string */
struct SDESC *xx;
char val;
{
if (xx->SDLEN != 0) memset(xx->ADDR, val, xx->SDLEN);
return(0);
}

/*  VFLIP     */

vflip(xx)               /* reverse a character vector in situ */
SLICE xx;
{
BYTE *s,*t;
char c;
if (NULL == xx) return (ERROR);
else if (NULL == (s = xx->ADDR))
        return (OK);
t = xx->ADDR + xx->SDLEN -1;
while (t > s) {          /* do it by transpositions */
        c = *t;
        *t-- = *s;
        *s++ = c;
        }
}

/*      search and replace */
/*      return -1 or position of match */

sx_instr(src, key, dx)
SLICE   src;    /* string */
SLICE   key;    /* search for this */
int     dx;     /* offset */
{
BYTE   *s = src->ADDR + dx;
int     n = src->SDLEN - dx;
BYTE   *t = key->ADDR;
int     m = key->SDLEN;
BYTE   *x, *y;
int     c = t[0], k;

if (n < m) return ERROR;
else if (m == 0) return 0;

for(k = m; k > 0 && n--;) if (*s++ == c) {  /* compare tail */
    for (k = m - 1, x = s, y = t + 1; k && *x++ == *y++; k--);
    }
return (k == 0) ? (s - src->ADDR) - 1 : -1;
}

char *mkasciz(src)      /* make string -- return NULL for zero length */
MATRIX src;             /* matrix */
{
extern BYTE *malloc();
BYTE   *s = src->ADDR;
int     n  = MSIZE(s);
char   *dst;
if (s == NULL || n == 0) return NULL;
dst = malloc (n+1);
memcpy(dst, s + HDSIZE, n);
dst[n] = 0;     /* ASCIZ string */
return dst;
}

/*      DSCCYC  */

dsccyc(dst, src)        /* cyclic fill op */
SLICE   dst;            /* allocated area */
SLICE   src;            /* slice */
{
BYTE *t  = dst->ADDR;
BYTE *s  = src->ADDR;
int m    = dst->SDLEN;
int n    = src->SDLEN;
for (; m > 0; m--, n--) {
        if (0 == n) {
                n = src->SDLEN;
                s = src->ADDR;
                }
        *t++ = *s++;
        }
return OK;
}

iv_a(dst, src, fw, cnt) /* Formats integer vector */
BYTE *dst;              /* Must allocate fw * cnt bytes */
int  *src;              /* Numeric list */
int   fw;               /* field width */
int   cnt;              /* Size of source */
{
struct SDESC tt;
for(tt.ADDR = dst, tt.SDLEN = fw; 0 < cnt--; src++, tt.ADDR += fw)
        ito_slice(&tt, *src);
return OK;
}

/*      USING   */

ss_using(src, val)
SLICE   src;
int    *val;
{
BYTE   *s = src->ADDR;
int     n = src->SDLEN;
int     mode, nv;
struct SDESC tt;
for (nv = mode = 0; 0 < n--; s++)
        switch(2 * mode + ('#' == *s)) {
        case 0: break;
        case 1: tt.ADDR  = s;   /* start */
                tt.SDLEN = 1;
                mode = 1;
                break;
        case 2:                 /* format */
                ito_slice(&tt, val[nv++]);
                mode = tt.SDLEN = 0;
                break;
        case 3: tt.SDLEN++;
                break;
        }
if (tt.SDLEN)   ito_slice(&tt, val[nv++]);
return nv;
}

/*      INT TO SLICE */

ito_slice(xx, val)      /* format integer */
SLICE xx;               /* place          */
int val;                /* value          */
{
int   n = xx->SDLEN;
BYTE *s = xx->ADDR + n - 1;
int  sn = (val < 0) ? -1 : 1;
if (val == 0) *s-- = '0';
else for (val = sn * val; n > 0 && val > 0; s--, n--) {
        *s = (val%10) + '0';
        val = val/10;   /*  right justify */
        }
if (s >= xx->ADDR &&  sn < 0) *s-- = '-';
while (s >= xx->ADDR) *s-- = ' ';
return OK;
}

/*  SSTOMAT   */

sstomat(dst, cc, src)   /* DST <- { c } SStoMAT SRC */
MATRIX dst;             /* a matrix */
MATRIX cc;              /* if null, take first char of src */
MATRIX src;             /* delimited string */
{
int     n, delim;
BYTE   *s;
struct SDESC ss;
if (src == NULL || NULL == (s = src->ADDR) || TYPT != MTYPE(s))
        return ERROR;
n = MSIZE(s);
if (n == 0) return mkobj(dst, 'T', 0, 0);
ss.ADDR  = TEXT_PTR(src);
ss.SDLEN = n;
if (cc != NULL) delim = DS_CVAL(cc);
else {
        delim = *(ss.ADDR);
        ss.ADDR++;
        ss.SDLEN--;
        }
return ss_mat(dst, &ss, delim);
}

ss_mat(dst, src, k)     /* DST <- SStoMAT SRC */
MATRIX  dst;            /* a matrix */
SLICE   src;            /* delimited string */
int     k;
{
BYTE   *s = src->ADDR;
BYTE   *t, *z;
int     n = src->SDLEN;
int     cnt, nr, nc;
struct SDESC tt;
for (cnt = nr = nc = 0; 0 < n--; s++)
        if (k == *s) {
                nr++;
                if (cnt > nc) nc = cnt;
                cnt = 0;
                }
        else    cnt++;
if (cnt > 0) {
        nr++;
        if (cnt > nc) nc = cnt;
        }
/*      pass 2 -- copy data */
if (mkobj(dst, 'T', nr * nc, nc)) return ERROR;
t = TEXT_PTR(dst);
s = src->ADDR;
for (n = src->SDLEN, z = s, cnt = 0; 0 < n--; s++)
        if (k == *s) {
                memcpy(t, z, cnt);
                t  += nc;
                z = s+1;
                cnt = 0;
                }
        else    cnt++;
if (cnt > 0) memcpy(t, z, cnt);
return OK;
}

/*  MATTOSS  */

mattoss(dst, cc, src)   /* vector <- file(matrix) */
MATRIX dst;             /* destination .. untyped string */
MATRIX cc;              /* if null, use CR */
MATRIX src;             /* object of matrix type */
{
int     rc;
int     delim = CR;
int     cnt, i, k, n, nr, nc;
BYTE   *s, *t, *z;
if (src == NULL || NULL == (s = src->ADDR) || TYPT != MTYPE(s))
        return ERROR;
n = rho(src, &nr, &nc);
if (n == 0 || nr == 1) return sasa(dst, src);
if (cc != NULL) delim = DS_CVAL(cc);
s = TEXT_PTR(src);
/*      trim lines, and compute size */
for (cnt = 0, i = nr; 0 < i--; s += nc) {
        for (z = s + (k = nc); z > s && ' ' == *--z; k--);
        cnt += 1 + k;
        }
if (mkobj(dst, 'T', cnt, cnt)) return ERROR;
/*      copy the data */
s = TEXT_PTR(src);
t = TEXT_PTR(dst);
for(i = nr; 0 < i--; s += nc) {
        *t++ = delim;
        for (z = s + (k = nc); z > s && ' ' == *--z; k--);
        memcpy(t, s, k);
        t += k;
        }
return OK;
}
