/* strstr.c  .. string match functions */

#include <htext.h>
#include <na.h>
#include <fdata.h>
#include <d4str.h>

sed_slash(s, n, ss, rr) /* extract one or more strings */
BYTE   *s;
int     n;
SLICE   ss;
SLICE   rr;
{
int     nsep, cnt;
int     sep = *s;
int     fc = 0;

ss->ADDR  = NULL;
ss->SDLEN = 0;
if (n == 0) return 0;
else if (sep == ' ') {
     ss->ADDR  = s+1;
     ss->SDLEN = n-1;
     ss_rtrim(ss);
     return 0;
     }

for (nsep = 0; 0 < n-- && nsep < 3; s++)
    if(*s != sep) cnt++;
    else switch (nsep++) {
        case 0: ss->ADDR = s+1;
            cnt = 0;
            break;
        case 1: rr->ADDR = s+1;
            ss->SDLEN = cnt;
            cnt = 0;
            break;
        case 2: rr->SDLEN = cnt;
            break;
            }

if (nsep == 1) ss->SDLEN = cnt;
else if (nsep == 3) {
    for (n++; 0 < n--; s++) switch(*s) {
        case '*':  fc |=12;
            break;
        case 'g':  fc |= 8;
            break;
        case 'a':  fc |= 4;
        default: break;
        }
    }
return nsep|fc;
}

struct  SDESC sx_match(src, key)
SLICE   src;    /* string */
SLICE   key;    /* search for this */
{
BYTE   *s = src->ADDR;
BYTE   *t;
struct  SDESC zz, kk;
int     c, cnt, m, n, qb, x, xp;

t = kk.ADDR  = key->ADDR;
m = kk.SDLEN = key->SDLEN;
s = src->ADDR;
zz.SDLEN = 0;
zz.ADDR  = s;
n =  src->SDLEN;
if (n < m) return zz;
xp =  0;
qb =  1;
for (cnt = 0, c = CC_NEXT(s, n), x = CC_NEXT(t, m); x != 0 && c != 0;) {
    if (x  == 0) break;
    if (x == IS_REP) {
        xp = *(t-2);
        if (xp == IS_ANY) {
            kk.ADDR  = t-2;
            kk.SDLEN = m+2;
            qb = 0;
            }
        x  = CC_NEXT(t, m);
        }
    if (x == 0) break;
    else if (c == x || x == IS_ANY) {
        cnt++;
        xp = 0;
        }
    else if (c == xp || xp == IS_ANY) cnt++;
    else {      /* compare substring again */
        m = kk.SDLEN;
        t = kk.ADDR;
        if (qb) cnt = 0; else cnt++;
        }
    if (xp == 0) x = CC_NEXT(t, m);
    c = CC_NEXT(s, n);
    }
if (x == 0) {
    zz.ADDR = s-cnt-(c != 0);
    zz.SDLEN = cnt;
    if (qb == 0 && *(t-1)==IS_REP)      /* .* -> rest of line */
        zz.SDLEN = src->ADDR + src->SDLEN - zz.ADDR;
    }
return zz;
}

sed_cstr(fc, ss)
int     fc;     /* 1 for search, 2 for replace */
SLICE   ss;     /* string */
{
BYTE   *s = ss->ADDR;
int     n = ss->SDLEN;
BYTE   *t;
int     c;

switch (fc) {
    default:
    case 1:     /* search string */
        for (t = s; 0 < n; --n, s++) {
            c = *s;
            if (c == '.')      c = IS_ANY;
            else if (c == '*') c = IS_REP;
            else if (c == IS_ESC) {
                if (0 == --n) break;
                c = *++s;
                if      (c == 'r') c = CR;
                else if (c == 'n') c = LF;
                else if (c == 't') c = HTAB;
                else if (c == 'b') c = BS;
                }
            *t++ = c;
            }
        break;
    case 2:     /* replace string */
        for (t = s; 0 < n; --n, s++) {
            c = *s;
            if (c == '&')      c = IS_DUP;
            else if (c == IS_ESC) {
                if (0 == --n) break;
                c = *++s;
                if      (c == 'r') c = CR;
                else if (c == 'n') c = LF;
                else if (c == 't') c = HTAB;
                else if (c == 'b') c = BS;
                }
            *t++ = c;
            }
        break;
        }
ss->SDLEN = t-ss->ADDR;
return ss->SDLEN;
}

struct  SDESC   sx_subs(dst, src, str, rr)
MATRIX  dst;
SLICE   src;    /* source */
SLICE   str;    /* string to replace */
SLICE   rr;     /* replacement */
{
struct  SDESC   zz;
BYTE   *s, *t;
int     cnt = src->SDLEN - str->SDLEN;
int     j, m, n;

zz.ADDR = NULL;
zz.SDLEN = 0;

for (t = rr->ADDR, m = rr->SDLEN; 0 < m--; t++)
    cnt += (*t == IS_DUP) ? str->SDLEN : 1;

if (mkobj(dst, 'T', cnt, cnt)) return zz;
zz.ADDR  = t = TEXT_PTR(dst);
zz.SDLEN = cnt;

for (s = src->ADDR; s < str->ADDR; s++) *t++ = *s;
for (s = rr->ADDR, m = rr->SDLEN; 0 < m--; s++) {
    if (*s == IS_DUP) {
        memcpy(t, str->ADDR, str->SDLEN);
        t += str->SDLEN;
        }
    else *t++ = *s;
    }
for (s = str->ADDR + str->SDLEN; s < src->ADDR + src->SDLEN; s++)
    *t++ = *s;
return zz;
}

rx_find(dst, key, src)  /* string search */
MATRIX  dst;    /* result -- (start, length) */
MATRIX  key;    /* find string with 'regular expressions' */
MATRIX  src;    /* data to scan  */
{
struct  SDESC   sx_match();
struct  SDESC   ss, tt, zz;
BYTE   *s, *t;
int     c, n, *ix;

if (MTYPE(key->ADDR) != TYPT ||
    MTYPE(src->ADDR) != TYPT)
        return ERROR;

tt.ADDR  = TEXT_PTR(key);
tt.SDLEN = MCOLS(key->ADDR);

sed_cstr(1, &tt);       /* interpret escape characters */

ss.ADDR  = TEXT_PTR(src);
ss.SDLEN = MSIZE(src->ADDR);

zz  = sx_match(&ss, &tt);

if (mkobj(dst, 'N', 2, 2)) return ERROR;

if (zz.SDLEN) { /* match */
    ix = INT_PTR(dst);
    ix[0] = zz.ADDR - TEXT_PTR(src);
    ix[1] = zz.SDLEN;
    }
return OK;
}

rx_subs(dst, xstr, src)  /* substitute strings */
MATRIX  dst;    /* result .. changed string */
MATRIX  xstr;   /* substitute operator */
MATRIX  src;    /* data to scan  */
{
struct  SDESC   sx_match(), sx_subs();
int     n, sub_fc;
struct  SDESC   rr, ss, xx, zz;

if (MTYPE(xstr->ADDR) != TYPT || MTYPE(src->ADDR) != TYPT) return ERROR;

sub_fc = sed_slash(TEXT_PTR(xstr), MCOLS(xstr->ADDR), &ss, &rr);
sed_cstr(1, &ss);       /* prepare string 1 */
sed_cstr(2, &rr);
n = (sub_fc & SED_ALL) ? src->SDLEN :1;
while (n--) {
    sasa(dst, src);
    xx.ADDR  = TEXT_PTR(src);
    xx.SDLEN = MCOLS(src->ADDR);
    zz = sx_match(&xx, &ss);
    if (zz.SDLEN == 0) break;
    zz = sx_subs(dst, &xx, &zz, &rr);
    sasa(src, dst);
    }
return OK;
}

fx_nfind(fc, dst, wn, str)
int     fc;     /* use regular expression matching ? */
MATRIX  dst;    /* int vector. line numbers */
MATRIX  wn;     /* window number */
MATRIX  str;    /* search for this string */
{
extern  struct  SDESC sl_slice();
extern  SLIST   sl_push();
extern  MATRIX  na_idx();       /* nested array selector */
extern  MATRIX  pm_ww;          /* window list */
MATRIX  wp;
SLBASE  base;                   /* transcript buffer */
SLIST   x, y;
struct  SDESC   cc, key, src, zz;
int     line_cnt = 0;
int     k;

wp = na_idx(pm_ww, (wn == NULL ) ? ERROR : 4 * DS_IVAL(wn));
if (wp == NULL) return mkobj(dst, 'N', 0, 0);
base = LINK_PTR(wp+1);  /* transcript buffer */

cc.ADDR = (BYTE*) &line_cnt;    /* collect line numbers in undo stack */
cc.SDLEN = sizeof(int);

key.ADDR = TEXT_PTR(str);       /* search string */
key.SDLEN = MSIZE(str->ADDR);
if (fc == F_NXFIND) sed_cstr(1, &key);

sl_del(base+1);         /* undo stack */
y = (SLIST)(base+1);

for (x = S_NEXT(base); x != NULL; x = S_NEXT(x), line_cnt++) {
    src = sl_slice(x);
    switch (fc) {
    default:
    case F_NFIND: /* exact match */
        k = sx_instr(&src, &key, 0);
        break;
    case F_NXFIND: /* match with regular expression */
        zz = sx_match(&src, &key);
        k = (zz.SDLEN) ? zz.ADDR - src.ADDR :ERROR;
        }
    if (k != ERROR) y = sl_push(y, &cc);
    }

if (sl_cat('M', dst, S_NEXT(base+1), NULL)) return ERROR;
sl_del(base+1);

/*      convert text matrix to integer vector */

MTYPE(dst->ADDR) = TYPN;
MSIZE(dst->ADDR) /= sizeof(int);
MCOLS(dst->ADDR) = MSIZE(dst->ADDR);
return OK;
}


