/*      UFN.C */

#include <na.h>
#include <dt.h>
#include <lex.h>
#include <fdata.h>

extern int qt;

MATRIX  sk_ufn(fd, adic)        /* user function */
MATRIX  fd;                     /* function pointer */
int adic;                       /* 0 1 or 2 */
{
extern  MATRIX sys_hput();
extern  MATRIX pm_sym;
MATRIX  sp = fd + adic;         /* new stack pointer -1 */
MATRIX  pv, fp, val, lnk;
TAGD    tk;
BYTE   *ucode;
int     np = MINDX(fd->ADDR);   /* symbol table offset */
int    *ix, kp, nc, dy;
int     j, nk;
int     rc = 0;

fp = NA_PTR(pm_sym) + np;

pv = NA_PTR(pm_sym) + MCOLS(pm_sym->ADDR);
fp = pv + np;
if (TYPA != MTYPE(fp->ADDR)) {
    mkobj(sp, 'F', ERR_SYN, 0);
    return sp;
    }
fp    = NA_PTR(fp);
ucode = TEXT_PTR(fp);   /* text */
nc    = MCOLS(fp->ADDR);

fp++;
tk = TAG_PTR(fp);       /* templates */
kp = rho(fp, &nk, &kp); /* size      */

mkik (++sp, adic);              /* save state */

mkobj(++sp, 'N', nk, nk);       /* link variables */
ix = INT_PTR(sp);

mkobj(++sp, 'A', nk, nk);       /* values */
MINDX(sp->ADDR) = -1;           /* no return value */

for (lnk = NA_PTR(sp); 0 < nk--; tk++, ix++, lnk++) {
        if ('N' == tk->tag) {      /* name */
            *ix = -1;
            continue;
            }
        val = sys_hput(pm_sym, &(tk->slice));   /* install name */
        if (val == NULL) {
            rc = 'U';
            break;
            }
        kp  = MINDX(pm_sym->ADDR);
        *ix = kp;
        val = pv + kp;
        sa_swap(lnk, val);
        switch(tk->tag) {
        case 'L':       /* left */
            if (adic == 2) sa_swap(fd+1, val);
            break;
        case 'R':       /* right */
            if (adic)  sa_swap(fd+adic, val);
            break;
        case 'K':       /* label */
            dy = (tk->slice.ADDR - ucode)/nc;
            mkik(val, dy);
            break;
        case 'Z':       /* return value */
            MINDX(sp->ADDR) = 0;
            break;
        case 'A':       /* no value known at this time */
        case 'N':
        default:
            break;
            }
        }
sasa(++sp, fp-1);                       /* push code text */
MELSIZ(sp->ADDR) = 'X';
MINDX(sp->ADDR) = MCOLS(sp->ADDR);      /* first line */
mkobj(++sp, 'F', (rc) ? EV_ELX: EV_DECOD, 0);
return sp;
}

/*      This function deals with two types of return
*       (I)     from #do "text"    -- just fiddle pointers
*      (II)     from function call -- change environment
*/

MATRIX sk_ret(sp)       /* return */
MATRIX sp;              /* current stack pointer */
{
extern  BYTE sk_tr[];   /* used by parser */
extern  int  sk_r3;     /* used by parser */
MATRIX  x;              /* old stack pointer */
MATRIX  lnk, pval, tmp;
MATRIX  val = sp+1;     /* return value */
BYTE   *s = sp->ADDR;
int    *ix;
int     qufn, nvar;
int     qret = 1;
int     rc = 0;
if (s == NULL) return NULL;
if (MSIZE(s) == MCOLS(s)) {
    sasr(sp--);                 /* delete text */
    sasm(sp, sp+2);             /* return value */
    sk_r3 = sk_tr['D'];         /* parser state */
    return sp;
    }

for (qufn = 1; qufn; )  {
        sasr(sp--);             /* delete function */
        rc = ERROR;
        s = sp->ADDR;           /* data descriptors */
        if (TYPA != MTYPE(s)) break;
        nvar = MSIZE(s);
        qret = 0 == MINDX(s);
        lnk = NA_PTR(sp) + nvar-1;
        sp--;

        /* offsets */
        if (TYPN != MTYPE(sp->ADDR)) break;
        ix = INT_PTR(sp) + nvar-1;

        /* restore values */
        pval = NA_PTR(pm_sym) + MCOLS(pm_sym->ADDR);
        for (; 0 < nvar--; ix--, lnk--) {
                if (0 > *ix) continue;  /* name only            */
                tmp = pval + *ix;       /* symbol table         */
                sa_swap(tmp, lnk);      /* restore local value  */
                }

        tmp =  NA_PTR(sp+1);            /* return value, if any */
        if (qret) sa_swap(val, tmp);    /* move value to stack */
        else sys_del(val);
        rc = sys_del(sp+1) || sys_del(sp);
        sp--;
        qufn = 0;                       /* done */
        }
if (rc || TYPN  != MTYPE(sp->ADDR))     /* wrong type */
        return NULL;                    /* error */
nvar = * INT_PTR(sp);                   /* calling sequence */
while (0 < nvar--) sasr(sp--);
sp--;                                   /* function */
if (qret) sa_swap(sp, val);             /* return the value */
else      mkobj(sp, 'F', 'V', 0);       /* or error */
sk_r3 = sk_tr['D'];                     /* parser state */
return sp;                              /* stack pointer */
}






