/*      USE.C  Generalised arrays */

#include <fdata.h>
#include <na.h>

#define NUL_VAL -1
#define NUL_KEY NOT_INT

unsigned int h_mask[] =
    {0X2624,0X564E,0XE8BC,0X0F85,0X2624,0X564E,0XE8BC,0X0F85};

use(dst, lo, hi)
MATRIX dst;
MATRIX lo;
MATRIX hi;
{
extern  MATRIX pm_sym;
extern  MATRIX sys_nput();
MATRIX  p, pv;
int    *ix;
int     rc, j, n, nc;

p = sys_nput(pm_sym, hi);
if (p == NULL) return ERROR;
pv = p + MCOLS(pm_sym->ADDR);
if (lo == NULL) return use_nlist(dst, pv);

ix = INT_PTR(lo);
n  = MSIZE(lo->ADDR);
if (n <1 || n >2) return ERROR;
else if (n == 1) rc = mkobj(pv, 'A', *ix, *ix);
else if (ix[0] == 2) rc = mkobj(pv, 'A', 2*ix[1], ix[1]);
else if (ix[0] > 2 && OK == mkobj(pv, 'A', 2, 1)) {
    p  = NA_PTR(pv);
    n  = ix[0]; /* table size*/
    nc = ix[1]; /* key size (integers) */
    rc = mkobj(p, 'N', n * nc, nc) ||   /* key table */
         mkobj(p+1, 'N', n, 1);         /* counters */
    if (rc == OK) {
        for (ix = INT_PTR(p), j = 0; j < n; j++, ix += nc) *ix = NUL_KEY;
        for (ix = INT_PTR(p+1), j = 0; j < n; j++, ix++)   *ix = NUL_VAL;
        }
    }
else rc = ERROR;

if (rc) return ERROR;
MELSIZ(pv->ADDR) = 'T'; /* generalised array */
return  sasa(dst, hi);
}

htab_scan(tab, key, vec)        /* Search a key table */
MATRIX  tab;            /* names -- text items */
int    *key;            /* symbol */
int    *vec;            /* value table */
{
BYTE   *s  = tab->ADDR;
int    *ix, *iz;
unsigned int   *mx;
int     n  = MSIZE(s);
int     nc = MCOLS(s);
int     j, nr, rc, cnt;

if (nc == 0) return ERROR;
nr = n / nc;
mx = &h_mask[0];
for (ix = key, j = nc, rc = 0; 0 < j--; ix++, mx+=2)
    rc += (*ix >> 4)^mx[0]+(*ix ^ mx[1]);
rc = (rc & MAX_INT) % nr;
for (ix = INT_PTR(tab), cnt = 0; cnt < nr; cnt++, rc++) {
    if (rc == nr) rc = 0;       /* wrap round */
    iz  = ix + nc * rc;
    if (vec[rc] == NUL_VAL ||
        0 == memcmp((BYTE*)iz, (BYTE*)key, nc*sizeof(int))) break;
    }
if (cnt == nr) return ERROR;
MINDX(tab->ADDR) = rc;
return rc;
}

use_get(dst, tab, idx)
MATRIX dst;     /* dst <- tab[idx] */
MATRIX tab;
MATRIX idx;
{
extern  MATRIX  sys_hput();
extern  MATRIX  pm_sym;
MATRIX  p;
struct  SDESC tt;
int    *is, *ix, *iy;
int     kw, n, nr, np, nx, rc;

if (tab->ADDR == NULL) return ERROR;

tab = NA_PTR(pm_sym)+MINDX(tab->ADDR)+MCOLS(pm_sym->ADDR);

if (tab->ADDR == NULL || MTYPE(tab->ADDR) != TYPA) return ERROR;

np = MCOLS(tab->ADDR);  /* virtual array size indicator */
n  = MSIZE(tab->ADDR);
if (n == 0) return na_getidx(dst, tab, idx);
nx = MSIZE(idx->ADDR);


if (n == np) {  /* word count */
    kw = MCOLS(idx->ADDR);
    if (kw == 0) nr = 1;
    else         nr = nx / kw;  /* number of keys */
    if (mkobj(dst, 'N', nr, 1)) return ERROR;
    tt.ADDR  = TEXT_PTR(idx);
    for (ix = INT_PTR(dst); 0 < nr--; tt.ADDR += kw, ix++) {
        *ix = ERROR;    /* default */
        tt.SDLEN = kw;
        ss_rtrim(&tt);
        rc = ht_scan(tab, &tt);
        if (rc == ERROR) return rc;
        p = NA_PTR(tab) + rc; /* integer value */
        if (p->ADDR != NULL) *ix = MINDX(p->ADDR);
        }
    }
else if (n == 2) {      /* pixel counter */
    if (nx == 0) return mkobj(dst, 'N', 0, 0);
    p  =  NA_PTR(tab);  /* keys */
    kw = MCOLS(p->ADDR);
    if (kw > 1 && kw != MCOLS(idx->ADDR)) return ERROR;
    iy = INT_PTR(p+1);  /* index values */
    nr = nx / kw;
    if (mkobj(dst, 'N', nr, 1)) return ERROR;
    is = INT_PTR(idx);
    for (ix = INT_PTR(dst); 0 < nr--; is += kw, ix++) {
        rc = htab_scan(p, is, iy);
        *ix = iy[rc];
        }
    }
else {          /* name, value pairs. :val <- T[idx] */
    tt.ADDR  = TEXT_PTR(idx);
    tt.SDLEN = nx;
    ss_rtrim(&tt);
    rc = ht_scan(tab, &tt);
    if (rc == ERROR) return ERROR;
    p = NA_PTR(tab) + rc;
    if (NULL == p->ADDR) return mkobj(dst, 'N', 0, 0);
    else return sasa(dst, p + np);      /* single value */
    }
return OK;
}

use_set(tab, idx, dat)
MATRIX tab;     /* tab[idx]<-dat */
MATRIX idx;
MATRIX dat;
{
extern  MATRIX  sys_hput();
MATRIX  p, pv;
struct  SDESC tt;
int    *is, *ix, *iy, *iz;
int     dx, j, kw, n, nr, np, nt, nx, qplus, rc;

if (tab->ADDR == NULL || MTYPE(tab->ADDR) != TYPA) return ERROR;
np = MCOLS(tab->ADDR);  /* virtual array size indicator */
n  = MSIZE(tab->ADDR);
if (n == 0)     /* special symbol */
    return na_setidx(tab, idx, dat);
nx = MSIZE(idx->ADDR);
nt = MSIZE(dat->ADDR);

if (nx == 0) return OK; /* no op */
qplus = (nt == 0);

if  (n == np) {         /* word count table */
    if (qplus == 0 && MTYPE(dat->ADDR) != TYPN) return ERROR;
    kw = MCOLS(idx->ADDR);
    nr = nx / kw;       /* number of words to match */
    if (nt == 1) dx = 0;
    else if (nt == nr) dx = 1;
    else if (nt != 0) return ERROR;

    tt.ADDR = TEXT_PTR(idx);
    for (ix = INT_PTR(dat); 0 < nr--; tt.ADDR += kw, ix += dx) {
       tt.SDLEN = kw;
       ss_rtrim(&tt);
       if (NULL == (p = sys_hput(tab, &tt))) return ERROR;
       if (qplus) MINDX(p->ADDR)++;
       else       MINDX(p->ADDR) = *ix;
       }
    }

else if (n == 2) {      /* pixel count. fixed length keys */
    p  = NA_PTR(tab);           /* keys */
    kw = MCOLS(p->ADDR);        /* key size */
    if (kw > 1 && kw != MCOLS(idx->ADDR)) return ERROR;
    nr = nx / kw;               /* number of keys */
    dx = nt > 1;

    iy = INT_PTR(p+1);      /* counters | values */
    is = INT_PTR(idx);      /* index slots */
    for (ix = INT_PTR(dat); 0 < nr--; is += kw, ix += dx) {
        rc = htab_scan(p, is, iy);
        if (rc == ERROR) return ERROR;
        if (iy[rc] == NUL_VAL) {
            iy[rc] = 0;
            iz = INT_PTR(p) + kw*rc;
            for (j = 0; j < kw; j++) iz[j] = is[j]; /* set key */
            }
        if (qplus) iy[rc]++;                        /* set value */
        else       iy[rc] = *ix;
        }
    }

else {          /* single assignment :  T[value]<-data */

   tt.ADDR  = TEXT_PTR(idx);
   tt.SDLEN = nx;
   ss_rtrim(&tt);
   if (NULL == (p = sys_hput(tab, &tt))) return ERROR;
   pv = p + MCOLS(tab->ADDR);
   return sasa(pv, dat);
   }

return OK;
}

use_nlist(dst, tab)
MATRIX dst;
MATRIX tab;
{
BYTE   *t = tab->ADDR;
BYTE   *s;
int     nsym = MCOLS(t);
MATRIX  p;
int     i, j, k, n, nc, nsize;
int    *is, *iv, *ix;

if (t == NULL) return ERROR;

if (MSIZE(t) == 2) {    /* fixed length table */
    p = NA_PTR(tab);
    nc    = MCOLS(p->ADDR);
    nsize = MSIZE((p+1)->ADDR);
    for (iv = INT_PTR(p+1), n = 0, j = nsize; 0 < j--; iv++)
        if (*iv != NUL_VAL) n++;
    if (mkobj(dst, 'N', n*nc, nc)) return ERROR;
    ix = INT_PTR(dst);
    for (iv = INT_PTR(p+1), i = 0; i < nsize; i++, iv++)
        if (*iv != NUL_VAL) {
            for (is = INT_PTR(p) + nc * i, j = nc; 0 < j--;) *ix++ = *is++;
            }
    return OK;
    }

        /* symbolic keys. Variable length */

for (p = NA_PTR(tab), n = 0, j = nsym; 0 < j--; p++)
    if (NULL != p->ADDR) n += (1+MSIZE(p->ADDR));

if (mkobj(dst, 'T', n, n))  return ERROR;
for (p = NA_PTR(tab), t = TEXT_PTR(dst), j = nsym; 0 < j--; p++)
    if (NULL != p->ADDR) {
        *t++ = CR;
        n = MSIZE(p->ADDR);
        if (n > 0) memcpy(t, TEXT_PTR(p), n);
        t += n;
        }
return OK;
}

na_getidx(dst, tab, idx)   /* get window / transcript data */
MATRIX dst;             /* dst<-$V[J] dst<-$T[J] */
MATRIX tab;
MATRIX idx;
{
extern  MATRIX  na_idx();       /* nested array selector */
extern  MATRIX  sys_nget();     /* symbol table lookup */
extern  BYTE   *mkasciz();      /* symbol table lookup */
extern  SLIST   sl_place();
extern  MATRIX  pm_ww;          /* window list */
extern  MATRIX  pm_sym;         /* main symbol table */
MATRIX  p, wp;
SLBASE  base;                   /* transcript buffer */
SLICE   xline;
SLIST   x;
int    *ix = INT_PTR(idx);
int     tv = MINDX(tab->ADDR);
int     nx = MSIZE(idx->ADDR);
int    *jx;
BYTE   *ws, *t;
int     i, nc;

if      (tv == F_SPLIT)  return na_catstr(dst, idx);
else if (tv == F_DBTIE)  return db_xfer(dst, NULL, idx);
else if (tv == F_SOCKET) return read_socket(dst, idx);
else if (tv == F_ZPUTS)  return fx_getscr(dst, idx);
else if (tv == F_GOTO)   return na_text(dst, idx);
else if (tv == F_PORT)   return fx_portb(dst, NULL, idx);
else if (tv == F_FTIME)  return d4_ftime(dst, idx);
else if (tv == F_FSTAT)  return d4_fstat(dst, idx); /* file status */
else if (tv == F_NL)     {      /* symbol table: Z<-$NL[name] */
    p = sys_nget(pm_sym, idx);
    i = (p == NULL || p->ADDR == NULL) ? 0 : MTYPE(p->ADDR);
    return (IS_LEAF_TYPE(i)) ? sasa(dst, p) : mkobj(dst, 'T', 0, 0);
    }

mkobj(dst, 'T', 0, 0);
wp =  na_idx(pm_ww, ERROR);     /* default */
if (wp == NULL) return OK;
base = LINK_PTR(wp+1);          /* transcript buffer */

switch (tv) {
    default: return ERROR;
    case F_NFIND:  /* transcript return set of lines as a matrix */
        if (nx == 0) return mkobj(dst, 'T', 0, 0);

        mkobj(dst, 'A', nx, nx);
        MTYPE(dst->ADDR) = TYPR;
        for (xline = NA_PTR(dst), nc = i = 0; i < nx; i++, xline++) {
            x = sl_place(base, ix[i]);
            if(nc < S_LEN(x)) nc = S_LEN(x);
            xline->ADDR = S_TEXT(x);
            xline->SDLEN = S_LEN(x);
            }
        if (mkobj(idx, 'T', nx*nc, nc)) return ERROR;     /* matrix */
        t = TEXT_PTR(idx);
        for (xline = NA_PTR(dst); 0 < nx--; xline++, t+=nc)
            if (xline->SDLEN > 0) memcpy(t, xline->ADDR, xline->SDLEN);
        sasr(dst);
        sasm(dst, idx);
    break;
    case F_NXFIND:  /* line lengths */
        if (mkobj(dst, 'N', nx, nx)) return ERROR;
        for (jx = INT_PTR(dst), i = 0; i < nx; i++, jx++) {
            x = sl_place(base, ix[i]);
            *jx = S_LEN(x);
            }
    break;
    case F_WINDOW: /* dst<-$V[idx] */
       ws =  wp->ADDR;
       sasa(dst, idx);
       if (nx == 0) return OK;
       for (ix = INT_PTR(dst); 0<nx--; ix++) switch(*ix) {
           case 0: *ix = S_LC(base);
               break;
           case 1: *ix = WW_HCUT(ws);
               break;
           case 2: *ix = WW_CY(ws);
               break;
           case 3: *ix = WW_CX(ws);
           default: break;
           }
    break;
    }
return OK;
}

na_setidx(tab, idx, dat)   /* get window / transcript data */
MATRIX tab;     /* $WD[wp, idx]<-dat */
MATRIX idx;
MATRIX dat;
{
extern  MATRIX  na_idx();       /* nested array selector */
extern  MATRIX  sys_nput();
extern  SLIST   sl_place();
extern  SLIST   sl_replace();
extern  SLIST   sl_app();
extern  SLIST   sl_movcur();
extern  MATRIX  pm_sym;         /* symbol table */
extern  MATRIX  pm_ww;          /* window list */
MATRIX  p, wp;
BYTE   *ws;
SLBASE  base;                   /* transcript buffer */
SLIST   x;
struct  SDESC ss;
int     n = MSIZE(dat->ADDR);
int     nc = MCOLS(dat->ADDR);
int    *ix = INT_PTR(idx);
int     tv = MINDX(tab->ADDR);
int     nx = MSIZE(idx->ADDR);
int     i, *iy, k;

if      (tv == F_ZPUTS) return fx_zputs(dat, dat, idx);
else if (tv == F_DBTIE) return db_xfer(dat, dat, idx);
else if (tv == F_PORT)  return fx_portb(dat, dat, idx);
else if (tv == F_SOCKET) return write_socket(dat, dat, idx);
else if (tv == F_NL) {  /* synbol table put. $NL[name]<-data */
    if (NULL== (p=sys_nput(pm_sym, idx))) return ERROR;
    p += MCOLS(pm_sym->ADDR);
    k = (p->ADDR) ? MTYPE(p->ADDR) : TYPT;
    return (IS_LEAF_TYPE(k)) ? sasa(p, dat) : OK;
    }

wp =  na_idx(pm_ww, ERROR);     /* default */

if (wp->ADDR == NULL && ww_init(wp, NULL)) return ERROR;
ws = wp->ADDR;
base = LINK_PTR(wp+1);  /* transcript buffer */

switch (tv) {
    default: return ERROR;
    case F_NFIND:
        if (nx == 0)    /* set transcript */
            return sl_del(base) || NULL == sl_app(base, dat);
        if (n == 0 || n != nx * nc) return OK;
        ss.ADDR = TEXT_PTR(dat);
        ss.SDLEN = nc;
        for (i = 0; i < nx; i++, ss.ADDR += nc) {
            x = sl_place(base, ix[i]);
            sl_replace(x, &ss);
            }
       break;
    case F_WINDOW: /* check and set view-port values */
       if (nx == 0) return OK;
       for (iy = INT_PTR(dat); 0<nx--; ix++, iy++) switch(*ix) {
           case 0: k = *iy;
                   S_LC(base) = (k < 0) ? 0 : k;
                   S_NOW(base) = sl_movcur(0, base, S_LC(base));
               break;
           case 1: k = *iy;
                   WW_HCUT(ws) = (k < 0) ? 0 : k;
               break;
           case 2: k = *iy;
               WW_CY(ws) = (k < 0 || k > *(WW_TXT(ws)+2)) ? 0 : k;
               break;
           case 3: k = *iy;
               WW_CX(ws) = (k < 0 || k > *(WW_TXT(ws)+3)) ? 0 : k;
           default: break;
           }
       break;
       }
return OK;
}

int     na_text(dst, idx)       /* return function text */
MATRIX  dst;
MATRIX  idx;
{
extern  MATRIX  sys_nlink();
extern  MATRIX  pm_sym;
extern  MATRIX  pm_stack;
MATRIX  sb = NA_PTR(pm_stack);
MATRIX  p, sp;
int     np;
np = (idx->ADDR && TYPN == MTYPE(idx->ADDR) && 0 < MSIZE(idx->ADDR))
    ? * INT_PTR(idx)
    : 0;

for (sp = dst; sp > sb; sp--) {
    if (sp->ADDR &&
        TYPT == MTYPE(sp->ADDR) &&
        'X'  == MELSIZ(sp->ADDR) &&
         0   <  MCOLS(sp->ADDR) &&
         0   == np++ &&
        OK   == sasa(dst, sp))  {
            MELSIZ(dst->ADDR) = 0;
            if (p = sys_nlink(pm_sym, "$LC", NULL, 0))
                 mkik(p, (MINDX(sp->ADDR)/MCOLS(sp->ADDR)));
            return OK;
            }
    }
return mkobj(dst, 'T', 0, 0);
}


