/*  Console I/O
*   DIRECT console IO.
*   Amended for LINUX
*   Sat Jun 13 09:10:37 BST 2009
*   Amended to give 144 = black on white for Acer Terminal
*/

#include <htext.h>
#include <na.h>
#include <scrnio.h>
#include <stdio.h>
#include <sys/termios.h>
#include <signal.h>

#define CPUTCH(X)       write(tty_out, &X, 1)
#define CU_SMAX 0X10

int     sk_cz = 0;
int     cu_ptr = 0;
int     cu_stack[CU_SMAX];

/*      write to console, but not virtual screen */

int     cputch(c)
int     c;
{
extern  int     tty_out;
BYTE    k = c;
CPUTCH(k);
return  c;
}

/*      define vputch   */

int     vputch(c)
int     c;
{
extern  int     tty_out;
int     done = 0;
BYTE    x = c;
if (c == LF) {  /* new line */
        sk_cz += S_NC;
        if (sk_cz >= S_WLEN) {
                sk_cz = (S_NR-1)*S_NC;
                ww_scrollup();
                }
        done = 1;
        }
else if (c == CR) {
        sk_cz = S_NC * (sk_cz / S_NC);  /* return */
        done = 1;
        }
else if (c == FF) {
        ww_cls();       /* clean screen */
        sk_cz = 0;      /* do not write to screen */
        vdisp("[H");
        vdisp("[2J");
        return c;
        }

CPUTCH(x);
if ((! done) && (sk_cz < S_NR*S_NC)) mm_vptr[sk_cz++] = x;
return  x;
}

ww_scrollup()   /* scroll up one line */
{
int     n = (ed_scr[2]-1) * ed_scr[3];
BYTE   *t = WW_MMAP(0, 0);
while (0 < n--) *t++ = *(t+ed_scr[3]);          /* shift up */
for   (n = ed_scr[3]; 0 < n--; ) *t++ = ' ';    /* push in a blank line */
return OK;
}

vs_puts(s, n)
BYTE   *s;
int     n;
{
extern  int     tty_out;
write(tty_out, s, n);
return n;
}

tcur(X,Y)       /* LOCATE X,Y   Text Cursor<-X,Y */
int X,Y;
{
char tx[16];
sk_cz = CU_MAP(Y, X);
X++; Y++;
sprintf(tx, "[%d;%dH", Y, X);
return vdisp(tx);
}

setsi(cb)       /* set colours */
int     cb;     /* foreground, background */
{
char    xx[16];
int     sif;
if (cb == 144) {        /* correct black on white */
    sprintf(xx, "[30;49m");
    vdisp(xx);
    return OK;
    }
if (cb & 8) vdisp("[1m");
else        vdisp("[0m");
sprintf(xx, "[3%c;4%cm", '0'+ (cb & 7), '0'+((cb/16) & 7));
vdisp(xx);
return OK;
}

vdisp(s)        /* Use to print control codes */
char *s;
{
int c;
if (s == NULL) return (OK);
cputch(ESC);
while ( c = *s++) cputch(c);
return(OK);
}

vdir(n)         /* move cursor in given direction */
int n;          /* 0-3 */
{
switch(n) {
        default: break;
        case 0: vdisp("[1C");   /* forward */
                break;
        case 1: vdisp("[1A");   /* up */
                break;
        case 2: vdisp("[1D");   /* back */
                break;
        case 3: vdisp("[1B");   /* down */
                break;
        }
}

vs_cur(yx)      /* read cursor */
int *yx;        /* value - 0 origin */
{
if (sk_cz > S_NR*S_NC-1) sk_cz = S_NC*(S_NR-1);
yx[0] = sk_cz / S_NC;
yx[1] = sk_cz % S_NC;
return OK;
}

si_inv(k)       /* text inverse rendition */
int     k;      /* 1 =  ON | 0 = OFF    */
{
cputch(ESC);
cputch('[');
if (k) cputch('7');
cputch('m');
return OK;
}

push_cur()
{
if (cu_ptr < CU_SMAX) cu_stack[cu_ptr++] = sk_cz;
return OK;
}

pop_cur()
{
if (cu_ptr > 0) {
        sk_cz = cu_stack[--cu_ptr];
        tcur(sk_cz % S_NC, sk_cz / S_NC);
        }
return OK;
}
