/*      edit.c  */

#include <htext.h>
#include <na.h>
#include <scrnio.h>

char   *ed_stext = "Move( )   ##### TAG[####:####]";

#define S_ORIENT   5
#define S_INS      8

ww_edit(wvec, sp)               /* edit */
MATRIX  wvec;                   /* window */
MATRIX  sp;                     /* stack */
{
extern  int a_astate;           /* input mode */
extern  int s_imode;            /* insert mode */
struct  SDESC sl_slice();
SLIST   sl_movcur();
SLIST   sl_place();
SLIST   sl_join();
SLIST   sl_break();
SLIST   sl_replace();
MATRIX  xx = WW_DLINK(wvec);
MATRIX  xcmd = wvec+2;
BYTE   *ws = wvec->ADDR;
int    *wx = WW_TXT(ws);
int    *wt = WW_LIN(ws);
int     nr = wx[2] - 1;         /* rows */
SLBASE  base  = LINK_PTR(xx);   /* transcript */
SLBASE  scrap = base+1;         /* delete store */
BYTE   *t;
struct  SDESC ss, tt;
int     c, k, n, rc;
int     q_refresh = 1;
int     mb, mx, my;

for(k = 0; k < 4; k++) wt[k] = wx[k];
wt[2] = 1;              /* cursor window */
mkobj(xcmd, 'T', wx[3], wx[3]);

for (rc = 0; rc == 0;) {
    if (S_LC(base) < WW_CY(ws)) S_LC(base) = WW_CY(ws);
    S_NOW(base) = sl_place(base, S_LC(base));
    a_astate = WW_MODE(ws);
    if (q_refresh) ww_show(wvec, sp);  /* update display */
    ed_stat(wvec, sp);  /* status line    */
    wt[0] = wx[0] + WW_CY(ws);          /* row window */
    ss = sl_slice(S_NOW(base));
    c = ww_edslice(wt, &WW_CX(ws), WW_HCUT(ws), &ss);
    S_NOW(base) = sl_replace(S_NOW(base), &ss);
    WW_MODE(ws) = a_astate;
    wt[0] = wx[0]+nr;
    q_refresh = 1;

    /* mouse stuff */
    if (XMOUSE_KEY(c)) {
        mb = XMOUSE_CB(c);
        mx = XMOUSE_CX(c) - 33;
        my = XMOUSE_CY(c) - 33;
        if (mb != 0X20) c = CTRLQ;                      /* ^Q exit */
        else if (mx >= wx[1]+wx[3]-4) {                 /* scrolling */
             if (my <= wx[0]) c =KHOME;                 /* Top */
             else if (my >= wx[0]+wx[2]-1) c = KEND;    /* End */
             else c = (my < wx[0] + wx[2]/2) ? KPGUP : KPGDN;
             }
        else if (my == wx[0]+nr) c = CTRLD;             /* ^D command */
        else {                                          /* ^L link */
             WW_CY(ws) = 0;
             WW_CX(ws) = mx - wx[1];
             S_LC(base) += (my - wx[0]);
             c = CTRLL;
             }
        }

    switch(c) {
        case CTRLT:     /* tag modes */
            ed_mkxstr(xcmd, "T", 0);
            sed(sp, NULL, xcmd);
            q_refresh = 0;
            break;
        case CTRLN:     /* again */
            ed_mkxstr(xcmd, "N", 0);
            sed(sp, NULL, xcmd);
            break;
        case PFK3:      /* search and replace */
            ed_mkxstr(xcmd, "| ", 1);
            a_astate = 0;
            c = ww_edlin(wt, xcmd);
            if (c == CR) sed(sp, NULL, xcmd);
            break;
        case ESC:       /* do commands */
            ed_mkxstr(xcmd, " ", 0);
            a_astate = 0;
            c = ww_edlin(wt, xcmd);
            if (c == CR) sed(sp, NULL, xcmd);
            if (c == CR || c == KUP || c == KLEFT || c == BS) break;
        default:
            rc = ERROR;
        case BS:
            break;
        case CTRLP:     /* delete line -- push */
            sl_swap(scrap, S_NOW(base));
            break;
        case CTRLR:     /* restore line */
            sl_swap(S_PREV(S_NOW(base)), S_NEXT(scrap));
            break;
        case KLEFT: /* scroll back */
            if (WW_HCUT(ws) >= 8) WW_HCUT(ws) -=8;
            break;
        case KRGHT: /* scroll forwards */
            if (WW_HCUT(ws) < MAXLINE - 88) {
                WW_HCUT(ws) += 8;
                WW_CX(ws) -= 6; /* continuous input */
                }
            break;
        case KHOME: WW_CY(ws) = WW_CX(ws) = 0;
            sl_movcur(0, base, 0);
            break;
        case KEND: WW_CY(ws) = WW_CX(ws) = 0;
             sl_movcur(2, base, 0);
            break;
        case KPGUP: S_LC(base) -=(nr-1);
            break;
        case KPGDN: S_LC(base) += (nr-1);
            break;
        case KUP: S_LC(base)--;
            if (WW_CY(ws) > 0) {
                WW_CY(ws)--;
                q_refresh = 0;
                }
            break;
        case DEL:       /* delete character */
            S_NOW(base) = sl_join(S_NOW(base));
            break;
        case CR:        /* break line when appropriate */
            if (s_imode)
                S_NOW(base) = sl_break(S_NOW(base), WW_HCUT(ws)+WW_CX(ws));
            WW_CX(ws) = WW_HCUT(ws) = 0;        /* move to left */
        case KDOWN:             /* drop through */
            S_LC(base)++;
            if (WW_CY(ws) < nr-1) {
                WW_CY(ws)++;
                if (c != CR || s_imode == 0) q_refresh = 0;
                }
            break;
        case HTAB:      /* scroll forwards 8 cols */
            if (wx[3] + WW_HCUT(ws) < MAXLINE - 8) WW_HCUT(ws) += 8;
            break;
            }
        }
mm_xattr(wx, nr);       /* invert attributes of status line */
return c;
}

ww_show(wvec, sp)               /* display contents */
MATRIX  wvec;                   /* window */
MATRIX  sp;                     /* stack pointer */
{
BYTE   *ws = wvec->ADDR;
SLBASE  base = LINK_PTR(wvec+1);
int     cz   = S_LC(base);
int    *wx = WW_TXT(ws);        /* display area */
int     ix[2];

ix[0] = cz-WW_CY(ws);
if (ix[0] < 0) ix[0] = 0;
ix[1] = ix[0] + wx[2]-2;
if (ix[1] < 0) ix[1] = 0;

sl_obj('M', sp, base, ix);      /* extract block */
ww_vput(sp, wx, WW_HCUT(ws), I_FLIP & WW_MODE(ws));
return OK;
}

ed_stat(wvec, sp)
MATRIX wvec;
MATRIX sp;
{
extern  int tty_out;
extern  int a_astate;
extern  int s_imode;            /* insert mode */
BYTE   *ws = wvec->ADDR;
int    *wx = WW_TXT(ws);
SLBASE  base  = LINK_PTR(wvec+1);   /* transcript */
int    *tbloc = WW_BLK(ws);
struct  SDESC ss, tt;
int     stat[4];
int     nc;

mkobj(sp, 'T', wx[3], wx[3]);   /* status line */

tt.ADDR  = ed_stext;
tt.SDLEN = strlen(ed_stext);

ss.ADDR  = TEXT_PTR(sp);
ss.SDLEN = wx[3];

lset(&ss, &tt);

stat[0]  = S_LC(base);
stat[1]  = tbloc[1];
stat[2]  = tbloc[2];

ss_using(&ss, stat);
*(ss.ADDR +S_ORIENT) = (WW_QFLIP(ws)) ? '<' : '>';
if (s_imode) *(ss.ADDR + S_INS) = '+';
wx[4] = wx[0] + wx[2] -1;       /* last line */
si_inv(1);
ww_vput(sp, wx+4, 0, 0);        /* display slice */
si_inv(0);
setsi(d4_si);
return OK;
}

ed_mkxstr(dst, str, cx)
MATRIX  dst;    /* string object */
char   *str;    /* ASCIZ string */
int     cx;     /* offset */
{
int     n = strlen(str);
if (mkobj(dst, 'T', n, n)) return ERROR;
if (n) memcpy(TEXT_PTR(dst), str, n);
MINDX(dst->ADDR) = cx;
return OK;
}






