/* alin.c  */
/* bilingual input routine */

#include <htext.h>
#include <na.h>

extern  int     s_imode;        /* insert mode */
extern  int     a_astate;       /* language mode */

ww_edlin(ww, xx)
int    *ww;             /* bounding window */
MATRIX  xx;             /* edited line */
{
struct SDESC ss;        /*  current input string  */
BYTE   *t = xx->ADDR;
int     c, j;
ss.ADDR = TEXT_PTR(xx);
ss.SDLEN = MSIZE(t);
j = MINDX(t);
c = ww_edslice(ww, &j, 0, &ss);
if (mk_sk(xx, TYPT, &ss))  return ERROR;
MINDX(xx->ADDR) = j;
return c;
}

ww_edslice(ww, jc, hcut, ss)
int    *ww;             /* bounding window */
int    *jc;             /* cursor */
int     hcut;           /* offset of window in ss */
SLICE   ss;             /* edited line */
{
extern  MATRIX  sys_text();
BYTE   *ed_modify();
extern  MATRIX  pm_sym;
MATRIX  alpha = sys_text(pm_sym, "$ALPHA");     /* fold symbols */
MATRIX  beta  = sys_text(pm_sym, "$BETA");
extern  BYTE   *kb_ttx;
extern  BYTE   *linbuf;
struct  SDESC   inbuf;
struct  SDESC   zz;
BYTE   *t;
int     smax = MAXLINE - hcut;
int     j, n, rc, beta_cnt;

/* deal with charecter composition table */
if (alpha != NULL) {
    if (TYPT != MTYPE(alpha->ADDR) || 0 == MCOLS(alpha->ADDR))
        alpha = NULL;
    }

/* deal with charecter modification table */
if (beta != NULL) {
    beta_cnt = MCOLS(beta->ADDR);
    if (0 == beta_cnt || TYPT != MTYPE(beta->ADDR))
        beta = NULL;
    else beta_cnt -=2;
    }

inbuf.ADDR  = linbuf;
inbuf.SDLEN = MAXLINE;
lset(&inbuf, ss);
ss->ADDR = linbuf + hcut;
if (hcut < ss->SDLEN) ss->SDLEN -= hcut;
else ss->SDLEN = 0;
for(j = *jc, rc = 0; rc == 0;) {
    ss_rtrim(ss);
    ed_sput(ww, ss);
    ed_tcur(ww, j);
    switch(rc = inkey()) {
    case CLEOL: /* delete to end of line */
        for (t = ss->ADDR + j, n = j; n < smax; n++) *t++ = ' ';
        ss->SDLEN = smax;
        rc = 0;
        break;
    case KLEFT: /* back */
        if (0 <= --j) rc = 0;
        break;
    case KRGHT: /* forwards */
        if (ww[3] > ++j) rc = 0;
        break;
    case HTAB:  /* tab forwards */
        j += (8-(j & 0X07));    /* tab forwards */
        if (j < ww[3]) rc = 0;
        break;
    case BS:    /* backspace then delete */
        if (j > 0) j--;
    case DEL:   /* delete, and pull in text */
        if (j >= ss->SDLEN) break;
        t = ss->ADDR + j;
        for (n = j+1; n++ < ss->SDLEN; t++) *t = *(t+1);
        *t =' ';
        rc = 0;
        break;
    default:
        if (XMOUSE_KEY(rc) || rc < 0X20) break; /* control code */
        if (j > ss->SDLEN)              /* expand with blanks */
            for (t = ss->ADDR + ss->SDLEN; ss->SDLEN < j; ss->SDLEN++)
                *t++=' ';
        if ((a_astate & I_FOLD) && 0 == ed_fold(alpha, ss, j, rc)) {
            rc = 0;
            break;
            }
        if (a_astate & I_ARAB)          /* arabic style */
            t = ed_modify(beta, ss, j, rc);
        else t = NULL;
        if (t == NULL) n = 1;
        else {  /* test for nul characters in t */
            for (n = beta_cnt; n > 0 && 0 == t[n-1]; n--);
            }
        if (s_imode) ed_rshift(ss->ADDR + j, ss->SDLEN - j + n - 1);
        if (s_imode || j == ss->SDLEN)  ss->SDLEN += n;
        if (t == NULL) ss->ADDR[j++] = rc;      /* this character */
        else
            for (j--; 0 < n--; j++, t++)        /* last character */
                if (j >= 0) ss->ADDR[j] = *t;
        rc = (j <= ww[3]) ?  0 : KRGHT;
        }
    }
ss->ADDR = linbuf;
ss->SDLEN += hcut;
ss_rtrim(ss);   /* trim trailing blanks */
if (j < 0) j = 0;
else if (j > ww[3]-1) j = ww[3]-1;
*jc = j;        /* remember cursor */
return rc;      /* last character typed */
}

ed_tcur(ww, cx)
int    *ww;             /* bounding window */
int     cx;             /* cursor */
{
int     qflip = (0 != (a_astate & I_FLIP));

if (qflip) tcur(ww[1] + ww[3] - 1 - cx, ww[0]);
else       tcur(ww[1] + cx, ww[0]);
return OK;
}

ed_sput(ww, ss)
int    *ww;             /* bounding window */
SLICE   ss;             /* edited line */
{
BYTE   *t = ss->ADDR + ss->SDLEN;
int     n = ww[3] - ss->SDLEN;
int     qflip = (0 != (a_astate & I_FLIP));
struct  SDESC tt;
tt.ADDR  = ss->ADDR;
tt.SDLEN = ww[3];
while (0 < n--) *t++ = ' ';
if (a_astate & I_FLIP)    vflip(&tt);     /* check display mode */
mmscr_sput(ww, &tt);
if (a_astate & I_FLIP)    vflip(&tt);
return OK;
}

ed_rshift(s, n)
BYTE   *s;
int     n;
{
for (s += n; 0 < n--; s--) *s = *(s-1);
return OK;
}

ed_fold(tab, ss, idx, c)     /* composite characters */
MATRIX  tab;    /* lookup table */
SLICE   ss;
int     idx;
int     c;
{
BYTE   *t;
int     j, k, n, nr, nc;
if (idx == 0 || tab == NULL) return ERROR;
n = MSIZE(tab->ADDR);
nc = MCOLS(tab->ADDR);
if (n == 0 || nc == 0) return ERROR;
k = ss->ADDR[idx-1];
for (t = TEXT_PTR(tab), j = n/nc; 0 < j--; t += nc)
    if (k == t[0] && c == t[1]) {
        ss->ADDR[idx-1] = t[2];
        return OK;
        }
return ERROR;
}

BYTE   *ed_modify(tab, ss, idx, c)      /* character modification */
MATRIX  tab;                            /* lookup table */
SLICE   ss;
int     idx;
int     c;
{
BYTE   *t;
int     j, k, n, nr, nc;
if (tab == NULL) return NULL;
n = MSIZE(tab->ADDR);
nc = MCOLS(tab->ADDR);
if (n == 0 || nc == 0) return NULL;
k = (idx == 0) ? ' ' : ss->ADDR[idx-1];
for (t = TEXT_PTR(tab), j = n/nc; 0 < j--; t += nc)
    if (k == t[0] && c == t[1]) return t+2;
return NULL;
}
