/*      FXWW.C
*       Interface functions for text processing.
*       Line input, edit, and spread sheet functions.
*       Bilingual set up functions included.
*       Screen management
*/

#include <htext.h>
#include <na.h>
#include <scrnio.h>

#define DS_IVAL(X)      (*(INT_PTR(X)))

#ifdef linux
#define YX_CUR(Z)   vs_cur(Z)
#else
#define YX_CUR(Z)   dos_cur(Z)
#endif

fx_inlin(dst)
MATRIX dst;             /* current line */
{
int     rc;
int     sw[4];          /* window for input */
int     cx;
struct  SDESC tt;
extern  int a_astate;

YX_CUR(&sw[0]);         /* cursor position   */
cx = sw[1];             /* x position        */
sw[1] = 0;              /* sw = current line */
sw[2] = 1;              /* one line          */
sw[3] = WW_MAXCOLS;
ww_vget(dst, sw);
MINDX(dst->ADDR) = cx;  /* inline cursor */
rc = ww_edlin(sw, dst);
vkpush(rc);
return OK;
}

fx_win(dst, lo, hi)     /* windows */
MATRIX dst;             /* result */
MATRIX lo;              /* data */
MATRIX hi;              /* function code, key */
{
extern  MATRIX  na_idx();       /* nested array selector */
extern  MATRIX  pm_ww;          /* window list */
extern  int a_astate;
MATRIX  wp;
BYTE   *ws;
int    *ix, n, fc;
int     rc = 0;
int     qret = 0;
int     j, k, qflip;
int    *ww;
SLBASE  base;

if (hi == NULL || 0 == MSIZE(hi->ADDR)) {       /* usage list */
    n = MSIZE(pm_ww->ADDR) / 4;
    if (mkobj(dst, 'N', n, n)) return ERROR;
    wp = NA_PTR(pm_ww);
    ix = INT_PTR(dst);
    k = MINDX(pm_ww->ADDR) / 4;         /* selected */
    for (j = 0; j < n; wp += 4, j++, ix++)
        if (wp->ADDR != NULL)           /* in use */
            *ix = 1 + 2*(j==k);
    return OK;
    }

n = MSIZE(hi->ADDR);
ix = INT_PTR(hi);
fc = ix[0];

wp =  na_idx(pm_ww, (n>1) ? 4*ix[1] : ERROR);
if (wp == NULL) return ERROR;
ws = wp->ADDR;
if (fc == WW_INIT) {    /* setup window */
    ix = (lo == NULL) ? NULL : INT_PTR(lo);
    rc = ww_init(wp, ix);
    return (rc) ? ERROR : mkik(dst, 0);
    }
else if (ws == NULL) return ERROR;

if (lo == NULL) switch (fc) {
    case  WW_DEL:               /* delete */
        rc = sys_del(wp) ||
             sys_del(wp + 1) ||
             sys_del(wp + 2) ||
             sys_del(wp + 3);
        if (rc) return ERROR;
        break;

     case  WW_IMODE:            /* Input mode */
        rc = WW_MODE(ws);
        qret = 1;
        break;

    case  WW_SIZE:
        if (mkobj(dst, 'N', 4, 4)) return ERROR;
        ix = INT_PTR(dst);
        ww = WW_TXT(ws);
        for (j = 4; 0 < j--;) *ix++ = *ww++;
        return OK;
        break;

    default: rc = ERROR;
        break;
    }
else  switch(fc) {

    case  WW_IMODE:             /* Input mode */
        a_astate = WW_MODE(ws) = DS_IVAL(lo);
        rc = 0;
        break;

    case  WW_SIZE:              /* reset display area */
        if (ww_size(lo) || sasa(dst, lo)) return ERROR;
        for (ix = INT_PTR(dst), ww = WW_TXT(ws), j = 4; 0 < j--;)
            *ww++ = *ix++;
        WW_CY(ws) = 0;
        WW_CX(ws) = 0;
        return OK;
        break;

    default: rc = ERROR;
        break;
    }

if (qret == 0) mkobj(dst, 'T', 0, 0);
else if (qret == 1) rc = mkik(dst, rc);
return rc;
}

fx_cur(dst, src)
MATRIX dst;     /* Current cursor */
MATRIX src;     /* Int vector y, x -- 0 origin */
{
int     rc;
int    *ix;
if (src == NULL) {      /* set dst */
        if(rc = mkobj(dst, 'N', 2, 2)) return rc;
        ix = INT_PTR(dst);
        YX_CUR(ix);
        return rc;
        }
if (NULL == src->ADDR || TYPN != MTYPE(src->ADDR))
        return ERROR;
ix = INT_PTR(src);
tcur(ix[1], ix[0]);
return mkobj(dst, 'T', 0, 0);
}

ww_init(window, ix)
MATRIX  window; /* pointer */
int    *ix;     /* size */
{
BYTE   *ws;
int     j, *ww;

if ( ix == NULL) ix = &ed_scr[0];       /* default */
if  (ix[0] < 0 || ix[1] < 0     ||
     ix[0] + ix[2] > WW_MAXROWS ||
     ix[1] + ix[3] > WW_MAXCOLS)
        return ERROR;

if (mkobj(window, 'W', 0, 0) || mkobj(window+1, 'L', 2, 2))
    return ERROR;

ws = window->ADDR;
for (ww = WW_TXT(ws), j = 4; 0 < j--;)
     *ww++ = *ix++;     /* location    */

WW_ATTR(ws) = 0X07;             /* display attributes */
return OK;
}





