/*   KB.C   Console I/O */

#include <htext.h>
#include <na.h>
#include <stdio.h>
#include <sys/termios.h>
#include <signal.h>

#define MAX_ESEQ        10      /* input escape sequence */

struct  termios tty_line, tty_screen;
int     tty_fd;
int     tty_out;
int     tty_mode = 0;
int     sk_sp    = 0;   /* analyse escape sequences */
int     sk_num   = 0;   /* numeric parameter    */
int     sk_eterm = 0;   /* terminator */
int     q_break  = 0;   /* user hit CTRL-C */

/*      new code to go with terminfo.d4f or similar script */

typedef struct  {
    BYTE val;
    BYTE nc;
    BYTE data[8];
    } kbseq_item;

kbseq_item kbseq_linux[] = {
    {KLEFT   ,   2, { '[','D', }},
    {KDOWN   ,   2, { '[','B', }},
    {KRGHT   ,   2, { '[','C', }},
    {KUP     ,   2, { '[','A', }},
    {DEL     ,   3, { '[','3','~', }},
    {KEND    ,   3, { '[','4','~', }},
    {PFK1    ,   3, { '[','[','A', }},
    {PFK2    ,   3, { '[','[','B', }},
    {PFK3    ,   3, { '[','[','C', }},
    {PFK4    ,   3, { '[','[','D', }},
    {PFK5    ,   3, { '[','[','E', }},
    {PFK6    ,   4, { '[','1','7','~', }},
    {PFK7    ,   4, { '[','1','8','~', }},
    {PFK8    ,   4, { '[','1','9','~', }},
    {PFK9    ,   4, { '[','2','0','~', }},
    {PF10    ,   4, { '[','2','1','~', }},
    {KHOME   ,   3, { '[','1','~', }},
    {KINS    ,   3, { '[','2','~', }},
    {KPGDN   ,   3, { '[','6','~', }},
    {KPGUP   ,   3, { '[','5','~', }},
    {0,0,{0,0,0,0,0,0,0,0}}
    };

#define KB_EOF  -1

unsigned int a_astate = 0;      /* language code bits for arabic etc. */
unsigned int s_imode =  0;      /* insert | overlay */
int vget_pushed = KB_EOF;

BYTE   *kb_ttx = NULL;

tty_init()
{
void    v_break();
int     rc;
tty_fd = fileno(stdin);
tty_out = fileno(stdout);
tcgetattr(tty_fd, &tty_line);
tty_screen = tty_line;
tty_screen.c_iflag = BRKINT;
tty_screen.c_oflag = tty_line.c_oflag & ~ 0 /* OPOST */ ;
                                                /* from stty */
tty_screen.c_lflag = tty_line.c_lflag & ~ (ICANON|ECHO|IEXTEN);
                                                /* no echo */
tty_screen.c_cc[VTIME]  = 0;
tty_screen.c_cc[VMIN]   = 1;
tty_mode = 0;

/* setbuf(stdout, NULL);        */

signal(SIGINT, v_break);                /* vector to v_break() handler */
return  OK;
}

tty_set(mode)
int     mode;
{
if (mode == 0) {
    tcsetattr(tty_fd, TCSANOW, &tty_line);
    tty_mode = 0;
    }
else if (mode == 1) {
    tcsetattr(tty_fd, TCSANOW, &tty_screen);
    tty_mode = 1;
    }
else mode = tty_mode;
return  mode;
}

void v_break()  /* SIGINT handler */
{
q_break = 1;
signal(SIGINT, v_break);        /* reset for LINUX */
}

int     break_in()      /* test global variable */
{
int     rc = q_break;
q_break = 0;            /* turn off */
return rc;
}

int     vgetch()
{
extern  MATRIX  sys_text();
extern  MATRIX  pm_sym;
MATRIX  kbmap = sys_text(pm_sym, "$KB");        /* keyboard mapping */
MATRIX  kbseq = sys_text(pm_sym, "$KB_SEQ");    /* control key sequences */
int     done, j, k, n, nr, nc;
BYTE    kq[MAX_ESEQ];
kbseq_item     *tk;
BYTE   *s;

/* deal with pushed key */
if (vget_pushed != KB_EOF) {
    k = vget_pushed;
    vget_pushed = KB_EOF;
    return k;
    }

/* deal with keyboard mapping */
if (kbmap == NULL ||
    TYPT   != MTYPE(kbmap->ADDR) ||
    256    != MSIZE(kbmap->ADDR))
        kb_ttx = NULL;
else    kb_ttx = TEXT_PTR(kbmap);

n = read(tty_fd, &kq[0], MAX_ESEQ);
if (n == 1) {   /* normal character */
    k = kq[0];
    if (a_astate & I_XLATE) k |= 0X80;
    return (kb_ttx) ? kb_ttx[k] : k;
    }

if (kq[0] != ESC) {     /* not a control code */
    vget_pushed = kq[1];
    return kq[0];       /* and lose the rest */
    }
else n--;               /* deal with end of sequence */

 /* mouse stuff */

if (kq[1]=='[' && kq[2]=='M' && sys_text(pm_sym, "$MOUSE")) {
    return XMOUSE_CONS(&kq[2]);
    }

    /* this should be done when $KB_SEQ changes */
tk = NULL;
if (kbseq && (s = kbseq->ADDR) && TYPT==MTYPE(s)) {
    nr = MSIZE(s);
    nc = MCOLS(s);
    if (nc > 3) {
        nr /= nc;
        tk = (kbseq_item*) TEXT_PTR(kbseq);
        }
    }

if (tk) {
    for (s = (BYTE*)tk; 0 < nr--; s+=nc, tk = (kbseq_item*)s) {
        if (n == tk->nc && 0 == memcmp(kq+1, tk->data, n))
            return tk->val;
            }
    return KLEFT;
    }

/*      search table    */
for(tk = kbseq_linux; 0 != tk->nc; tk++) {
    if (n == tk->nc && 0 == memcmp(kq+1, tk->data, n))
        return tk->val;
    }

return KLEFT;     /* least harm solution to lost keystrokes */
}

inkey()         /* translate horizontal movement keys */
{
int  c;
int done;
int tmp;
for (done = 0; done == 0;) {
        switch(c = vgetch()) {
        default: done = 1;
                break;
        case CLEFT:     /* Arabic => forwards */
        case CRGHT:     /* Arabic => backwards */
                c = ((0 != (a_astate & I_FLIP))^(c == CLEFT))
                ? CLEFT : CRGHT;
                done = 1;
                break;
        case CTRLA:     /* toggle xlate and push mode */
                BIT_XOR(a_astate, tmp, I_PUSH|I_XLATE);
                break;
        case CTRLV:     /* toggle insert mode */
                s_imode = 1 & (1 ^ s_imode);
                break;
                }
        }       /* next key */
return (c);
}

vkpush(c)       /* push character */
int     c;
{
vget_pushed = c;
return OK;
}

/*
*       NON BLOCKING KEY WAIT WITH TIME OUT
*       This routine should use select
*/

fx_inkey(dst, src)      /* check keyboard input */
MATRIX  dst;
MATRIX  src;            /* delay time to poll */
{
BYTE    xx[MAX_ESEQ];
int     k, cnt;

tty_screen.c_cc[VMIN] = 0;   /* just test for keys */
tcsetattr(tty_fd, TCSAFLUSH, &tty_screen);

for (k = 0, cnt = 1+ *(INT_PTR(src)); k == 0 && 0 < cnt--;) {
    k = read(tty_fd, &xx[0], MAX_ESEQ);
    if (k > 0) {
        k = xx[0];
        if (k == ESC && xx[1]=='[' && xx[2] == 'M') {
            k = XMOUSE_CONS(&xx[2]);
            }
        }
     }

tty_screen.c_cc[VMIN] = 1;    /* wait for a key */
tcsetattr(tty_fd, TCSAFLUSH, &tty_screen);

return  mkik(dst, k);
}
