/*      kjscr.c read and write blocks on bitmap planes */

#include <na.h>
#include <scrnio.h>

#define VGA_DATA

#ifdef TC
#define outp outportb
#endif

#include <d4vga.h>

#ifdef DOS_GRAPH

kjput(dst, map, wwsi)   /* write bitmap */
MATRIX  dst;            /* return code */
MATRIX  map;            /* bitmap */
MATRIX  wwsi;           /* y, x, colour */
{
BYTE   *s  = map->ADDR;
int     n  = MSIZE(s);
int     nc = MCOLS(s);
int     np = MSIZE(wwsi->ADDR);
int    *ix = INT_PTR(wwsi);
BYTE   *t, *z;
BYTE    x;
int     si = 15;        /* colour */
int     xor = 0;        /* write mode */
int     i, j, nr;

if (np < 2) return ERROR;
if (n * nc == 0) return mkobj(dst, 'T', 0, 0);
nr = n / nc;
if (np > 2) {
    si = ix[2] & 0X7F;
    if (ix[2] & 0X80) xor = (XOR << 3);
    }

GRAFOUT(0, 0);
GRAFOUT(1, 0X00);       /* disable set-reset */
GRAFSEQ(2, si);         /* enable CPU write */
GRAFOUT(3, xor);        /* mode */

s = TEXT_PTR(map);      /* bitmap data */
t = gr_ram + COLBYTES * ix[0] + ix[1];

for(i = nr; 0 < i--; t += COLBYTES)
    for (z = t, j = nc; 0 < j--; *z++ = *s++) {
        x = *z;         /* read before write, for fancy mode */
        }

GRAFOUT(3, 0);          /* reset */
GRAFOUT(0, 0);
GRAFOUT(1, 0);
GRAFSEQ(2, 0XFF);       /* Enable CPU write */
GRAFOUT(8, 0XFF);       /* write 8 bits */

return mkobj(dst, 'T', 0, 0);
}

kjget(dst, wwsi)        /* read bitmap */
MATRIX  dst;            /* bit map */
MATRIX  wwsi;           /* window + colour */
{
int     np = MSIZE(wwsi->ADDR);
int    *ix = INT_PTR(wwsi);
BYTE   *s, *t, *z;
int     i, j, si;

if (np < 4) return ERROR;
si = (np == 5) ? ix[4] : 1;     /* colour planes 1 2 4 8 */

if (mkobj(dst, 'T', ix[2] * ix[3], ix[3])) return ERROR;

t = gr_ram + ix[0] * COLBYTES + ix[1];
s = TEXT_PTR(dst);

GRAFOUT(4, si);         /* select plane */
GRAFOUT(5,0X00);        /* READ MODE -- get plane */

for (i = ix[2]; 0 < i--; t += COLBYTES)
    for(z = t, j = ix[3]; 0 < j--; *s++ = *z++);           /* read line */

return OK;
}

kjbloc(dst, cc, src)    /* fill blocks */
MATRIX  dst;            /* result */
MATRIX  cc;             /* colour, style */
MATRIX  src;            /* nblocs table of (Y0,X0)-(Y1,X1) */
{
MATRIX  sys_text();
extern  MATRIX  pm_sym;
MATRIX  tile = sys_text(pm_sym, "$TILE");       /* raster fill pattern */
int     n  = MSIZE(src->ADDR);
int     nc = MCOLS(src->ADDR);
int     ncc = MCOLS(cc->ADDR);
int    *ix = INT_PTR(cc);
int     mode = PSET;
int     si = 7;
int     i, np;

if (n == 0 || nc == 0) return mkik(dst, 0);
np = n / nc;

if (ncc > 0) si = ix[0];
if (ncc > 1) si = ix[1];

if (tile == NULL) mkik(tile = dst, 0XFFFF);

GRAFOUT(0, si);         /* set-reset register */
GRAFOUT(1, 0X0F);
GRAFOUT(3, mode << 3);  /* set pixel write mode */

for (i = np; 0 < i--; MINDX(src->ADDR)++)
    vga_block_fill(tile, src);

GRAFOUT(0, 0);
GRAFOUT(1, 0);
GRAFOUT(8, 0XFF);       /* full graphics functions */

return  mkobj(dst, 'T', 0, 0);
}

kjplot(dst, cc, src)    /* set of pixels */
MATRIX  dst;            /* result */
MATRIX  cc;             /* colour, mode */
MATRIX  src;            /* Y,X pairs */
{
int     n =  MSIZE(src->ADDR);
int     nc = MCOLS(src->ADDR);
int    *ix = INT_PTR(src);
int    *ic = (cc == NULL) ? NULL : INT_PTR(cc);
int     mode = PSET;
int     si   = 7;
int     i, ncc, nr, tmp, x, y;
BYTE   *addr;
BYTE    lbit;

if (n == 0 || nc == 0) return mkik(dst, 0);
nr = n / nc;

if (ic != NULL && 0 < (ncc = MSIZE(cc->ADDR))) {
    si = ic[0];
    if (ncc > 1) mode = ic[1];
    }

GRAFOUT(0, si);         /* set-reset register */
GRAFOUT(1, 0X0F);       /* enable these planes */
GRAFOUT(3, mode << 3);  /* set mode = 0  */

if (nc == 2)            /* set of points */
    for (i = nr; 0 < i--; ix += nc) {
        y = ix[0];
        x = ix[1];
        addr = gr_ram + y * WW_MAXCOLS + (x>>3);
        lbit  = m1_bit[x & 7];
        GRAFOUT(8, lbit);       /* mask register */
        *addr &= 1;             /* set reset  */
        }
else if (nc == 4)       /* draw rectangles */
    for (i = nr; 0 < i--; ix += nc) {
        if (ix[0]>ix[2]) SWAP(ix[0], ix[2], tmp);
        if (ix[1]>ix[3]) SWAP(ix[1], ix[3], tmp);
        vga_rect(ix[0], ix[1], ix[2], ix[3]);
        }

GRAFOUT(0, 0);
GRAFOUT(1, 0);
GRAFOUT(8, 0XFF);       /* full graphics functions */

return  mkobj(dst, 'T', 0, 0);
}

/*      Handle de-generate cases correctly for XOR function */
/*      Write mode (PSET, XOR etc.) is set outside this routine */

vga_rect(y0, x0, y1, x1)        /* draw rectangle */
int     y0, x0, y1, x1;
{
BYTE   *alo, *ahi;
BYTE    lmask = LMASK(x0);
BYTE    rmask = RMASK(x1);
BYTE    lbit  = m1_bit[x0 & 7];
BYTE    rbit  = m1_bit[x1 & 7];
int     qh = (y0 != y1);   /* not horizontal line */
int     ncols, i, j;

x0 >>= 3;
x1 >>= 3;
ncols = x1 - x0;

if (ncols == 0) {                 /* single byte */
    lmask &= rmask;
    rmask = 0;
    lbit |= rbit;
    }

/*  horizontal lines */

alo = gr_ram + y0 * WW_MAXCOLS + x0;
ahi = alo + (y1-y0)* WW_MAXCOLS;

GRAFOUT(8, lmask);      /* mask register */
*(alo++)  &= 1;
if (qh) *(ahi++) &= 1;

if (ncols) {
    GRAFOUT(8, 0XFF);       /* mask register */
    for (j = 0; j < ncols - 1; j++) {
        *(alo++)  &= 1;
        if (qh) *(ahi++) &= 1;
        }
    GRAFOUT(8, rmask);      /* mask register */
    *(alo++)  &= 1;
    if(qh)  *(ahi++) &= 1;
    }

/* vertical line or lines */
alo = gr_ram + (y0+1) * WW_MAXCOLS + x0;
ahi = alo + ncols;

for (i = y0+1; i < y1; i++) {   /* put each pixel once only */
    GRAFOUT(8, lbit);   /* mask register */
    (*alo) &= 1;
    alo += WW_MAXCOLS;
    if (ncols) {
        GRAFOUT(8, rbit);       /* mask register */
        (*ahi) &= 1;
        ahi += WW_MAXCOLS;
        }
    }
return OK;
}

#endif

mk_yxline(dst, src)     /* relative move table for line */
MATRIX  dst;            /* NP*2 matrix of (dy,dx) pairs */
MATRIX  src;            /* (y,x) pairs, with selector */
{
int    *ix = INT_PTR(src);
int     n  = MSIZE(src->ADDR);
int     nc = MCOLS(src->ADDR);
int     i  = MINDX(src->ADDR);  /* current segment */
int     qswap = 0;
int     a, b, np, tmp, y, x;
int     delta, sy, sx;         /* signs */
int     inc1, inc2;

if (n == 0 || nc < 2) return mkobj(dst, 'N', 0, 0);
ix += i * nc;           /* row selector */
y  = ix[0];
sy = (y > 0) ? 1 : -1;
x  = ix[1];
sx = (x > 0) ? 1 : -1;
b  = y * sy;
a  = x * sx;
if (a < b) {
    SWAP(a, b, tmp);
    qswap = 1;
    }
if (mkobj(dst, 'N', 2 * a, 2)) return ERROR;
for (ix = INT_PTR(dst), i= a; 0 < i--; ix += 2) {
    ix[0] = sy;
    ix[1] = sx;
    }

ix = INT_PTR(dst) + qswap;
inc1  = 2 * b;          /* 2 * |dy| */
delta = inc1 - a;       /* 2 * |dy| - |dx| */
inc2  = delta - a;      /* 2 * (|dy| - |dx|) */
for (i = a; 0 < i--; ix += 2) {
    if (delta < 0) {
        delta += inc1;
        ix[0] = 0;
        }
    else delta += inc2;
    }
return OK;
}

fx_reltoabs(dst, zc)    /* make set of yx co-ordinates */
MATRIX  dst;    /* move table .. (dy, dx) paiirs */
int    *zc;     /* start points */
{
int     n = MSIZE(dst->ADDR);
int     nc = MCOLS(dst->ADDR);
int     dy, dx, i;
int    *ix;

if (zc == NULL || n == 0 || nc ==0) return OK;

for (ix = INT_PTR(dst), i = n / nc; 0 < i--; ix += nc) {
    dy = ix[0];
    dx = ix[1];
    ix[0] = zc[0];
    zc[0] += dy;
    ix[1] = zc[1];
    zc[1] += dx;
    }
return OK;
}

#ifdef DOS_GRAPH

kjvec(dst, cc, src)
MATRIX  dst;
MATRIX  cc;     /* colour, mode */
MATRIX  src;    /* line segment table - offsets */
{
MATRIX  sys_text();
extern  MATRIX  pm_sym;
MATRIX  pz = sys_text(pm_sym, "$GZ");
int     n =  MSIZE(src->ADDR);
int     nc = MCOLS(src->ADDR);
int     i;

if (pz == NULL || 2 != MSIZE(pz->ADDR)) return ERROR;
vga_cz = INT_PTR(pz);   /* graphics cursor */

if (n == 0 || nc == 0) return mkik(dst, 0);

for (i = n / nc; 0 < i--; MINDX(src->ADDR)++) {
    if (mk_yxline(dst, src) || fx_reltoabs(dst, vga_cz)) break;
    kjplot(dst, cc, dst);
    }
return mkobj(dst, 'T', 0, 0);
}

#endif

kjarc (dst, cc, src)     /* circle and ellipse */
MATRIX  dst;
MATRIX  cc;     /* colour, mode, {fill style} */
MATRIX  src;    /* bounding rectangle {sector specifiers} */
{
return mk_arc(dst, src);
}

mk_arc(dst, src)
MATRIX  dst;    /* relative move table .. pi/4 segment */
MATRIX  src;    /* radius */
{
int     n = MSIZE(src->ADDR);
int    *ix = INT_PTR(src);
int     rsize = *ix;    /* radius */
int     delta, x, y, cnt, *iy;

if (n == 0 || rsize <=0 ) return sasa(dst, src);

if (mkobj(src, 'N', 2 * rsize, 2))      /* (dy,dx) pairs */
    return ERROR;
cnt = x = y = 0;
ix = INT_PTR(src);
for (delta = 0; cnt < rsize ; cnt++, ix += 2) {
    ix[0] = 0;
    ix[1] = 1;
    delta += 2*x+1;
    x++;
    if (delta > 2*rsize + 1) {
        y++;
        ix[0]++;
        delta -= 2*(rsize-y)+1;
        }
    if (y > rsize - x) break;
    }

/* trim */

if (mkobj(dst, 'N', 2 * cnt, 2)) return ERROR;
ix = INT_PTR(src);
iy = INT_PTR(dst);
for (x = 2 * cnt; 0 < x--; *iy++ = *ix++);

return sasr(src);
}

#ifdef DOS_GRAPH

vga_block_fill(tile, src)       /* fill block */
MATRIX  tile;           /* fill style */
MATRIX  src;            /* co-ordinates list */
{
BYTE   *tx     = TEXT_PTR(tile);
int     nt     = MSIZE(tile->ADDR);
int     ntcols = MCOLS(tile->ADDR);
int     nc = MCOLS(src->ADDR);
int    *ix = INT_PTR(src) + nc * MINDX(src->ADDR);
int     j, y, tmp;

if (ix[0]>ix[2]) SWAP(ix[0], ix[2], tmp);
if (ix[1]>ix[3]) SWAP(ix[1], ix[3], tmp);

for (j = 0, y = ix[0]; y <= ix[2]; y++) {
    vga_rxline(y, ix[1], ix[3], ntcols, tx + j);
    j += ntcols;        /* next pattern line */
    if ( j == nt) j = 0;
    }

return OK;
}

kjfill (dst, cc, src)   /* fill X-convex area */
MATRIX  dst;
MATRIX  cc;             /* colour, mode */
MATRIX  src;            /* boundary points */
{
MATRIX  sys_text();
extern  MATRIX  pm_sym;
MATRIX  tile = sys_text(pm_sym, "$TILE");       /* raster fill pattern */
BYTE   *tbase;
BYTE   *tyline;
int     ncc = MSIZE(cc->ADDR);
int    *cx = INT_PTR(cc);
int     mode = PSET;
int     si = 7;
int     ntrows = 1;
int     ntcols = 1;
int    *it;
int     i, n, ntri, y;
BYTE    tdefault = 0XFF;

if (MCOLS(src->ADDR) == 3) sasm(dst, src);      /* line table ? */
else if (mk_yxx(dst, src)) return ERROR;        /* make line table */

if (0 == (n = MSIZE(dst->ADDR))) return OK;
ntri = n/3;
if (ncc > 0) si = cx[0];
if (ncc > 1) si = cx[1];

        /* Set up tile pointers */
if (tile ==  NULL || 0 == (n = MSIZE(tile->ADDR)))
    tbase = &tdefault;
else {
    tbase = TEXT_PTR(tile);
    ntcols = MCOLS(tile->ADDR);
    ntrows = n / ntcols;
    }

        /* Do the fill */

GRAFOUT(3, mode << 3);  /* set pixel write mode */
GRAFOUT(0, si);         /* set-reset register */
GRAFOUT(1, 0X0F);

for (it = INT_PTR(dst), i = ntri; 0 < i--; it+=3) {
    y = it[0];
    tyline = tbase + ntcols * (y % ntrows);
    vga_rxline(y, it[1]+1, it[2]-1, ntcols, tyline);
    }
GRAFOUT(0,0);
GRAFOUT(1,0);
GRAFOUT(8,0XFF);        /* full graphics functions */
return mkobj(dst, 'T', 0, 0);
}

vga_rxline(y, xlo, xhi, np, pattern)      /* trim pattern into line */
int     y, xlo, xhi;
int     np;             /* count of pattern bytes */
BYTE   *pattern;        /* fill style */
{
BYTE   *addr = gr_ram + y * WW_MAXCOLS + (xlo >>3);
BYTE    lmask = LMASK(xlo);
BYTE    rmask = RMASK(xhi);
int     ncols = (xhi>>3)-(xlo>>3)-1;
BYTE    mk;
int     xt = xlo >> 3;  /* character pointer on the screen. */
int     j;

if (ncols < 0) {                 /* single byte */
    lmask &= rmask;
    rmask = ncols = 0;
    }

mk = pattern[(xt++) % np ];     /* left part */
GRAFOUT(8, lmask & mk);
*(addr++) &= 1;

for (j = ncols; 0 < j--;) {     /* middle part */
    mk = pattern[(xt++) % np];
    GRAFOUT(8, mk);
    *(addr++) &= 1;
    }

mk = pattern[xt % np];          /* right part */
GRAFOUT(8, rmask & mk );
*(addr++) &= 1;
return OK;
}
#endif

mk_yxx(dst, src)        /* make table of horizontal line segments */
MATRIX  dst;            /* (y, xlo, xhi) triples */
MATRIX  src;            /* set of boundary points */
{
int     n  = MSIZE(src->ADDR);
int     nc = MCOLS(src->ADDR);
int    *ix = INT_PTR(src);
int    *iy, *it;
int     i, np, nt;
int     y, ymin, ymax;
int     x, tmp;

if (n == 0 || nc == 0) return mkobj(dst, 'N', 0, 0);
np = n/nc;
        /* pass 1 .. find ymin, ymax */
for (ymin = 0X3FFF, ymax = -1, i = np; 0 < i--; ix+=nc) {
    y = ix[0];
    if (y < ymin) ymin = y;
    if (y > ymax) ymax = y;
    }

nt = ymax-ymin-1;
if (nt < 0) nt = 0;
if (mkobj(dst, 'N', nt * 3, 3)) return ERROR;
if (nt == 0) return OK;
it = INT_PTR(dst);
for (iy = it, i = nt, y = ymin+1; 0 < i--; iy+=3) {
    iy[0] = y++;
    iy[1] = iy[2] = -1;
    }

ix = INT_PTR(src);
it = INT_PTR(dst);
for (i = np; 0 < i--; ix += nc) {
    y = ix[0];
    if (y <= ymin || y >= ymax) continue;
    iy = it + 3 * (y-ymin-1);
    x = ix[1];
    if (iy[1] < 0) iy[1] = x;
    else if (iy[2] < 0) {
        if (x >= iy[1]) iy[2] = x;
        else {  /* x < iy[1], so swap */
            iy[2] = iy[1];
            iy[1] = x;
            }
        }
    else if (x < iy[1]) iy[1] = x;      /* multiple y values */
    else if (x > iy[2]) iy[2] = x;
    }
return OK;
}

