/*
*       fx_zgets()      keyboard mouse
*                       can use to run quiz program
*       fx_inwin()      restricted input
*/

#include <htext.h>
#include <na.h>
#include <scrnio.h>

#define ZG_CU   0       /* move cursor here */
#define ZG_XA   1       /* invert attributes */
#define ZG_KS   4       /* exit, for further selection */

fx_zgets(dst, lo, hi)
MATRIX  dst;    /* index locator */
MATRIX  lo;     /* optional start position */
MATRIX  hi;     /* (1) list of y, x values or (2) window list */
{
BYTE   *s  = hi->ADDR;
int     n  = MSIZE(s);
int     nc = MCOLS(s);
int     j  = 0; /* starting position */
int     rc = 0;
int    *ix = INT_PTR(hi);
int     fc, c, nr, x, y;
int    *si;
struct SDESC tt;

if  (nc == 2 || nc == 4) nr = n / nc;
else return ERROR;
fc = (nc == 2) ? ZG_CU : ZG_XA;

if (lo != NULL) {       /* starting point */
    j = *(INT_PTR(lo));
    if (j < 0) j = 0;
    else if (j >= nr) j = nr-1;
    }

while (rc == 0) {       /* deal with fields */
    si = ix + nc * j;
    y = si[0]; x = si[1];
    switch(fc) {
    default:
    case ZG_CU: /* cursor */
        tcur(si[1], si[0]);
        c = vgetch();
        break;
    case ZG_XA: /* window */
        si_inv(1);
        mm_xattr(si, 0);    /* invert attributes */
        c = vgetch();
        si_inv(0);
        setsi(d4_si);
        mm_xattr(si, 0);    /* invert attributes */
        break;
            }
    if (nr == 1) rc = 1;
    else
    switch(c) {         /* exit key */
    case CR:  rc = 1;
        break;
    case ESC:
    default: rc = ERROR;
        break;
    case KHOME: j = 0;
        break;
    case KEND:  j = nr-1;
        break;
    case KLEFT: /* previous field */
        if (--j < 0) j = nr-1;
        break;
    case HTAB:
    case KRGHT: /* next field */
        if (++j == nr) j = 0;
        break;
    case KUP:       /* nearest y-1, x */
         for (; si[0] >= y && si > ix; si -= nc);
         for (;si > ix && si[1] > x; si -= nc);
         j = (si-ix)/nc;
         break;
    case KDOWN:     /* nearest y+1, x */
         for (; si[0] <= y && si < ix + n-nc; si+=nc);
         for (;si < ix + n-nc && si[1] < x; si+=nc);
         j = (si-ix)/nc;
         break;
         }
    }
vkpush(c);
if (rc == ERROR) j = rc;
return mkik(dst, j);
}

fx_inwin(dst, src)      /* restrict input to 1-line window */
MATRIX  dst;            /* text */
MATRIX  src;            /* where */
{
BYTE   *s;
int     rc;
int     n, nr, nc;
int    *wx;
if (src == NULL || NULL == (s = src->ADDR) || TYPN != MTYPE(s))
        return ERROR;
n = rho(src, &nr, &nc);
if (nc < 4) return ERROR;
ww_mget(dst, src);              /* starting data */
wx = INT_PTR(src);
rc = ww_edlin(wx, dst);         /* edit single line */
vkpush(rc);                     /* keep key */
return OK;
}

fx_zputs(dst, lo, hi)
MATRIX  dst;    /* bytes printed */
MATRIX  lo;     /* text data */
MATRIX  hi;     /* (1) list of y, x, colour (2) { window, colour} list */
{
extern  int     tty_fd;
BYTE   *src = TEXT_PTR(lo);
int     ns  = MSIZE(lo->ADDR);
int    *ix = INT_PTR(hi);
BYTE   *t  = hi->ADDR;
int     n  = MSIZE(t);
int     nc = MCOLS(t);
int     nr = (nc ==0) ? 0 : n / nc;
int     ds = ns > 1;

if (MTYPE(t) != TYPN) return ERROR;
for (; 0 < nr--; ix += nc, src += ds)
    if (ix[0] >= 0 &&
        ix[1] >= 0 &&
        ix[0] < WW_MAXROWS &&
        ix[1] < WW_MAXCOLS) {
        tcur(ix[1], ix[0]);
        if (nc == 3) setsi(ix[2]);  /* colour */
        write(tty_fd, src, 1);
        t = WW_MMAP(ix[0], ix[1]);  /* write text to screen */
        *t = *src;
        }
setsi(d4_si);
return mkobj(dst, 'T', 0, 0);
}

fx_getscr(dst, idx)
MATRIX  dst;
MATRIX  idx;
{
BYTE   *s  = idx->ADDR;
int     n  = MSIZE(s);
int     nc = MCOLS(s);
int    *ix = INT_PTR(idx);
BYTE   *t;
int     nr;

if (n == 0 || nc == 0) return mkik(dst, 0);
nr = n/nc;
if (nc != 2 || mkobj(dst, 'T', nr, nr)) return ERROR;
for (t = TEXT_PTR(dst); 0 < nr--; ix += nc) {
     if (   ix[0] >= 0 && ix[0] < WW_MAXROWS
         && ix[1] >= 0 && ix[1] < WW_MAXCOLS) {
        s = WW_MMAP(ix[0], ix[1]);
       *t++ = *s;
        }
    }
return  OK;
}



