/* WWMAP.C
*
*       Memory mapped screen IO functions
*/

#include <htext.h>
#include <na.h>
#define SCRMAP_DATA
#include <scrnio.h>

fx_screen(dst, src)     /* enquire | set screen size */
MATRIX dst;             /* rows, columns             */
MATRIX src;             /* set with these values     */
{
extern  MATRIX pm_scr;
MATRIX  vs = NA_PTR(pm_scr);
BYTE   *s;
int    *ix;
if (src != NULL) {      /* set sane values */
    s = src->ADDR;
    if (MTYPE(s) != TYPN || MSIZE(s) < 2) return ERROR;
    ix = INT_PTR(src);
    if (ix[0] <= 0 || ix[0] > SCR_MAX_YVAL ||
        ix[1] <= 0 || ix[1] > SCR_MAX_XVAL) return ERROR;
    ed_scr[2] = ix[0];
    ed_scr[3] = ix[1];
    mkobj(vs, 'T', ix[0]*ix[1], ix[1]);
    mm_vptr = TEXT_PTR(vs);
    }
if (mkobj(dst, 'N', 2, 2)) return ERROR;
ix = INT_PTR(dst);      /* values */
ix[0] = ed_scr[2];
ix[1] = ed_scr[3];
return OK;
}

fx_vram(dst, src)       /* enquire | set video ram pointer */
MATRIX dst;             /* for dos -- integer SEG, OFFSET  */
MATRIX src;             /* segment, offset in DOS          */
{
return mkik(dst, (int) mm_vptr);
}

ww_menu(wvec, txt)      /* menu function */
MATRIX wvec;            /* window spec */
MATRIX txt;             /* menu data */
{
BYTE   *s  = txt->ADDR;
int    *wx = INT_PTR(wvec);
int     dy = wx[2];
int     qscroll = 0;
int     qcur = (MSIZE(wvec->ADDR) > 4);
int     rc, c, k;
int     nr, nc;
int     mx, my;
if (s == NULL || TYPT != MTYPE(s) || ww_size (wvec)) return ERROR;
k = rho(txt, &nr, &nc);
if (qcur) {             /* starting position */
        k = wx[4];
        if (k >= 0 && k < nr) MINDX(s) = k;
        }
k = MINDX(s);
if (dy < k) {
        MINDX(s) = (k / dy) * dy;
        k = k % dy;
        }
else    MINDX(s) = 0;
ww_mput(txt, wvec);
for    (rc = 0; rc == 0;) {
        qscroll = 0;
        si_inv(1);
        mm_xattr(wx, k);
        c = vgetch();
        si_inv(0);
        setsi(d4_si);
        mm_xattr(wx, k);
        if (XMOUSE_KEY(c)) {    /* translate mouse coordinates to key */
            mx = XMOUSE_CX(c)-33;
            my = XMOUSE_CY(c)-33;
            if (mx < wx[1]-1  || mx > wx[1]+wx[3] ||
                my < wx[0]-1  || my > wx[0]+wx[2])
                c = ESC;
            else if (my == wx[0]-1)
                c = (mx == wx[1]-1)     ? KHOME: KPGUP;
            else if (my == wx[0]+wx[2])
                c = (mx == wx[1]+wx[3]) ? KEND : KPGDN;
            else {
                c = CR;
                k = my-wx[0];
                }
            }
        switch(c) {
        case CR:
                rc = c;
                break;
        case ESC:
        case KLEFT:
        case KRGHT:
                rc = ERROR;
                break;
        case KHOME:
        case KPGDN:
        case KPGUP:
        case KEND:
                qscroll = mm_scroll(c, txt, wx);
                break;
        case KUP:
                if (k > 0) k--;
                else qscroll = mm_scroll(c, txt, wx);
                break;
        case KDOWN:
        default:
                if (k < dy -1 ) k++;
                else qscroll = mm_scroll(c, txt, wx);
                break;
                }
        if (qscroll) ww_mput(txt, wvec);
        }
if (rc == ERROR) return rc;
MINDX(s) += k;
return MINDX(s);
}

mm_scroll(fc, xx, wx)   /* change xx[index] */
int     fc;             /* function code */
MATRIX  xx;             /* text */
int    *wx;             /* scroll region */
{
BYTE   *v;
int     k;
int     maxy;           /* window height */
int     n, nr, nc;
if (xx == NULL || NULL == (v = xx->ADDR)) return 0;
n = rho(xx, &nr, &nc);
k = MINDX(v);
maxy = wx[2];
switch (fc) {
        case KPGDN:     k += maxy;
                break;
        case KPGUP:     k -= maxy;
                break;
        case KUP:       k--;
                break;
        case KDOWN:     k++;
                break;
        case KHOME:     k = 0;
                break;
        case KEND:      k = nr - maxy;
                break;
        }
if (k < 0 || k + maxy > nr) return 0;
MINDX(v) = k;   /* update */
return 1;
}

mm_xattr(wx, idx)       /* invert attributes of line */
int    *wx;     /* y0, x0, dy, dx for window */
int     idx;    /* line offset */
{
BYTE   *dst;
BYTE    attr;
int     dx;
if (idx < 0 || idx >= wx[2])
        return ERROR;
dst  = WW_MMAP(wx[0], wx[1]);   /* point y, x   */
dst +=  idx * ed_scr[3];
push_cur();
tcur(wx[1], wx[0]+idx);
vs_puts(dst, wx[3]);
pop_cur();
return OK;
}

ww_cls()        /* clear screen */
{
int     n = ed_scr[2] * ed_scr[3];
BYTE   *t = WW_MMAP(0, 0);
while (0 < n--) *t++ = ' ';
return OK;
}

ww_vput(xx, ix, hcut, qflip)    /* write, and trim matrix to window */
MATRIX  xx;     /* data -- with cursor */
int    *ix;     /* window size */
int     hcut;   /* horizontal shift offset */
int     qflip;  /* reverse orientation */
{
BYTE   *v = xx->ADDR;
int     n = MSIZE(v);
int     nc = MCOLS(v);
BYTE   *t;
int    *iy;
int     i, j, nr, dy;
struct SDESC tt;

nr = (nc == 0) ? 0 : n / nc;
t = WW_MMAP(ix[0], ix[1]);
if (MTYPE(v) == TYPN) {         /* attributes */
    iy = INT_PTR(xx);
    if (n==1) return setsi(d4_si = *iy);
    push_cur();
    for (i=0; i < ix[2]; i++, t+=ed_scr[3]) {
        tcur(ix[1], ix[0]+i);
        for (j = 0, v = t; j < ix[3]; j++) {
            setsi(*iy++);
            cputch(*v++);
            }
        }
    pop_cur();
    return OK;
    }
else if (MTYPE(v) == TYPT) {    /* text */
    tt.ADDR  = TEXT_PTR(xx) + hcut;
    tt.SDLEN = (nc <= hcut) ? 0 : nc - hcut;
    if (nr > 1) {
        nr -= MINDX(v);
        tt.ADDR  += nc * MINDX(v);
        }
    i = ix[0];
    push_cur();
    for (dy = ix[2]; 0 < dy-- ; nr--, t += ed_scr[3], tt.ADDR += nc) {
        if (nr <= 0) tt.SDLEN = 0;
        if (qflip) mm_rlin(t, ix[3], &tt);
        else       mm_dlin(t, ix[3], &tt);
        tcur(ix[1], i++);
        vs_puts(t, ix[3]);
        }
    pop_cur();
    }
return OK;
}

ww_mput(xx, wvec)       /* write, and trim matrix to window */
MATRIX xx;              /* data -- with cursor */
MATRIX wvec;            /* window spec */
{
return ww_size(wvec) || ww_vput(xx, INT_PTR(wvec), 0, 0);
}

ww_size(wvec)           /* validate window size */
MATRIX wvec;            /* Int vector Y, X, DY, DX */
{
BYTE *v;
int  *ix;
if (wvec == NULL || NULL == (v = wvec->ADDR) || TYPN != MTYPE(v))
    return ERROR;
ix = INT_PTR(wvec);
if     (ix[0] < 0  ||
        ix[1] < 0  ||
        ix[0] + ix[2] > WW_MAXROWS ||
        ix[1] + ix[3] > WW_MAXCOLS)
        return ERROR;
return OK;
}

mm_dlin(dst, max, ss)   /* paste a line */
BYTE *dst;              /* where on screen */
int max;                /* size */
struct SDESC *ss;       /* message */
{
BYTE *s = ss->ADDR;
int   n = ss->SDLEN;
while (0 < n-- && 0 < max--) {
    *dst++ = *s++;
     }
while (0 < max--) *dst++ = ' ';
return OK;
}

mm_rlin(dst, max, ss)   /* paste a reversed line */
BYTE *dst;              /* where on screen */
int max;                /* size */
struct SDESC *ss;       /* message */
{
BYTE *s = ss->ADDR;
int   n = ss->SDLEN;
dst += max-1;
while (0 < n-- && 0 < max--) {
    *dst-- = *s++;
     }
while (0 < max--) *dst-- = ' ';
return OK;
}

mmscr_sput(ww, ss)      /* paste a slice */
int  *ww;               /* where on screen */
SLICE ss;               /* message */
{
BYTE   *dst = WW_MMAP(ww[0], ww[1]);    /* point y, x   */
mm_dlin(dst, ww[3], ss);
tcur(ww[1], ww[0]);
return vs_puts(ss->ADDR, ss->SDLEN);
}

ww_vget(dst, wx)        /* read a box on the text screen */
MATRIX  dst;    /* data */
int    *wx;     /* window size (Y0,X0),(DY,DX) */
{
BYTE   *z = WW_MMAP(wx[0], wx[1]);
BYTE   *s, *t;
int     nr, nc;

if (mkobj(dst, 'T', wx[2]*wx[3], wx[3])) return ERROR;
for (t = TEXT_PTR(dst), nr = wx[2]; 0 < nr--; z += ed_scr[3])
        for (s = z, nc = wx[3]; 0 < nc--; *t++ = *s++);
return OK;
}

ww_mget(dst, ww)        /* read screen */
MATRIX dst;             /* text matrix */
MATRIX ww;              /* window specifier */
{
return (dst == NULL ||
        ww_size(ww) ||
        ww_vget(dst, INT_PTR(ww)));
}
